
#include <iostream>
#include <iomanip>
#include "math.h"
#include "smplRNn.h"

using namespace std;
using namespace smplRN;

const double PI = 4.0 * atan(1.0);

const double sqrt2pi = sqrt(2.0 * PI);

//@WKzmx֐
double phi( double z ) {
	double v = exp(-0.5 * z * z) / sqrt2pi;
	return v;
}

int cat( double v ){
	int iv = round(2.0 * v);
	if (iv < -8){	iv = -8; }
	else if (iv > 8){ iv = 8; };
	iv += 8;
	return iv;
}

const int n = 1000000;
double vx[n];

int main()
{
	smplrn rn;

	int acpt = 0; 
	double x; 
	int count[17] = {0};

	x = 0.0;
	for (int t = 0; t < n; t++){
		x = rn.normal(); vx[t] = x;	count[cat(x)]++;
	}

	int maxc = count[0];
	for (int i = 1; i < 17; i++) if (maxc < count[i]) maxc = count[i];
	cout << "normal()..." << endl;
	int ic;
	for (int i = 0; i < 17; i++){
		cout << setw(5) << fixed << setprecision(1) << 0.5 * double(i-8) << " : I"; 
		ic = round(50.0 * double(count[i]) / maxc);
		if (ic > 0)	for (int i = 0; i < ic; i++) cout << "d";
		cout << endl;
		cout << "     " << " : I";
		ic = round(50.0 * phi(0.5 * double(i-8)) * 0.5 * n / maxc);
		if (ic > 0)	for (int i = 0; i < ic; i++) cout << "z";
		cout << endl;
	}

	cout << endl;
	cout << "normalp( x1, x2 )..." << endl;

	smplrn rn1;
	for (int i = 0; i < 17; i++) count[i] = 0;
	double x1, x2;
	for (int t = 0; t < n; t++){
		rn1.normalp( x1, x2 );	vx[t] = x1; count[cat(x1)]++;
	}

	maxc = count[0];
	for (int i = 1; i < 17; i++) if (maxc < count[i]) maxc = count[i];
	for (int i = 0; i < 17; i++){
		cout << setw(5) << fixed << setprecision(1) << 0.5 * double(i-8) << " : I"; 
		ic = round(50.0 * double(count[i]) / maxc);
		if (ic > 0)	for (int i = 0; i < ic; i++) cout << "d";
		cout << endl;
		cout << "     " << " : I";
		ic = round(50.0 * phi(0.5 * double(i-8)) * 0.5 * n / maxc);
		if (ic > 0)	for (int i = 0; i < ic; i++) cout << "z";
		cout << endl;
	}

	return 0;
}


