#ifndef smplRN_CK
#define smplRN_CK

namespace smplRN {

/********************************************

	B.D.Ripley, "Stochastic Simulation", 1987.
		See Table 2.4
            a = 69069;  c = 1;

	The period is of order 10 to the 9th power
                  i.e. 4giga.
		  See, Theorem 2.1 in Ripley (1987)

*********************************************/

class smplrn {
	public:
		const unsigned int a, c;  //   32-bit unsigned integer
		unsigned int seed;

		smplrn();
		smplrn( unsigned int s );

		virtual ~smplrn(){ }

		unsigned int getSeed(){
			return seed;
		}

		double uni();     //    0 < uni() < 1
};

	smplrn::smplrn(): a(69069), c(1), seed(1){ }

	smplrn::smplrn( unsigned int s ): a(69069), c(1), seed(s){ }


	double smplrn::uni(){
		seed = a * seed + c;
		double v = (double(seed) + 1.0) / (double(0xFFFFFFFF) + 2.0);

		return v;
	}

}

#endif
