/**************************************************

   z\NX^myMatSFŏ@\

           Y. Okamoto

***************************************************/

#ifndef MyMatS_CK
#define MyMatS_CK

namespace MyMatS {

class myVecS {
	public:
		int vctrn;
		double * v;
	
		myVecS(): vctrn(0), v(NULL) { }
		virtual ~myVecS(){
			if (v != NULL)	delete[] v;
		}

		double & operator[](int nn){	return v[nn];   };
};

class myMatS {
	public:
		int m, n;
		myVecS * vv;

		myMatS(): m(0), n(0), vv(NULL){	}
		myMatS(int mm, int nn): vv(NULL) {
			if (!((mm > 0) && (nn > 0))){
				m = 0; n = 0; vv = NULL;
			} else {
				set_size(mm, nn); 
			}
		}

		//   ln\Ƃ邽߂̃RXgN^
		myMatS(const myMatS & tmplt){
			m = tmplt.m;
			n = tmplt.n;

			vv = new myVecS[m];
			for (int i = 0;  i < m; i++){
				vv[i].v = new double[n];
				vv[i].vctrn = n;
				
				for (int j = 0; j < n; j++){
					vv[i].v[j] = tmplt.vv[i].v[j];
				}
			}
		}

		virtual ~myMatS(){
			if (vv != NULL) delete[] vv;
		}
		
		//     z̃TCÝiājݒ
		int set_size( int mm, int nn );
		
		int get_size_row(){ return m; }

		int get_size_col(){ return n; }

		myVecS & operator[](int mm){  return vv[mm];  };
};

//      s a ̋ts invMat ̌vZ
int calcInvMat( myMatS a, myMatS & invMat, int n );

//-------------------  Definitions  --------------------

int myMatS::set_size( int mm, int nn ){
	int ck = 0;

	if (vv != NULL)	delete[] vv;

	m = mm;  n = nn;
	vv = new myVecS[mm];
	for (int i = 0;  i < mm; i++){
		vv[i].v = new double[nn];
		vv[i].vctrn = nn;
		for (int j = 0; j < nn; j++){
			vv[i].v[j] = 0.0;
		}
	}
	return ck;
}

void swapd( double & a, double & b ){
		double c = a;
		a = b; b = c;
}

//    tšvZF@|o@
//     a : ts߂sG    invMat : tsԂs
int calcInvMat( myMatS a, myMatS & invMat, int n ){
	int ck = 0;
	if (n == 1){
		if (System::Math::Abs(a[1][1]) > 1.0e-20){
			invMat[1][1] = 1.0 / a[1][1];
		}
		else ck = 1;
	}
	else {
		//       invMat Pʍsɐݒ
		for (int i = 0; i < n; i++){
			for (int j = 0; j < n; j++){
				if (i != j) {
					invMat[i][j] = 0.0;
				}
				else {
					invMat[i][i] = 1.0;
				}
			}
		}
		//  IɂOƂ݂Ȃݒ
		double czero = 0.0;
		for (int i = 0; i < n; i++)
			for (int j = 0; j < n; j++) 
				if (czero < System::Math::Abs(a[i][j])) czero = System::Math::Abs(a[i][j]);
		czero *= 1.0e-9;     //   OƌȂX̐xŐݒ肷
		double vp;
		int ip;
		for (int i = 0; i < n; i++){
			vp = System::Math::Abs(a[i][i]);
			if (i < n-1){
				//      Βlő̍sT
				ip = i;
				for (int j = i+1; j < n; j++){
					if (vp < System::Math::Abs(a[j][i])){
						vp = System::Math::Abs(a[j][i]);
						ip = j;
					}
				}
			}
			if (vp < czero){   //   Βl̍őlIɂOł
				ck = 1;
				return ck;
			}
			if (ip > i){   //     Βlő̍sƌ
				for (int j = 0; j < n; j++){
					swapd(a[ip][j], a[i][j]);
					swapd(invMat[ip][j], invMat[i][j]);
				}
			}
			double vs;
			for (int j = 0; j < n; j++)
				if (j != i){     //     j s̑|o
					vs = a[j][i] / a[i][i];
					for (int k = i; k < n; k++)
						a[j][k] -= a[i][k] * vs;
					for (int k = 0; k < n; k++)
						invMat[j][k] -= invMat[i][k] * vs;
									}
		}
		double vs;
		for (int i = 0; i < n; i++){
			vs = 1.0 / a[i][i];
			//  (i, i)Pɂ
			for (int j = 0; j < n; j++) invMat[i][j] *= vs;
		}
	}

	return ck;
}

}

#endif
