/************************************************************************
Ver.2008.04.05

             This program was written Y.Okamoto:
		            2007.10 -

*************************************************************************/

#ifndef MyMat_CK
#define MyMat_CK

#define MATDEBUG 1  //   1 -> exception on,  0 -> exception off.

#include <iostream>
using namespace std;

namespace myLib {

class myVec {
	public:
		int vctrn;
		double * v;
	
		myVec(): vctrn(0), v(NULL) { }
		explicit myVec(int nn): vctrn(0), v(NULL) {
			if (nn > 0) {
				vctrn = nn;
				v = new double[vctrn];
				for (int i = 0; i < vctrn; i++) v[i] = 0.0;
			}
		}
		myVec(const myVec & tmplt){
			vctrn = tmplt.vctrn;

			if (vctrn > 0){
				v = new double[vctrn];
				for (int i = 0; i < vctrn; i++)	v[i] = tmplt.v[i];
			}
			else v = NULL;
		}

		virtual ~myVec(){ if (v != NULL) delete[] v; }

		int set_vsize( int nn );

		double & operator[](int nn);

		myVec & operator = (const myVec & R);
};


class myMat {
	public:
		int m, n;
		myVec * vv;

		myMat(): m(0), n(0), vv(NULL){	}
		myMat(int mm, int nn): vv(NULL) {
			if (!((mm > 0) && (nn > 0))){
				m = 0; n = 0; vv = NULL;
			} else {
				set_size(mm, nn); 
			}
		}

		myMat(const myMat & tmplt){
			m = tmplt.m;
			n = tmplt.n;

			if (m > 0){
				vv = new myVec[m];
				for (int i = 0;  i < m; i++){
					vv[i].v = new double[n];
					vv[i].vctrn = n;
					
					for (int j = 0; j < n; j++){
						vv[i].v[j] = tmplt.vv[i].v[j];
					}
				}
			}
			else vv = NULL;
		}
	
		virtual ~myMat(){ if (vv != NULL) delete[] vv; }
		
		//     (Re-)size the matrix
		int set_size( int mm, int nn );
		

		int get_size_row(){ return m; }

		int get_size_col(){ return n; }

		//       *this[]
		myVec & operator[](int mm);

		//       *this = R
		myMat & operator = (const myMat & R);

		//      *this = *this + R
		myMat & operator += (const myMat & R);

		//      *this = *this - R
		myMat & operator -= (const myMat & R);

		//      *this = *this * R
		myMat & operator *= (const myMat & R);

		//      *this = *this / R
		myMat & operator /= (const myMat & R);
};


//    Calculate L + R
myMat operator+ (const myMat & L, const myMat & R);

//    Calculate L - R
myMat operator- (const myMat & L, const myMat & R);

//    Calculate L * R
myMat operator* (const myMat & L, const myMat & R);

//    Calculate L / R
myMat operator/ (const myMat & L, const myMat & R);

//      calculate a'
myMat matTransp( myMat & a );

//      myVec̏o
void WriteVec( myVec Vec );

//      myVec̏oFow
void WriteVec( int w, myVec Vec );

//      myMat̏o
void WriteMat( myMat Mat );

//      myMat̏oFow
void WriteMat( int w, myMat Mat );

//      myMat̓ǂݍ
void ReadMat( myMat & Mat );

//    c = a + b
int matAdd( myMat & a, myMat & b, myMat & c, int m, int n );


//    tšvZF@|o@
//     a : ts߂sG    invMat : tsԂs
int calcInvMat( myMat a, myMat & invMat, int n, double rzero = 1.0e-15 );


//    ʋtšvZF@|o@
//    aFʋts߂s
//    ֐lF߂ʋts
myMat gInv( myMat a,  
		    double czero = 1.0e-9  //   O
		  );

//   s̊K
int RankMat(myMat a,  
		    double czero = 1.0e-9  //   O
		  );

//   s
double DetMat(myMat a,  
		      double czero = 1.0e-9  //   O
		     );

//    ʋtšvZF@Penrose̕@
//    aFʋts߂s
//    ֐lF߂ʋts
myMat MPInv( myMat a,  
		    double czero = 1.0e-9  //   O
			);

//    Cholesky
int CholeskyDecom( myMat a,  myMat & b );


}   //   End of myLib

#endif
