#ifndef smplRN_CK
#define smplRN_CK

namespace smplRN {

/********************************************
Version 2008.04


	B.D.Ripley, "Stochastic Simulation", 1987.
		See Table 2.4
            a = 69069;  c = 1;

	The period is of order 10 to the 9th power
                  i.e. 4giga.
		  See, Theorem 2.1 in Ripley (1987)

*********************************************/

class smplrn {
	public:
		const unsigned __int32 a, c;
		unsigned __int32 seed;

		smplrn();
		smplrn( unsigned __int32 s );

		virtual ~smplrn(){ }

		unsigned __int32 getSeed(){
			return seed;
		}

		double uni();     //    0 < uni() < 1
};

}

#endif
