// QL.cpp : C vWFNg t@CłB

#include "stdafx.h"
#include <iostream>
#include "mymat.h"
#include "myEigen.h"
#include "smplRN.h"

using namespace System;
using namespace std;
using namespace smplRN;
using namespace myLib;

int main(array<System::String ^> ^args)
{
	const int n = 4;

	double u1[n] = { 1, 1, 1, 1 };
	double u2[n] = { 1, -1, 1, -1 };
	double u3[n] = { 1, 1, -1, -1 };
	double u4[n] = { 1, -1, -1, 1 };
	
	myMat a(n,n);
	for (int i = 0; i < n; i++)
		for (int j = 0; j < n; j++)
			a[i][j] = 4*u1[i]*u1[j] + 3*u2[i]*u2[j] + 2*u3[i]*u3[j] + u4[i]*u4[j];

	cout << "a = " << endl;
	WriteMat( 9, a );

	myMat StoreA(n,n);
	StoreA = a;

	myMat EigenVec(n,n);
	myMat EigenVal(n,1);
	int n_eigens;
	QL_decom ql;
	ql.DoQL( a, EigenVec, EigenVal, n_eigens );

	cout << "Eigen values and Eigen vectors..." << endl;
	for (int i = 0; i < n; i++){
		cout << "Eigen Value = " << EigenVal[i][0] << endl;
		for (int j = 0; j < n; j++)
			cout << EigenVec[j][i] << endl;
	}

	myMat CkA(n,n);
	for (int i = 0; i < n; i++)
		for (int j = 0; j < n; j++){
			double tv = 0.0;
			for (int k = 0; k < n; k++) tv += EigenVal[k][0] * EigenVec[i][k] * EigenVec[j][k];
			CkA[i][j] = tv;
		}
	cout << "a =" << endl;
	WriteMat( StoreA );
	cout << "a(constructed) =" << endl;
	WriteMat( CkA );

    Console::WriteLine("EnterL[ďI");
	Console::ReadLine();
    return 0;
}
