#include "stdafx.h"
#include "smplRN.h"

using namespace smplRN;


/********************************************
Version 2008.04, 2009.04


	B.D.Ripley, "Stochastic Simulation", 1987.
		See Table 2.4
            a = 69069;  c = 1;

	The period is of order 10 to the 9th power
                  i.e. 4giga.
		  See, Theorem 2.1 in Ripley (1987)

*********************************************/

namespace smplRN {

		smplrn::smplrn(): a(69069), c(1), seed(1){ }

		smplrn::smplrn( unsigned __int32 s ): a(69069), c(1), seed(s){ }


		double smplrn::uni(){
			seed = a * seed + c;
			double v = (double(seed) + 1.0) / (double(0xFFFFFFFF) + 2.0);

			return v;
		}

}
