#include "stdafx.h"
#include "WHRN.h"
#include "myetc.h"

using namespace myLib;

namespace myLib {

using namespace System;

//    Wichmann/Hill generator...the period is of the order of 10 to the 12th power.
//    cf.  J.E.Gentle, 2003. 
//         "Random Number Generation and Monte Carlo Methods, 2nd ed."  Springer.


double WHrn::uni(){
	do {
		x = (171 * x) % 30269;
		y = (172 * y) % 30307;
		z = (170 * z) % 30323;
		u = (x/30269.0) + (y/30307.0) + (z/30323.0);
		u = u - Math::Truncate(u);
	} while (u <= 0.0);
	return u;
}


   //        Standard Normal Distribution
	double NormalRN::normal(){
		double v1, v2, w;
		do {
    		v1 = 2.0 * uni() - 1.0;
			v2 = 2.0 * uni() - 1.0;
			w  = myLib::sqr(v1) + myLib::sqr(v2);
		} while (((w >= 1.0) || (w <= 0.0)));

		double c = Math::Sqrt(-2.0 * Math::Log(w)/w);

		return c * v1;
	}


    //    Normal Distribution of mean m  and standard deviation s
	double NormalRN::normalMS(double m, double s){
			double v = s * normal() + m;
			return  v;
	}


    //    A Pair of Independent Random Numbers of 
	//      the Standard Normal Distribution 
	void  NormalRN::normalPair( double & n1, double & n2 ){
			double v1, v2, w, c;
			do {
				  v1 = 2.0 * uni() - 1.0;
				  v2 = 2.0 * uni() - 1.0;
				  w  = myLib::sqr(v1) + myLib::sqr(v2);
			} while (((w >= 1.0) || (w <= 0.0)));

			c = Math::Sqrt(-2.0 * Math::Log(w) / w);

			n1 = c * v1;
			n2 = c * v2;
	}


}  //   End of namespace myLib


