#ifndef WHrn_CK
#define WHrn_CK

namespace myLib {

using namespace System;

//
//    Wichmann/Hill generator...the period is of the order of 10 to the 12th power.
//    cf.  J.E.Gentle, 2003. 
//         "Random Number Generation and Monte Carlo Methods, 2nd ed."  Springer.
//

class WHrn {
public:
	unsigned __int32 x;
	unsigned __int32 y;
	unsigned __int32 z;
	double u;

	WHrn(): x(11111), y(22222), z(33333) {}
	virtual ~WHrn(){}

	WHrn(unsigned __int32 ix, unsigned __int32 iy, unsigned __int32 iz):
		x(ix), y(iy), z(iz) {}

	double uni();
};

class NormalRN: public WHrn {
public:
	NormalRN(){}
	virtual ~NormalRN(){}

	NormalRN(unsigned __int32 ix, unsigned __int32 iy, unsigned __int32 iz){
		x = ix;  y = iy;  z = iz;
	}		

	//        Standard Normal Distribution
	double NormalRN::normal();

    //        Normal Distribution of mean m  and standard deviation s
	double NormalRN::normalMS(double m, double s);

    //        A Pair of Independent Random Numbers of 
	//            the Standard Normal Distribution 
	void  NormalRN::normalPair( double & n1, double & n2 );

};


}  //   End of namespace myLib

#endif
