// SVD.cpp : C vWFNg t@CłB

#include "stdafx.h"
#include <iostream>
#include "mymat.h"
#include "myEigen.h"

using namespace System;
using namespace std;
using namespace myLib;

int main(array<System::String ^> ^args)
{
	myMat a(2,3);
	a[0][0] = 2.0;  a[0][1] = 1.0;  a[0][2] = 0.0;
	a[1][0] = 0.0;  a[1][1] = 1.0;  a[1][2] = 2.0;

	cout << "a =" << endl;
	WriteMat( 7, a );

	myMat U(2,2);
	myMat V(3,3);
	myMat lambda(3,1);
	int rnk;
	
	SVD( a, rnk, U, V, lambda );

	Console::WriteLine("Root of 6 = " + Math::Sqrt(6.0));
	Console::WriteLine("1/Root(2) = " + 1.0/Math::Sqrt(2.0));
	Console::WriteLine("1/Root(3) = " + 1.0/Math::Sqrt(3.0));

	cout << "rank = " << rnk << endl;
	for (int i = 0; i < rnk; i++){
		cout << "Lambda-" << (i+1) << " = " << lambda[i][0] << endl;
		for (int j = 0; j < a.m; j++) cout << "  u/" << U[j][i];
		cout << endl;
		for (int j = 0; j < a.n; j++) cout << "  v/" << V[j][i];
		cout << endl;
	}

	myMat a0(2,3);
	cout << endl << "a0 =" << endl;
	WriteMat( 7, a0 );
	SVD( a0, rnk, U, V, lambda );
	cout << "rank = " << rnk << endl << endl;

	myMat a1(3,2);
	a1 = matTransp( a );
	cout << "a1 =" << endl;
	WriteMat( 7, a1 );

	myMat U1(3,3);
	myMat V1(2,2);
	myMat lambda1(3,1);
	int rnk1;
	
	SVD( a1, rnk1, U1, V1, lambda1 );

	Console::WriteLine("Root of 6 = " + Math::Sqrt(6.0));
	Console::WriteLine("1/Root(2) = " + 1.0/Math::Sqrt(2.0));
	Console::WriteLine("1/Root(3) = " + 1.0/Math::Sqrt(3.0));

	cout << "rank1 = " << rnk1 << endl;
	for (int i = 0; i < rnk1; i++){
		cout << "Lambda1-" << (i+1) << " = " << lambda1[i][0] << endl;
		for (int j = 0; j < a1.m; j++) cout << "  u1/" << U1[j][i];
		cout << endl;
		for (int j = 0; j < a1.n; j++) cout << "  v1/" << V1[j][i];
		cout << endl;
	}

	Console::WriteLine();
    Console::WriteLine("EnterL[ďI");
	Console::ReadLine();
    return 0;
}
