#include "stdafx.h"
#include "myEigen.h"


#include "mymat.h"
#include <math.h>
#include <iostream>
#include "myTools.h"

namespace myLib {

	using namespace std;
	using namespace System;
	using namespace myLib;


/*********************************************************

        Ώ̍ŝRdΊpFnEXz_[̕@

*********************************************************/

int Householder( myMat & a, double czero = 1.0e-14 ){
	int ck = 0;
	if (a.m < 3) return ck;

	int n = a.m;
	for (int i = 0; i < (a.m -2); i++){
		//  xNg b ̐ݒ
		myMat b(n-i-1, 1);
		for (int j = 0; j < (n-i-1); j++) b[j][0] = a[j+i+1][i];
		double nrm_b = 0.0;
		for (int j = 0; j < n-i-1; j++) nrm_b += b[j][0] * b[j][0];
		nrm_b = System::Math::Sqrt(nrm_b);
		if (nrm_b > czero){
			//   vZxlāAb[0][0]̕ɍ킹ċfϊsB
			//   b < 0.0 ? b - (||b|| 0 ... 0): b + (||b|| 0 ... 0) 
			int ck_b = b[0][0] < 0.0 ? -1 : 1 ;
			if (ck_b < 0) b[0][0] -= nrm_b;
			else          b[0][0] += nrm_b;
			double nrm_bb = 0.0;
			for (int j = 0; j < n-i-1; j++) nrm_bb += b[j][0] * b[j][0];
			nrm_bb = System::Math::Sqrt(nrm_bb);

			//     fϊ\PʃxNg u ̐ݒ
			myMat u(n-i-1,1);
			for (int j = 0; j < n-i-1; j++) u[j][0] = b[j][0]/nrm_bb;

			//     xNgɖ߂
			if (ck_b < 0) b[0][0] += nrm_b;
			else          b[0][0] -= nrm_b;

			//     fϊs Q
			myMat Q(n-i-1, n-i-1);
			for (int j = 0; j < n-i-1; j++)
				for (int k = 0; k < n-i-1; k++)
					if (j == k){
						Q[j][j] = 1.0 - 2.0 * u[j][0] * u[j][0];
					} else {
						Q[j][k] = -2.0 * u[j][0] * u[k][0];
					}

			//    b ̕ϊ@
			b = Q * b;
			a[i+1][i] = b[0][0]; a[i][i+1] = b[0][0];
			for (int j = i+2; j < a.m; j++){
			a[i][j] = 0.0; a[j][i] = 0.0;
			}

			//   s C ̍\ƕϊ
			myMat C(n-i-1, n-i-1);
			for (int j = 0; j < n-i-1; j++)
				for (int k = 0; k < n-i-1; k++) C[j][k] = a[j+i+1][k+i+1];
			C = Q * C * Q;
			for (int j = 0; j < n-i-1; j++)
				for (int k = 0; k < n-i-1; k++) a[j+i+1][k+i+1] = C[j][k];
		}
	}

	return ck;
}



int SeekPos( int i, myMat indx ){
	int n = indx.m;
	int ip = 0;
	
	do {
		if (i == indx[ip][0]) break;
		ip++;
	} while (ip < n);
	
	return ip;
}


/********************************************************

                 P̉

********************************************************/
int calcVec( myMat a, myMat & x, double czero ){
	int ck = 0;

	int n = a.m;

	double maxV = 0.0;
	for (int i = 0; i < n; i++)
		for (int j = 0; j < n; j++)
			if (maxV < Math::Abs(a[i][j])) maxV = Math::Abs(a[i][j]);
	if (maxV > czero) czero = maxV * czero * 100.0;

	int ck_rank = 0;
	myMat index(n,1);
	for (int i = 0; i < n; i++) index[i][0] = i;

	for (int i = 0; i < n; i++){
		int maxi = i; 
		int maxj = i;
		for (int h = i; h < n; h++)
			for (int k = i; k < n; k++)
				if (Math::Abs(a[h][k]) > Math::Abs(a[maxi][maxj])){
					maxi = h;  maxj = k;
				}
		if (Math::Abs(a[maxi][maxj]) < czero){
			ck_rank = i;
			goto my_end1;
		}
		if (i >= n-1){
			ck = 1;
			return ck;
		}
		if (maxi > i){
			for (int j = i; j < n; j++) dswap( a[i][j], a[maxi][j] );
		}
		if (maxj > i){
			for (int j = 0; j < n; j++) dswap( a[j][i], a[j][maxj] );
			dswap( index[maxj][0], index[i][0] );
		}
		for (int j = i+1; j < n; j++){
			double scl = a[j][i]/a[i][i];
			for (int k = i; k < n; k++) a[j][k] -= a[i][k] * scl;
		}
	}
	
	my_end1 : ;

	for (int j = ck_rank; j < n; j++) x[j][0] = 1.0;
	if (ck_rank > 0){
		for (int j = ck_rank-1; j >= 0; j--){
			double sum = 0.0;
			for (int k = j+1; k < n; k++) sum += a[j][k] * x[k][0];
			x[j][0] = -sum / a[j][j];
		}
	}

	double sum = 0.0;
	for (int i = 0; i < n; i++) sum += sqr(x[i][0]);
	sum = Math::Sqrt(sum);
	for (int i = 0; i < n; i++) x[i][0] /= sum;

	myMat y(n,1);
	y = x;
	for (int i = 0; i < n; i++) x[i][0] = y[SeekPos(i, index)][0];

	return ck;
}



/*****************************************************************

                      pk@

******************************************************************/


QL_decom::QL_decom(): czero(1.0e-14) {}

QL_decom::QL_decom( double vzero ){ czero = vzero; }

int QL_decom::doSubQL( int left, int right, double shiftv ){
	int ck = 0;

	if (left == right) {
		a[left][left] += shiftv;
		return ck;
	}
	if (left+1 == right){
		double a_d = a[left][left] + a[right][right];
		double root_in = sqr(a_d) - 4.0 * (a[left][left] * a[right][right]
											   - a[left][right] * a[right][left]);
		a[left][left] = 0.5 * (a_d + Math::Sqrt(root_in)) + shiftv;
		a[right][right] = 0.5 * (a_d - Math::Sqrt(root_in)) + shiftv;
		a[left][right] = 0.0;
		a[right][left] = 0.0;
		return ck;
	}

	int icount = 0;
	do {
		int ckPos = left;
		do {
			if (ckPos >= right) break;
			if (Math::Abs(a[ckPos][ckPos+1]) < czero) break;
			ckPos++;
		} while(true);

		if (ckPos < right) {
			doSubQL(left, ckPos, shiftv);
			doSubQL(ckPos+1, right, shiftv);
			break;
		}

		double a_d = a[left][left] + a[left+1][left+1];
		double root_in = sqr(a_d) - 4.0 * (a[left][left] * a[left+1][left+1]
											   - a[left][left+1] * a[left+1][left]);
		double r1 = 0.5 * (a_d + Math::Sqrt(root_in));
		double r2 =  0.5 * (a_d - Math::Sqrt(root_in));
		double shiftc = (Math::Abs(r1 - a[left][left]) < Math::Abs(r2 - a[left][left])) ? r1: r2;
		for (int k = left; k <= right; k++) a[k][k] -= shiftc;
		shiftv += shiftc;

		myMat Q(right-left+1,right-left+1);
		myMat L(right-left+1,right-left+1);
		for (int i = 0; i < right-left+1; i++)
			for (int j = 0; j < right-left+1; j++){
				L[i][j] = a[i+left][j+left];
				if (i == j) Q[i][i] = 1.0;
				else        Q[i][j] = 0.0;
			}

		double sin_t;
		double cos_t;
		double ai1;
		double ai;
		for (int i = right-left; i > 0; i--){
			sin_t = L[i-1][i] / Math::Sqrt(sqr(L[i-1][i]) + sqr(L[i][i]));
			cos_t = L[i][i] / Math::Sqrt(sqr(L[i-1][i]) + sqr(L[i][i]));
			for (int k = i-2; k <= i; k++){
				if (k >= 0){
					ai1 = cos_t * L[i-1][k] - sin_t * L[i][k];
					ai  = sin_t * L[i-1][k] + cos_t * L[i][k];
					L[i-1][k] = ai1;
					L[i][k]   = ai;
				}
			}
			for (int k = i-1; k < right-left+1; k++){
					ai1 = cos_t * Q[i-1][k] - sin_t * Q[i][k];
					ai  = sin_t * Q[i-1][k] + cos_t * Q[i][k];
					Q[i-1][k] = ai1;
					Q[i][k]   = ai;
			}
		}

		myMat A1(right-left+1, right-left+1);
	
		A1 = L / Q; 

		for (int i = 0; i < right-left+1; i++)
			for (int j = 0; j < right-left+1; j++)
				a[i+left][j+left] = A1[i][j];

		icount++;
	} while (icount < 1000);
	if (icount >= 1000){
		ck = 9;
		return ck;
	}


	return ck;
}


int QL_decom::DoQL( myMat & aa, myMat & EigenVec, myMat & EigenVal, int & n_eigen ){
	int ck = 0;

	n = aa.m;
	a.set_size(n,n);
	a = aa;

	int hck = Householder( a, czero );
	if (hck != 0) {
		ck = hck;
		return ck;
	}

	doSubQL( 0, n-1, 0.0 );

	for (int i = 0; i < n; i++)
		if (Math::Abs(a[i][i]) > czero) EigenVal[i][0] = a[i][i];
		else                            EigenVal[i][0] = 0.0;

	if (n > 1){
		for (int i = 0; i < n-1; i++){
			int j = i;
			for (int k = i; k < n; k++)
			if (Math::Abs(EigenVal[j][0]) < Math::Abs(EigenVal[k][0])) j = k;
			if ( i < j){
				double t = EigenVal[i][0];
				EigenVal[i][0] = EigenVal[j][0];
				EigenVal[j][0] = t;
			}
		}
	}

	
	myMat x(n,1);
	n_eigen = 0;
	for (int h = 0; h < n; h++){
		if (Math::Abs(EigenVal[h][0]) <= czero){
			EigenVal[h][0] = 0.0;
			for (int k1 = 0; k1 < n; k1++) EigenVec[k1][h] = 0.0;
		} else {
			n_eigen++;

			a = aa;

			for (int i = 0; i < n; i++) a[i][i] -= EigenVal[h][0];

			int ckck = calcVec( a, x, czero );

			for (int i = 0; i < n; i++) EigenVec[i][h] = x[i][0];

			if (h < n-1){
				if (Math::Abs(EigenVal[h][0] - EigenVal[h+1][0]) < czero){
					myMat tempMat(n,n);
					for (int k1 = 0; k1 < n; k1++)
					for (int k2 = 0; k2 < n; k2++) 
					tempMat[k1][k2] = EigenVal[h][0] * x[k1][0] * x[k2][0];
					aa -= tempMat;
				}
			}
		}
	}


	return ck;
};



/****************************************************************

                    ْliSVDj

****************************************************************/

void SVD( myMat a, int & rnk,  myMat & U, myMat & V, myMat & lambda, double ckzero ){
	int m = a.m;
	int n = a.n;
	if (m <= n ){
		myMat aa(m,m);
		aa = a * matTransp( a );
		QL_decom ql(ckzero);
		myMat eigenVal(m,1);
		ql.DoQL( aa, U, eigenVal, rnk );

		if (rnk > 0){
			for (int i = 0; i < rnk; i++){
				lambda[i][0] = Math::Sqrt(eigenVal[i][0]);
				for (int j = 0; j < n; j++){
					double tv = 0.0;
					for (int k = 0; k < m; k++) tv += a[k][j] * U[k][i];
					V[j][i] = tv/lambda[i][0];
				}
			}
		}
	} else {
		myMat aa(n,n);
		aa = matTransp(a) * a;
		QL_decom ql(ckzero);
		myMat eigenVal(n,1);
		ql.DoQL( aa, V, eigenVal, rnk );

		if (rnk > 0){
			for (int i = 0; i < rnk; i++){
				lambda[i][0] = Math::Sqrt(eigenVal[i][0]);
				for (int j = 0; j < m; j++){
					double tv = 0;
					for (int k = 0; k < n; k++) tv += a[j][k] * V[k][i];
					U[j][i] = tv/lambda[i][0];
				}
			}
		}
	}
};

}   //   End of myLib


