/************************************************************************
Ver.2009.04.20

             This program was written Y.Okamoto:
		            2007.11 -

*************************************************************************/

#include "stdafx.h"
#include <iostream>
#include <iomanip>
#include <sstream>
#include "mymat.h"

using namespace std;
using namespace myLib;

namespace myLib {


void WriteVec( myVec Vec ){
	int n = Vec.vctrn;
	if (n > 0){
	for (int i = 0; i < n; i++)
		cout << "   " << Vec.v[i];
	}
	else {
		cout << "Null Vector";
	}
	cout << endl;
	return;
}

void WriteVec( int w, myVec Vec ){
	int n = Vec.vctrn;
	if (n > 0){
		for (int i = 0; i < n; i++)
			cout <<setw(w) << Vec.v[i];
	}
	else {
		cout << "Null Vector";
	}
	cout << endl;
	return;
}


void WriteMat( myMat Mat ){
	int m = Mat.m;
	int n = Mat.n;
	if (m > 0) {
		for (int i = 0; i < m; i++){
			for (int j = 0; j < n; j++){
				cout << "   " << Mat[i][j];
			}
			cout << endl;
		}
	}
	else {
		cout << "NULL Matrix" << endl;
	}
	return;
}

void WriteMat( int w, myMat Mat ){
	int m = Mat.m;
	int n = Mat.n;
	if (m > 0) {
		for (int i = 0; i < m; i++){
			for (int j = 0; j < n; j++){
				cout << setw(w) << Mat[i][j];
			}
			cout << endl;
		}
	}
	else {
		cout << "NULL Matrix" << endl;
	}
	return;
}

//      myMat̓ǂݍ
void ReadMat( myMat & Mat ){
	int m = Mat.m;
	int n = Mat.n;
	cout << "Input data for (" << m << ", " << n << ") matrix" << endl;
	for (int i = 0; i < m; i++)
		for (int j = 0; j < n; j++)
			cin >> Mat[i][j];

	return;
}


void StrToPChar( ostringstream & os, char * c ){
		string s = os.str();
		int L = s.length();
		if(L > 99) L = 99;
		for (int i = 0; i < L; i++)	c[i] = char(s[i]);
		c[L] = NULL;
		return;
}


int myVec::set_vsize( int nn ){
	int ck = 0;

	if (nn < 1){
		ostringstream ostrm;
		ostrm << "Invalid value for set_vsize of class myVec...nn = " << nn;
		char cstr[100];
		StrToPChar( ostrm, cstr );
		
		throw exception(cstr);
	} 

	if (v != NULL) delete [] v;
	vctrn = nn;
	v = new double[vctrn];
	for (int i = 0; i < vctrn; i++) v[i] = 0.0;

	return ck;
}


double & myVec::operator[](int nn){
#if MATDEBUG
	if ((nn < 0) || (vctrn <= nn)){
		ostringstream ostrm;
		ostrm << "Index Range Over Error in class myVec in myVec...Index = " << nn;
		char cstr[100];
		StrToPChar( ostrm, cstr );
		
		throw exception(cstr);
	}
#endif

	return v[nn];
}


myVec & myVec::operator = (const myVec & R){
	if(vctrn != R.vctrn){
		ostringstream ostrm;
		ostrm << "Size Mis-Match Error in =(myVec)...L.vctrn = " << vctrn
			  << ",   R.vctrn = " << R.vctrn;
		char cstr[100];
		StrToPChar( ostrm, cstr );
		
		throw exception(cstr);
	} 
	if (this != &R){
		for (int i = 0; i < R.vctrn; i++) v[i] = R.v[i];
	}
	cout << endl;

	return *this;
};


int myMat::set_size( int mm, int nn ){
	int ck = 0;

	if (!((mm > 0) && (nn > 0))){
		ostringstream ostrm;
		ostrm << "Error in set_size of class myMat...RowIndex = " << mm
			  << "/ ColIndex = " << nn;
		char cstr[100];
		StrToPChar( ostrm, cstr );
		
		throw exception(cstr);
	} 

	if (vv != NULL)	delete[] vv;

	m = mm;
	n = nn;
	vv = new myVec[mm];
	for (int i = 0;  i < mm; i++){
		vv[i].v = new double[nn];
		vv[i].vctrn = nn;
		for (int j = 0; j < nn; j++){
			vv[i].v[j] = 0.0;
		}
	}

	return ck;
}

myVec & myMat::operator[](int mm){
#if MATDEBUG
		if ((m < 1) || (n < 1)){
			ostringstream ostrm;
			ostrm << "The proper object of class myMat does not exist...RowSize = " << m
				  << "/ ColSize = " << n;
			char cstr[100];
			StrToPChar( ostrm, cstr );
			
			throw exception(cstr);
		};
		if((mm < 0) || (m <= mm)){
			ostringstream ostrm;
			ostrm << "Index Range Over Error in class myMat...RowIndex = " << mm;
			char cstr[100];
			StrToPChar( ostrm, cstr );
			
			throw exception(cstr);
		}
#endif
	
	return vv[mm];
}



myMat & myMat::operator = (const myMat & R){   // cf.   (i = 3) += 5;
	if(!((m == R.m) && (n == R.n))){
			ostringstream ostrm;
			ostrm << "Size Mis-Match Error in =(myMat)...L.m = " << m
				  << ",  L.n = " << n 
				  << "/ R.m = " << R.m << " R.n = " << R.n;
			char cstr[100];
			StrToPChar( ostrm, cstr );
			
			throw exception(cstr);
	} 
	if (this != &R){
		for (int i = 0; i < m; i++){
			for (int j = 0; j < n; j++) {
				vv[i].v[j] = R.vv[i].v[j];
			}
		}
	}

	return *this;
}

myMat operator+ (const myMat & L, const myMat & R)  {
	if(!((L.m == R.m) && (L.n == R.n))){
			ostringstream ostrm;
			ostrm << "Size Mis-Match Error in +(myMat)...L.m = " << L.m
				  << ",  L.n = " << L.n 
				  << "/ R.m = " << R.m << " R.n = " << R.n;
			char cstr[100];
			StrToPChar( ostrm, cstr );
			
			throw exception(cstr);
	} 

	int row_s = L.m;
	int col_s = L.n;  
	myMat tmp(row_s, col_s);
	for (int i = 0; i < row_s; i++){
		for (int j = 0; j < col_s; j++){
			tmp.vv[i].v[j] = L.vv[i].v[j] + R.vv[i].v[j];
		}
	}  

	return tmp;   
}


//      *this = *this + R
myMat & myMat::operator += (const myMat & R){
	if(!((m == R.m) && (n == R.n))){
			ostringstream ostrm;
			ostrm << "Size Mis-Match Error in +=(myMat)...L.m = " << m
				  << ",  L.n = " << n 
				  << "/ R.m = " << R.m << " R.n = " << R.n;
			char cstr[100];
			StrToPChar( ostrm, cstr );
			
			throw exception(cstr);
	} 

	for (int i = 0; i < m; i++){
		for (int j = 0; j < n; j++) {
			vv[i].v[j] += R.vv[i].v[j];
		}
	}

	return *this;
}


myMat operator- (const myMat & L, const myMat & R)  {
	if(!((L.m == R.m) && (L.n == R.n))){
			ostringstream ostrm;
			ostrm << "Size Mis-Match Error in -(myMat)...L.m = " << L.m
				  << ",  L.n = " << L.n 
				  << "/ R.m = " << R.m << " R.n = " << R.n;
			char cstr[100];
			StrToPChar( ostrm, cstr );
			
			throw exception(cstr);
	} 

	int row_s = L.m;
	int col_s = L.n;  
	myMat tmp(row_s, col_s);
	for (int i = 0; i < row_s; i++){
		for (int j = 0; j < col_s; j++){
			tmp.vv[i].v[j] = L.vv[i].v[j] - R.vv[i].v[j];
		}
	}  

	return tmp;
}

//      *this = *this - R
myMat & myMat::operator -= (const myMat & R){
	if(!((m == R.m) && (n == R.n))){
			ostringstream ostrm;
			ostrm << "Size Mis-Match Error in -=(myMat)...L.m = " << m
				  << ",  L.n = " << n 
				  << "/ R.m = " << R.m << " R.n = " << R.n;
			char cstr[100];
			StrToPChar( ostrm, cstr );
			
			throw exception(cstr);
	} 

	for (int i = 0; i < m; i++){
		for (int j = 0; j < n; j++) {
			vv[i].v[j] -= R.vv[i].v[j];
		}
	}

	return *this;
}


myMat operator* (const myMat & L, const myMat & R)  {
	int r = L.m;
	int s = L.n;  
	int t = R.m;
	int u = R.n;
	if (s != t){
		ostringstream ostrm;
		ostrm << "Matrix Size Error in *...r = " << r
			  << ", s = " << s << ", t = " << t
			  << ", u = " << u;
		char cstr[100];
		StrToPChar( ostrm, cstr );
		
		throw exception(cstr);
	};

	myMat tmp(r, u);
	double tv;
	for (int i = 0; i < r; i++){
		for (int j = 0; j < u; j++){
			tv = 0.0;
			for (int k = 0; k < s; k++){
                tv += L.vv[i].v[k] * R.vv[k].v[j];
			}
			tmp.vv[i].v[j] = tv;
		}
	}  

	return tmp;   
}


//      *this = *this * R
myMat & myMat::operator *= (const myMat & R){
	if(n != R.m){
			ostringstream ostrm;
			ostrm << "Size Mis-Match Error in *=(myMat)...L.n = " << n
				  << ",  R.m = " << R.m;
			char cstr[100];
			StrToPChar( ostrm, cstr );
			
			throw exception(cstr);
	} 

	myMat tmpMat(m, R.n);
	double sum;
	for (int i = 0; i < m; i++){
		for (int j = 0; j < R.n; j++) {
			sum = 0.0;
			for (int k = 0; k < n; k++)
			    sum += vv[i].v[k] * R.vv[k].v[j];
			tmpMat.vv[i].v[j] = sum;
		}
	}
	this->set_size(m, R.n);
	*this = tmpMat;

	return  *this;
}


myMat operator/ (const myMat & L, const myMat & R)  {
	int r = L.m;
	int s = L.n;  
	int t = R.m;
	int u = R.n;
	if ((s != t) || (t != u)){
		ostringstream ostrm;
		ostrm << "Matrix Size Error in /...r = " << r
			  << ", s = " << s << ", t = " << t
			  << ", u = " << u;
		char cstr[100];
		StrToPChar( ostrm, cstr );
		
		throw exception(cstr);
	};

	myMat tmpInv(t, t);
	int ck = calcInvMat( R, tmpInv, t );
	if (ck != 0){
		ostringstream ostrm;
		ostrm << "Matrix Inversion Error in /...ck = " << ck;
		char cstr[100];
		StrToPChar( ostrm, cstr );
		
		throw exception(cstr);
	}

	myMat tmp(r, t);
	double tv;
	for (int i = 0; i < r; i++){
		for (int j = 0; j < t; j++){
			tv = 0.0;
			for (int k = 0; k < t; k++){
                tv += L.vv[i].v[k] * tmpInv.vv[k].v[j];
			}
			tmp.vv[i].v[j] = tv;
		}
	}  

	return tmp;   
}


//      *this = *this / R
myMat & myMat::operator /= (const myMat & R){
	if((n != R.m) || (R.m != R.n)){
			ostringstream ostrm;
			ostrm << "Size Mis-Match Error in /=(myMat)...L.n = " << n
				  << ",  R.m = " << R.m << ",  R.n = " << R.n;
			char cstr[100];
			StrToPChar( ostrm, cstr );
			
			throw exception(cstr);
	} 

	*this = *this / R;
	return  *this;
}

 
myMat matTransp( myMat & a ) {
  int m = a.m;
  int n = a.n;

  myMat tmp(n, m);
  for (int i = 0; i < n; i++){
	  for (int j = 0; j < m; j++){
		tmp.vv[i].v[j] = a.vv[j].v[i];
	  }
  }

  return tmp;
}

int matAdd( myMat & a, myMat & b, myMat & c, int m, int n ){
	int ck = 0;

	for (int i = 0; i < m; i++){
		for (int j = 0; j < n; j++){
			c[i][j] = a[i][j] + b[i][j];
		}
	}

	return ck;
}

void swapd( double & a, double & b ){
		double c = a;
		a = b; b = c;
}

//    tšvZF@|o@
//     a : ts߂sG    invMat : tsԂs
int calcInvMat( myMat a, myMat & invMat, int n, double rzero ){
	int ck = 0;
	if (n == 1){
		if (System::Math::Abs(a[0][0]) > rzero){
			invMat[0][0] = 1.0 / a[0][0];
		}
		else ck = 1;
	}
	else {
		//       invMat Pʍsɐݒ
		for (int i = 0; i < n; i++){
			for (int j = 0; j < n; j++){
				if (i != j) {
					invMat[i][j] = 0.0;
				}
				else {
					invMat[i][i] = 1.0;
				}
			}
		}
		//  IɂOƂ݂Ȃݒ
		double czero = 0.0;
		for (int i = 0; i < n; i++)
			for (int j = 0; j < n; j++) 
				if (czero < System::Math::Abs(a[i][j])) czero = System::Math::Abs(a[i][j]);
		if (czero < rzero){       //   s񂪗słƔ
			ck = 1;
			return ck;
		}
		else czero *= 1.0e-9;     //   OƌȂX̐xŐݒ肷
		double vp;
		int ip;
		for (int i = 0; i < n; i++){
			vp = System::Math::Abs(a[i][i]);
			if (i < n-1){
				//      Βlő̍sisڈȉŒT
				ip = i;
				for (int j = i+1; j < n; j++){
					if (vp < System::Math::Abs(a[j][i])){
						vp = System::Math::Abs(a[j][i]);
						ip = j;
					}
				}
			}
			if (vp < czero){   //   Βl̍őlIɂOł
				ck = 1;
				return ck;
			}
			if (ip > i){   //     Βlő̍sƌ
				for (int j = 0; j < n; j++){
					swapd(a[ip][j], a[i][j]);
					swapd(invMat[ip][j], invMat[i][j]);
				}
			}
			double vs;
			for (int j = 0; j < n; j++)
				if (j != i){     //     j s̑|o
					vs = a[j][i] / a[i][i];
					for (int k = i; k < n; k++)
						a[j][k] -= a[i][k] * vs;
					for (int k = 0; k < n; k++)
						invMat[j][k] -= invMat[i][k] * vs;
									}
		}
		double vs;
		for (int i = 0; i < n; i++){
			vs = 1.0 / a[i][i];
			//  (i, i)Pɂ
			for (int j = 0; j < n; j++) invMat[i][j] *= vs;
		}
	}

	return ck;
}


//    ʋtšvZF@|o@
//    aFʋts߂s
//    ֐lF߂ʋts
myMat gInv( myMat a,  
		    double czero   //   O
		  ){
	int m = a.m;
	int n = a.n;
	myMat g(n,m);

	if((m == 1) && (n == 1)){
		if (a[0][0] == 0.0) 
		   g[0][0] = 0.0;
		else
		   g[0][0] = 1.0/a[0][0];
	}
	else{
		int ckTransp = 0;
		int gm = m;
		int gn = n;
		if (m > n){
		gm = n;
		gn = m;
		ckTransp = 1;
		}
		myMat ta(gm, gn);
		if (ckTransp == 0) ta = a;
		else               ta = matTransp( a );

		myMat Im(gm,gm), In(gn,gn);
		for (int i = 0; i < gm; i++){
			for (int j = 0; j < gm; j++){
				if (i == j) Im[i][j] = 1.0;
				else        Im[i][j] = 0.0;
			}
		}
		for (int i = 0; i < gn; i++){
			for (int j = 0; j < gn; j++){
				if (i == j) In[i][j] = 1.0;
				else        In[i][j] = 0.0;
			}
		}

		int rnk = 0;
		for (int i = 0; i < gm; i++){
			double ckv = 0.0;
			int cki = i;
			int ckj = i;
			for (int i1 = i; i1 < gm; i1++){
				for (int j1 = i; j1 < gn; j1++){
					if (ckv < System::Math::Abs(ta[i1][j1])){
						ckv = System::Math::Abs(ta[i1][j1]);
						cki = i1;
						ckj = j1;
					}
				}
			}
			if (ckv < czero){
			//	rnk = i;
				break;
			};
			rnk++;

			if (i != cki) {
				for (int j1 = i; j1 < gn; j1++){
					swapd(ta[i][j1], ta[cki][j1]);
				}
				for (int j1 = 0; j1 < gm; j1++){
					swapd(Im[i][j1], Im[cki][j1]);
				}
			}
			if( i != ckj){
				for (int i1 = i; i1 < gm; i1++){
					swapd(ta[i1][i], ta[i1][ckj]);
				}
				for (int i1 = 0; i1 < gn; i1++){
					swapd(In[i1][i], In[i1][ckj]);
				}
			}

			double scl = ta[i][i];
			for(int j1 = i; j1 < gn; j1++)
				ta[i][j1] /= scl;
			for (int j1 = 0; j1 < gm; j1++)
				Im[i][j1] /= scl;
			if (i < gm - 1){
				for (int i1 = i+1; i1 < gm; i1++){
					double sclr = ta[i1][i];
					for (int j1 = i; j1 < gn; j1++){
						ta[i1][j1] -= ta[i][j1] * sclr;
					}
					for (int j1 = 0; j1 < gm; j1++){
						Im[i1][j1] -= Im[i][j1] * sclr;
					}
				}
			}
			if (i < gn - 1){
				for (int j1 = i + 1; j1 < gn; j1++){
					double sclc = ta[i][j1];
					for (int i1 = i; i1 < gm; i1++){
						ta[i1][j1] -= ta[i1][i] * sclc;
					}
					for (int i1 = 0; i1 < gn; i1++){
						In[i1][j1] -= In[i1][i] * sclc;
					}
				}
			}

		}

		myMat tg(gn, gm);
		if (rnk > 0){
			for (int i = 0; i < gn; i++){
				for (int j = 0; j < gm; j++){
					double v = 0.0;
					for (int k = 0; k < rnk; k++)
						v += In[i][k] * Im[k][j];
					tg[i][j] = v;
				}
			}
		}
		else {
			for (int i = 0; i < gn; i++){
				for (int j = 0; j < gm; j++) 
					tg[i][j] = 0.0;
			}
		}

		if (ckTransp == 0) g = tg;
		else               g = matTransp( tg );
	}

	return g;
}


//@@s̊K
int RankMat(myMat a,  
		    double czero   //   O
	       ){
	int m = a.m;
	int n = a.n;
	int rnk = 0;
	int ckTransp = 0;

	if((m == 1) && (n == 1)){
		if (a[0][0] == 0.0) rnk = 0;
		else                rnk = 1;
	}
	else{
		int gm = m;
		int gn = n;
		if (m > n){
		gm = n;
		gn = m;
		ckTransp = 1;
		}
		myMat ta(gm, gn);
		if (ckTransp == 0) ta = a;
		else               ta = matTransp( a );

		for (int i = 0; i < gm; i++){
			double ckv = 0.0;
			int cki = i;
			int ckj = i;
			for (int i1 = i; i1 < gm; i1++){
				for (int j1 = i; j1 < gn; j1++){
					if (ckv < System::Math::Abs(ta[i1][j1])){
						ckv = System::Math::Abs(ta[i1][j1]);
						cki = i1;
						ckj = j1;
					}
				}
			}
			if (ckv < czero){
				break;
			};
			rnk++;

			if (i != cki) {
				for (int j1 = i; j1 < gn; j1++){
					swapd(ta[i][j1], ta[cki][j1]);
				}
			}
			if( i != ckj){
				for (int i1 = i; i1 < gm; i1++){
					swapd(ta[i1][i], ta[i1][ckj]);
				}
			}

			double scl = ta[i][i];
			for(int j1 = i; j1 < gn; j1++)
				ta[i][j1] /= scl;
			if (i < gm - 1){
				for (int i1 = i+1; i1 < gm; i1++){
					double sclr = ta[i1][i];
					for (int j1 = i; j1 < gn; j1++){
						ta[i1][j1] -= ta[i][j1] * sclr;
					}
				}
			}
			if (i < gn - 1){
				for (int j1 = i + 1; j1 < gn; j1++){
					double sclc = ta[i][j1];
					for (int i1 = i; i1 < gm; i1++){
						ta[i1][j1] -= ta[i1][i] * sclc;
					}
				}
			}

		}

	}

	return rnk;
}

//   s
double DetMat(myMat a,  
		      double czero    //   O
		     ){
	if (a.m != a.n){
			ostringstream ostrm;
			ostrm << "Matrix Size Error in DetMat...a.m = " << a.m
				  << ",  a.n = " << a.n;
			char cstr[100];
			StrToPChar( ostrm, cstr );
			
			throw exception(cstr);
	}

	int m = a.m;
	int n = a.n;
	double vdet = 1.0;

	if((m == 1) && (n == 1)) vdet = a[0][0];
	else{
		int gm = m;
		int gn = n;

		for (int i = 0; i < gm; i++){
			double ckv = 0.0;
			int cki = i;
			int ckj = i;
			for (int i1 = i; i1 < gm; i1++){
				for (int j1 = i; j1 < gn; j1++){
					if (ckv < System::Math::Abs(a[i1][j1])){
						ckv = System::Math::Abs(a[i1][j1]);
						cki = i1;
						ckj = j1;
					}
				}
			}
			if (ckv < czero){
			    vdet = 0.0;
				break;
			};

			if (i != cki) {
				for (int j1 = i; j1 < gn; j1++){
					swapd(a[i][j1], a[cki][j1]);
				}
				vdet *= -1.0;
			}
			if( i != ckj){
				for (int i1 = i; i1 < gm; i1++){
					swapd(a[i1][i], a[i1][ckj]);
				}
				vdet *= -1.0;
			}

			double scl = a[i][i];
			for(int j1 = i; j1 < gn; j1++)
				a[i][j1] /= scl;
			vdet *= scl;
			if (i < gm - 1){
				for (int i1 = i+1; i1 < gm; i1++){
					double sclr = a[i1][i];
					for (int j1 = i; j1 < gn; j1++){
						a[i1][j1] -= a[i][j1] * sclr;
					}
				}
			}
			if (i < gn - 1){
				for (int j1 = i + 1; j1 < gn; j1++){
					double sclc = a[i][j1];
					for (int i1 = i; i1 < gm; i1++){
						a[i1][j1] -= a[i1][i] * sclc;
					}
				}
			}

		}
		
	}

	return vdet;
}


//    ʋtšvZF@Penrose̕@
//    aFʋts߂s
//    ֐lF߂ʋts
myMat MPInv( myMat a,  
		    double czero  //   O
			){
	int a_m = a.m;
	int a_n = a.n;
	myMat MP(a_n, a_m);            //  Moore-Penrose inverse
	myMat B(a_n, a_n);
	B = matTransp(a) * a;          //  B = A' * A
	double ckTr = 0.0;             //  tr(Ci * B)
	for (int j = 0; j < a_n; j++)
		ckTr += B[j][j];           //  Ci * B == B,  Ci == C1 == I
	if (ckTr < czero){
		for (int j = 0; j < a_n; j++){
			for (int k = 0; k < a_m; k++)
				MP[j][k] = 0.0;                     //   A+ == 0  when A == 0;
		}
	}
	else {
		int istep = 0;                              //   i = 0
		double ckTrp1 = ckTr;                       //   tr(C(i+1) * B)
		myMat Cip1(a_n, a_n);                       //   C(i+1)
		for (int j = 0; j < a_n; j++)
			for (int k = 0; k < a_n; k++){
				if (j == k) Cip1[j][k] = 1.0;
				else        Cip1[j][k] = 0.0;
			}
		myMat Ci(a_n, a_n);
		myMat CiB(a_n, a_n);
		CiB = B;                                    //  C1 * B = I * B;
		do{
			istep++;
			ckTr = ckTrp1;
			Ci = Cip1;
			for (int j = 0; j < a_n; j++){
				for (int k = 0; k < a_n; k++){
					if ( j == k ) Cip1[j][k] = (ckTr/istep) - CiB[j][k];
					else          Cip1[j][k] = -CiB[j][k];
				}
			}
			CiB = Cip1 * B;                          //  C(i+1) * B
			ckTrp1 = 0.0;                            //  tr(C(i+1) * B)
			for (int j = 0; j < a_n; j++)
				ckTrp1 += CiB[j][j];
		}while(System::Math::Abs(ckTrp1) > czero);

		//     XebviSj
		MP = Ci * matTransp(a);
		for (int j = 0; j < a_n; j++){
			for (int k = 0; k < a_m; k++)
				MP[j][k] *= (istep/ckTr);
		}
	}

	return MP;
}



}   //   End of myLib


