/************************************************************************
Ver.2009.04
             This program was written by Y.Okamoto:
		            2007.11 -

*************************************************************************/

#ifndef MyMat_CK
#define MyMat_CK

#include <iostream>

using namespace std;

#define MATDEBUG 1  //   1 -> exception on,  0 -> exception off.

namespace myLib {


class myVec {
	public:
		int vctrn;
		double * v;
	
		myVec(): vctrn(0), v(NULL) { }
		explicit myVec(int nn): vctrn(0), v(NULL) {
			if (nn > 0) {
				vctrn = nn;
				v = new double[vctrn];
				for (int i = 0; i < vctrn; i++) v[i] = 0.0;
			}
		}
		myVec(const myVec & tmplt){
			vctrn = tmplt.vctrn;

			if (vctrn > 0){
				v = new double[vctrn];
				for (int i = 0; i < vctrn; i++)	v[i] = tmplt.v[i];
			}
			else v = NULL;
		}

		virtual ~myVec(){ if (v != NULL) delete[] v; }

		int set_vsize( int nn );

		double & operator[](int nn);

		myVec & operator = (const myVec & R);
};


class myMat {
	public:
		int m, n;
		myVec * vv;

		myMat(): m(0), n(0), vv(NULL){	}
		myMat(int mm, int nn): vv(NULL) {
			if (!((mm > 0) && (nn > 0))){
				m = 0; n = 0; vv = NULL;
			} else {
				set_size(mm, nn); 
			}
		}

		myMat(const myMat & tmplt){
			m = tmplt.m;
			n = tmplt.n;

			if (m > 0){
				vv = new myVec[m];
				for (int i = 0;  i < m; i++){
					vv[i].v = new double[n];
					vv[i].vctrn = n;
					
					for (int j = 0; j < n; j++){
						vv[i].v[j] = tmplt.vv[i].v[j];
					}
				}
			}
			else vv = NULL;
		}
	
		virtual ~myMat(){ if (vv != NULL) delete[] vv; }
		
		//     (Re-)size the matrix
		int set_size( int mm, int nn );
		

		int get_size_row(){ return m; }

		int get_size_col(){ return n; }

		//       *this[]
		myVec & operator[](int mm);

		//       *this = R
		myMat & operator = (const myMat & R);

		//      *this = *this + R
		myMat & operator += (const myMat & R);

		//      *this = *this - R
		myMat & operator -= (const myMat & R);

		//      *this = *this * R
		myMat & operator *= (const myMat & R);

		//      *this = *this / R
		myMat & operator /= (const myMat & R);
};


//    Calculate L + R
myMat operator+ (const myMat & L, const myMat & R);

//    Calculate L - R
myMat operator- (const myMat & L, const myMat & R);

//    Calculate L * R
myMat operator* (const myMat & L, const myMat & R);

//    Calculate L / R
myMat operator/ (const myMat & L, const myMat & R);

//      calculate a'
myMat matTransp( myMat & a );

//      myVec̏o
void WriteVec( myVec Vec );

//      myVec̏oFow
void WriteVec( int w, myVec Vec );

//      myMat̏o
void WriteMat( myMat Mat );

//      myMat̏oFow
void WriteMat( int w, myMat Mat );

//    c = a + b
int matAdd( myMat & a, myMat & b, myMat & c, int m, int n );


//    tšvZF@|o@
//     a : ts߂sG    invMat : tsԂs
int calcInvMat( myMat a, myMat & invMat, int n );


}   //   End of myLib

#endif
