unit UConstStBayes;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, StdCtrls, ComCtrls;

type
  TMainForm = class(TForm)
    AddButton: TButton;
    ExitButton: TButton;
    DelButton: TButton;
    CalcButton: TButton;
    SaveButton: TButton;
    LoadButton: TButton;
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    Label1: TLabel;
    SSEdit: TEdit;
    PButton: TButton;
    StringGrid1: TStringGrid;
    PrintDialog1: TPrintDialog;
    OpenDialogG: TOpenDialog;
    Label2: TLabel;
    PSEMinEdit: TEdit;
    Label3: TLabel;
    PSEMaxEdit: TEdit;
    Label4: TLabel;
    JNDMinEdit: TEdit;
    Label5: TLabel;
    JNDMaxEdit: TEdit;
    Label6: TLabel;
    cnfLEdit: TEdit;
    procedure ExitButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure AddButtonClick(Sender: TObject);
    procedure DelButtonClick(Sender: TObject);
    procedure CalcButtonClick(Sender: TObject);
    procedure SaveButtonClick(Sender: TObject);
    procedure LoadButtonClick(Sender: TObject);
    procedure PButtonClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  MainForm: TMainForm;

{$R+}

type
  TRec = record
             St : extended;                //  rhl
             More, Less : Longint;
         end;

var
  ARec1      //   npz
         : array[1..100] of TRec;
  n1         //   nɂrh̑
         : Longint;

const
  NStep = 100;     //  Ȑ̕`Xebv
  NPoints = 100;   //  p^Ul̐-1

function FuncPSE( i : integer ) : extended;

function FuncSgm( i : integer ) : extended;

function LF( mu, sigma{, c} : extended ) : extended;


type
  TDistri = array[0..NPoints] of extended;
  TFunc   = function( i : integer ) : extended;

var
  Pprior, Ppost : array[0..NPoints, 0..NPoints{, 0..NPoints}] of extended;
  PPSE, PSgm{, PC} : TDistri; // array[0..NPoints] of extended;


var
  Sstd,    //  Whl
  gsigma,  //  oʂ̕W΍
  gmu,     //  = Sstd
  PSEMin, PSEMax,
  SgmMin, SgmMax,
  cnfL
          : extended;

function ProbP( x : extended ) : extended;

function ProbQ( x : extended ) : extended;

function Cum_NormalKC( z : extended ) : extended;


var outfG : TextFile;
    CkFG  : integer = 0;


procedure CalcCrtclP( p : extended;
                      d : TDistri;
                      Func : TFunc;
                      var z : extended );


implementation

{$R *.DFM}

uses
  Printers, UDrawGraphBayes, Math;


procedure CalcCrtclP( p : extended;
                      d : TDistri;
                      Func : TFunc;
                      var z : extended );
  var i1, i2 : integer;
      sum, w1, w2 : extended;

    procedure CalcZ;
      var i1 : integer;
          w1, w2 : extended;
      begin
          i1:=i2-1;
          w1:=p-(sum-d[i2]);
          w2:=sum-p;
          z:=(w1*i2+w2*i1)/(w1+w2);
      end;  

  begin
      i2:=-1; sum:=0.0;
      repeat
        i2:=i2+1;
        sum:=sum+d[i2];
      until sum >= p;

      if i2 <= 0
        then
            z:=0.0
        else
            CalcZ;

      if z <= 0.0
        then z:=Func(0)
        else if z >= NPoints
          then z:=Func(NPoints)
          else
            begin
              i1:=trunc(z);
              w1:=z-i1;
              w2:=1-w1;
              z:=w2*Func(i1)+w1*Func(i1+1);
            end;
  end;




{
      Kerridge and Cook(1976, Biometrika, 63, 401-403)'s Algorithm
                         referred to
      in  A. L. Brophy and  D. L. Wood (1989, Behav. Res. Meth. Istr.
                                        & Comp., 21, 447-454)
}

function  Normal_0_To_Z( z : extended ) : extended;
  label QP;
  var  p, zz, d, m, zz4, theta2,
       theta1, p_prev    : extended;
       n2                : Longint;
  begin
       z:=abs(z);
       if z > 6.8
         then
           begin
              zz:=sqr(z);
              d:=zz+3-1/(0.22*zz+0.704);
              m:=1-1/d;
              p:=0.5-exp(-0.5*zz)*m/(z*sqrt(2*pi));
           end
         else
           begin
             p:=0.0;
             if z > 0.0 then
               begin
                   zz4:=0.25*sqr(z);
                   n2:=2;       // initial value of 2n          ; n = 1
                   theta2:=1.0; // initial value of theta(2n-2)
                   theta1:=zz4; // initial value of theta(2n-1)
                   p:=1;        // sum for n = 0
                   p_prev:=0;   // initial value of sub-sum
                   while true do
                     begin
                         theta2:=zz4*(theta1-theta2)/n2;
                         n2:=n2+1;
                         p:=p+theta2/n2;
                         if p = p_prev then goto QP;
                         theta1:=zz4*(theta2-theta1)/n2;
                         n2:=n2+1;
                         p_prev:=p;
                     end;
                 QP : ;
                   p:=z*exp(-0.5*zz4)*p/sqrt(2*pi);
               end;
           end;

       Normal_0_To_Z:=p;
  end;   {   Normal_0_To_Z   }



function Cum_NormalKC( z : extended ) : extended;
  var  v : extended;
  begin
      if z >= 0.0
        then
          begin
            if z > 0.0
              then
                begin
                   v:=0.5+Normal_0_To_Z(z);
                   if v > 1.0 then Cum_NormalKC:=1.0
                              else Cum_NormalKC:=v;
                end
              else Cum_NormalKC:=0.5;
          end
        else
          begin
              v:=0.5-Normal_0_To_Z( abs(z) );
              if v < 0.0 then Cum_NormalKC:=0.0
                         else Cum_NormalKC:=v;
          end;
  end;    {   Cum_NormalKC   }



function FuncPSE( i : integer ) : extended;
  begin
      FuncPSE:=PSEMin+(PSEMax-PSEMin)*i/NPoints;
  end;

function FuncSgm( i : integer ) : extended;
  begin
      FuncSgm:=SgmMin+(SgmMax-SgmMin)*i/NPoints;
  end;



//   urhWhv̊m
function ProbP( x : extended ) : extended;
  begin
      ProbP:=Cum_NormalKC( (x-gmu{-gc})/gsigma );
  end;


//   urhWhv̊m
function ProbQ( x : extended ) : extended;
   begin
      ProbQ:=1-Cum_NormalKC( (x-gmu{+gc})/gsigma );
  end;


//         ޓx֐
function LF( mu, sigma : extended ) : extended;
  var v, p1, p2 : extended;
      i : integer;
  
  function MyLN( a : extended ) : extended;
    begin
        if a > 0.0 then MyLN:=LN(a)
                   else MyLN:=-11399.0;
    end;

  begin
      gmu:=mu;
      gsigma:=sigma;

      v:=0.0;
      for i:=1 to n1 do
        with ARec1[i] do
          begin
            p1:=ProbP(St);
            p2:=1-p1;  //ProbQ(St);
            if More > 0  then v:=v+More*MyLN(p1);
            if Less > 0  then v:=v+Less*MyLN(p2);
          end;

      if v > -11396.0 then LF:=exp(v)
                      else LF:=0.0;
  end;



procedure TMainForm.ExitButtonClick(Sender: TObject);
begin
           Close;
end;


procedure TMainForm.FormCreate(Sender: TObject);
var sel : TGridRect;      //  IZ̈ʒu\킷߂̌^
    i : Longint;
begin
    SetPrecisionMode(pmExtended);

    with StringGrid1 do
      begin
          ColCount:=4;                  //  
          for i:=1 to 3 do
            ColWidths[i]:=Round(1.5*ColWidths[0]); //  ̕
          Width:=Round(5.0*ColWidths[0])+70;
          RowCount:=2;                  //  s
          Font.Height:=16;
          Cells[0,0]:=' n-1';
          Cells[0,1]:='1Ԗ';
          Cells[1,0]:=' rh';
          Cells[2,0]:=' 唻f';
          Cells[3,0]:=' f';
          Options:=Options-[goRangeSelect];  //  PZ̑I
          with sel do                        //  Z̈ʒu
            begin  Left:=1; Top:=1; Right:=1; Bottom:=1;  end;
          Selection:=sel;                    //  IZ̐ݒ
          Options:=[goEditing]+Options;      //  ZҏW
          EditorMode:=true;                  //  ZҏW
      end;

    SSEdit.Text:='';
    PSEMinEdit.Text:='';
    PSEMaxEdit.Text:='';
    JNDMinEdit.Text:='';
    JNDMaxEdit.Text:='';
    cnfLEdit.Text:='';
end;


(*           s̒ǉ          *)
procedure TMainForm.AddButtonClick(Sender: TObject);
var   i, j, pos : Longint;
begin
      with StringGrid1 do
        begin
            pos:=Selection.top;
            RowCount:=RowCount+1;
            Cells[0,RowCount-1]:=IntToStr(RowCount-1)+'Ԗ';
            for j:=1 to 3 do
              Cells[j,RowCount-1]:=' ';
            if (0 < pos) and (pos < RowCount-2) then
              begin
                for i:=RowCount-1 downto pos+2 do
                  for j:=1 to 3 do
                    Cells[j,i]:=Cells[j,i-1];
                for j:=1 to 3 do
                  Cells[j,pos+1]:=' ';
              end;
        end;
end;

(*          s̍폜           *)
procedure TMainForm.DelButtonClick(Sender: TObject);
var pos, i, j : Longint;
begin
    with StringGrid1 do
      begin
        if RowCount > 2 then
          begin
            pos:= Selection.top;     //  Is̐ݒ

            //   Z̒l̈ړ
            if (0 < pos) then
              begin
                if (pos < RowCount-1) then
                  for i:=pos to RowCount-2 do
                    for j:=1 to 3 do
                      Cells[j,i]:=Cells[j,i+1];

                   //   Ō̍s폜
                RowCount:=RowCount-1;

                for i:=1 to RowCount-1 do
                  Cells[0,i]:=IntToStr(i)+'Ԗ';
              end;
          end;
      end;
end;

//  StringGridɐݒ肳ꂽf[^̓Ǎ݂ƕ`
procedure TMainForm.CalcButtonClick(Sender: TObject);
var i, j, k, x0, x1, y0, y1, x20, x21, y20, y21, w, cs  : Longint;
    v, v0, v1, p1, p2, p3, SumP : extended;
    sdata  : string;
    VRec : TRec;

  function xpos( a : extended ) : Longint;
    var v : extended;
    begin
          v:=x0 + (x1-x0)/(n1+1) + (a-ARec1[1].St)*(x1-x0)*((n1-1)/(n1+1))
                                   /(ARec1[n1].St-ARec1[1].St);
          xpos:=round(v);
    end;

  function ypos( b : extended ) : Longint;
    begin
          ypos:=round( y0-b*(y0-y1) );
    end;


begin
     //   Whl̓Ǎ
     try
       Sstd:=StrToFloat(SSEdit.Text);
     except
       ShowMessage('Whl̐ݒ肪sKł');
       exit;
     end;

     //  p^͈̔͂̐ݒ
     try
       cnfL:=StrToFloat(cnfLEdit.Text);
       if cnfL <= 50.0 then cnfL:=50.0;
       if cnfL >= 99.0 then cnfL:=99.0;
       PSEMin:=StrToFloat(PSEMinEdit.Text);
       PSEMax:=StrToFloat(PSEMaxEdit.Text);
       SgmMin:=StrToFloat(JNDMinEdit.Text)/0.67448975;
       if SgmMin <= 1.0e-5 then SgmMin:=1.0e-5;
       SgmMax:=StrToFloat(JNDMaxEdit.Text)/0.67448975;
     except
       ShowMessage('A̐ݒ肪sKł');
       exit;
     end;


     with StringGrid1 do
       begin
         n1:=RowCount-1;   //   f[^̐ݒ
         try
           for i:=1 to n1 do
             with ARec1[n1+1-i] do
               begin
                 St:=StrToFloat(Cells[1,i]);  //   f[^z֐ݒ
               end;
         except                             //   sȃf[^
           ShowMessage('Error ===>  Cells[1,'+IntToStr(i)+'] = '
                        +Cells[1,i]);
           Exit;   //   ̎葱̏I
         end;

         try
           for i:=1 to n1 do
             with ARec1[n1+1-i] do
               begin
                 More:=StrToInt(Cells[2,i]);  //   f[^z֐ݒ
               end;
         except                             //   sȃf[^
           ShowMessage('Error ===>  Cells[2,'+IntToStr(i)+'] = '
                        +Cells[2,i]);
           Exit;   //   ̎葱̏I
         end;

         try
           for i:=1 to n1 do
             with ARec1[n1+1-i] do
               begin
                 Less:=StrToInt(Cells[3,i]);  //   f[^z֐ݒ
               end;
         except                             //   sȃf[^
           ShowMessage('Error ===>  Cells[3,'+IntToStr(i)+'] = '
                        +Cells[4,i]);
           Exit;   //   ̎葱̏I
         end;
       end;

     for i:=1 to n1-1 do
       begin
         k:=i;
         for j:=i+1 to n1 do
           if ARec1[k].St > ARec1[j].St then k:=j;
         if i < k then
           begin
             VRec:=ARec1[i]; ARec1[i]:=ARec1[k]; ARec1[k]:=VRec;
           end;
       end;

     with OpenDialogG do
       begin
         Title:='o̓t@C̐ݒ';
         FileName:='*.txt';
         if not execute then exit;
         AssignFile(outfG,FileName);
         Rewrite(outfG);
         CkFG:=1;
       end;

     writeln(outfG);
     writeln(outfG, 'PSEMin = ', FloatToStrF(PSEMin,ffGeneral,9,3));
     writeln(outfG, 'PSEMax = ', FloatToStrF(PSEMax,ffGeneral,9,3));
     writeln(outfG, 'JNDMin = ', FloatToStrF(SgmMin*0.67448975,ffGeneral,9,3));
     writeln(outfG, 'JNDMax = ', FloatToStrF(SgmMax*0.67448975,ffGeneral,9,3));
     writeln(outfG);  

     writeln(outfG, 'f[^...');
     for i:=1 to n1 do
       with ARec1[i] do
         writeln(outfG, 'ST[', i, '] = ', FloatToStrF(St,ffFixed, 9,2),
                        '     More = ', IntToStr(More),
                 //       '     Equal = ', IntToStr(Equal),
                        '     Less = ', IntToStr(Less) );


     {---------------------------------------------

                f[^̕`

     ---------------------------------------------}

     //   l̐ݒ
     gmu:=Sstd; gsigma:=1.0; // gc:=0.5*gsigma;

     ExitButton.SetFocus;
     UpDate;

     //   `ptH[̐@jbgUDrawGraph
     GraphForm:=TGraphForm.Create(Self);
     with GraphForm do
       begin
         Visible:=true;      UpDate;
         WindowState:=wsMaximized; UpDate;  //  `ʂ̍ő剻


         //     `ʂł̃R|[lg̔zu
         with ExitButton do
           begin
               Top:=0; Left:=0;
           end;

         with PMButton do
           begin
             Top:=0;
             Left:=ExitButton.Width*2;
           end;
         with PSEButton do
           begin
             Top:=0;
             Left:=ExitButton.Width*4;
           end;
         with JNDButton do
           begin
             Top:=0;
             Left:=ExitButton.Width*6;
           end;

         ExitButton.Enabled:=false;
         PMButton.Enabled:=false;
         PSEButton.Enabled:=false;
         JNDButton.Enabled:=false;

         UpDate;

         with Panel1 do
           begin
             Top:=round(ExitButton.Height*1.2);
             Left:=0;
             Width:=GraphForm.ClientWidth;
             Height:=GraphForm.ClientHeight-Top;
           end;

         //  Panel1ɂ`pImageR|[lg̐ݒ
         with Image1 do
           begin
             Top:=0; Left:=0;
             Width:=Panel1.Width;
             Height:=Panel1.Height;
           end;

         with Image1.Canvas do
           begin
             Pen.Color:=clWhite;
             Brush.Color:=clWhite;
             Rectangle(0,0,ClientWidth,ClientHeight);
             UpDate;

             Font.Size:=12;
             TextOut(50,50,'z̏łB');
             UpDate;

             v:=1/((NPoints+1.0)*(NPoints+1.0){*(NPoints+1.0)});
             for i:=0 to NPoints do
               for j:=0 to NPoints do
                   Pprior[i,j{,k}]:=v;

             TextOut(50,50,'                               ');
             TextOut(50,50,'m̌vZ̏Ă܂B');
             UpDate;

             SumP:=0.0;
             for i:=0 to NPoints do
               begin
                 TextOut(50,50,'i = '+IntToStr(i)+'/'+
                               IntToStr(NPoints)+'                  '+
                               '                                       ');
                 UpDate;

                 for j:=0 to NPoints do
                     begin
                       Ppost[i,j]:=LF( FuncPSE(i), FuncSgm(j) )
                                     *Pprior[i,j];
                       SumP:=SumP+Ppost[i,j];
                     end;
               end;

             TextOut(50,50,'                                         '+
                           '                                           ');
             UpDate;
             TextOut(50,50,'m̌vZłB');
             UpDate;

             for i:=0 to NPoints do
               for j:=0 to NPoints do
                   Ppost[i,j]:=Ppost[i,j]/SumP;

             TextOut(50,50,'                                         ');
             UpDate;
             TextOut(50,50,'ӕžvZłB');
             UpDate;

             for i:=0 to NPoints do
               begin
                 PPSE[i]:=0.0;
                 for j:=0 to NPoints do
                     PPSE[i]:=PPSE[i]+Ppost[i,j];
               end;

             for j:=0 to NPoints do
               begin
                 PSgm[j]:=0.0;
                 for i:=0 to NPoints do
                     PSgm[j]:=PSgm[j]+Ppost[i,j];
               end;

             TextOut(50,50,'                                         '+
                           '                                           ');
             UpDate;
             TextOut(50,50,'_ľvZłB');
             UpDate;

             gmu:=0.0;
             for i:=0 to NPoints do
               gmu:=gmu+FuncPSE(i)*PPSE[i];

             writeln(outfG);
             writeln(outfG, 'mu = ', FloatToStrF(gmu,ffGeneral,7,1));

             gsigma:=0.0;
             for j:=0 to NPoints do
               gsigma:=gsigma+FuncSgm(j)*PSgm[j];

             writeln(outfG);
             writeln(outfG, 'sigma = ', FloatToStrF(gsigma,ffGeneral,7,1));  

             Pen.Color:=clWhite;
             Brush.Color:=clWhite;
             Rectangle(0,0,ClientWidth,ClientHeight);
             UpDate;


             //   nP̕\p_̐ݒ
             x0:=round(Image1.Width*0.05);
             x1:=round(Image1.Width*0.95);
             y0:=round(Image1.Height*0.7);
             y1:=round(Image1.Height*0.2);

             //   nP̕\
             with Pen do
               begin
                   Width:=1;
                   Color:=clBlack;
               end;
             Brush.Style:=bsClear;
             Rectangle(x0,y1,x1,y0);

             w:=round(0.25*(x1-x0)/(n1+1));
             Pen.Width:=2;
             Brush.Style:=bsClear;
             cs:=Round(0.015*y0);
             for i:=1 to n1 do
               with ARec1[i] do
                 begin
                   Pen.Color:=clBlue;
                   Ellipse(xpos(St)-cs, ypos(More/(More+Less))-cs,
                           xpos(St)+cs, ypos(More/(More+Less))+cs );
                 end;

             UpDate;

             with Pen do
               begin
                   Width:=2;
               end;      
             v0:=ARec1[1].St-(ARec1[2].St-ARec1[1].St);
             v1:=ARec1[n1].St+(ARec1[n1].St-ARec1[n1-1].St);


             //  Prob(XWh)̃Ot̕`
             Pen.Color:=clRed;
             MoveTo(xpos(v0),ypos(ProbP(v0)));
             for i:=1 to NStep do
               begin
                 LineTo(xpos(v0+i*(v1-v0)/NStep),
                        ypos(ProbP(v0+i*(v1-v0)/NStep)));
                 UpDate;
               end;

             //   Whl̕\
             Brush.Style:=bsClear;
             Font.Height:=round(y1/6);
             sdata:='Whl = '+FloatToStrF(Sstd,ffGeneral,5,1);
             TextOut((ClientWidth-TextWidth(sdata)) div 2,
                     round(y1*2/6), sdata);
             sdata:='PSE = '+FloatToStrF(gmu,ffGeneral,5,1)+
                    '     Sigma = '+FloatToStrF(gsigma,ffGeneral,5,1);
             TextOut((ClientWidth-TextWidth(sdata)) div 2,
                     round(y1*4/6), sdata);


             //   Whl̈ʒu}[N
             Pen.Color:=clRed;
             Ellipse(xpos(Sstd)-3,ypos(0.0)-3, xpos(Sstd)+3,ypos(0.0)+3);

             //   Mark the Min and Max values on the abscissa
             with Pen do
               begin
                   Width:=1;
                   Color:=clBlack;
               end;

             MoveTo(xpos(ARec1[1].St), ypos(0.0));
             LineTo(xpos(ARec1[1].St), ypos(-0.03));
             Brush.Style:=bsClear;
             Font.Height:=round(0.8*y1/6);
             sdata:=FloatToStrF(ARec1[1].ST,ffGeneral,5,1);
             TextOut(xpos(ARec1[1].St)-(TextWidth(sdata) div 2),
                     ypos(-0.05), sdata);

             MoveTo(xpos(ARec1[n1].St), ypos(0.0));
             LineTo(xpos(ARec1[n1].St), ypos(-0.03));
             Brush.Style:=bsClear;
             Font.Height:=round(0.8*y1/6);
             sdata:=FloatToStrF(ARec1[n1].ST,ffGeneral,5,1);
             TextOut(xpos(ARec1[n1].St)-(TextWidth(sdata) div 2),
                     ypos(-0.05), sdata);

             Font.Height:=round(y1/6);
             sData:='ٕ臂ɂl = '+
                    FloatToStrF(gmu-0.67448975*gsigma,ffGeneral,7,1)+
                    '     ٕ臂ɂl = '+
                    FloatToStrF(gmu+0.67448975*gsigma,ffGeneral,7,1);
             TextOut((ClientWidth-TextWidth(sdata)) div 2,
                     ypos(-0.05)+round(y1*2/6), sdata);

             sData:='JND = '+FloatToStrF(0.67448975*gsigma,ffGeneral,7,1);
             TextOut((ClientWidth-TextWidth(sdata)) div 2,
                     ypos(-0.05)+round(y1*4/6), sdata);
           end;

         ExitButton.Enabled:=true;
         PMButton.Enabled:=true;
         PSEButton.Enabled:=true;
         JNDButton.Enabled:=true;
       end;
end;


(*    Obhɐݒ肳Ăf[^̕ۑ    *)
procedure TMainForm.SaveButtonClick(Sender: TObject);
var outf : TextFile;
    i, j : Longint;
    FN : string;

  function CheckCSV( s : string ) : string;
    begin
        if Length(s) < 5 then s:=s+'.csv'
        else if  (Copy(s, Length(s)-3,4) <> '.csv')
               and
                 (Copy(s, Length(s)-3,4) <> '.CSV') then s:=s+'.csv';
        CheckCSV:=s;
    end;

begin
    with SaveDialog1 do        //   ۑpt@C̖O̐ݒ
      begin
          Title:='t@C';
          FileName:='*.csv';
          if not Execute then exit;
          FN:=CheckCSV(FileName);
          AssignFile(outf,FN);
      end;

    Rewrite(outf);             //  t@Copɐݒ

    with StringGrid1 do
      begin
        for i:=1 to RowCount-1 do
          begin
            for j:=1 to 2 do
              write(outf,Trim(Cells[j,i]), ','); //  f[^̏o
            writeln(outf,Trim(Cells[3,i]));
          end;
      end;

    writeln(outf,Trim(SSEdit.Text));

    CloseFile(outf);
end;

(*    t@CObhփf[^ǂݍ    *)
procedure TMainForm.LoadButtonClick(Sender: TObject);
Label Q1;
var inf : TextFile;
    i   : Longint;
    s      : string;
    SL : TStringList;

  function CheckSL : boolean;
    var ck : boolean;
    begin
      ck:=true;
      if  SL.Count < 2 then ck:=false
      else if Trim(SL.Strings[1]) = '' then ck:=false;

      CheckSL:=ck;
    end;

begin
    with OpenDialog1 do           //  t@C̐ݒ
      begin
          Title:='t@C';
          FileName:='*.csv';
          if not Execute then exit;
          AssignFile(inf,FileName);
      end;

    Reset(inf);                  //   t@Cǂݏopɐݒ
    SL:=TStringList.Create;
    with StringGrid1 do
      begin
        RowCount:=1;
        repeat
          readln(inf,s);
          SL.CommaText:=s;
          if CheckSL
            then
              begin
                RowCount:=RowCount+1;
                Cells[0,RowCount-1]:=IntToStr(RowCount-1)+'Ԗ';
                for i:=1 to 3 do
                  Cells[i,RowCount-1]:=Trim(SL.Strings[i-1]);
              end
            else
              begin
                SSEdit.Text:=Trim(SL.Strings[0]);
                break;  //  goto Q1;
              end;
        until eof(inf);
      end;

  Q1 :
    CloseFile(inf);
    SL.Free;
    PSEMinEdit.SetFocus;
end;



//    ݒf[^̃v^o
procedure TMainForm.PButtonClick(Sender: TObject);
var outf : TextFile;
    i, j : Longint;

  function AdjToL( s : string; L : Longint ) : string;
    var v : string;
        i : Longint;
    begin
        v:=s;
        if Length(s) < L then
          for i:=1 to L-Length(s) do v:=v+' ';
        AdjToL:=v;
    end;

begin
    if not PrintDialog1.execute then exit;

    AssignPrn(outf);
    Rewrite(outf);
    with Printer.Canvas.Font do
      begin
        Name:='lr SVbN';
        Size:=12;
      end;

    writeln(outf,'  Wh = ',SSEdit.Text);
    writeln(outf);
    with StringGrid1 do
      begin
        for i:=0 to RowCount-1 do
          begin
            for j:=0 to 3 do
              write(outf, '  ',AdjToL(Trim(Cells[j,i]), 10) );
            writeln(outf);
          end;
      end;

    CloseFile(outf);
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
       if CkFG <> 0 then
         begin
           ShowMessage('o̓t@C = '+OpenDialogG.FileName);
           CloseFile(outfg);
         end;
end;

end.
