unit UDrawGraphBayes;  //  `Aĕ`AœKp[^̒T

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TGraphForm = class(TForm)
    ExitButton: TButton;
    Panel1: TPanel;
    Image1: TImage;
    PMButton: TButton;
    PSEButton: TButton;
    JNDButton: TButton;
    procedure ExitButtonClick(Sender: TObject);
    procedure PMButtonClick(Sender: TObject);
    procedure PSEButtonClick(Sender: TObject);
    procedure JNDButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  GraphForm: TGraphForm;

implementation

{$R *.DFM}

uses
  Printers, UConstStBayes;

{$R+}

procedure TGraphForm.ExitButtonClick(Sender: TObject);
begin
            UConstStBayes.MainForm.Close;
end;




procedure TGraphForm.PMButtonClick(Sender: TObject);
var i, j, k, x0, x1, y0, y1, x20, x21, y20, y21, w, cs  : Longint;
    v, v0, v1, p1, p2, p3, SumP : extended;
    sdata  : string;

  function xpos( a : extended ) : Longint;
    var v : extended;
    begin
          v:=x0 + (x1-x0)/(n1+1) + (a-ARec1[1].St)*(x1-x0)*((n1-1)/(n1+1))
                                   /(ARec1[n1].St-ARec1[1].St);
          xpos:=round(v);
    end;

  function ypos( b : extended ) : Longint;
    begin
          ypos:=round( y0-b*(y0-y1) );
    end;
begin
  with Image1.Canvas do
    begin
      Pen.Color:=clWhite;
      Brush.Color:=clWhite;
      Rectangle(0,0,ClientWidth,ClientHeight);
      UpDate;


      //   nP̕\p_̐ݒ
      x0:=round(Image1.Width*0.05);
      x1:=round(Image1.Width*0.95);
      y0:=round(Image1.Height*0.7);
      y1:=round(Image1.Height*0.2);

      //   n̕\
      with Pen do
        begin
            Width:=1;
            Color:=clBlack;
        end;
      Brush.Style:=bsClear;
      Rectangle(x0,y1,x1,y0);

      w:=round(0.25*(x1-x0)/(n1+1));
      Pen.Width:=2;
      Brush.Style:=bsClear;
      cs:=Round(0.015*y0);
      for i:=1 to n1 do
        with ARec1[i] do
          begin
            Pen.Color:=clBlue;
            Ellipse(xpos(St)-cs, ypos(More/(More+Less))-cs,
                    xpos(St)+cs, ypos(More/(More+Less))+cs );
          end;

      UpDate;

      with Pen do
        begin
            Width:=2;
        end;
      v0:=ARec1[1].St-(ARec1[2].St-ARec1[1].St);
      v1:=ARec1[n1].St+(ARec1[n1].St-ARec1[n1-1].St);



      //  Prob(XWh)̃Ot̕`
      Pen.Color:=clRed;
      MoveTo(xpos(v0),ypos(ProbP(v0)));
      for i:=1 to NStep do
        begin
          LineTo(xpos(v0+i*(v1-v0)/NStep),
                 ypos(ProbP(v0+i*(v1-v0)/NStep)));
          UpDate;
        end;

      //   Whl̕\
      Brush.Style:=bsClear;
      Font.Height:=round(y1/6);
      sdata:='Whl = '+FloatToStrF(Sstd,ffGeneral,5,1);
      TextOut((ClientWidth-TextWidth(sdata)) div 2,
              round(y1*2/6), sdata);
      sdata:='PSE = '+FloatToStrF(gmu,ffGeneral,5,1)+
             '     Sigma = '+FloatToStrF(gsigma,ffGeneral,5,1);
      TextOut((ClientWidth-TextWidth(sdata)) div 2,
              round(y1*4/6), sdata);


      //   Whl̈ʒu}[N
      Pen.Color:=clRed;
      Ellipse(xpos(Sstd)-3,ypos(0.0)-3, xpos(Sstd)+3,ypos(0.0)+3);

      //   Mark the Min and Max values on the abscissa
      with Pen do
        begin
            Width:=1;
            Color:=clBlack;
        end;

      MoveTo(xpos(ARec1[1].St), ypos(0.0));
      LineTo(xpos(ARec1[1].St), ypos(-0.03));
      Brush.Style:=bsClear;
      Font.Height:=round(0.8*y1/6);
      sdata:=FloatToStrF(ARec1[1].ST,ffGeneral,5,1);
      TextOut(xpos(ARec1[1].St)-(TextWidth(sdata) div 2),
              ypos(-0.05), sdata);

      MoveTo(xpos(ARec1[n1].St), ypos(0.0));
      LineTo(xpos(ARec1[n1].St), ypos(-0.03));
      Brush.Style:=bsClear;
      Font.Height:=round(0.8*y1/6);
      sdata:=FloatToStrF(ARec1[n1].ST,ffGeneral,5,1);
      TextOut(xpos(ARec1[n1].St)-(TextWidth(sdata) div 2),
              ypos(-0.05), sdata);

      Font.Height:=round(y1/6);
      sData:='ٕ臂ɂl = '+
             FloatToStrF(gmu-0.67448975*gsigma,ffGeneral,7,1)+
             '     ٕ臂ɂl = '+
             FloatToStrF(gmu+0.67448975*gsigma,ffGeneral,7,1);
      TextOut((ClientWidth-TextWidth(sdata)) div 2,
              ypos(-0.05)+round(y1*2/6), sdata);

      sData:='JND = '+FloatToStrF(0.67448975*gsigma,ffGeneral,7,1);
      TextOut((ClientWidth-TextWidth(sdata)) div 2,
              ypos(-0.05)+round(y1*4/6), sdata);
    end;
end;

procedure TGraphForm.PSEButtonClick(Sender: TObject);
var x0, x1, y0, y1, i : integer;
    pmax, v, se, pL, pU : extended;
    dstr : string;

  function xpos( x : extended ) : integer;
    begin
        xpos:=Round(x0+x*(x1-x0));
    end;

  function ypos( y : extended ) : integer;
    begin
        ypos:=Round(y0-y*(y0-y1));
    end;

begin
    with IMage1, Canvas do
      begin
        Pen.Color:=clWhite;
        Brush.Color:=clWhite;
        Rectangle(0,0,Width,Height);

        x0:=Round(Width*0.2);
        x1:=Round(Width*0.8);
        y0:=Round(Height*0.8);
        y1:=Round(Height*0.2);

        with Pen do
          begin
            Width:=2;
            Color:=clBlack;
          end;
        with Brush do
          begin
            Style:=bsSolid;
          end;
        Rectangle(xpos(0.0), ypos(1.0), xpos(1.0), ypos(0.0));

        pmax:=0.0;
        for i:=0 to NPoints do
          if pmax < PPSE[i] then pmax:=PPSE[i];
        Pen.Width:=1;
        MoveTo(xpos(0.0), ypos(0.9*PPSE[0]/pmax));
        for i:=1 to NPoints do
          LineTo(xpos(i/NPoints), ypos(0.9*PPSE[i]/pmax));

        v:=0.0;
        for i:=0 to NPoints do
          v:=v+sqr(FuncPSE(i)-gmu)*PPSE[i];
        se:=sqrt(v);

        dstr:='PSE̎㕪z    Mean = '+FloatToStrF(gmu,ffGeneral,5,1)+
              '     SD = '+FloatToStrF(se,ffGeneral,5,1);
        Font.Height:=Round(0.07*(y0-y1));
        TextOut((width-TextWidth(dstr)) div 2, ypos(1.2), dstr);

        Font.Height:=Round(0.05*(y0-y1));
        MoveTo(xpos(0.0),ypos(0.0));
        LineTo(xpos(0.0), ypos(-0.02));
        dstr:=FloatToStrF(PSEMin,ffGeneral,5,1);
        TextOut(xpos(0.0)-(TextWidth(dstr) div 2),
                ypos(-0.04), dstr);
        MoveTo(xpos(1.0),ypos(0.0));
        LineTo(xpos(1.0), ypos(-0.02));
        dstr:=FloatToStrF(PSEMax,ffGeneral,5,1);
        TextOut(xpos(1.0)-(TextWidth(dstr) div 2),
                ypos(-0.04), dstr);
        v:=(gmu-FuncPSE(0))/(PSEMax-PSEMin);
        MoveTo(xpos(v),ypos(0.0));
        LineTo(xpos(v), ypos(-0.02));
        dstr:=FloatToStrF(gmu,ffGeneral,5,1);
        TextOut(xpos(v)-(TextWidth(dstr) div 2),
                ypos(-0.04), dstr);

        CalcCrtclP( 0.5*(100-cnfL)/100, PPSE, FuncPSE, pL );

        v:=(pL-FuncPSE(0))/(PSEMax-PSEMin);
        MoveTo(xpos(v),ypos(0.0));
        LineTo(xpos(v), ypos(-0.02));
        dstr:=FloatToStrF(pL,ffGeneral,5,1);
        TextOut(xpos(v)-(TextWidth(dstr) div 2),
                ypos(-0.09), dstr);

        CalcCrtclP( 0.5*(100+cnfL)/100, PPSE, FuncPSE, pU );

        v:=(pU-FuncPSE(0))/(PSEMax-PSEMin);
        MoveTo(xpos(v),ypos(0.0));
        LineTo(xpos(v), ypos(-0.02));
        dstr:=FloatToStrF(pU{gmu+se},ffGeneral,5,1);
        TextOut(xpos(v)-(TextWidth(dstr) div 2),
                ypos(-0.14), dstr);

        with Pen do
          begin
            Width:=5;
            Color:=clRed;
          end;
        v:=(pL-FuncPSE(0))/(PSEMax-PSEMin);
        MoveTo(xpos(v),ypos(0.0));
        v:=(pU-FuncPSE(0))/(PSEMax-PSEMin);
        LineTo(xpos(v),ypos(0.0));
        Font.Color:=clRed;
        dstr:=FloatToStrF(cnfL,ffGeneral,5,1)+'% mM';
        v:=(gmu-FuncPSE(0))/(PSEMax-PSEMin);
        TextOut(xpos(v)-(TextWidth(dstr) div 2),
                ypos(-0.19), dstr);
        Font.Color:=clBlack;

        writeln(outfG);
        writeln(outfG,'PSE = ', FloatToStrF(gmu,ffGeneral,5,1));
        writeln(outfG, 'se(PSE) = ', FloatToStrF(se,ffGeneral,5,1));
        writeln(outfG, FloatToStrF(cnfL,ffGeneral,4,1),
                       '% mM ==> ',
                       FloatToStrF(pL,ffGeneral,7,1),
                       ' - ',
                       FloatToStrF(pU,ffGeneral,7,1) );
      end;
end;

//   JND = 0.67448975 * Sigma
procedure TGraphForm.JNDButtonClick(Sender: TObject);
var x0, x1, y0, y1, i : integer;
    pmax, v, se, pL, pU : extended;
    dstr : string;

  function xpos( x : extended ) : integer;
    begin
        xpos:=Round(x0+x*(x1-x0));
    end;

  function ypos( y : extended ) : integer;
    begin
        ypos:=Round(y0-y*(y0-y1));
    end;

begin
    with IMage1, Canvas do
      begin
        Pen.Color:=clWhite;
        Brush.Color:=clWhite;
        Rectangle(0,0,Width,Height);

        x0:=Round(Width*0.2);
        x1:=Round(Width*0.8);
        y0:=Round(Height*0.8);
        y1:=Round(Height*0.2);

        with Pen do
          begin
            Width:=2;
            Color:=clBlack;
          end;
        with Brush do
          begin
            Style:=bsSolid;
          end;
        Rectangle(xpos(0.0), ypos(1.0), xpos(1.0), ypos(0.0));

        pmax:=0.0;
        for i:=0 to NPoints do
          if pmax < PSgm[i] then pmax:=PSgm[i];
        Pen.Width:=1;
        MoveTo(xpos(0.0), ypos(0.9*PSgm[0]/pmax));
        for i:=1 to NPoints do
          LineTo(xpos(i/NPoints), ypos(0.9*PSgm[i]/pmax));

        v:=0.0;
        for i:=0 to NPoints do
          v:=v+sqr(0.67448975*(FuncSgm(i)-gsigma))*PSgm[i];
        se:=sqrt(v);

        dstr:='JND̎㕪z    Mean = '+
              FloatToStrF(0.67448975*gsigma,ffGeneral,5,1)+
              '     SD = '+FloatToStrF(se,ffGeneral,5,1);
        Font.Height:=Round(0.07*(y0-y1));
        TextOut((width-TextWidth(dstr)) div 2, ypos(1.2), dstr);

        Font.Height:=Round(0.05*(y0-y1));
        MoveTo(xpos(0.0),ypos(0.0));
        LineTo(xpos(0.0), ypos(-0.02));
        dstr:=FloatToStrF(SgmMin*0.67448975,ffGeneral,5,1);
        TextOut(xpos(0.0)-(TextWidth(dstr) div 2),
                ypos(-0.04), dstr);
        MoveTo(xpos(1.0),ypos(0.0));
        LineTo(xpos(1.0), ypos(-0.02));
        dstr:=FloatToStrF(SgmMax*0.67448975,ffGeneral,5,1);
        TextOut(xpos(1.0)-(TextWidth(dstr) div 2),
                ypos(-0.04), dstr);

        v:=(gsigma-FuncSgm(0))/(SgmMax-SgmMin);
        MoveTo(xpos(v),ypos(0.0));
        LineTo(xpos(v), ypos(-0.02));
        dstr:=FloatToStrF(gsigma*0.67448975,ffGeneral,5,1);
        TextOut(xpos(v)-(TextWidth(dstr) div 2),
                ypos(-0.04), dstr);

        CalcCrtclP( 0.5*(100-cnfL)/100, PSgm, FuncSgm, pL );

        v:=(pL-FuncSgm(0))/(SgmMax-SgmMin);
        MoveTo(xpos(v),ypos(0.0));
        LineTo(xpos(v), ypos(-0.02));
        dstr:=FloatToStrF(pL*0.67448975,ffGeneral,5,1);
        TextOut(xpos(v)-(TextWidth(dstr) div 2),
                ypos(-0.09), dstr);

        CalcCrtclP( 0.5*(100+cnfL)/100, PSgm, FuncSgm, pU );

        v:=(pU-FuncSgm(0))/(SgmMax-SgmMin);
        MoveTo(xpos(v),ypos(0.0));
        LineTo(xpos(v), ypos(-0.02));
        dstr:=FloatToStrF(pU*0.67448975,ffGeneral,5,1);
        TextOut(xpos(v)-(TextWidth(dstr) div 2),
                ypos(-0.14), dstr);

        with Pen do
          begin
            Width:=5;
            Color:=clRed;
          end;
        v:=(pL-FuncSgm(0))/(SgmMax-SgmMin);
        MoveTo(xpos(v),ypos(0.0));
        v:=(pU-FuncSgm(0))/(SgmMax-SgmMin);
        LineTo(xpos(v),ypos(0.0));
        Font.Color:=clRed;
        dstr:=FloatToStrF(cnfL,ffGeneral,5,1)+'% mM';
        v:=(gsigma-FuncSgm(0))/(SgmMax-SgmMin);
        TextOut(xpos(v)-(TextWidth(dstr) div 2),
                ypos(-0.19), dstr);
        Font.Color:=clBlack;

        writeln(outfG);
        writeln(outfG,'JND = ', FloatToStrF(gsigma*0.67448975,ffGeneral,5,1));
        writeln(outfG,'se(JND) = ', FloatToStrF(se,ffGeneral,5,1));
        writeln(outfG,FloatToStrF(cnfL,ffGeneral,4,1),
                      '% mM ==> ',
                      FloatToStrF(pL*0.67448975,ffGeneral,7,1),
                      ' - ',
                      FloatToStrF(pU*0.67448975,ffGeneral,7,1) );
      end;
end;



end.