unit UTestDif;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, StdCtrls;

type
  TForm1 = class(TForm)
    StringGrid1: TStringGrid;
    Memo1: TMemo;
    CloseButton: TButton;
    Label1: TLabel;
    Edit1: TEdit;
    CalcButton: TButton;
    PrintButton: TButton;
    SaveDialog1: TSaveDialog;
    procedure FormCreate(Sender: TObject);
    procedure CloseButtonClick(Sender: TObject);
    procedure PrintButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure CalcButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure Display( s : string ) ;
  begin
      Form1.Memo1.Lines.Add(s);
  end;


procedure TForm1.FormCreate(Sender: TObject);
var sel : TGridRect;      //  IZ̈ʒu\킷߂̌^
begin                               
    Edit1.Text:='';
    with StringGrid1 do
      begin
          ColCount:=3;                  //  ̐
          RowCount:=3;                  //  ̃f[^̐
          Font.Height:=16;
          ColWidths[0]:=Round(1.2*ColWidths[0]);
          Cells[0,1]:='Session 1';
          Cells[0,2]:='Session 2';
          Cells[1,0]:='   f';
          Cells[2,0]:='   h';
          Options:=Options-[goRangeSelect];  //  PZ̑I
          with sel do                        //  Z̈ʒu
            begin  Left:=1; Top:=1; Right:=1; Bottom:=1;  end;
          Selection:=sel;                    //  IZ̐ݒ
          Options:=[goEditing]+Options;      //  ZҏW
          EditorMode:=true;                  //  ZҏW
      end;

    with Memo1 do
      begin
        Clear;
        Font.Size:=11;
      end;
    Display('Put values in the string grid component,');
    Display('and click Calc button.');
end;

procedure TForm1.CloseButtonClick(Sender: TObject);
begin
             Close;
end;

procedure TForm1.PrintButtonClick(Sender: TObject);
var f : TextFile;
    i : integer;
begin
    with SaveDialog1 do
      begin
        if not execute then exit;
        AssignFile(f, FileName);
        Rewrite(f);
      end;
    with Memo1, lines do
      for i := 1 to count do
        writeln(f, Strings[i-1]);

    CloseFile(f);
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
             PrintButton.Enabled:=false;
end;


  
type   TFunc = function( x : Extended ) : Extended;

 
{
      Kerridge and Cook(1976, Biometrika, 63, 401-403)'s Algorithm
                         referred to
      in  A. L. Brophy and  D. L. Wood (1989, Behav. Res. Meth. Istr.
                                        & Comp., 21, 447-454)
}

function  Normal_0_To_Z( z : extended ) : extended;
  label QP;
  var  p, zz, d, m, zz4, theta2,
       theta1, p_prev{, v }: extended;
       n2                : Longint;
  begin
       z:=abs(z);
       if z > 6.8
         then
           begin
              zz:=sqr(z);
              d:=zz+3-1/(0.22*zz+0.704);
              m:=1-1/d;
              p:=0.5-exp(-0.5*zz)*m/(z*sqrt(2*pi));
           end
         else
           begin
             p:=0.0;
             if z > 0.0 then
               begin
                   zz4:=0.25*sqr(z);
                   n2:=2;       // initial value of 2n          ; n = 1
                   theta2:=1.0; // initial value of theta(2n-2)
                   theta1:=zz4; // initial value of theta(2n-1)
                   p:=1;        // sum for n = 0
                   p_prev:=0;   // initial value of sub-sum
                   while true do
                     begin
                         theta2:=zz4*(theta1-theta2)/n2;
                         n2:=n2+1;
                         p:=p+theta2/n2;
                         if p = p_prev then goto QP;
                         theta1:=zz4*(theta2-theta1)/n2;
                         n2:=n2+1;
                         p_prev:=p;
                     end;
                 QP : ;
                   p:=z*exp(-0.5*zz4)*p/sqrt(2*pi);
               end;
           end;

       Normal_0_To_Z:=p;
  end;   {   Normal_0_To_Z   }


function Cum_NormalKC( z : extended ) : extended;
  var  v : extended;
  begin
      if z >= 0.0
        then
          begin
            if z > 0.0
              then
                begin
                   v:=0.5+Normal_0_To_Z(z);
                   if v > 1.0 then Cum_NormalKC:=1.0
                              else Cum_NormalKC:=v;
                end
              else Cum_NormalKC:=0.5;
          end
        else
          begin
              v:=0.5-Normal_0_To_Z( abs(z) );
              if v < 0.0 then Cum_NormalKC:=0.0
                         else Cum_NormalKC:=v; 
          end;
  end;    {   Cum_NormalKC   }


function phi( x : extended ) : extended;
  begin
        phi := (1/sqrt(2*pi))*exp(-0.5*sqr(x));
  end;


function CalcSE( d, Lambda : extended; N : integer ) : extended;
  var v, f, h : extended;
  begin
      f:=1-Cum_NormalKC(Lambda);
      h:=1-Cum_NormalKC(Lambda-d);
      v:=(f*(1-f)/N)/sqr(phi(Lambda)) + (h*(1-h)/N)/sqr(phi(d-Lambda));
      CalcSE:=sqrt(v);
  end;



function DCum_Normal( x : Extended ) : Extended;
  begin
        DCum_Normal:=exp(-sqr(x)/2)/sqrt(2*pi);
  end;

(*    Bisection@ɂ鍪̌vZ    *)

procedure  Bisection( f : TFunc;
                      s,         //   f֐̂Ƃ s > 0.0
                      c,         //   ɑ΂֐l
                      L_b, U_b   //   ̑݋Ԃ̉Ə
                                : Extended;
                      var  Root  //     f(Root) = c
                                : Extended;
                      acc       : Extended          );
  var  m, v : Extended;
  begin
         if (f(L_b)-c)*(f(U_b)-c) > 0.0 then
           begin
             ShowMessage('Ɖ̑gݍ킹sK؂łB');
             Application.Terminate;
           end;

         repeat
           m:=0.5*(L_b+U_b);
           v:=f(m);
           if s*(v-c) > 0.0 then U_b:=m
                            else L_b:=m;
         until  (abs(U_b-L_b) < acc*abs(U_b))
              or
                ( (abs(U_b)+abs(L_b)) < 1.0E-14 );

         Root:=0.5*(L_b+U_b);
  end;   {   Bisection   }


(*    Newton@ɂ鍪̌vZ   *)

procedure Newton( var x : Extended;  //  ̏lA߂l͍ f(x)=c
                  c     : Extended;  //  ֐l
                  f,             //  ֐
                  df             //  ֐
                        : TFunc;
                  acc   : Extended      );
  Label QP, QP0;
  var  x0, L_b, U_b : Extended;
       NStep : Longint;
  begin
       NStep:=0;
       repeat
            NStep:=NStep+1;
            if NStep > 20 then goto QP; //  20ȏJԂ̂Ƃ
            x0:=x;
            x:=x0+(c-f(x0))/df(x0);
       until ( abs(x-x0) < (acc*(abs(x)+abs(x0))) )
            or
             ( (abs(x)+abs(x0)) < 1.0E-14 );
       goto QP0;

    QP :        //   Bisection@ŌvZ
       L_b:=x;
       repeat  L_b:=L_b-1.0; until f(L_b) < c;
       U_b:=x;
       repeat  U_b:=U_b+1.0; until f(U_b) > c;

       Bisection( f, 1.0, c, L_b, U_b, x, acc );

    QP0 : ;
  end;   {   Newton   }


function CalcZ( p : extended ) : extended;
  var z : extended;
  begin
    z:=0.0;
    Newton( z, p, Cum_NormalKC, DCum_Normal, 1.0E-12 );
    CalcZ := z;
  end;


function CalcP( z : extended ) : extended;
  begin
      if z >= 0.0 then CalcP:=1-Cum_NormalKC(z)
                  else CalcP:=Cum_NormalKC(z);
  end;



procedure TForm1.CalcButtonClick(Sender: TObject);
var f1, h1, f2, h2,
    Lambda1, Lambda2, d1, d2, LogB1, LogB2,
    varf1, varh1, varf2, varh2,
    varLambda1, varLambda2, vard1, vard2,
    varLogB1, varLogB2, z : extended;
    N : integer;
begin
    try
      with StringGrid1 do
        begin
          f1:=StrToFloat(Cells[1,1]);
          h1:=StrToFloat(Cells[2,1]);
          f2:=StrToFloat(Cells[1,2]);
          h2:=StrToFloat(Cells[2,2]);
        end;
      N:=StrToInt(Edit1.Text);
    except
      ShowMessage('ݒ肳ĂlsK؂łB');
      exit;
    end;
    Memo1.Clear;
    Display('N = '+IntToStr(N));
    Display(' ');
    Display('Session 1...');
    Display('f = '+FloatToStr(f1));
    Display('h = '+FloatToStr(h1));
    Lambda1:=-CalcZ(f1);
    Display('Lambda = '+FloatToStrF(Lambda1,ffGeneral,5,3));
    varf1:=f1*(1-f1)/N;
  //  Display('varf = '+FloatToStrF(varf1,ffGeneral,5,3));
    varLambda1:=varf1/sqr(phi(Lambda1));
    Display('SE(Lambda) = '
            +FloatToStrF(sqrt(varLambda1),ffGeneral,5,3));
    d1:=CalcZ(h1)-CalcZ(f1);
    Display('d'' = '+FloatToStrF(d1,ffGeneral,5,3));
    varh1:=h1*(1-h1)/N;
 //   Display('varh = '+FloatToStrF(varh1,ffGeneral,5,3));
    vard1:=varf1/sqr(phi(Lambda1)) + varh1/sqr(phi(d1-Lambda1));
    Display('SE(d'') = '
            +FloatToStrF(sqrt(vard1),ffGeneral,5,3));
    LogB1:=0.5*(sqr(CalcZ(f1))-sqr(CalcZ(h1)));
    Display('LogB = '+FloatToStrF(LogB1,ffGeneral,5,3));
    varLogB1:=sqr(Lambda1)*varf1/sqr(phi(Lambda1))
              +sqr(d1-Lambda1)*varh1/sqr(phi(d1-Lambda1));
    Display('SE(LogB) = '
             +FloatToStrF(sqrt(varLogB1),ffGeneral,5,3));


    Display(' ');
    Display('Session 2...');
    Display('f = '+FloatToStr(f2));
    Display('h = '+FloatToStr(h2));
    Lambda2:=-CalcZ(f2);
    Display('Lambda = '+FloatToStrF(Lambda2,ffGeneral,5,3));
    varf2:=f2*(1-f2)/N;
 //   Display('varf = '+FloatToStrF(varf2,ffGeneral,5,3));
    varLambda2:=varf2/sqr(phi(Lambda2));
    Display('SE(Lambda) = '
            +FloatToStrF(sqrt(varLambda2),ffGeneral,5,3));
    d2:=CalcZ(h2)-CalcZ(f2);
    Display('d'' = '+FloatToStrF(d2,ffGeneral,5,3));
    varh2:=h2*(1-h2)/N;
 //   Display('varh = '+FloatToStrF(varh2,ffGeneral,5,3));
    vard2:=varf2/sqr(phi(Lambda2)) + varh2/sqr(phi(d2-Lambda2));
    Display('SE(d'') = '
            +FloatToStrF(sqrt(vard2),ffGeneral,5,3));
    LogB2:=0.5*(sqr(CalcZ(f2))-sqr(CalcZ(h2)));
    Display('LogB = '+FloatToStrF(LogB2,ffGeneral,5,3));
    varLogB2:=sqr(Lambda2)*varf2/sqr(phi(Lambda2))
              +sqr(d2-Lambda2)*varh2/sqr(phi(d2-Lambda2));
    Display('SE(LogB) = '
             +FloatToStrF(sqrt(varLogB2),ffGeneral,5,3));

    z:=(Lambda1-Lambda2)/sqrt(varLambda1+varLambda2);
    Display(' ');
    Display('H0: Lambda1 = Lambda2');
    Display('z = '+FloatToStrF(z,ffGeneral,5,3)+
            '    p = '+FloatToStrF(CalcP(z),ffGeneral,5,3));

    z:=(d1-d2)/sqrt(vard1+vard2);
    Display(' ');
    Display('H0: d1 = d2');
    Display('z = '+FloatToStrF(z,ffGeneral,5,3)+
            '    p = '+FloatToStrF(CalcP(z),ffGeneral,5,3));

   z:=(LogB1-LogB2)/sqrt(varLogB1+varLogB2);
   Display(' ');
   Display('H0: LogB1 = LogB2');
   Display('z = '+FloatToStrF(z,ffGeneral,5,3)+
            '    p = '+FloatToStrF(CalcP(z),ffGeneral,5,3));

    PrintButton.Enabled:=true;
end;

end.
