unit UIntEstD;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    CalcButton: TButton;
    CloseButton: TButton;
    Label2: TLabel;
    Edit1: TEdit;
    Label3: TLabel;
    Edit2: TEdit;
    Label1: TLabel;
    Edit3: TEdit;
    Memo1: TMemo;
    OutButton: TButton;
    Label4: TLabel;
    Edit4: TEdit;
    SaveDialog1: TSaveDialog;
    procedure CloseButtonClick(Sender: TObject);
    procedure CalcButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure OutButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure display( s : string );
  begin
      with Form1.Memo1.Lines do
  //      begin
  //          while count > 20 do Delete(0);
            Add( s );
  //      end;
  end;

procedure TForm1.FormCreate(Sender: TObject);
begin
             Edit1.Text:='';
             Edit2.Text:='';
             Edit3.Text:='';
             Edit4.Text:='';
             with Memo1 do
               begin
                 Clear;
                 Font.Size:=14;
               end;
             Display('Set values, and click "Calc" button.');
end;

procedure TForm1.CloseButtonClick(Sender: TObject);
begin
                   Close;
end;

 
type   TFunc = function( x : Extended ) : Extended;

 
{
      Kerridge and Cook(1976, Biometrika, 63, 401-403)'s Algorithm
                         referred to
      in  A. L. Brophy and  D. L. Wood (1989, Behav. Res. Meth. Istr.
                                        & Comp., 21, 447-454)
}

function  Normal_0_To_Z( z : extended ) : extended;
  label QP;
  var  p, zz, d, m, zz4, theta2,
       theta1, p_prev{, v }: extended;
       n2                : Longint;
  begin
       z:=abs(z);
       if z > 6.8
         then
           begin
              zz:=sqr(z);
              d:=zz+3-1/(0.22*zz+0.704);
              m:=1-1/d;
              p:=0.5-exp(-0.5*zz)*m/(z*sqrt(2*pi));
           end
         else
           begin
             p:=0.0;
             if z > 0.0 then
               begin
                   zz4:=0.25*sqr(z);
                   n2:=2;       // initial value of 2n          ; n = 1
                   theta2:=1.0; // initial value of theta(2n-2)
                   theta1:=zz4; // initial value of theta(2n-1)
                   p:=1;        // sum for n = 0
                   p_prev:=0;   // initial value of sub-sum
                   while true do
                     begin
                         theta2:=zz4*(theta1-theta2)/n2;
                         n2:=n2+1;
                         p:=p+theta2/n2;
                         if p = p_prev then goto QP;
                         theta1:=zz4*(theta2-theta1)/n2;
                         n2:=n2+1;
                         p_prev:=p;
                     end;
                 QP : ;
                   p:=z*exp(-0.5*zz4)*p/sqrt(2*pi);
               end;
           end;

       Normal_0_To_Z:=p;
  end;   {   Normal_0_To_Z   }


function Cum_NormalKC( z : extended ) : extended;
  var  v : extended;
  begin
      if z >= 0.0
        then
          begin
            if z > 0.0
              then
                begin
                   v:=0.5+Normal_0_To_Z(z);
                   if v > 1.0 then Cum_NormalKC:=1.0
                              else Cum_NormalKC:=v;
                end
              else Cum_NormalKC:=0.5;
          end
        else
          begin
              v:=0.5-Normal_0_To_Z( abs(z) );
              if v < 0.0 then Cum_NormalKC:=0.0
                         else Cum_NormalKC:=v; 
          end;
  end;    {   Cum_NormalKC   }


function phi( x : extended ) : extended;
  begin
        phi := (1/sqrt(2*pi))*exp(-0.5*sqr(x));
  end;


function CalcSE( d, Lambda : extended; N : integer ) : extended;
  var v, f, h : extended;
  begin
      f:=1-Cum_NormalKC(Lambda);
      h:=1-Cum_NormalKC(Lambda-d);
      v:=(f*(1-f)/N)/sqr(phi(Lambda)) + (h*(1-h)/N)/sqr(phi(d-Lambda));
      CalcSE:=sqrt(v);
  end;


function DCum_Normal( x : Extended ) : Extended;
  begin
        DCum_Normal:=exp(-sqr(x)/2)/sqrt(2*pi);
  end;

(*    Bisection@ɂ鍪̌vZ    *)

procedure  Bisection( f : TFunc;
                      s,         //   f֐̂Ƃ s > 0.0
                      c,         //   ɑ΂֐l
                      L_b, U_b   //   ̑݋Ԃ̉Ə
                                : Extended;
                      var  Root  //     f(Root) = c
                                : Extended;
                      acc       : Extended          );
  var  m, v : Extended;
  begin
         if (f(L_b)-c)*(f(U_b)-c) > 0.0 then
           begin
             ShowMessage('Ɖ̑gݍ킹sK؂łB');
             Application.Terminate;
           end;

         repeat
           m:=0.5*(L_b+U_b);
           v:=f(m);
           if s*(v-c) > 0.0 then U_b:=m
                            else L_b:=m;
         until  (abs(U_b-L_b) < acc*abs(U_b))
              or
                ( (abs(U_b)+abs(L_b)) < 1.0E-14 );

         Root:=0.5*(L_b+U_b);
  end;   {   Bisection   }


(*    Newton@ɂ鍪̌vZ   *)

procedure Newton( var x : Extended;  //  ̏lA߂l͍ f(x)=c
                  c     : Extended;  //  ֐l
                  f,             //  ֐
                  df             //  ֐
                        : TFunc;
                  acc   : Extended      );
  Label QP, QP0;
  var  x0, L_b, U_b : Extended;
       NStep : Longint;
  begin
       NStep:=0;
       repeat
            NStep:=NStep+1;
            if NStep > 20 then goto QP; //  20ȏJԂ̂Ƃ
            x0:=x;
            x:=x0+(c-f(x0))/df(x0);
       until ( abs(x-x0) < (acc*(abs(x)+abs(x0))) )
            or
             ( (abs(x)+abs(x0)) < 1.0E-14 );
       goto QP0;

    QP :        //   Bisection@ŌvZ
       L_b:=x;
       repeat  L_b:=L_b-1.0; until f(L_b) < c;
       U_b:=x;
       repeat  U_b:=U_b+1.0; until f(U_b) > c;

       Bisection( f, 1.0, c, L_b, U_b, x, acc );

    QP0 : ;
  end;   {   Newton   }




function CalcSERep( d_L, LogB : extended; N : integer ) : extended;
  var tLambda : extended;
  begin
      tLambda:=(LogB/d_L)+0.5*d_L;
      CalcSERep:=CalcSE(d_L,tLambda, N);
  end;





procedure TForm1.CalcButtonClick(Sender: TObject);
var d, Lambda, sed, A, z, d_L, d_U, LogB,
    sed_L1, sed_U1, d_L1, d_U1,
    sed_L2, sed_U2, d_L2, d_U2 : extended;
    N : integer;
begin
  try
      d:=StrToFloat(Edit1.Text);
      Lambda:=StrToFloat(Edit3.Text);
      N:=StrToInt(Edit2.Text);
      A:=0.01*StrToFloat(Edit4.Text);
  except
      ShowMessage('Invalid value in a cell');
      exit;
  end;

  Display(' ');
  Display('d'' = '+FloatToStrF(d,ffGeneral,5,3));
  Display('Lambda = '+FloatToStrF(Lambda,ffGeneral,5,3));
  Display('N = '+IntToStr(N));
  Display('Alpha = '+FloatToStrF(A*100,ffGeneral,5,3)+'%');

  sed:=CalcSE( d, Lambda, N );

  Display('se(d'') = '+FloatToStrF(sed, ffGeneral, 5, 3 ));

  z:=0.0;
  Newton( z, 1-(A/2), Cum_NormalKC, DCum_Normal, 1.0E-12 );

  Display('z = '+FloatToStrF(z,ffGeneral,5,3));

  d_L:=d-z*sed;
  d_U:=d+z*sed;
  Display(FloatToStrF(d_L,ffGeneral,5,3)+' < d'' < '+
          FloatToStrF(d_U,ffGeneral,5,3));

  sed_L1:=CalcSE( d_L, Lambda, N );
  sed_U1:=CalcSE( d_U, Lambda, N );
  d_L1:=d-z*sed_L1;
  d_U1:=d+z*sed_U1;
  Display(FloatToStrF(d_L1,ffGeneral,5,3)+' < d'' < '+
          FloatToStrF(d_U1,ffGeneral,5,3));

  d_L2:=d_L1;
  d_U2:=d_U1;
  LogB:=d*(Lambda-0.5*d);
  repeat
    d_L1:=d_L2;
    d_U1:=d_U2;
    sed_L2:=CalcSERep( d_L1, LogB, N );
    sed_U2:=CalcSERep( d_U1, LogB, N );
    d_L2:=d-z*sed_L2;
    d_U2:=d+z*sed_U2;
    Display(FloatToStrF(d_L2,ffGeneral,5,3)+' < d'' < '+
            FloatToStrF(d_U2,ffGeneral,5,3));
  until  abs(d_L1-d_L2)+abs(d_U1-d_U2) < 1.0e-5;
 

  OutButton.Enabled:=true;        

end;

procedure TForm1.FormActivate(Sender: TObject);
begin
           OutButton.Enabled:=false;
end;

procedure TForm1.OutButtonClick(Sender: TObject);
var f : TextFile;
    i : integer;
begin
    with SaveDialog1 do
      begin
          if not execute then exit;
          AssignFile(f, FileName);
          Rewrite(f);
      end;
    with Memo1, Lines do
      begin
        for i:=1 to count do
          writeln(f, Strings[i-1]);
      end;

    CloseFile(f);
end;

end.
