unit UFROCGuassNE;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls;

type
  TFROC = class(TForm)
    CloseButton: TButton;
    Image1: TImage;
    PrintButton: TButton;
    PrintDialog1: TPrintDialog;
    procedure CloseButtonClick(Sender: TObject);
    procedure DrawROC;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure PrintButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  FROC: TFROC;

implementation

uses UROCGaussNE, UDefTypeOpt, UOptNoDiff, Printers;

{$R *.dfm}

 
type   TFunc = function( x : Extended ) : Extended;

   

{
      Kerridge and Cook(1976, Biometrika, 63, 401-403)'s Algorithm
                         referred to
      in  A. L. Brophy and  D. L. Wood (1989, Behav. Res. Meth. Istr.
                                        & Comp., 21, 447-454)
}

function  Normal_0_To_Z( z : extended ) : extended;
  label QP;
  var  p, zz, d, m, zz4, theta2,
       theta1, p_prev{, v }: extended;
       n2                : Longint;
  begin
       z:=abs(z);
       if z > 6.8
         then
           begin
              zz:=sqr(z);
              d:=zz+3-1/(0.22*zz+0.704);
              m:=1-1/d;
              p:=0.5-exp(-0.5*zz)*m/(z*sqrt(2*pi));
           end
         else
           begin
             p:=0.0;
             if z > 0.0 then
               begin
                   zz4:=0.25*sqr(z);
                   n2:=2;       // initial value of 2n          ; n = 1
                   theta2:=1.0; // initial value of theta(2n-2)
                   theta1:=zz4; // initial value of theta(2n-1)
                   p:=1;        // sum for n = 0
                   p_prev:=0;   // initial value of sub-sum
                   while true do
                     begin
                         theta2:=zz4*(theta1-theta2)/n2;
                         n2:=n2+1;
                         p:=p+theta2/n2;
                         if p = p_prev then goto QP;
                         theta1:=zz4*(theta2-theta1)/n2;
                         n2:=n2+1;
                         p_prev:=p;
                     end;
                 QP : ;
                   p:=z*exp(-0.5*zz4)*p/sqrt(2*pi);
               end;
           end;

       Normal_0_To_Z:=p;
  end;   {   Normal_0_To_Z   }


function Cum_NormalKC( z : extended ) : extended;
  var  v : extended;
  begin
      if z >= 0.0
        then
          begin
            if z > 0.0
              then
                begin
                   v:=0.5+Normal_0_To_Z(z);
                   if v > 1.0 then Cum_NormalKC:=1.0
                              else Cum_NormalKC:=v;
                end
              else Cum_NormalKC:=0.5;
          end
        else
          begin
              v:=0.5-Normal_0_To_Z( abs(z) );
              if v < 0.0 then Cum_NormalKC:=0.0
                         else Cum_NormalKC:=v; 
          end;
  end;    {   Cum_NormalKC   }



function DCum_Normal( x : Extended ) : Extended;
  begin
        DCum_Normal:=exp(-sqr(x)/2)/sqrt(2*pi);
  end;

(*    Bisection@ɂ鍪̌vZ    *)

procedure  Bisection( f : TFunc;
                      s,         //   f֐̂Ƃ s > 0.0
                      c,         //   ɑ΂֐l
                      L_b, U_b   //   ̑݋Ԃ̉Ə
                                : Extended;
                      var  Root  //     f(Root) = c
                                : Extended;
                      acc       : Extended          );
  var  m, v : Extended;
  begin
         if (f(L_b)-c)*(f(U_b)-c) > 0.0 then
           begin
             ShowMessage('Ɖ̑gݍ킹sK؂łB');
             Application.Terminate;
           end;

         repeat
           m:=0.5*(L_b+U_b);
           v:=f(m);
           if s*(v-c) > 0.0 then U_b:=m
                            else L_b:=m;
         until  (abs(U_b-L_b) < acc*abs(U_b))
              or
                ( (abs(U_b)+abs(L_b)) < 1.0E-14 );

         Root:=0.5*(L_b+U_b);
  end;   {   Bisection   }


(*    Newton@ɂ鍪̌vZ   *)

procedure Newton( var x : Extended;  //  ̏lA߂l͍ f(x)=c
                  c     : Extended;  //  ֐l
                  f,             //  ֐
                  df             //  ֐
                        : TFunc;
                  acc   : Extended      );
  Label QP, QP0;
  var  x0, L_b, U_b : Extended;
       NStep : Longint;
  begin
       NStep:=0;
       repeat
            NStep:=NStep+1;
            if NStep > 20 then goto QP; //  20ȏJԂ̂Ƃ
            x0:=x;
            x:=x0+(c-f(x0))/df(x0);
       until ( abs(x-x0) < (acc*(abs(x)+abs(x0))) )
            or
             ( (abs(x)+abs(x0)) < 1.0E-14 );
       goto QP0;

    QP :        //   Bisection@ŌvZ
       L_b:=x;
       repeat  L_b:=L_b-1.0; until f(L_b) < c;
       U_b:=x;
       repeat  U_b:=U_b+1.0; until f(U_b) > c;

       Bisection( f, 1.0, c, L_b, U_b, x, acc );

    QP0 : ;
  end;   {   Newton   }




var
  Zf, Zh : array of extended;
  x0, y0, fs, N : integer;
  minx, maxx, miny, maxy, gxic, gyic : extended;


procedure SetXY( xic, yic : extended;
                 var  x1, x2 : extended );
  begin
        x1:=sqrt(-0.001-xic);
        x2:=sqrt(yic-0.001);
  end;


procedure Setxicyic( x1, x2 : extended;
                     var  xic, yic : extended );
  begin
        xic:=-0.001-sqr(x1);
        yic:= 0.001+sqr(x2);
  end;

 

function SSE( x : TOptVector; m : Longint ) : Extended;
  var xic, yic, v : extended;
      i : integer;

  function SSDist( a, b : extended ) : extended;
    begin
        if (abs(a) > 1.0e-19) and (abs(b) > 1.0e-19)
          then
            SSDist:=sqr(a*b)/(sqr(a)+sqr(b))
          else
            SSDist:=0.0;
    end;

  begin
      Setxicyic( x[1], x[2], xic, yic );
      v:=0.0;

      for i:=1 to N do
        v:=v+SSDist(xic-Zf[i]-xic*Zh[i]/yic,
                    yic-Zh[i]-yic*Zf[i]/xic);
      SSE:=v;
  end;



procedure SetXYeq( yic : extended;
                   var  x : extended );
  begin
        x:=sqrt(yic-0.001);
  end;



procedure Setxicyiceq( x : extended;
                     var  xic, yic : extended );
  begin
        yic:= 0.001+sqr(x);
        xic:=-yic
  end;


function SSEeq( x : TOptVector; m : Longint ) : Extended;
  var xic, yic, v : extended;
      i : integer;

  function SSDist( a, b : extended ) : extended;
    begin
        if (abs(a) > 1.0e-19) and (abs(b) > 1.0e-19)
          then
            SSDist:=sqr(a*b)/(sqr(a)+sqr(b))
          else
            SSDist:=0.0;
    end;

  begin
      Setxicyiceq( x[1], xic, yic );
      v:=0.0;

      for i:=1 to N do
        v:=v+SSDist(xic-Zf[i]-xic*Zh[i]/yic,
                    yic-Zh[i]-yic*Zf[i]/xic);
      SSEeq:=v;
  end;


function fLine( x : extended ) : extended;
  begin
           fLine:=(-gyic/gxic)*x + gyic;
  end;


function InvLine( y : extended ) : extended;
  begin
           InvLine:=gxic*(1-(y/gyic));
  end;


function SSELine(x : TOptVector; m : Longint ) : Extended;
  var v : extended;
      i : integer;
  begin
      gxic:=x[1];
      gyic:=x[2];
      v:=0.0;

    //  ShowMessage('N = '+IntToStr(N));

      for i:=1 to N do
        v:=v+sqr(Zh[i]-fLine(Zf[i]));
      SSELine:=v;
  end;


function SSELineEq(x : TOptVector; m : Longint ) : Extended;
  var v : extended;
      i : integer;
  begin
      gxic:=x[1];
      gyic:=-gxic;
      v:=0.0;

    //  ShowMessage('N = '+IntToStr(N));

      for i:=1 to N do
        v:=v+sqr(Zh[i]-fLine(Zf[i]));
      SSELineEq:=v;
  end;


procedure TFROC.CloseButtonClick(Sender: TObject);
begin
            UROCGaussNE.Form1.Close;
end;



procedure TFROC.FormClose(Sender: TObject; var Action: TCloseAction);
begin
            Finalize(Zf);
            Finalize(Zh);
end;

procedure TFROC.DrawROC;
  var i, iminx, imaxx, iminy, imaxy : integer;
      f, h, rng, LMaxX, LMinX, mu_s_eq, mu_s, sigma_s : extended;
      x1 : TOptVector;

  function xpos( x : extended ) : integer;
    var v : extended;
    begin
          v:=x0+fs*2*0.9*(x-0.5*(minx+maxx))/rng;
          xpos:=round(v);
    end;

  function ypos( y : extended ) : integer;
    var v : extended;
    begin
          v:=y0-fs*2*0.9*(y-0.5*(miny+maxy))/rng;
          ypos:=round(v);
    end;

  begin
    WindowState:=wsMaximized; UpDate;

    try
      with UROCGaussNE.Form1.StringGrid1 do
        begin
            SetLength(Zf, RowCount);
            SetLength(Zh, RowCount);
            N:=RowCount-1;
            for i:=1 to N do
              begin
                  f:=StrToFloat(Cells[1,i]);
                  h:=StrToFloat(Cells[2,i]);
                  Zf[i]:=0.0;
                  Newton( Zf[i], f, Cum_NormalKC, DCum_Normal, 1.0E-12 );
                  Zh[i]:=0.0;
                  Newton( Zh[i], h, Cum_NormalKC, DCum_Normal, 1.0E-12 );

            //      ShowMessage('Zf = '+FloatToStrF(Zf[i],ffFixed,9,5)+
            //                  '     Zh = '+FloatToStrF(Zh[i],ffFixed,9,5));
              end;
        end;
    except
      ShowMessage('Invalid Value in the String Grid');
      FROC.Close
    end;

    with CloseButton do
      begin
          Left:=FROC.ClientWidth-Width;
          Top:=0;
      end;
    with PrintButton do
      begin
          Left:=0;
          Top:=0;
      end;
    UpDate;
    with Image1 do
      begin
        Left:=0; Top:=CloseButton.Height;
        Width:=FROC.ClientWidth;
        Height:=FROC.ClientHeight-CloseButton.Height;
        with Canvas do
          begin
            Pen.Color:=clWhite;
            Brush.Color:=clWhite;
            Rectangle(0,0,Width,Height);
            x0:=Width div 2;
            y0:=Height div 2;
            fs:=x0;
            if fs > y0 then fs:=y0;

            minx:=-1.0;  maxx:=1.0;
            miny:=-1.0;  maxy:=1.0;
            for i:=1 to N do
              begin
                while minx > Zf[i] do minx:=minx-1.0;
                while maxx < Zf[i] do maxx:=maxx+1.0;
                while miny > Zh[i] do miny:=miny-1.0;
                while maxy < Zh[i] do maxy:=maxy+1.0;
              end;
            rng:=maxx-minx;
            if rng < maxy-miny then rng:=maxy-miny;

            with Pen do
              begin
                Width:=1;
                Color:=clBlack;
              end;
            MoveTo(xpos(minx), ypos(0.0));
            LineTo(xpos(maxx), ypos(0.0));
            MoveTo(xpos(0.0),  ypos(miny));
            LineTo(xpos(0.0),  ypos(maxy));

            iminx:=round(minx);
            imaxx:=round(maxx);
            iminy:=round(miny);
            imaxy:=round(maxy);
            with Font do
              begin
                Height:=Round(0.07*fs);
              end;
            Brush.Style:=bsClear;

            for i:=iminx to imaxx do
              if i <> 0 then
                begin
                  MoveTo(xpos(i), ypos(0.0)+round(0.02*fs));
                  LineTo(xpos(i), ypos(0.0)-round(0.02*fs));
                  TextOut(xpos(i), ypos(0.0)+round(0.02*fs), IntToStr(i));
                end;
            TextOut(xpos(imaxx), ypos(0.0)-Round(0.08*fs), 'Z(f)');
            for i:=iminy to imaxy do
              if i <> 0 then
                begin
                  MoveTo(xpos(0.0)-round(0.02*fs), ypos(i));
                  LineTo(xpos(0.0)+round(0.02*fs), ypos(i));
                  TextOut(xpos(0.0)+round(0.02*fs),
                          ypos(i)-TextHeight('1'), IntToStr(i));
                end;
            TextOut(xpos(0.0)-TextWidth('Z(h)')-round(0.025*fs),
                    ypos(imaxy)-TextHeight('1'), 'Z(h)');

            with Pen do
              begin
                Width:=1;
                Color:=clBlue;
              end;
            with Brush do
              begin
                Style:=bsSolid;
                Color:=clBlue;
              end;
            for i:=1 to N do
              Ellipse(xpos(Zf[i])-round(0.015*fs), ypos(Zh[i])-round(0.015*fs),
                      xpos(Zf[i])+round(0.015*fs), ypos(Zh[i])+round(0.015*fs)
                      );

            gxic:=-1.0;
            gyic:= 1.0;
            SetXYeq( gyic, x1[1] );

            MinByRosenbrock( SSEeq, 1, x1, 1.0e-8, 1.0e-16, 0.1 );

      //      MinByBrent( SSEeq, 1, x1, 1.0e-8, 1.0e-16 );

            Setxicyiceq( x1[1], gxic, gyic );

            mu_s_eq:=-gxic;

            with Pen do
              begin
                  Width:=1;
                  Color:=clRed;
              end;
            LMinX:=minx;
            if fLine(minx) < miny then LMinX:=InvLine(miny);
            LMaxX:=maxx;
            if fLine(maxx) > maxy then LMaxX:=InvLine(maxy);
            MoveTo(xpos(LMinX), ypos(fLine(LMinX)));
            LineTo(xpos(LMaxX), ypos(fLine(LMaxX)));

            gxic:=-1.0;
            gyic:= 1.0;
            SetXY(gxic, gyic, x1[1], x1[2]);

            MinByRosenbrock( SSE, 2, x1, 1.0e-8, 1.0e-16, 0.1 );

      //      MinByBrent( SSE, 2, x1, 1.0e-8, 1.0e-16 );

            Setxicyic( x1[1], x1[2], gxic, gyic );

        //    ShowMessage('xic = '+FloatToStrF(gxic,ffGeneral,8,3)+
        //                '     yic = '+FloatToStrF(gyic,ffGeneral,8,3));

            with Pen do
              begin
                  Width:=2;
                  Color:=clBlack;
              end;
            LMinX:=minx;
            if fLine(minx) < miny then LMinX:=InvLine(miny);
            LMaxX:=maxx;
            if fLine(maxx) > maxy then LMaxX:=InvLine(maxy);
            MoveTo(xpos(LMinX), ypos(fLine(LMinX)));
            LineTo(xpos(LMaxX), ypos(fLine(LMaxX)));

            mu_s:=-gxic;
            sigma_s:=-gxic/gyic;
            with Font do
              begin
                Color:=clBlack;
                Height:=round(0.06*fs);
              end;
            Brush.Style:=bsClear;
            TextOut(xpos(0.3), ypos(-0.3),
                    'mu_s    = '+FloatToStrF(mu_s,ffGeneral,5,3) );
            TextOut(xpos(0.3), ypos(-0.3)+round(1.2*Font.Height),
                    'sigma_s = '+FloatToStrF(sigma_s,ffGeneral,5,3) );

            Font.Color:=clRed;
            TextOut(xpos(0.3), ypos(-0.3)+round(2.7*Font.Height),
                    'mu_s(eq) = '+FloatToStrF(mu_s_eq,ffGeneral,5,3) );

          end;
      end;
  end;

procedure TFROC.PrintButtonClick(Sender: TObject);
  var i, iminx, imaxx, iminy, imaxy : integer;
      f, h, rng, LMaxX, LMinX, mu_s_eq, mu_s, sigma_s : extended;
      x1 : TOptVector;

  function xpos( x : extended ) : integer;
    var v : extended;
    begin
          v:=x0+fs*2*0.8*(x-0.5*(minx+maxx))/rng;
          xpos:=round(v);
    end;

  function ypos( y : extended ) : integer;
    var v : extended;
    begin
          v:=y0-fs*2*0.8*(y-0.5*(miny+maxy))/rng;
          ypos:=round(v);
    end;

  begin
    if not PrintDialog1.execute then exit;

    with Printer do
      begin
        BeginDoc;

        with Canvas do
          begin
            x0:=PageWidth div 2;
            y0:=PageHeight div 2;
            fs:=x0;
            if fs > y0 then fs:=y0;

            minx:=-1.0;  maxx:=1.0;
            miny:=-1.0;  maxy:=1.0;
            for i:=1 to N do
              begin
                while minx > Zf[i] do minx:=minx-1.0;
                while maxx < Zf[i] do maxx:=maxx+1.0;
                while miny > Zh[i] do miny:=miny-1.0;
                while maxy < Zh[i] do maxy:=maxy+1.0;
              end;
            rng:=maxx-minx;
            if rng < maxy-miny then rng:=maxy-miny;

            with Pen do
              begin
                Width:=3;
                Color:=clBlack;
              end;
            MoveTo(xpos(minx), ypos(0.0));
            LineTo(xpos(maxx), ypos(0.0));
            MoveTo(xpos(0.0),  ypos(miny));
            LineTo(xpos(0.0),  ypos(maxy));

            iminx:=round(minx);
            imaxx:=round(maxx);
            iminy:=round(miny);
            imaxy:=round(maxy);
            with Font do
              begin
                Color:=clBlack;
                Height:=Round(0.07*fs);
              end;
            Brush.Style:=bsClear;

            Pen.Width:=2;
            for i:=iminx to imaxx do
              if i <> 0 then
                begin
                  MoveTo(xpos(i), ypos(0.0)+round(0.02*fs));
                  LineTo(xpos(i), ypos(0.0)-round(0.02*fs));
                  TextOut(xpos(i), ypos(0.0)+round(0.02*fs), IntToStr(i));
                end;
            TextOut(xpos(imaxx), ypos(0.0)-Round(0.08*fs), 'Z(f)');
            for i:=iminy to imaxy do
              if i <> 0 then
                begin
                  MoveTo(xpos(0.0)-round(0.02*fs), ypos(i));
                  LineTo(xpos(0.0)+round(0.02*fs), ypos(i));
                  TextOut(xpos(0.0)+round(0.02*fs),
                          ypos(i)-TextHeight('1'), IntToStr(i));
                end;
            TextOut(xpos(0.0)-TextWidth('Z(h)')-round(0.025*fs),
                    ypos(imaxy)-TextHeight('1'), 'Z(h)');

            with Pen do
              begin
                Width:=1;
                Color:=clBlue;
              end;
            with Brush do
              begin
                Style:=bsSolid;
                Color:=clBlue;
              end;
            for i:=1 to N do
              Ellipse(xpos(Zf[i])-round(0.015*fs), ypos(Zh[i])-round(0.015*fs),
                      xpos(Zf[i])+round(0.015*fs), ypos(Zh[i])+round(0.015*fs)
                      );

            gxic:=-1.0;
            gyic:= 1.0;
            SetXYeq( gyic, x1[1] );

            MinByRosenbrock( SSEeq, 1, x1, 1.0e-8, 1.0e-16, 0.1 );

        //    MinByBrent( SSEeq, 1, x1, 1.0e-8, 1.0e-16 );


            Setxicyiceq( x1[1], gxic, gyic );

            mu_s_eq:=-gxic;

            with Pen do
              begin
                  Width:=2;
                  Color:=clRed;
              end;
            LMinX:=minx;
            if fLine(minx) < miny then LMinX:=InvLine(miny);
            LMaxX:=maxx;
            if fLine(maxx) > maxy then LMaxX:=InvLine(maxy);
            MoveTo(xpos(LMinX), ypos(fLine(LMinX)));
            LineTo(xpos(LMaxX), ypos(fLine(LMaxX)));

            gxic:=-1.0;
            gyic:= 1.0;
            SetXY(gxic, gyic, x1[1], x1[2]);

            MinByRosenbrock( SSE, 2, x1, 1.0e-8, 1.0e-16, 0.1 );

         //   MinByBrent( SSE, 2, x1, 1.0e-8, 1.0e-16 );


            Setxicyic( x1[1], x1[2], gxic, gyic );

        //    ShowMessage('xic = '+FloatToStrF(gxic,ffGeneral,8,3)+
        //                '     yic = '+FloatToStrF(gyic,ffGeneral,8,3));

            with Pen do
              begin
                  Width:=3;
                  Color:=clBlack;
              end;
            LMinX:=minx;
            if fLine(minx) < miny then LMinX:=InvLine(miny);
            LMaxX:=maxx;
            if fLine(maxx) > maxy then LMaxX:=InvLine(maxy);
            MoveTo(xpos(LMinX), ypos(fLine(LMinX)));
            LineTo(xpos(LMaxX), ypos(fLine(LMaxX)));

            mu_s:=-gxic;
            sigma_s:=-gxic/gyic;
            with Font do
              begin
                Color:=clBlack;
                Height:=round(0.05*fs);
              end;
            Brush.Style:=bsClear;
            TextOut(xpos(0.3), ypos(-0.3),
                    'mu_s    = '+FloatToStrF(mu_s,ffGeneral,5,3) );
            TextOut(xpos(0.3), ypos(-0.3)+round(1.2*Font.Height),
                    'sigma_s = '+FloatToStrF(sigma_s,ffGeneral,5,3) );

            Font.Color:=clRed;
            TextOut(xpos(0.3), ypos(-0.3)+round(2.7*Font.Height),
                    'mu_s(eq) = '+FloatToStrF(mu_s_eq,ffGeneral,5,3) );

          end;

        EndDoc;
      end;
  end;

end.
