unit UOptNoDiff;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,
  UDefTypeOpt;    //      ^`
                  //
                  //   NDimOpt = 20;
                  //   TOptVector = array[1..NDimOpt] of Extended;
                  //   TOptFunc   = function
                  //                  ( x : TOptVector; n : Longint )
                  //                   : Extended;


type
  TFOptNoDiff = class(TForm)
    Memo1: TMemo;
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  FOptNoDiff: TFOptNoDiff;

//    Rosenbrock's method  cf. Rao(1984)
procedure  MinByRosenbrock( f                   //  ɏl߂֐
                              : TOptFunc;
                            n                   //  ϐ̐
                              : Longint;
                            var  x1             //  ϐ̔z
                              : TOptVector;
                            crtrn_lambda,       //  ϐ̕ωʂ̊
                            crtrn_f,            //  ֐̕ωʂ̊
                            max_lambda          //  ϐ̕ωʂ̏l
                                       : Extended );

//    Brent's method   cf. Brent(1973)
procedure MinByBrent( f                //  ɏl߂֐
                        : TOptFunc;
                      n                //  ϐ̐
                        : Longint;
                      var  x0          //  ϐ̔z
                        : TOptVector;
                      criterionX,      //  ϐ̕ωʂ̊
                      criterionF       //  ֐̕ωʂ̊
                        : Extended );


implementation

{$R *.DFM}


//    rʂ̕\p葱
procedure display( s : string );
  begin
      with FOptNoDiff.Memo1.Lines do
        begin
            while count > 20 do Delete(0);
            Add( s );
        end;
  end;


(*
          Rosenbrock's method

     cf. S.S.Rao, Optimization, 1984     
*)
procedure  MinByRosenbrock( f : TOptFunc;
                            n : Longint;
                            var  x1 : TOptVector;
                            crtrn_lambda, crtrn_f,
                            max_lambda : Extended );
  label
    qq;
  type
    opt_base = array[1..NDimOpt] of TOptVector;
  var
    k : Longint;
    s : opt_base;                 //  TxNg̔z
    lambda, old_x : TOptVector;
    vf0, vf1 : Extended;
    s_dt : string;
  
  //   
  procedure  init_s;
    var  i, j : Longint;
    begin
      if max_lambda <= 0.0
        then  max_lambda:=1000.0*crtrn_lambda;
      for i:=1 to n do
        for j:=1 to n do
          if i = j then s[i][j]:=1.0   else s[i][j]:=0.0;
    end;
  
  //   T
  procedure  one_dim_opt( n : Longint;
                          var
                            x1,        //  ϐlpz
                            direction  //  T
                                    : TOptVector;
                          var opt_t    //  ɏl^XebvTCY
                                    : Extended );
    label
      qq_min_step, out_golden;
    var
      ta, tb, tc, f_a, f_b, f_c, neg_f, pos_f,
      opt_f, QuadV : Extended;
      i, n_opt : Longint;

    //  XebvTCYopt_t̂Ƃ̊֐lopt_f̌vZ
    procedure  cal_tf( direction : TOptVector;
                       opt_t : Extended;
                       var  opt_f : Extended );
      var  i : Longint;
           tx : TOptVector;
      begin
        for i:=1 to n do
          tx[i]:=x1[i]+(direction[i]*opt_t);
        opt_f:=f(tx, n);
      end;

    //   Q֐ɂߎɂċɏl
    //   ^XebvTCYopt_t߂
    procedure  calc_opt_t( u : TOptVector;
                           var opt_t, QuadV, OptF : Extended;
                           ta, tb, tc,
                           fa, fb, fc : Extended );
      var  gamma, beta, alpha, den : Extended;
      begin
           if ( (abs(ta-tb) < crtrn_lambda) or
                (abs(tb-tc) < crtrn_lambda) or
                (abs(tc-ta) < crtrn_lambda) )
             then
                 QuadV:=-1.0E4929
             else
               begin
                   gamma:=(-1.0)*((fa*(tb-tc)) + (fb*(tc-ta)) + (fc*(ta-tb)));
                   beta:=(fa*(sqr(tb)-sqr(tc))) + (fb*(sqr(tc)-sqr(ta)))
                          + (fc*(sqr(ta)-sqr(tb)));

                   if gamma <> 0.0
                     then
                       begin
                          opt_t:=(-beta)/(2*gamma);

                          if ((ta < opt_t) and (opt_t < tc))
                            then
                              begin
                                alpha:=fa*tb*tc*(tc-tb)+fb*tc*ta*(ta-tc)
                                       +fc*ta*tb*(tb-ta);
                                den  :=(ta-tb)*(tb-tc)*(tc-ta);
                                QuadV:=-sqr(beta)/(4*gamma*den)+(alpha/den);
                                cal_tf(direction, opt_t, OptF);
                              end
                            else QuadV:=-1.0E4928;
                       end
                     else
                       begin
                         QuadV:=-1.0E4930;
                       end;
               end;
      end;   {   CalcOpt_t   }

    //  Golden Section @ɂXebvTCYopt_t̒T
    procedure  call_golden;
      label
        qq, qp;
      var
        h0, h1, h2, h3, v0, v1, v2, v3 : Extended;
      begin   (*   call_golden   *)
        h0:=0.0;  cal_tf(direction, h0, v0);
        h2:=max_lambda*10.0;
        repeat
          h2:=0.5*h2;  cal_tf(direction, h2, v2);
        until  (v0 > v2) or (h2 < crtrn_lambda);
        if (h2 < crtrn_lambda) then
          begin
            opt_t:=0.0;  goto qp;
          end;
        h3:=h2;
        repeat
          h3:=h3*2.0;  cal_tf(direction, h3, v3);
        until  v2 < v3;
        h1:=h0+(0.382*(h3-h0));
        h2:=h3-(0.382*(h3-h0));
        cal_tf(direction, h1, v1);  cal_tf(direction, h2, v2);

        repeat
          if v1 > v2
            then
              begin
                h0:=h1;  v0:=v1;  h1:=h2;  v1:=v2;
                h2:=h1+(0.382*(h3-h1));
                cal_tf(direction, h2, v2);
              end
            else
              begin
                h3:=h2;  v3:=v2;  h2:=h1;  v2:=v1;
                h1:=h0+(0.382*(h3-h0));
                cal_tf(direction, h1, v1);
              end;
        until  (abs(h3-h0) < ((1.0e-3)*abs(h3)) )
                 or
               (h3 < crtrn_lambda);

        opt_t:=0.5*(h0+h3);

        qp : cal_tf(direction, opt_t, opt_f);
      end;   (*   call_golden   *)


    begin   (*   one_dim_opt   *)

      //  
      ta:=0.0;  f_a:=f(x1, n);
      opt_t:=10.0*max_lambda;

      repeat
        opt_t:=0.5*opt_t;
        if opt_t < crtrn_lambda then
          begin
            opt_t:=0.0;  goto qq_min_step;
          end;

        cal_tf(direction, opt_t, pos_f);
        cal_tf(direction, -opt_t, neg_f);
      until  (pos_f < f_a) or (neg_f < f_a);

      if (pos_f >= f_a) and (neg_f < f_a)
        then
          begin            //  Ttɐݒ
            for i:=1 to n
              do  direction[i]:=(-1.0)*direction[i];
          end;

      tb:=opt_t;   cal_tf(direction, tb, f_b);
      tc:=tb;
      repeat
        tc:=2*tc;  cal_tf(direction, tc, f_c);
      until  f_b < f_c;

      calc_opt_t(direction, opt_t, QuadV, opt_f,
                 ta, tb, tc, f_a, f_b, f_c );

      if (opt_f >= f_a) or
         (opt_t <  ta ) or
         (   tc < opt_t) or
         (QuadV < -1.0e4000)
        then                 //  Golden Section @ɐ؂芷
          begin
            call_golden;   goto out_golden;
          end;

      if (abs(opt_f-QuadV) < (crtrn_f*(abs(opt_f)+abs(QuadV))))
        or
         ((abs(opt_f)+abs(QuadV)) < crtrn_f)
        or
         (abs(tb-opt_t) < (crtrn_lambda*(abs(tb)+abs(opt_t))))
        or
         ((abs(tb)+abs(opt_t)) < crtrn_lambda)
          then
            goto qq_min_step;    //   T̏I

      n_opt:=0;
      repeat                    //    ŤJԂ
        n_opt:=n_opt+1;

        if opt_t > tb
          then
            begin
              if opt_f < f_b
                then
                  begin
                    ta:=tb;     f_a:=f_b;
                    tb:=opt_t;  f_b:=opt_f;
                    calc_opt_t(direction, opt_t, QuadV, opt_f,
                               ta, tb, tc, f_a, f_b, f_c );
                  end
                else
                  begin
                    tc:=opt_t;   f_c:=opt_f;
                    calc_opt_t(direction, opt_t, QuadV, opt_f,
                               ta, tb, tc, f_a, f_b, f_c );
                  end;
            end
          else
            begin
              if opt_f < f_b
                then
                  begin
                    tc:=tb;      f_c:=f_b;
                    tb:=opt_t;   f_b:=opt_f;
                    calc_opt_t(direction, opt_t, QuadV, opt_f,
                               ta, tb, tc, f_a, f_b, f_c );
                  end
                else
                  begin
                    ta:=opt_t;    f_a:=opt_f;
                    calc_opt_t(direction, opt_t, QuadV, opt_f,
                               ta, tb, tc, f_a, f_b, f_c );
                  end;
            end;
  
        if (opt_f >= f_a)
          or
           (opt_t <  ta )
          or
           (   tc < opt_t)
          or
           (QuadV < -1.0e4000)
          or
           (n_opt > 20)
            then           //  Golden Section @ɐ؂芷
              begin
                call_golden;  goto out_golden;
              end;

      until  (abs(opt_f-QuadV) < (crtrn_f*(abs(opt_f)+abs(QuadV))))
            or
             ((abs(opt_f)+abs(QuadV)) < crtrn_f)
            or
             (abs(tb-opt_t) < (crtrn_lambda*(abs(tb)+abs(opt_t))))
            or
             ((abs(tb)+abs(opt_t)) < crtrn_lambda);

      out_golden :   (*   exit from golden   *);

      qq_min_step:
        if opt_t <> 0.0 then    //  ϐl̍XV
          for i:=1 to n
            do  x1[i]:=x1[i]+(opt_t*direction[i]);
    end;   (*   one_dim_opt   *)


  //   TxNg̍XV
  procedure  new_s;
    var
      u : TOptVector;
      old_s : opt_base;
      i, j, k, h : Longint;
      p, v : Extended;
    begin   (*   new_s   *)
      for i:=1 to n do
        if lambda[i] < crtrn_lambda
          then lambda[i]:=crtrn_lambda;

      for i:=1 to n do
        for j:=1 to n do
          begin
            v:=0.0;
            for k:=i to n do
              v:=v+lambda[k]*s[k][j];
            old_s[i][j]:=v;
          end;

      v:=0.0;
      for k:=1 to n do
        v:=v+sqr(old_s[1][k]);
      v:=sqrt(v);
      for k:=1 to n do s[1][k]:=old_s[1][k]/v;

      //   Gram-Schmidt orthogonalization procedure
      if n > 1 then
        for h:=2 to n do
          begin
            u:=old_s[h];
            for k:=1 to h-1 do
              begin
                p:=0.0;
                for j:=1 to n
                  do p:=p+(old_s[h][j]*s[k][j]);
                for j:=1 to n
                  do u[j]:=u[j]-(p*s[k][j]);
              end;
            v:=0.0;
            for j:=1 to n do v:=v+sqr(u[j]);
            v:=sqrt(v);
            for j:=1 to n do s[h][j]:=u[j]/v;
          end;
    end;   (*   new_s   *)
  
  
  begin   (*   MinByRosenbrock   *)
    //   vZo߂̕\ptH[̐
    FOptNoDiff:=TFOptNoDiff.Create(application);
    FOptNoDiff.Visible:=true;

    init_s;  vf1:=f(x1, n);  //  
    while true do
      begin
        old_x:=x1;  vf0:=vf1;
        for k:=1 to n do     //  eTɂɏ
          begin
            one_dim_opt( n, x1, s[k], lambda[k] );
          end;
  
        vf1:=f(x1, n);
  
        max_lambda:=0.0;
        for k:=1 to n do
          if max_lambda < abs(lambda[k])
            then max_lambda:=abs(lambda[k]);

        str(max_lambda, s_dt);
        display('max_lambda = '+s_dt);
 
        str(vf1, s_dt);
        display('vf1 = '+s_dt);
  
        if (max_lambda < crtrn_lambda)
          and
            ( (abs(vf0-vf1) < (crtrn_f*(abs(vf0)+abs(vf1))))
             or
              ((abs(vf0)+abs(vf1)) < crtrn_f) )
            then                                //  T̏I
              goto qq;
  
        new_s;      //  TxNg̍XV
      end;
  
    qq: ;

  //    ShowMessage('MinByRosenbrock ended');  //  Lɂ
                                       //  tH[OMemo
      FOptNoDiff.Close;              //  emFł
  end;   (*   MinByRosenbrock   *)




(*        ْl       *)

{
const maxoptdim = 50;

type  TOptVector = array[1..maxoptdim] of Extended;
      TOptMat    = array[1..maxoptdim] of TOptVector;
      TOptFunc   = function( x : TOptVector;
                             n : Longint ) : Extended;    }


type
      svd_mat  = TOptMat;
      svd_vctr = TOptVector;

const
      tridiag_zero = 1.0e-17;

type
      tridiag_mat = svd_mat;
      tridiag_vctr = svd_vctr;
  
  
procedure  tri_diag( var  a : tridiag_mat;
                          n : Longint );
  var  act_zero, s : Extended;
       i, j        : Longint;
  
  
  procedure  mirror( i : Longint );
    var  u  : tridiag_vctr;
         j  : Longint;
         u_sqr, u_norm : Extended;
  
  
    procedure  calc_new_b( i : Longint );
      var  t  : Extended;
           j, k : Longint;
           v, p, q : tridiag_vctr;
      begin
        t:=1.0/u_norm;
        for j:=i+1 to n do
          v[j]:=u[j]*t;
  
        for j:=i+1 to n do
          begin
            t:=0.0;
            for k:=i+1 to n do
              t:=t+(a[j, k]*v[k]);
            p[j]:=t;
          end;
  
        t:=0.0;
        for j:=i+1 to n do
          t:=t+(v[j]*p[j]);
        for j:=i+1 to n do
          q[j]:=2.0*(p[j]-(t*v[j]));
  
        a[i, i+1]:=s;  a[i+1, i]:=s;
        for j:=i+1 to n do
          for k:=j to n do
            begin
              a[j, k]:=a[j, k]-(v[j]*q[k])
                                  -(q[j]*v[k]);
              a[k, j]:=a[j, k];
            end;
      end;   (*   calc_new_b   *)
  
  
    begin   (*   mirror   *)
      u[i+1]:=a[i, i+1]-s;
      for j:=i+2 to n do
        u[j]:=a[i, j];
  
      u_sqr:=2.0*s*(s-a[i, i+1]);
      u_norm:=sqrt(u_sqr);
      if u_norm > act_zero  then calc_new_b( i );
    end;   (*   mirror   *)
  
  
  begin   (*   tri_diag   *)
    act_zero:=0.0;
    for i:=1 to n do
      for j:=i to n do
        if act_zero < abs(a[i, j])
          then act_zero:=abs(a[i, j]);
    if act_zero > 0.0 then
      begin
        act_zero:=act_zero*tridiag_zero;
        if n >= 3 then
          for i:=1 to n-2 do
            begin
              s:=0.0;
              for j:=i+1 to n do
                s:=s+sqr(a[i, j]);
              if a[i, i+1] > 0.0 then s:=-sqrt(s)
                                   else s:=sqrt(s);
              if abs(s) > (act_zero*(n-i))
                then mirror( i );
            end;
      end;
  end;   (*   tri_diag   *)
  
  
  
type    ql_mat = svd_mat;
        ql_vctr = svd_vctr;
  
const   ql_zero = 1.0e-17;
  
  
procedure  ql( var  a : ql_mat;
               n : Longint;
               var success : boolean );
  const  max_ql3 = 10000;
  var    s, c : ql_vctr;
         max_v, prac_zero : Extended;
         i, count_ql3 : Longint;
  
  
  procedure  do_ql( left, right : Longint );
    label  q_do_ql;
    var  ck_pos : Longint;
         ck_zero, ck_stop : boolean;
  
  
    procedure  ql2( left, right : Longint );
      var  v_root, b : Extended;
      begin
        v_root:=sqrt(sqr(a[left, left]+a[right, right])
                    -(4.0*((a[left, left]*a[right, right])
                          -(a[left, right]*a[right, left]))));
        b:=a[left, left]+a[right, right];
        a[left, left]:=0.5*(b-v_root);
        a[right, right]:=0.5*(b+v_root);
        if abs(a[left, left]) > abs(a[right, right])
          then
            begin
              b:=a[left, left];
              a[left, left]:=a[right, right];
              a[right, right]:=b;
            end;
        a[left, right]:=0.0;
        a[right, left]:=0.0;
      end;   (*   ql2   *)
  
  
    procedure  ql3( left, right : Longint );
      var  shift : Extended;
           i : Longint;
  
  
      procedure  adjust_shift;
        var  cb, cc, s1, v_root : Extended;
             i : Longint;
        begin
          cb:=-(a[left, left]+a[left+1, left+1]);
          cc:=(a[left, left]*a[left+1,left+1])
              -(a[left, left+1]*a[left+1, left]);
          v_root:=sqrt(sqr(cb)-(4.0*cc));
          shift:=0.5*((-cb)+v_root);
          s1:=0.5*((-cb)-v_root);
          if abs(s1) < abs(shift) then shift:=s1;
          for i:=left to right do
            a[i, i]:=a[i, i]-shift;
        end;   (*   adjust_shift   *)
  
  
      procedure  make_l;
        var  k : Longint;
  
  
        procedure  q_transfm( k : Longint;
                              a1, b1, c1, a2, b2, c2 : Extended );
          var  v : Extended;
          begin
            v:=1.0/sqrt(sqr(c1)+sqr(c2));
            c[k]:=c2*v;    s[k]:=-c1*v;
            a[k-1, k]:=0.0;
            a[k, k]:=-(s[k]*c1)+(c[k]*c2);
            a[k-1, k-1]:=(c[k]*b1)+(s[k]*b2);
            a[k, k-1]:=-(s[k]*b1)+(c[k]*b2);
            if k > (left+1) then
              begin
                a[k-1, k-2]:=c[k]*a1;
                a[k, k-2]:=-s[k]*a1;
              end;
          end;   (*   q_transfm   *)
  
  
        begin   (*   make_l   *)
          for k:=right downto left+1 do
            if k > (left+1)
              then q_transfm( k, a[k-1, k-2], a[k-1, k-1],
                                 a[k-1, k],
                                 a[k, k-2], a[k, k-1], a[k, k] )
              else q_transfm( k, 0.0, a[k-1, k-1], a[k-1, k],
                                 0.0, a[k, k-1], a[k, k] );
        end;   (*   make_l   *)
  
  
      procedure  cal_lq;
        var  k : Longint;
  
  
        procedure  cal_sub_lq( k : Longint;
                               x1, x2, y1, y2 : Extended );
          begin
            a[k-1, k-1]:=c[k]*x1;
            a[k-1, k]:=-(s[k]*x1);
            a[k, k-1]:=(c[k]*y1)+(s[k]*y2);
            a[k, k]:=-(s[k]*y1)+(c[k]*y2);
          end;   (*   cal_sub_lq   *)
  
  
        begin   (*   cal_lq   *)
          for k:=right downto left+1 do
            cal_sub_lq( k, a[k-1, k-1],
                           a[k-1, k], a[k, k-1], a[k, k] );
          for k:=left+1 to right do a[k, k-1]:=a[k-1, k];
        end;   (*   cal_lq   *)
  
  
      begin   (*   ql3   *)
        count_ql3:=count_ql3+1;
        if count_ql3 > max_ql3 then
          begin
            success:=false;
            writeln;
            writeln('ql3 is called too many times');
            halt;
          end;
        adjust_shift;  make_l;  cal_lq;
        for i:=left to right do
          a[i, i]:=a[i, i]+shift;
      end;   (*   ql3   *)
  
  
    begin   (*   do_ql   *)
      if left < right then
        repeat
          ck_pos:=right;
          if abs(a[ck_pos-1, ck_pos]) < prac_zero
            then
              begin
                ck_zero:=true;
                repeat
                  ck_pos:=ck_pos-1;
                  if ck_pos > left then
                    begin
                      if abs(a[ck_pos-1, ck_pos]) >= prac_zero
                        then ck_zero:=false;
                    end;
                until not(ck_zero) or (ck_pos <= left);
                if not(ck_zero) then
                  begin
                    do_ql( left, ck_pos );
                    do_ql( ck_pos+1, right );
                  end;
              end
            else
              begin
                ck_zero:=false; ck_stop:=false;
                repeat
                  ck_pos:=ck_pos-1;
                  if ck_pos > left then
                    begin
                      if abs(a[ck_pos-1, ck_pos]) < prac_zero
                        then ck_stop:=true;
                    end;
                until (ck_pos <= left) or ck_stop;
                if ck_pos > left
                  then
                    begin
                      do_ql( left, ck_pos-1 );
                      do_ql( ck_pos, right );
                    end
                  else
                    begin
                      if right-left <= 1
                        then ql2( left, right )
                        else ql3( left, right );
                    end;
              end;
          if not( success )  then goto q_do_ql;
        until ck_zero;
  
      q_do_ql : (*   nothing   *);
    end;   (*   do_ql   *)
  
  
  begin   (*   ql   *)
    success:=true; count_ql3:=0;
    if n > 1 then
      begin
        max_v:=abs(a[1, 1]);
        for i:=2 to n do
          begin
            if max_v < abs(a[i, i])
              then max_v:=abs(a[i, i]);
            if max_v < abs(a[i-1, i])
              then max_v:=abs(a[i-1, i]);
          end;
        if max_v > 0.0 then
          begin
            prac_zero:=max_v*ql_zero;  do_ql( 1, n );
          end;
      end;
  end;   (*   ql   *)
  
  
  
  
const   sw_out_zero = 1.0e-15;
  
type    sw_out_mat = svd_mat;
        sw_out_vctr = svd_vctr;
  
  
procedure  sw_out( var mat : sw_out_mat;
                   n   : Longint;
                   var solution : sw_out_vctr;
                   var  rnk : Longint );
  var  a : sw_out_mat;
       indx, z : sw_out_vctr;
       v, prac_zero, s : Extended;
       ir, ic, i_pos, c_pos, r_pos : Longint;
       chk_end : boolean;
  
  
  procedure  swap( var  a, b : Extended );
    var  v : Extended;
    begin
            v := a;   a := b;   b := v;
    end;
  
  
  procedure  sweep;
    var  ir, ic : Longint;
    begin
      if i_pos < n
        then
          begin
            if i_pos < c_pos then
              begin
                swap( indx[i_pos], indx[c_pos] );
                for ir:=1 to n do
                  swap( a[ir, i_pos], a[ir, c_pos] );
              end;
            if i_pos < r_pos then
              for ic:=i_pos to n do
                swap( a[i_pos, ic], a[r_pos, ic] );
            s:=1.0/a[i_pos, i_pos];
            for ic:=i_pos+1 to n do
              a[i_pos, ic]:=a[i_pos, ic]*s;
            for ir:=i_pos+1 to n do
              begin
                s:=a[ir, i_pos];
                for ic:=i_pos+1 to n do
                  a[ir, ic]:=a[ir, ic]-(s*a[i_pos, ic]);
              end;
          end
        else
          begin
            rnk:=n;        chk_end:=true;
          end;
    end;   (*   sweep   *)
  
  
  procedure  calc_sltn;
    var  ir, ic : Longint;
    begin
      for ir:=rnk+1 to n do      z[ir]:=1.0;
      for ir:=rnk downto 1 do
        begin
          v:=0.0;
          for ic:=ir+1 to n do
            v:=v-(a[ir, ic]*z[ic]);
          z[ir]:=v;
        end;
      s:=0.0;
      for ir:=1 to n do      s:=s+sqr(z[ir]);
      s:=sqrt(s);      s:=1.0/s;
      for ir:=1 to n do      z[ir]:=z[ir]*s;
      for ir:=1 to n do
        solution[ round(indx[ir]) ]:=z[ir];
    end;   (*   calc_sltn   *)
  
  
  begin   (*   sw_out   *)
    a:=mat;
  
    v:=0.0;
    for ir:=1 to n do
      for ic:=1 to n do
        if v < abs(a[ir, ic])    then v:=abs(a[ir, ic]);
    prac_zero:=sw_out_zero*v;
  
    for ic:=1 to n do  indx[ic]:=ic;
  
    i_pos:=1; chk_end:=false;
    repeat
      c_pos:=i_pos; r_pos:=i_pos;
      v:=abs(a[i_pos, i_pos]);
      for ir:=i_pos to n do
        for ic:=i_pos to n do
          if v < abs(a[ir, ic])    then
            begin
              v:=abs(a[ir, ic]);    c_pos:=ic; r_pos:=ir;
            end;
      if v <= prac_zero
        then
          begin
            chk_end:=true;  rnk:=i_pos-1;
          end
        else
          sweep;
  
      i_pos:=i_pos+1;
    until    chk_end;
  
    if rnk >= n
      then
        begin
          for ir:=1 to n do solution[ir]:=0.0;
        end
      else
        calc_sltn;
  end;   (*   sw_out   *)
  
  
  
const   ql_decomp_zero          = 1.0e-15;
        ql_decomp_same_accuracy = 1.0e-14;
  
type    ql_decomp_mat = svd_mat;
        ql_decomp_vctr = svd_vctr;
  
(*
  
            spectral decomposition
                     of
              a symmetric matrix
  
  
     parametrs...a    : input matrix
                 n    : size of a
                 t_n_eigen : required no. of eigen values
                 n_eigen   : actual no. of calculated eigen values
                 lambda[i]       : the i th eigen value
                 eigen_vctr[*,i] : the i th eigen vector
*)
  
procedure  ql_decomp_1( var a : ql_decomp_mat;
                      n, t_n_eigen : Longint;
                      var  n_eigen : Longint;
                      var lambda : ql_decomp_vctr;
                      var eigen_vctr : ql_decomp_mat );
  label  qq;
  var  b : ql_decomp_mat;
       solution : ql_decomp_vctr;
       zero_chk, ck_ql, same_lambda : boolean;
       i, k, j, rnk, ir, ic : Longint;
       v, c_zero : Extended;
  
  
  procedure  check_zero( var  zero_chk : boolean );
    var  v : Extended;
         ir, ic : Longint;
    begin
      zero_chk:=false;
      v:=0.0;
      for ir:=1 to n do
        for ic:=1 to n do
          if v < abs(a[ir, ic]) then v:=abs(a[ir, ic]);
      if v < ql_decomp_zero then
        begin  zero_chk:=true;  n_eigen:=0;  end;
    end;
  
  
  procedure  calc_c_zero( var  c_zero : Extended );
    var  v : Extended;
         ir, ic : Longint;
    begin
      v:=0.0;
      for ir:=1 to n do
        for ic:=1 to n do
          if v < abs(a[ir, ic])    then v:=abs(a[ir, ic]);
      c_zero:=v*ql_decomp_zero;
    end;
  
  
  procedure  check_lambda( var  ck : boolean );
    var  i : Longint;
    begin
      ck:=false;
      if n_eigen > 1 then
        for i:=1 to n_eigen-1 do
          if abs(lambda[i]-lambda[i+1]) <
            (ql_decomp_same_accuracy
              *(abs(lambda[i])+abs(lambda[i+1])))
               then
                 ck := true;
    end;
  
  
  begin   (*   ql_decomp_1 *)
    check_zero( zero_chk );
    if zero_chk  then goto qq;
  
    if n <= 1
      then
        begin
          if abs(a[1, 1]) < ql_decomp_zero
            then
                   n_eigen:=0
            else
              begin
                n_eigen:=1;
                lambda[1]:=a[1, 1];      eigen_vctr[1, 1]:=1.0;
              end;
        end
      else
        begin
          b:=a; tri_diag( b, n );
  
          ql( b, n, ck_ql );
  
          if not ck_ql then
            begin
              writeln;
              writeln('ql failed');
              halt;
            end;
  
          for i:=1 to n-1 do
            begin
              k:=i;
              for j:=i+1 to n do
                if abs(b[k, k]) < abs(b[j, j])      then k:=j;
              if i < k then
                begin
                  v:=b[i, i]; b[i, i]:=b[k, k]; b[k, k]:=v;
                end;
            end;
  
          n_eigen:=0; calc_c_zero( c_zero );
          for i:=1 to n do
            if abs(b[i, i]) > c_zero
              then
                begin
                  n_eigen:=n_eigen+1;
                  lambda[n_eigen]:=b[i, i];
                end
              else
                lambda[i]:=0.0;
  
          check_lambda( same_lambda );
  
          if n_eigen > t_n_eigen  then n_eigen:=t_n_eigen;
          for i:=1 to n_eigen do
            begin
              b:=a;
              for j:=1 to n do
                b[j, j]:=b[j, j]-lambda[i];
  
              sw_out( b, n, solution, rnk );
  
              if rnk >= n then
                begin
                  writeln;
                  writeln('calculation accuracy error occurred.');
                  halt;
                end;
  
              for j:=1 to n do
                eigen_vctr[j, i]:=solution[j];
  
              if same_lambda then
                for ir:=1 to n do
                  for ic:=1 to n do
                    a[ir, ic]:=a[ir, ic]
                                -(lambda[i]*eigen_vctr[ir, i]
                                            *eigen_vctr[ic, i]);
            end;
        end;
  
    qq:  (*   nothing  *) ;
  end;   (*   ql_decomp_1 *)
  
  
procedure  svd_1( var a       (*  input matrix         *)
                      : svd_mat;
                m,            (*  no. of rows of a     *)
                n             (*  no. of columns of a  *)
                      : Longint;
                var u         (*  left singular vectors   *)
                      : svd_mat;
                var lambda    (*  vector of sigular values   *)
                      : svd_vctr;
                var  rnk      (*  no. of non-zero singular values  *)
                      : Longint;
                var v         (*  right singular vectors   *)
                      : svd_mat     );
  
  var  aa      : svd_mat;
       i, j, k : Longint;
       t       : Extended;
  begin
    if m <= n
      then   (*   a * a'   *)
        begin
          for i:=1 to m do
            for j:=i to m do
              begin
                t:=0.0;
                for k:=1 to n do
                  t:=t+(a[i, k]*a[j, k]);
                aa[i, j]:=t;
                if i < j  then aa[j, i]:=t;
              end;
  
          ql_decomp_1( aa, m, m, rnk, lambda, u );
  
          if rnk > 0 then
            begin
              for i:=1 to rnk do
                begin
                  lambda[i]:=sqrt(lambda[i]);
                  for j:=1 to n do
                    begin
                      t:=0.0;
                      for k:=1 to m do
                        t:=t+(a[k, j]*u[k, i]);
                      v[j, i]:=t/lambda[i];
                    end;
                end;
            end;
        end
      else   (*   a' * a   *)
        begin
          for i:=1 to n do
            for j:=i to n do
              begin
                t:=0.0;
                for k:=1 to m do
                  t:=t+(a[k, i]*a[k, j]);
                aa[i, j]:=t;
                if i < j then aa[j, i]:=t;
              end;
  
          ql_decomp_1( aa, n, n, rnk, lambda, v );
  
          if rnk > 0 then
            begin
              for i:=1 to rnk do
                begin
                  lambda[i]:=sqrt(lambda[i]);
                  for j:=1 to m do
                    begin
                      t:=0.0;
                      for k:=1 to n do
                        t:=t+(a[j, k]*v[k, i]);
                      u[j, i]:=t/lambda[i];
                    end;
                end;
            end;
        end;
  end;   (*   svd_1 *)


type
  txpmat     = array[1..3] of TOptVector;


(*
    cf.  R. P. Brent (1973).
         Algorithms for minimization without derivatives.
         Prentice-Hall, Inc.
*)

procedure MinByBrent( f : TOptFunc;
                      n : Longint;
                      var x0 : TOptVector;
                      criterionX, criterionF : Extended );
  Label QPRestart, QP2, q_opt;
  var   u : TOptMat;
        istep, NRandomStep, i, j, k : Longint;
        ck_end : Boolean;
        PrevX, xi, PrevRndX, d : TOptVector;
        Beta, NormU, TempF, JmpX, SizeX, f0, f1 : Extended;
        xp : TXPMat;

  //    TxNg̍XVSVDōs
  procedure ResetUbySVD( var u : TOptMat;
                         n : Longint );
    var  i, j, rnk : Longint;
         dd : Extended;
         v, q, w : TOptMat;
         Lambda : TOptVector;
    begin
        for j:=1 to n do
          begin
            if d[j] > criterionX
              then dd:=1.0/sqrt(d[j])
              else dd:=1000.0;

            for i:=1 to n do
              v[i,j]:=u[j][i]*dd;
          end;

        svd_1( v, n, n, q, Lambda, rnk, w );

        Display('n = '+IntToStr(n)+'    rnk = '+IntToStr(rnk));

        if rnk >= n
          then
            begin
              for i:=1 to n do
                for j:=1 to n do
                  u[i][j]:=q[j][i];
            end
          else
            begin
                for i:=1 to n do
                  for j:=1 to n do
                    if i = j then u[i][j]:=1.0
                             else u[i][j]:=0.0;
            end;
    end;   {   ResetUbySVD   }


  //   Brent,eq.(4.6)ɂD̑Ίpvf̌vZ
  procedure CalcDi( f : TOptFunc;
                    n : Longint;
                    xi : TOptVector;
                    u  : TOptVector;
                    Beta : Extended;
                    var di : Extended );
    var  a0, a1, a2, f0, f1, f2,
         f01, f12, fpv, fnv : Extended;


    function CalcfValue( a : Extended ) : Extended;
      var  j : Longint;
           tx : TOptVector;
      begin
          for j:=1 to n do
            tx[j]:=xi[j]+a*u[j];

          CalcfValue:=f( tx, n );
      end;

    function CheckFDiff( f1, f2 : Extended ) : Boolean;
      begin
          if (abs(f1-f2) < (10*criterionF*(abs(f1)+abs(f2))))
            or
             ((abs(f1)+abs(f2)) < (10*criterionF))
              then CheckFDiff:=false
              else CheckFDiff:=true;
      end;

    begin   {   CalcDi   }
        a0:=0.0;
        f0:=CalcfValue(a0);

        a1:=Beta;
        repeat
          a1:=2*a1;
          fpv:=CalcfValue(a1); fnv:=CalcfValue(-a1);
        until CheckFDiff(fpv,f0) or CheckFDiff(fnv,f0);

        if not CheckFDiff(fpv,f0) then a1:=-a1;

        f1:=CalcfValue(a1);

        a2:=a1*2;
        f2:=CalcfValue(a2);

        f01:=(f1-f0)/(a1-a0);
        f12:=(f2-f1)/(a2-a1);

        di:=(f12-f01)/(a2-a0);  //  Brent,eq.(4.5)
    end;   {   CalcDi   }


  {    S. S. Rao (1984)
       Optimization: Theory and applications (2nd ed.).
                               John Wiley & Sons.
              ̋ɒlT                            }

  procedure OneDimLocalMin( f  : TOptFunc;
                            n  : Longint;
                            x1 : TOptVector;        //  ϐlpz
                            var
                              direction  //  T
                               : TOptVector;
                            var
                              opt_t    //  ɏl^XebvTCY
                               : Extended;
                            criterionX,
                            criterionF
                               : Extended );
    label
      qq_min_step, out_golden;
    var
      ta, tb, tc, f_a, f_b, f_c, neg_f, pos_f,
      opt_f, QuadV, max_lambda : Extended;
      i, j, n_opt : Longint;

    //  XebvTCYopt_t̂Ƃ̊֐lopt_f̌vZ
    procedure  cal_tf( direction : TOptVector;
                       opt_t : Extended;
                       var  opt_f : Extended );
      var  i : Longint;
           tx : TOptVector;
      begin
        for i:=1 to n do
          tx[i]:=x1[i]+(direction[i]*opt_t);
        opt_f:=f(tx, n);
      end;

    //   Q֐ɂߎɂċɏl
    //   ^XebvTCYopt_t߂
    procedure  calc_opt_t( u : TOptVector;
                           var opt_t, QuadV, OptF : Extended;
                           ta, tb, tc,
                           fa, fb, fc : Extended );
      var  gamma, beta, alpha, den : Extended;
      begin
           if ( (abs(ta-tb) < criterionX) or
                (abs(tb-tc) < criterionX) or
                (abs(tc-ta) < criterionX) )
             then
                 QuadV:=-1.0E4929
             else
               begin
                   gamma:=(-1.0)*((fa*(tb-tc)) + (fb*(tc-ta)) + (fc*(ta-tb)));
                   beta:=(fa*(sqr(tb)-sqr(tc))) + (fb*(sqr(tc)-sqr(ta)))
                          + (fc*(sqr(ta)-sqr(tb)));

                   if gamma <> 0.0
                     then
                       begin
                          opt_t:=(-beta)/(2*gamma);

                          if ((ta < opt_t) and (opt_t < tc))
                            then
                              begin
                                alpha:=fa*tb*tc*(tc-tb)+fb*tc*ta*(ta-tc)
                                       +fc*ta*tb*(tb-ta);
                                den  :=(ta-tb)*(tb-tc)*(tc-ta);
                                QuadV:=-sqr(beta)/(4*gamma*den)+(alpha/den);
                                cal_tf(direction, opt_t, OptF);
                              end
                            else QuadV:=-1.0E4928;
                       end
                     else
                       begin
                         QuadV:=-1.0E4930;
                       end;
               end;
      end;   {   calc_opt_t   }

    //  Golden Section @ɂXebvTCYopt_t̒T
    procedure  call_golden;
      label
        qq, qp;
      var
        h0, h1, h2, h3, v0, v1, v2, v3 : Extended;
      begin   (*   call_golden   *)
        h0:=0.0;  cal_tf(direction, h0, v0);
        h2:=max_lambda*10.0;
        repeat
          h2:=0.5*h2;  cal_tf(direction, h2, v2);
        until  (v0 > v2) or (h2 < criterionX);
        if (h2 < criterionX) then
          begin
            opt_t:=0.0;  goto qp;
          end;
        h3:=h2;
        repeat
          h3:=h3*2.0;  cal_tf(direction, h3, v3);
        until  v2 < v3;
        h1:=h0+(0.382*(h3-h0));
        h2:=h3-(0.382*(h3-h0));
        cal_tf(direction, h1, v1);  cal_tf(direction, h2, v2);

        repeat
          if v1 > v2
            then
              begin
                h0:=h1;  v0:=v1;  h1:=h2;  v1:=v2;
                h2:=h1+(0.382*(h3-h1));
                cal_tf(direction, h2, v2);
              end
            else
              begin
                h3:=h2;  v3:=v2;  h2:=h1;  v2:=v1;
                h1:=h0+(0.382*(h3-h0));
                cal_tf(direction, h1, v1);
              end;
        until  (abs(h3-h0) < ((1.0e-3)*abs(h3)) )
                 or
               (h3 < criterionX);

        opt_t:=0.5*(h0+h3);

        qp : ;
      end;   (*   call_golden   *)


    begin   (*   OneDimLocalMin   *)

      //  
      ta:=0.0;  f_a:=f(x1, n);
      if opt_t < 0.0
        then
          begin
            max_lambda:=0.0;
            for j:=1 to n do
              if max_lambda < abs(x1[j])
                then max_lambda:=abs(x1[j]);
            max_lambda:=max_lambda*criterionX*100.0;
            if max_lambda < criterionX
              then max_lambda:=1000.0*criterionX;

            opt_t:=10.0*max_lambda;
          end
        else
          opt_t:=2*opt_t;

      repeat
        opt_t:=0.5*opt_t;
        if opt_t < criterionX then
          begin
            opt_t:=0.0;  goto qq_min_step;
          end;

        cal_tf(direction, opt_t, pos_f);
        cal_tf(direction, -opt_t, neg_f);
      until  (pos_f < f_a) or (neg_f < f_a);

      if (pos_f >= f_a) and (neg_f < f_a)
        then
          begin            //  Ttɐݒ
            for i:=1 to n
              do  direction[i]:=(-1.0)*direction[i];
          end;

      tb:=opt_t;   cal_tf(direction, tb, f_b);
      tc:=tb;
      repeat
        tc:=2*tc;  cal_tf(direction, tc, f_c);
      until  f_b < f_c;

      calc_opt_t(direction, opt_t, QuadV, opt_f,
                 ta, tb, tc, f_a, f_b, f_c );

      if (opt_f >= f_a) or
         (opt_t <  ta ) or
         (   tc < opt_t) or
         (QuadV < -1.0e4000)
        then                 //  Golden Section @ɐ؂芷
          begin
            call_golden;   goto out_golden;
          end;

      if (abs(opt_f-QuadV) < (criterionF*(abs(opt_f)+abs(QuadV))))
        or
         ((abs(opt_f)+abs(QuadV)) < criterionF)
        or
         (abs(tb-opt_t) < (criterionX*(abs(tb)+abs(opt_t))))
        or
         ((abs(tb)+abs(opt_t)) < criterionX)
          then
            goto qq_min_step;    //   T̏I

      n_opt:=0;
      repeat                    //    ŤJԂ
        n_opt:=n_opt+1;

        if opt_t > tb
          then
            begin
              if opt_f < f_b
                then
                  begin
                    ta:=tb;     f_a:=f_b;
                    tb:=opt_t;  f_b:=opt_f;
                    calc_opt_t(direction, opt_t, QuadV, opt_f,
                               ta, tb, tc, f_a, f_b, f_c );
                  end
                else
                  begin
                    tc:=opt_t;   f_c:=opt_f;
                    calc_opt_t(direction, opt_t, QuadV, opt_f,
                               ta, tb, tc, f_a, f_b, f_c );
                  end;
            end
          else
            begin
              if opt_f < f_b
                then
                  begin
                    tc:=tb;      f_c:=f_b;
                    tb:=opt_t;   f_b:=opt_f;
                    calc_opt_t(direction, opt_t, QuadV, opt_f,
                               ta, tb, tc, f_a, f_b, f_c );
                  end
                else
                  begin
                    ta:=opt_t;    f_a:=opt_f;
                    calc_opt_t(direction, opt_t, QuadV, opt_f,
                               ta, tb, tc, f_a, f_b, f_c );
                  end;
            end;
  
        if (opt_f >= f_a)
          or
           (opt_t <  ta )
          or
           (   tc < opt_t)
          or
           (QuadV < -1.0e4000)
          or
           (n_opt > 20)
            then           //  Golden Section @ɐ؂芷
              begin
                call_golden;  goto out_golden;
              end;

      until  (abs(opt_f-QuadV) < (criterionF*(abs(opt_f)+abs(QuadV))))
            or
             ((abs(opt_f)+abs(QuadV)) < criterionF)
            or
             (abs(tb-opt_t) < (criterionX*(abs(tb)+abs(opt_t))))
            or
             ((abs(tb)+abs(opt_t)) < criterionX);

      out_golden :   (*   exit from golden   *);

      qq_min_step:  ;
    end;   (*   OneDimLocalMin   *)

  //  R_Axp1,xp2,xp3AقȂ邱ƂmF
  function Check_xp : Boolean;
    var d12, d23, d31 : Extended;
        j : Longint;
    begin
         d12:=0.0;  d23:=0.0;  d31:=0.0;
         for j:=1 to n do
           begin
             if d12 < abs(xp[1][j]-xp[2][j])
               then d12:=abs(xp[1][j]-xp[2][j]);
             if d23 < abs(xp[2][j]-xp[3][j])
               then d23:=abs(xp[2][j]-xp[3][j]);
             if d31 < abs(xp[3][j]-xp[1][j])
               then d31:=abs(xp[3][j]-xp[1][j]);
           end;

         if (d12 > criterionX)  and
            (d23 > criterionX)  and
            (d31 > criterionX)
            then
                 Check_xp:=True
            else
                 Check_xp:=False;
    end;   {   Check_xp   }


  //     Extrapolation along the valley.  cf. Brent, p.134
  procedure  MinFLambda( f : TOptFunc;
                         n : Longint;
                         xp : TXPMat;
                         var  x0 : TOptVector;
                         criterionX, criterionF : Extended );
    Label q_opt, out_golden, qq_min_step;
    var   sigF, ta, tb, tc, fa, fb, fc,
          opt_t, OptF, PosF, NegF,
          d0, d1, QuadV, opt_f : Extended;
          j, n_opt : Longint;
          tx : TOptVector;

    procedure CalcFLambda( lambda : Extended;
                           var OptF : Extended;
                           var x : TOptVector );
      var  j : Longint;
           c1, c2, c3 : Extended;
      begin
          lambda:=sigF*lambda+d1;

          c1:=lambda*(lambda-d1)/(d0*(d0+d1)); //  = 1 for org.lambda = -d1-d0
          c2:=(lambda+d0)*(lambda-d1)/(d0*d1); //  =-1 for org.lambda = -d1
          c3:=lambda*(lambda+d0)/(d1*(d0+d1)); //  = 1 for org.lambda =  0

          for j:=1 to n do
            x[j]:=c1*xp[1][j]-c2*xp[2][j]+c3*xp[3][j];

          OptF:=f( x, n );
      end;   {   CalcFLambda   }

     //   Q֐ɂߎɂċɏl
    //   ^XebvTCYopt_t߂
    procedure  calc_opt_t( //u : TOptVector;
                           var opt_t, QuadV, OptF : Extended;
                           ta, tb, tc,
                           fa, fb, fc : Extended );
      var  gamma, beta, alpha, den : Extended;
      begin
           if ( (abs(ta-tb) < criterionX) or
                (abs(tb-tc) < criterionX) or
                (abs(tc-ta) < criterionX) )
             then
                 QuadV:=-1.0E4929
             else
               begin
                   gamma:=(-1.0)*((fa*(tb-tc)) + (fb*(tc-ta)) + (fc*(ta-tb)));
                   beta:=(fa*(sqr(tb)-sqr(tc))) + (fb*(sqr(tc)-sqr(ta)))
                          + (fc*(sqr(ta)-sqr(tb)));

                   if gamma <> 0.0
                     then
                       begin
                          opt_t:=(-beta)/(2*gamma);

                          if ((ta < opt_t) and (opt_t < tc))
                            then
                              begin
                                alpha:=fa*tb*tc*(tc-tb)+fb*tc*ta*(ta-tc)
                                       +fc*ta*tb*(tb-ta);
                                den  :=(ta-tb)*(tb-tc)*(tc-ta);
                                QuadV:=-sqr(beta)/(4*gamma*den)+(alpha/den);
                                CalcFLambda(opt_t, OptF, tx);
                              end
                            else QuadV:=-1.0E4928;
                       end
                     else
                       begin
                         QuadV:=-1.0E4930;
                       end;
               end;
      end;   {   CalcOpt_t   }

    //  Golden Section @ɂXebvTCYopt_t̒T
    procedure  call_golden;
      label
        qq, qp;
      var
        h0, h1, h2, h3, v0, v1, v2, v3 : Extended;
      begin   (*   call_golden   *)
        h0:=0.0; CalcFLambda( h0, v0, tx );
        h2:=d0+d1;
        repeat
          h2:=0.5*h2; CalcFLambda( h2, v2, tx );
        until  (v0 > v2) or (h2 < criterionX);
        if (h2 < criterionX) then
          begin
            opt_t:=0.0;  goto qp;
          end;
        h3:=h2;
        repeat
          h3:=h3*2.0;  CalcFLambda( h3, v3, tx );
        until  v2 < v3;
        h1:=h0+(0.382*(h3-h0));
        h2:=h3-(0.382*(h3-h0));
        CalcFLambda( h1, v1, tx );  CalcFLambda( h2, v2, tx );
        repeat
          if v1 > v2
            then
              begin
                h0:=h1;  v0:=v1;  h1:=h2;  v1:=v2;
                h2:=h1+(0.382*(h3-h1));
                CalcFLambda( h2, v2, tx );
              end
            else
              begin
                h3:=h2;  v3:=v2;  h2:=h1;  v2:=v1;
                h1:=h0+(0.382*(h3-h0));
                CalcFLambda( h1, v1, tx );
              end;
        until  (abs(h3-h0) < ((1.0e-3)*abs(h3)) )
                 or
               (h3 < criterionX);

        opt_t:=0.5*(h0+h3);

        qp : CalcFLambda( opt_t, opt_f, tx );

      end;   (*   call_golden   *)


    begin   {   MinFLambda   }

    //    xp[3] = current x0

        d0:=0.0; d1:=0.0;
        for j:=1 to n do
          begin
            d0:=d0+sqr(xp[1][j]-xp[2][j]);
            d1:=d1+sqr(xp[2][j]-xp[3][j]);
          end;
        d0:=sqrt(d0);  d1:=sqrt(d1);

        ta:=0.0; fa:=f(x0, n);

        opt_t:=d1;  sigF:=1.0;
        repeat
             opt_t:=0.5*opt_t;
             if opt_t < criterionX then
               begin
                   opt_t:=0.0;
                   goto qq_min_step; 
               end;

             CalcFLambda(opt_t, PosF, tx);
             CalcFLambda(-opt_t, NegF, tx);
        until  (PosF < fa) or (NegF < fa);

        if NegF < fa then sigF:=-1.0
                     else sigF:=1.0;

        tb:=opt_t; CalcFLambda(tb, fb, tx);
        tc:=tb;
        repeat
             tc:=2*tc;  CalcFLambda(tc, fc, tx);
        until  fb < fc;

        calc_opt_t( opt_t, QuadV, opt_f,
                    ta, tb, tc, fa, fb, fc );

        if (opt_f >= fa) or
           (opt_t <  ta ) or
           (   tc < opt_t) or
           (QuadV < -1.0e4000)
          then                 //  Golden Section @ɐ؂芷
            begin
              call_golden;   goto out_golden;
            end;

        if (abs(opt_f-QuadV) < (criterionF*(abs(opt_f)+abs(QuadV))))
          or
           ((abs(opt_f)+abs(QuadV)) < criterionF)
          or
           (abs(tb-opt_t) < (criterionX*(abs(tb)+abs(opt_t))))
          or
           ((abs(tb)+abs(opt_t)) < criterionX)
            then
              goto qq_min_step;    //   T̏I

        n_opt:=0;
        repeat                    //    ŤJԂ
          n_opt:=n_opt+1;

          if opt_t > tb
            then
              begin
                if opt_f < fb
                  then
                    begin
                      ta:=tb;     fa:=fb;
                      tb:=opt_t;  fb:=opt_f;
                      calc_opt_t( opt_t, QuadV, opt_f,
                                  ta, tb, tc, fa, fb, fc );
                    end
                  else
                    begin
                      tc:=opt_t;   fc:=opt_f;
                      calc_opt_t( opt_t, QuadV, opt_f,
                                  ta, tb, tc, fa, fb, fc );
                    end;
              end
            else
              begin
                if opt_f < fb
                  then
                    begin
                      tc:=tb;      fc:=fb;
                      tb:=opt_t;   fb:=opt_f;
                      calc_opt_t( opt_t, QuadV, opt_f,
                                  ta, tb, tc, fa, fb, fc );
                    end
                  else
                    begin
                      ta:=opt_t;    fa:=opt_f;
                      calc_opt_t( opt_t, QuadV, opt_f,
                                  ta, tb, tc, fa, fb, fc );
                    end;
              end;
  
          if (opt_f >= fa)
            or
             (opt_t <  ta )
            or
             (   tc < opt_t)
            or
             (QuadV < -1.0e4000)
            or
             (n_opt > 20)
              then           //  Golden Section @ɐ؂芷
                begin
                  call_golden;  goto out_golden;
                end;

        until  (abs(opt_f-QuadV) < (criterionF*(abs(opt_f)+abs(QuadV))))
              or
               ((abs(opt_f)+abs(QuadV)) < criterionF)
              or
               (abs(tb-opt_t) < (criterionX*(abs(tb)+abs(opt_t))))
              or
               ((abs(tb)+abs(opt_t)) < criterionX);

    out_golden :   (*   exit from golden   *);

    qq_min_step:
    
        CalcFLambda(opt_t, OptF, x0);  //  x0̍XV

    end;   {   MinFLambda   }


  begin    {   MinByBrent   }
      //   vZo߂̕\ptH[̐
      FOptNoDiff:=TFOptNoDiff.Create(application);
      FOptNoDiff.Visible:=true;

      //   
      Randomize;
      istep:=1;  NRandomStep:=0;

      repeat
      QPRestart :
           Application.ProcessMessages;

           if NRandomStep > 0 then   //  incorporation of a random step
             for j:=1 to n do
               x0[j]:=x0[j]+100*criterionX*Random;

           ck_end:=false;
           PrevX:=x0;
           if istep <= 1
             then
               begin
                 for i:=1 to n do
                   for j:=1 to n do
                     if i = j then u[i][j]:=1.0
                              else u[i][j]:=0.0;
               end
             else        //   Brent(1973),sec.7.4
               begin
                 for i:=1 to n do
                   begin
                     Beta:=10.0*criterionX;
                     CalcDi( f, n, x0, u[i], Beta, d[i] );
                   end;

                 ResetUbySVD( u, n );
               end;

           Beta:=-1.0;
           OneDimLocalMin( f, n, x0, u[n], Beta, criterionX, criterionF );

           for j:=1 to n do
             x0[j]:=x0[j]+Beta*u[n][j];

           for k:=1 to n do
             begin
                 xi:=x0;

                 for i:=1 to n do
                   begin
                       Application.ProcessMessages;

                       //   Brent,p.127, Powell's basic procedure step 1
                       Beta:=-1.0;
                       OneDimLocalMin( f, n, xi, u[i], Beta,
                                       criterionX, criterionF );
                       for j:=1 to n do
                         xi[j]:=xi[j]+Beta*u[i][j];

                       if i < n
                         then       //  Powell's basic procedure step 2
                           u[i]:=u[i+1]
                         else       //  Powell's basic procedure step 3
                           for j:=1 to n do u[n][j]:=xi[j]-x0[j];
                   end;

                 NormU:=0.0;
                 for j:=1 to n do
                   if NormU < abs(xi[j]-x0[j])
                     then NormU:=abs(xi[j]-x0[j]);

                 if (NormU > criterionX)
                    and (NRandomStep <= 0)
                   then                      //  u[n] is not zero
                     begin
                       //          Powell's basic procedure step 4
                       Beta:=1.0;
                       OneDimLocalMin( f, n, x0, u[n], Beta,
                                       criterionX, criterionF );
                       for j:=1 to n do
                         xi[j]:=x0[j]+Beta*u[n][j];

                       NormU:=0.0;
                       for j:=1 to n do
                         NormU:=NormU+sqr(u[n][j]);
                       NormU:=sqrt(NormU);
                       for j:=1 to n do
                         u[n][j]:=u[n][j]/NormU;
                     end
                   else                     //  u[n] is zero
                     begin
                       if NRandomStep <= 0
                         then
                           begin
                             istep:=1;
                             NRandomStep:=1;    //  Incorporation of
                             goto QPRestart;    //   a random step
                           end
                         else
                           goto q_opt;          //   TI
                     end;

                 x0:=xi;

             end;

           NRandomStep:=0;    //  random stepsȂ

           if istep <= 2
             then
               begin
                  xp[istep]:=x0;       //  T̓roߓ_̐ݒ
                  istep:=istep+1;
               end
             else                      //  R_Axp1,xp2,xp3Aʂ
               begin                   //  valley̒Ts
                   xp[3]:=x0;

                   if Check_xp
                     then
                       MinFLambda( f, n, xp, x0, criterionX, criterionF )
                     else
                       istep:=1;
               end;

           QP2 : TempF:=f(x0, n);
                 Display('Temporal Function Value = '
                         +FloatToStrF(TempF, ffGeneral, 19,4));

           //   ϐl̕ωJmpX̌vZ
           JmpX:=0.0;  SizeX:=0.0;
           for i:=1 to n do
             begin
               if JmpX < abs(PrevX[i]-x0[i])
                 then JmpX:=Abs(PrevX[i]-x0[i]);
               if SizeX < (abs(PrevX[i])+abs(x0[i]))
                 then SizeX:=abs(PrevX[i])+abs(x0[i]);
             end;

           f0:=f(x0, n);
           f1:=f(PrevX, n);

           //  ϐl̕ωʂƊ֐l̕ωʂ̃`FbN
           if (JmpX < (criterionX*SizeX))
             or
              (SizeX < criterionX)
             or
              (abs(f0-f1) < (criterionF*(abs(f0)+abs(f1))))
             or
              ((abs(f0)+abs(f1)) < criterionF)
             then
                  ck_end:=true;   //  ωʂ̂ŒTI

      until  ck_end;

      q_opt : ;

   //   ShowMessage('MinByBrent ended');  //  Lɂ
                                       //  tH[OMemo
      FOptNoDiff.Close;              //  emFł

  end;    {    MinByBrent   }



end.
 