unit UROCGaussNE;
                    //  By Yasuharu Okamoto, 2004.2

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids;

type
  TForm1 = class(TForm)
    StringGrid1: TStringGrid;
    AddButton: TButton;
    DelButton: TButton;
    CloseButton: TButton;
    CalcButton: TButton;
    SaveButton: TButton;
    LoadButton: TButton;
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    procedure CloseButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure AddButtonClick(Sender: TObject);
    procedure SaveButtonClick(Sender: TObject);
    procedure LoadButtonClick(Sender: TObject);
    procedure DelButtonClick(Sender: TObject);
    procedure CalcButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

uses UFROCGuassNE;

{$R *.dfm}

procedure TForm1.CloseButtonClick(Sender: TObject);
begin
                 Close;
end;

procedure TForm1.FormCreate(Sender: TObject);
var sel : TGridRect;      //  IZ̈ʒu\킷߂̌^
begin
    with StringGrid1 do
      begin
          ColCount:=3;
          RowCount:=3;
          Font.Height:=16;
          Cells[0,1]:='  1';
          Cells[0,2]:='  2';
          Cells[1,0]:='  f';
          Cells[2,0]:='  h';
          Options:=Options-[goRangeSelect];  //  PZ̑I
          with sel do                        //  Z̈ʒu
            begin  Left:=1; Top:=1; Right:=1; Bottom:=1;  end;
          Selection:=sel;                    //  IZ̐ݒ
          Options:=[goEditing]+Options;      //  ZҏW
          EditorMode:=true;                  //  ZҏW
      end;
end;


(*           s̒ǉ          *)
procedure TForm1.AddButtonClick(Sender: TObject);
var   i, j, pos : Longint;
begin
      with StringGrid1 do
        begin
            pos:=Selection.top;
            RowCount:=RowCount+1;
            Cells[0,RowCount-1]:='  '+IntToStr(RowCount-1);
            for j:=1 to ColCount-1 do
              Cells[j,RowCount-1]:=' ';
            if (pos < RowCount-2) then
              begin
                for i:=RowCount-1 downto pos+2 do
                  for j:=1 to ColCount-1 do
                    begin
                      Cells[j,i]:=Cells[j,i-1];
                    end;

                for j:=1 to ColCount-1 do
                  Cells[j,pos+1]:=' ';
              end;
        end;
end;




function CheckCSV( s : string ) : string;
  var v : string;
  begin
    v:=s;
    if Length(v) < 5
      then v:=v+'.csv'
      else
        begin
          if ( (Copy(v, Length(s)-3, 4) <> '.csv') and
               (Copy(v, Length(s)-3, 4) <> '.CSV')    )
              then v:=v+'.csv';
        end;

    CheckCSV:=v;
  end;

procedure TForm1.SaveButtonClick(Sender: TObject);
var outf : TextFile;
    i, j : Longint;
    DataFileName : string;
begin
    with SaveDialog1 do        //   ۑpt@C̖O̐ݒ
      begin
          Title:='t@C';
          Filter:='CSV files|*.csv';
          FileName:='';
          if not Execute then exit;
          DataFileName:=CheckCSV(FileName);
          AssignFile(outf,DataFileName);
      end;

    Rewrite(outf);            //  t@Copɐݒ

    with StringGrid1 do
      begin
        for i:=1 to RowCount-1 do
          begin
            if ColCount > 2 then
              for j:=1 to ColCount-2 do
                write(outf, Trim(Cells[j,i]), ',');
              writeln(outf, Trim(Cells[ColCount-1,i]));
          end;
      end;

    CloseFile(outf);
end;

procedure TForm1.LoadButtonClick(Sender: TObject);
var inf : TextFile;
    i   : Longint;
    SL : TStringList;
    s, DataFileName : string;
begin
    with OpenDialog1 do           //  t@C̐ݒ
      begin
          Title:='t@C';
          Filter:='CSV files|*.csv';
          FileName:='';
          if not Execute then exit;
          AssignFile(inf,FileName);
          DataFileName:=FileName;
      end;

    Reset(inf);                  //   t@Cǂݏopɐݒ


    with StringGrid1 do
      begin
        RowCount:=1;
        SL:=TStringList.Create;
  
        repeat
          readln(inf, s);
          RowCount:=RowCount+1;
          Cells[0, RowCount-1]:='  '+IntToStr(RowCount-1);
          SL.CommaText:=s;
          for i:=1 to 2 do
            Cells[i,RowCount-1]:=SL.Strings[i-1];
        until eof(inf);

        SL.Free;
        CloseFile(inf);
      end;
end;

procedure TForm1.DelButtonClick(Sender: TObject);
var pos, i, j : Longint;
begin
    with StringGrid1 do
      if RowCount > 2 then
        begin
          pos:= Selection.top;     //  Is̐ݒ

          //   Z̒l̈ړ
          if (0 < pos) and (pos < RowCount-1) then
              for i:=pos to RowCount-2 do
                for j:=1 to ColCount-1 do
                  Cells[j,i]:=Cells[j,i+1];

          //   Ō̍s폜
          RowCount:=RowCount-1;
          for i:=1 to RowCount-1 do
            Cells[0,i]:='  '+IntToStr(i);
        end;
end;

procedure TForm1.CalcButtonClick(Sender: TObject);
begin
      FROC:=TFROC.Create(Application);
      with FROC do
        begin
            Show;  DrawROC;
        end;
end;

end.
