unit UChiSqr1S;     (*  JCQ挟Fxž   *)

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, StdCtrls;

type
  TForm1 = class(TForm)
    StringGrid1: TStringGrid;
    ExitButton: TButton;
    CalcButton: TButton;
    SaveButton: TButton;
    LoadButton: TButton;
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    PButton: TButton;
    AddColButton: TButton;
    DelColButton: TButton;
    PrintDialog1: TPrintDialog;
    procedure ExitButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CalcButtonClick(Sender: TObject);
    procedure SaveButtonClick(Sender: TObject);
    procedure LoadButtonClick(Sender: TObject);
    procedure PButtonClick(Sender: TObject);
    procedure AddColButtonClick(Sender: TObject);
    procedure DelColButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses  Printers;

procedure TForm1.ExitButtonClick(Sender: TObject);
begin
           Close;
end;


procedure TForm1.FormCreate(Sender: TObject);
var sel : TGridRect;      //  IZ̈ʒu\킷߂̌^
begin
    with StringGrid1 do
      begin
          ColCount:=2;                  //  ̐
          RowCount:=3;                  //  ̃f[^̐
          Font.Height:=16;
          Cells[0,1]:='x';
          Cells[0,2]:='x  ';
          Cells[1,0]:=' P';
          Cells[1,1]:='xP';
          Options:=Options-[goRangeSelect];  //  PZ̑I
          with sel do                        //  Z̈ʒu
            begin  Left:=1; Top:=1; Right:=1; Bottom:=1;  end;
          Selection:=sel;                    //  IZ̐ݒ
          Options:=[goEditing]+Options;      //  ZҏW
          EditorMode:=true;                  //  ZҏW
      end;
end;



(*         ̒ǉ        *)
procedure TForm1.AddColButtonClick(Sender: TObject);
var   i, j, pos : Longint;
begin
      with StringGrid1 do
        begin
            pos:=Selection.Left;
            ColCount:=ColCount+1;
            for j:=1 to ColCount-1 do
              Cells[j,0]:=' '+IntToStr(j);
            for i:=1 to RowCount-1 do
              Cells[ColCount-1,i]:=' ';
            if (0 < pos) and (pos < ColCount-2) then
              begin
                for i:=ColCount-1 downto pos+2 do
                  for j:=1 to RowCount-1 do
                    Cells[i,j]:=Cells[i-1,j];

                for j:=1 to RowCount-1 do
                  Cells[pos+1,j]:=' ';
              end;
        end;
end;


(*      ̍폜      *)
procedure TForm1.DelColButtonClick(Sender: TObject);
var pos, i, j : Longint;
begin
    with StringGrid1 do
      begin
        pos:= Selection.Left;     //  I̐ݒ

        //   Z̒l̈ړ
        if (0 < pos) and (pos < ColCount-1) then
            for i:=pos to ColCount-2 do
              for j:=1 to RowCount-1 do
                Cells[i,j]:=Cells[i+1,j];

        //   Ō̗폜
        if 0 < pos then
          if ColCount > 2 then ColCount:=ColCount-1;
        for i:=1 to ColCount-1 do
          Cells[i,0]:=' '+IntToStr(i);  
      end;
end;

procedure TForm1.CalcButtonClick(Sender: TObject);
var out_f   : TextFile;
    k, i, n : Longint;
    e, x2   : extended;
    obs     : array[1..20] of Longint;
begin
      with OpenDialog1 do
        begin
          FileName:='';
          Title:='vZʏo͗pt@C';
          if not execute then exit;
          AssignFile(out_f, FileName);
          Rewrite(out_f);
        end;

      with StringGrid1 do
        begin
          k:=Colcount-1;   //   JeS̐
          try
            for i := 1 to k do      //  f[^̓ǂݍ
              obs[i]:=StrToInt(Cells[i,2]);
          except                             //   sȃf[^
            ShowMessage('Error ===>  Cells[1,'+IntToStr(i)+'] = '
                         +Cells[1,i]);
            Exit;   //   ̎葱̏I
          end;
        end;

      n := 0;
      writeln(out_f, 'f[^');
      for i := 1 to k do
        begin
              write(out_f, obs[i]:5);
              n := n + obs[i];
        end;
      writeln(out_f);
      writeln(out_f, ' = ', n);

      e := n / k ;
      writeln(out_f);
      writeln(out_f, 'e = ', e:7:1);
      x2 := 0 ;
      for i := 1 to k do
         x2 := x2 + sqr(obs[i] - e)/e ;

      writeln(out_f);
      writeln(out_f, 'Chi square = ', x2:7:2,
                     '     df = ', k-1);

      CloseFile(out_f);
      ExitButton.SetFocus;
end;

(*    Obhɐݒ肳Ăf[^̕ۑ    *)
procedure TForm1.SaveButtonClick(Sender: TObject);
var outf : TextFile;
    h    : Longint;
begin
    with SaveDialog1 do        //   ۑpt@C̖O̐ݒ
      begin
          Title:='t@C';
          if not Execute then exit;
          AssignFile(outf,FileName);
      end;

    Rewrite(outf);            //  t@Copɐݒ

    with StringGrid1 do
      begin
        writeln(outf,ColCount-1);
        for h:=1 to ColCount-1 do
          begin
            writeln(outf,Cells[h,1]);
            writeln(outf,Cells[h,2]);
          end;
      end;

    CloseFile(outf);
end;

(*    t@CObhփf[^ǂݍ    *)
procedure TForm1.LoadButtonClick(Sender: TObject);
var inf : TextFile;
    v, h   : Longint;
    s      : string;
begin
    with OpenDialog1 do           //  t@C̐ݒ
      begin
          Title:='t@C';
          if not Execute then exit;
          AssignFile(inf,FileName);
      end;

    Reset(inf);                  //   t@Cǂݏopɐݒ

    with StringGrid1 do
      begin
        readln(inf,v);          //   f[^̓ǂݍ
        ColCount:=v+1;

        for h:=1 to ColCount-1 do
          begin
            readln(inf,s);     //    f[^̓ǂݍ
            Cells[h,1]:=s;
            readln(inf,s);
            Cells[h,2]:=s;
          end;

        for h:=1 to ColCount-1 do
          Cells[h,0]:=' '+IntToStr(h);
      end;

    CloseFile(inf);
end;

procedure TForm1.PButtonClick(Sender: TObject);
var   pout : TextFile;
      h    : Longint;
begin
      PrintDialog1.Execute;

      with printer do
        begin
          AssignPrn(pout);
          Rewrite(pout);

          with Canvas.Font do
            begin
                Name:='lr ';
                size:=16;
            end;

          writeln(pout);

          with StringGrid1 do
            begin
              for h:=1 to ColCount-1 do
                write(pout,''+IntToStr(h)+'':10);
              writeln(pout);
              writeln(pout);

              for h:=1 to ColCount-1 do
                write(pout,Cells[h,1]:10);
              writeln(pout);
              writeln(pout);

              for h:=1 to ColCount-1 do
                write(pout,Cells[h,2]:10);
              writeln(pout);
            end;
          CloseFile(pout);
        end;
end;

end.