unit UChiSqrXTable;     (*   JCQ挟FNX\    *)

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, StdCtrls;

type
  TForm1 = class(TForm)
    StringGrid1: TStringGrid;
    AddButton: TButton;
    ExitButton: TButton;
    DelButton: TButton;
    CalcButton: TButton;
    SaveButton: TButton;
    LoadButton: TButton;
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    PButton: TButton;
    AddColButton: TButton;
    DelColButton: TButton;
    procedure ExitButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure AddButtonClick(Sender: TObject);
    procedure DelButtonClick(Sender: TObject);
    procedure CalcButtonClick(Sender: TObject);
    procedure SaveButtonClick(Sender: TObject);
    procedure LoadButtonClick(Sender: TObject);
    procedure PButtonClick(Sender: TObject);
    procedure AddColButtonClick(Sender: TObject);
    procedure DelColButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses  Printers;

procedure TForm1.ExitButtonClick(Sender: TObject);
begin
           Close;
end;

var fw : Longint;

procedure TForm1.FormCreate(Sender: TObject);
var sel : TGridRect;      //  IZ̈ʒu\킷߂̌^
begin
    with StringGrid1 do
      begin
          ColCount:=2;                  //  sJeS[̐{P
          RowCount:=2;                  //  JeS[̐{P
          with Canvas do
            begin
              with Font do
                begin  Height:=16; Name:='lr ';  end;
              fw:=TextWidth('sJeS[ XXX');
            end;
          with Font do
            begin Height:=16; Name:='lr ';  end;
          ColWidths[0]:=fw;
          ColWidths[1]:=fw;
          Cells[0,1]:='sJeS[ 1';
          Cells[1,0]:='JeS[ 1';
          Options:=Options-[goRangeSelect];  //  PZ̑I
          with sel do                        //  Z̈ʒu
            begin  Left:=1; Top:=1; Right:=1; Bottom:=1;  end;
          Selection:=sel;                    //  IZ̐ݒ
          Options:=[goEditing]+Options;      //  ZҏW
          EditorMode:=true;                  //  ZҏW
      end;
end;


(*           s̒ǉ          *)
procedure TForm1.AddButtonClick(Sender: TObject);
var   i, j, pos : Longint;
begin
      with StringGrid1 do
        begin
            pos:=Selection.top;
            RowCount:=RowCount+1;
            Cells[0,RowCount-1]:='sJeS[ '+IntToStr(RowCount-1);
            for j:=1 to ColCount-1 do
              Cells[j,RowCount-1]:=' ';
            if (0 < pos) and (pos < RowCount-2) then
              begin
                for i:=RowCount-1 downto pos+2 do
                  for j:=1 to ColCount-1 do
                    begin
                      Cells[j,i]:=Cells[j,i-1];
                    end;

                for j:=1 to ColCount-1 do
                  Cells[j,pos+1]:=' ';
              end;
        end;
end;

(*         ̒ǉ        *)
procedure TForm1.AddColButtonClick(Sender: TObject);
var   i, j, pos : Longint;
begin
      with StringGrid1 do
        begin
            pos:=Selection.Left;
            ColCount:=ColCount+1;
            ColWidths[ColCount-1]:=fw;
            for j:=1 to ColCount-1 do
              Cells[j,0]:='JeS[ '+IntToStr(j);
            for i:=1 to RowCount-1 do
              Cells[ColCount-1,i]:=' ';
            if (0 < pos) and (pos < ColCount-2) then
              begin
                for i:=ColCount-1 downto pos+2 do
                  for j:=1 to RowCount-1 do
                    Cells[i,j]:=Cells[i-1,j];

                for j:=1 to RowCount-1 do
                  Cells[pos+1,j]:=' ';
              end;
        end;
end;

(*          s̍폜           *)
procedure TForm1.DelButtonClick(Sender: TObject);
var pos, i, j : Longint;
begin
    with StringGrid1 do
      begin
        pos:= Selection.top;     //  Is̐ݒ

        //   Z̒l̈ړ
        if (0 < pos) and (pos < RowCount-1) then
            for i:=pos to RowCount-2 do
              for j:=1 to ColCount-1 do
                Cells[j,i]:=Cells[j,i+1];

           //   Ō̍s폜
        if 0 < pos then
          if RowCount > 2 then RowCount:=RowCount-1;
        for i:=1 to RowCount-1 do
          Cells[0,i]:='sJeS[ '+IntToStr(i);
      end;
end;

(*      ̍폜      *)
procedure TForm1.DelColButtonClick(Sender: TObject);
var pos, i, j : Longint;
begin
    with StringGrid1 do
      begin
        pos:= Selection.Left;     //  I̐ݒ

        //   Z̒l̈ړ
        if (0 < pos) and (pos < ColCount-1) then
            for i:=pos to ColCount-2 do
              for j:=1 to RowCount-1 do
                Cells[i,j]:=Cells[i+1,j];

        //   Ō̗폜
        if 0 < pos then
          if ColCount > 2 then ColCount:=ColCount-1;
        for i:=1 to ColCount-1 do
          Cells[i,0]:='JeS[ '+IntToStr(i);  
      end;
end;

procedure TForm1.CalcButtonClick(Sender: TObject);
var      outf : TextFile;
         e, chi_square : Extended;
         k, r, i, j, n : Longint;
         o1, o2            : array of Longint;
         o                 : array of array of Longint;
begin
    with StringGrid1 do
      begin
        r:=RowCount-1;   //   sJeS[̐
        k:=Colcount-1;   //   JeS[̐
        SetLength(o,r+1,k+1);
        SetLength(o1, r+1);
        SetLength(o2, k+1);
        try
          for i := 1 to r do      //  f[^̓ǂݍ
              for j := 1 to k do
                o[i, j]:=StrToInt(Cells[j,i]);
        except                             //   sȃf[^
          ShowMessage('Error ===>  Cells['
                      +IntToStr(j)+','+IntToStr(i)
                      +'] = '+Cells[j,i]);
          Exit;   //   ̎葱̏I
        end;
      end;

    with OpenDialog1 do
      begin
        Title:='vZʂ̏o͗pt@C';
        FileName:='';
        Execute;
        AssignFile(outf,FileName);
        Rewrite(outf);
      end;

    writeln(outf, '̓f[^');
    n := 0 ;
    for i := 1 to r do
      begin
            o1[i] := 0 ;
            for j := 1 to k do
              begin
                    write(outf, o[i, j]:5);
                    o1[i] := o1[i] + o[i, j] ;
              end;
            writeln(outf);

            n := n + o1[i] ;
      end;

    for j := 1 to k do
      begin
            o2[j] := 0 ;
            for i := 1 to r do  o2[j] := o2[j] + o[i, j] ;
      end;

    writeln(outf);
    writeln(outf, 'e = ');
    chi_square := 0.0 ;
    for i := 1 to r do
      begin
        for j := 1 to k do
          begin
                e := o1[i] * o2[j] / n ;
                chi_square := chi_square + sqr(o[i, j] - e)/e ;
                write(outf, e:7:1);
          end;
        writeln(outf);  
      end;

    writeln(outf);
    writeln(outf, 'Chi square = ', chi_square:8:2,
                   '      df = ', (k-1)*(r-1) );

    Closefile(outf);

    Finalize(o);
    Finalize(o1);
    Finalize(o2);

    ExitButton.SetFocus;
end;


(*    Obhɐݒ肳Ăf[^̕ۑ    *)
procedure TForm1.SaveButtonClick(Sender: TObject);
var outf : TextFile;
    h, i : Longint;
begin
    with SaveDialog1 do        //   ۑpt@C̖O̐ݒ
      begin
          Title:='t@C';
          Execute;
          AssignFile(outf,FileName);
      end;

    Rewrite(outf);            //  t@Copɐݒ

    with StringGrid1 do
      begin
        writeln(outf,ColCount-1);
        writeln(outf,RowCount-1);
        for h:=1 to ColCount-1 do
          for i:=1 to RowCount-1 do
            writeln(outf, Trim(Cells[h,i])); //  f[^̏o
      end;

    CloseFile(outf);
end;

(*    t@CObhփf[^ǂݍ    *)
procedure TForm1.LoadButtonClick(Sender: TObject);
var inf : TextFile;
    v, h, i   : Longint;
    s      : string;
begin
    with OpenDialog1 do           //  t@C̐ݒ
      begin
          Title:='t@C';
          Execute;
          AssignFile(inf,FileName);
      end;

    Reset(inf);                  //   t@Cǂݏopɐݒ

    with StringGrid1 do
      begin
        readln(inf,v);          //   f[^̓ǂݍ
        ColCount:=v+1;
        readln(inf,v);
        RowCount:=v+1;
        for h:=0 to ColCount-1 do ColWidths[h]:=fw;
        for h:=1 to ColCount-1 do
          for i:=1 to RowCount-1 do
            begin
              readln(inf,s);     //    f[^̓ǂݍ
              Cells[h,i]:=s;
            end;

        for i:=1 to RowCount-1 do
          Cells[0,i]:='sJeS[ '+IntToStr(i);
        for h:=1 to ColCount-1 do
          Cells[h,0]:='JeS[ '+IntToStr(h);
      end;

    CloseFile(inf);
end;

procedure TForm1.PButtonClick(Sender: TObject);
var   pout : TextFile;
      h, i    : Longint;
begin
      with printer do
        begin
          AssignPrn(pout);
          Rewrite(pout);

          with Canvas.Font do
            begin
                Name:='lr ';
                size:=16;
            end;

          writeln(pout);
          writeln(pout);
          writeln(pout,'Data =');

          with StringGrid1 do
            for i:=1 to RowCount-1 do
              begin
                writeln(pout);
                for h:=1 to ColCount-1 do
                  write(pout,StrToInt(Cells[h,i]):7);
                writeln(pout);
              end;
          CloseFile(pout);
        end;
end;

end.