unit UFCumDistri;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    MsgLabel: TLabel;
    Label2: TLabel;
    EditP: TEdit;
    OKButton: TButton;
    ExitButton: TButton;
    Label1: TLabel;
    DF1Edit: TEdit;
    Label3: TLabel;
    DF2Edit: TEdit;
    procedure FormActivate(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormActivate(Sender: TObject);
begin
           MsgLabel.Caption:='̒lƎRxdf1,df2ݒ肵ĉ';
           DF1Edit.Text:='';
           DF2Edit.Text:='';
           EditP.Text:='';
end;

procedure TForm1.ExitButtonClick(Sender: TObject);
begin
            Close;
end;



type   TFunc = function( x : Extended ) : Extended;


(*   Guass-Legendre̐ϕ    *)

function  Gauss_Legendre( a, b : Extended;
                          f    : TFunc ) : Extended;
  const  n_points = 9;
  type   pos_arry = array[1..n_points] of Extended;
  const  x0 : pos_arry = ( -9.68160239507626090E-0001,
                           -8.36031107326635794E-0001,
                           -6.13371432700590397E-0001,
                           -3.24253423403808929E-0001,
                            0.00000000000000000E+0000,
                            3.24253423403808929E-0001,
                            6.13371432700590397E-0001,
                            8.36031107326635794E-0001,
                            9.68160239507626090E-0001  );

         w  : pos_arry = (  8.12743883615744120E-0002,
                            1.80648160694857404E-0001,
                            2.60610696402935462E-0001,
                            3.12347077040002840E-0001,
                            3.30239355001259763E-0001,
                            3.12347077040002840E-0001,
                            2.60610696402935462E-0001,
                            1.80648160694857404E-0001,
                            8.12743883615744120E-0002  );
         accuracy = 1.0E-14;
  var    v1, i_w, xi : Extended;
         i : longint;
  begin
        v1:=0.0;
        i_w:=b-a;

        for i:=1 to n_points do
          begin
                xi:=(0.5*i_w*x0[i])+(0.5*(b+a));
                v1:=v1+(w[i]*f(xi));
          end;

        v1:=0.5*i_w*v1;
        Gauss_Legendre:=v1;
  end;    {    Gauss_Legendre     }


(*    ϕԂ̂QɂJԂ   *)

procedure  CalcIntegral( var S0  : Extended;
                         a, b    : Extended;
                         f       : TFunc;
                         w_intvl,
                         acc     //  acc >= 1.0E-14
                                 : Extended );
  var  S1, S2 : Extended;
  begin
       S1:=Gauss_Legendre( a, 0.5*(a+b), f );
       S2:=Gauss_Legendre( 0.5*(a+b), b, f );
       if ((abs(S0-S1-S2) < acc*abs(S1+S2))
             or
          ((abs(S0)+abs(S1+S2)) < 1.0E-14))
          and
          (abs(b-a) < w_intvl)
         then S0:=S1+S2
         else
           begin
               CalcIntegral(S1, a, 0.5*(a+b), f, w_intvl, acc);
               CalcIntegral(S2, 0.5*(a+b), b, f, w_intvl, acc);
               S0:=S1+S2;
           end;
  end;   {   CalcIntegral   }


(*   ClacIntegraľĂяȍ     *)

function AdaptiveGL( a, b    : Extended;
                     f       : TFunc;
                     w_intvl : Extended;
                     acc     //   acc >= 1.0E-14
                             : Extended ) : Extended;
  var S0 : Extended;
  begin
        S0:=0.0;
        CalcIntegral(S0, a, b, f, w_intvl, acc);
        AdaptiveGL:=S0;
  end;   {   AdaptiveGL   }



function My_Power( a, b : Extended ) : Extended;
  begin
        My_Power:=exp(b*ln(a));
  end;


var  df1, df2 : Extended;

function t_kernel( x : Extended ) : Extended;
  begin
        t_kernel:=1.0/My_Power(1+sqr(x)/df2, (df2+1)/2);
  end;


var ga : Extended;

function k_gamma_tr( t : Extended ) : Extended;
  begin
        k_gamma_tr:=exp((ga-1)*Ln(-Ln(t)));
  end;


function k_gamma( y : Extended ) : Extended;
  begin
        k_gamma:=exp((ga-1)*Ln(y)) * exp(-y);
  end;


function gamma( r : Extended ) : Extended;
  var c, v1, v2 : Extended;
  begin
    ga:=r;
    c:=exp(-1.0);
    v1:=AdaptiveGL( 0.0, 1.0, k_gamma, 1.0, 1.0E-11 );
    v2:=AdaptiveGL( 0.0, c, k_gamma_tr, 1.0, 1.0E-11 );

    gamma:=v1+v2;
  end;


function F_kernel( x : Extended ) : Extended;
  begin
        F_kernel:=My_Power(x, df1/2-1)/
                   My_Power(1+df1*x/df2, (df1+df2)/2);
  end;


function Cum_F_distribution( F : Extended ) : Extended;
  var  v : Extended;
  begin
      if F <= 0.0
        then Cum_F_distribution:=0.0
      else if df1 <= 1
        then begin
             v:=AdaptiveGL( -sqrt(F),sqrt(F),t_kernel, 1.0, 1.0E-11 );
             Cum_F_distribution:=gamma((df2+1)/2)*v/
                                 (sqrt(pi*df2)*gamma(df2/2));
        end
      else begin
             v:=AdaptiveGL( 0.0, F, F_kernel, 1.0, 1.0E-11 );
             Cum_F_distribution:=v*gamma((df1+df2)/2)*
                                   My_Power(df1/df2, df1/2)/
                                  (gamma(df1/2)*gamma(df2/2));
        end;
  end;

                                     

(*    Bisection@ɂ鍪̌vZ    *)

procedure  Bisection( f : TFunc;
                      s,         //   f֐̂Ƃ s > 0.0
                      c,         //   ɑ΂֐l
                      L_b, U_b   //   ̑݋Ԃ̉Ə
                                : double;
                      var  Root  //     f(Root) = c
                                : double;
                      acc       : double          );
  var  m, v : double;
  begin
         if (f(L_b)-c)*(f(U_b)-c) > 0.0 then
           begin
             ShowMessage('Ɖ̑gݍ킹sK؂łB');
             Application.Terminate;
           end;

         repeat
           m:=0.5*(L_b+U_b);
           v:=f(m);
           if s*(v-c) > 0.0 then U_b:=m
                            else L_b:=m;
         until  (abs(U_b-L_b) < acc*abs(U_b))
              or
                ( (abs(U_b)+abs(L_b)) < 1.0E-13 );

         Root:=0.5*(L_b+U_b);
  end;   {   Bisection   }



procedure TForm1.OKButtonClick(Sender: TObject);
var   F, VAlpha, p, vp, L_b, U_b : double;
begin
      MsgLabel.caption:='Calculation Started';

      VAlpha:=StrToFloat(EditP.Text);
      df1:=StrToFloat(DF1Edit.Text);
      df2:=StrToFloat(DF2Edit.Text);
      if (VAlpha <= 0) or (1 <= VAlpha) then
        begin
          MsgLabel.Caption := '̒l0<<1Őݒ肵ĉ';
        end;

      p := 1 - VAlpha;

      L_b := 1.0e-9;
      repeat
         L_b := L_b * 0.5;
         vp := Cum_F_distribution( L_b );
      until vp < p;
      U_b := 1.0;
      repeat
          U_b := U_b * 2.0;
          vp := Cum_F_distribution( U_b );
      until p < vp;

      Bisection( Cum_F_distribution, 1.0, p, L_b, U_b, F, 1.0e-12 );

      MsgLabel.Caption := 'F = '+FloatToStrF(F,ffGeneral,7,4);
      ExitButton.SetFocus;
end;

end.