#ifndef CALCFDISTRI_CK
#define CALCFDISTRI_CK


#include "adapIntgrtn.h"

using namespace adapInt;

namespace calcfd {

	double df1, df2;

	double t_kernel( double x ){
		double v = 1.0 / Math::Pow( 1.0 + x * x / df2, (df2 + 1.0)/2.0 );
		return v;
	}

	double ga;

	double k_gamma_tr( double t ){
		double v = Math::Exp( (ga - 1.0) * Math::Log( -Math::Log( t ) ) );
		return v;
	}

	double k_gamma( double y ){
		double v = Math::Exp( (ga - 1.0) * Math::Log(y)) * Math::Exp(-y);
		return v;
	}

	double gamma( double r ){
		ga = r;
		double c = Math::Exp(-1.0);
		AdaptiveGL gl;
		double v1 = gl.integral( 0.0, 1.0, k_gamma );
		double v2 = gl.integral( 0.0, c, k_gamma_tr );
		return v1 + v2;
	}

	double F_kernel( double x ){
		double v = Math::Pow( x, df1/2.0 - 1.0 ) / Math::Pow( 1.0 + df1 * x / df2, (df1 + df2) / 2.0 );
		return v;
	}

	double Cum_F_distribution( double F ){
		double v;
		if ( F <= 0.0 ){
			return 0.0;
		} else {
			if ( df1 <= 1 ){
				AdaptiveGL gl;
				double v = gl.integral( -Math::Sqrt(F), Math::Sqrt(F), t_kernel );
				v *= gamma( (df2 + 1.0)/2.0) / (Math::Sqrt(Math::PI * df2) * gamma(df2/2.0));
				return v;
			} else {
				AdaptiveGL gl;
				double v = gl.integral( 0.0, F, F_kernel );
				v *= gamma( (df1 + df2)/2.0 ) * Math::Pow( df1/df2, df1/2.0 ) / (gamma(df1/2.0) * gamma(df2/2.0));
				return v;
			};
		}
	}

//
//     Bisection@ɂ鍪̌vZ    
// 
	void Bisection( double (*f)( double ), 
					double s,			//   f֐̂Ƃ s > 0.0
					double c,			//   ɑ΂֐l
					double L_b,			//   ̑݋Ԃ̉
					double U_b,			//   ̑݋Ԃ̏
					double & Root,		//     f(Root) = c
					double acc ){
				if( (f(L_b) - c) * (f(U_b) - c) > 0.0 ){
					throw gcnew Exception("Ɖ̑gݍ킹sK؂łB");
					return;
				}
				double m;
				do {
					m = 0.5 * (L_b + U_b);
					double v = f(m);
					if ( s * (v - c) > 0.0 ) U_b = m; else L_b = m;
				} while ( (Math::Abs(U_b - L_b) >= acc * Math::Abs(U_b))
							&&
						  ( (Math::Abs(U_b) + Math::Abs(L_b)) >= 1.0e-13) );

				Root = 0.5 * (L_b + U_b);
	}


}

#endif
