#include "stdafx.h"
#include "calcFDistri.h"


#include "adapIntgrtn.h"

using namespace adapInt;

namespace calcfd {

	double df1, df2;

	void set_df( double vdf1, double vdf2 ){
			df1 = vdf1;
			df2 = vdf2;
	}

	double t_kernel( double x ){
		double v = 1.0 / Math::Pow( 1.0 + x * x / df2, (df2 + 1.0)/2.0 );
		return v;
	}

	double ga;

	double k_gamma_tr( double t ){
		double v = Math::Exp( (ga - 1.0) * Math::Log( -Math::Log( t ) ) );
		return v;
	}

	double k_gamma( double y ){
		double v = Math::Exp( (ga - 1.0) * Math::Log(y)) * Math::Exp(-y);
		return v;
	}

	double gamma( double r ){
		ga = r;
		double c = Math::Exp(-1.0);
		AdaptiveGL gl;
		double v1 = gl.integral( 0.0, 1.0, k_gamma );
		double v2 = gl.integral( 0.0, c, k_gamma_tr );
		return v1 + v2;
	}

	double F_kernel( double x ){
		double v = Math::Pow( x, df1/2.0 - 1.0 ) / Math::Pow( 1.0 + df1 * x / df2, (df1 + df2) / 2.0 );
		return v;
	}

	double Cum_F_distribution( double F ){
		if ( F <= 0.0 ){
			return 0.0;
		} else {
			if ( df1 <= 1 ){
				AdaptiveGL gl;
				double v = gl.integral( -Math::Sqrt(F), Math::Sqrt(F), t_kernel );
				v *= gamma( (df2 + 1.0)/2.0) / (Math::Sqrt(Math::PI * df2) * gamma(df2/2.0));
				return v;
			} else {
				AdaptiveGL gl;
				double v = gl.integral( 0.0, F, F_kernel );
				v *= gamma( (df1 + df2)/2.0 ) * Math::Pow( df1/df2, df1/2.0 ) / (gamma(df1/2.0) * gamma(df2/2.0));
				return v;
			};
		}
	}


}
