unit UANOVA2FctrCalc;     (*  ÚF팱ҊԂQv    *)

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, StdCtrls, ComCtrls;

type
  TCalcForm = class(TForm)
    ExitButton: TButton;
    CalcButton: TButton;
    SaveButton: TButton;
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    PButton: TButton;
    TabControl1: TTabControl;
    StringGrid1: TStringGrid;
    procedure ExitButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CalcButtonClick(Sender: TObject);
    procedure SaveButtonClick(Sender: TObject);
    procedure PButtonClick(Sender: TObject);
    procedure TabControl1Change(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  CalcForm: TCalcForm;
  a, b, n : Longint;
  y     : array of array of array of Extended;
  ydata : array of array of array of String;

implementation

{$R *.DFM}

uses  Printers,UANOVA2Fctr;

var   SelCond : record
                    Prev, Cur : Longint;
                end;

procedure TCalcForm.ExitButtonClick(Sender: TObject);
begin
             Finalize(y);
             Finalize(ydata);
             Finalize(LA);
             Finalize(LB);
             Form1.Close;
end;


procedure TCalcForm.FormCreate(Sender: TObject);
var  sel : TGridRect;      //  IZ̈ʒu\킷߂̌^
     i, j, h : Longint;
begin
    SetLength(y,n+1,a+1,b+1);
    with TabControl1 do
      begin
        MultiLine:=false;
        Style:=tsTabs;
        with Tabs do
          begin
            Strings[0]:=LA[1];
            if a > 1 then
              for i:=2 to a do Add(LA[i]);
          end;
        TabIndex:=0;
      end;

    
    TabControl1.TabIndex:=0;
    with StringGrid1 do
      begin
          ColCount:=b+1;                  //  a̐
          RowCount:=n+1;                  //  `ãf[^̐
          Font.Height:=16;

          for i:=1 to b do
            Cells[i,0]:=LB[i];
          for i:=1 to n do
            Cells[0,i]:=IntToStr(i)+'Ԗ';
          h:=TabControl1.TabIndex+1;
          for i:=1 to n do
            for j:=1 to b do
              Cells[j,i]:=ydata[i,h,j];

          with SelCond do
            begin  Prev:=1; Cur:=1; end;

          Options:=Options-[goRangeSelect];  //  PZ̑I
          with sel do                        //  Z̈ʒu
            begin  Left:=1; Top:=1; Right:=1; Bottom:=1;  end;
          Selection:=sel;                    //  IZ̐ݒ
          Options:=[goEditing]+Options;      //  ZҏW
          EditorMode:=true;                  //  ZҏW
      end;
end;

{-------------------------------------------------------------

  J.L.Myers,"Fundametals of Experimetal Design",2nd Ed.,1972,

                    Table 5-2, p.99.

---------------------------------------------------------------}
procedure TCalcForm.CalcButtonClick(Sender: TObject);
var outf : TextFile;
    i, j, k  : Longint;
    ss_total, ss_c, ss_a, ss_b,
    ss_ab, ss_err, v, rn : Extended;
    sum : array of extended;
  
  function AdjStr( s : string ) : string;
    var  i, n : Longint;
    begin
        n:=Length(s);
        if n < 10 then
          for i:=1 to 10-n do s:=' '+s;
        AdjStr:=s;
    end;

  function AdjStrL( s : string;  LStr : Longint ) : string;
    var NChar, i : Longint;
    begin
      NChar:=Length(s);
      if NChar < LStr then
        for i:=1 to LStr-NChar do s:=s+' ';

        AdjStrL:=s;
    end;

begin
    j:=TabControl1.TabIndex+1;
    for i:=1 to n do
      for k:=1 to b do
        ydata[i,j,k]:=Trim(StringGrid1.Cells[k,i]);

    for i:=1 to n do
      for j:=1 to a do
        for k:=1 to b do
          y[i,j,k]:=StrToFloat(ydata[i,j,k]);

    with OpenDialog1 do
      begin
        Title:='vZʂ̏o͗pt@C';
        FileName:='';
        if not Execute then exit;
        AssignFile(outf,FileName);
        Rewrite(outf);
      end;

    v:=0.0;
    for i:=1 to n do
      for j:=1 to a do
        for k:=1 to b do
          v:=v+y[i,j,k];
    rn:=n;
    ss_c:=sqr(v)/(rn*a*b);

    v:=0.0;
    for i:=1 to n do
      for j:=1 to a do
        for k:=1 to b do
          v:=v+sqr(y[i,j,k]);
    ss_total:=v-ss_c;

    ss_a:=0.0;
    for j:=1 to a do
      begin
        v:=0.0;
        for i:=1 to n do
          for k:=1 to b do
            v:=v+y[i,j,k];
        ss_a:=ss_a+sqr(v);
      end;
    ss_a:=(ss_a/(rn*b))-ss_c;

    ss_b:=0.0;
    for k:=1 to b do
      begin
        v:=0.0;
        for i:=1 to n do
          for j:=1 to a do
            v:=v+y[i,j,k];
        ss_b:=ss_b+sqr(v);
      end;
    ss_b:=(ss_b/(rn*a))-ss_c;

    ss_ab:=0.0;
    for j:=1 to a do
      for k:=1 to b do
        begin
          v:=0.0;
          for i:=1 to n do
            v:=v+y[i,j,k];
          ss_ab:=ss_ab+sqr(v);
        end;
    ss_ab:=(ss_ab/rn)-ss_c-ss_a-ss_b;

    ss_err:=ss_total-ss_a-ss_b-ss_ab;

    SetLength(sum, b+1);
    writeln(outf);
    writeln(outf);
    for j:=1 to a do
      begin
        writeln(outf);
        writeln(outf,'v`',LA[j],'');
        write(outf, AdjStr(' '));
        for k:=1 to b do
          begin
            write(outf, AdjStr(LB[k]));
            sum[k]:=0.0;
          end;
        writeln(outf);
        for i:=1 to n do
          begin
            write(outf, AdjStr(IntToStr(i)));
            for k:=1 to b do
              begin
                write(outf, AdjStr(ydata[i,j,k]));
                sum[k]:=sum[k]+StrToFloat(ydata[i,j,k]);
              end;
            writeln(outf);
          end;
        write(outf, AdjStr(''));
        for k:=1 to b do
          write(outf, AdjStr(FloatToStrF(sum[k]/n,ffGeneral,5,1)));
        writeln(outf);
      end;

    writeln(outf);
    writeln(outf);
    writeln(outf, AdjStrL('SV',10),
                  AdjStrL('SS',15), AdjStrL('df',10), AdjStrL('MS',15),
                  AdjStrL('F',15) );
    writeln(outf, AdjStrL('A',10),
                  AdjStrL(FloatToStrF(ss_a,ffGeneral,9,1),15),
                  AdjStrL(IntToStr(a-1),10),
                  AdjStrL(FloatToStrF(ss_a/(a-1),ffGeneral,9,1),15),
                  AdjStrL(FloatToStrF((ss_a/(a-1))/(ss_err/(a*b*(n-1.0))),
                                       ffGeneral,9,1), 15) );
    writeln(outf, AdjStrL('B',10),
                  AdjStrL(FloatToStrF(ss_b,ffGeneral,9,1),15),
                  AdjStrL(IntToStr(b-1),10),
                  AdjStrL(FloatToStrF(ss_b/(b-1),ffGeneral,9,1),15),
                  AdjStrL(FloatToStrF((ss_b/(b-1))/(ss_err/(a*b*(n-1.0))),
                                       ffGeneral,9,1), 15) );
    writeln(outf, AdjStrL('AB',10),
                  AdjStrL(FloatToStrF(ss_ab,ffGeneral,9,1),15),
                  AdjStrL(IntToStr((a-1)*(b-1)),10),
                  AdjStrL(FloatToStrF(ss_ab/((a-1)*(b-1)),ffGeneral,9,1),15),
                  AdjStrL(FloatToStrF((ss_ab/((a-1)*(b-1)))
                                       /(ss_err/(a*b*(n-1.0))),
                                       ffGeneral,9,1), 15) );
    writeln(outf, AdjStrL('S/AB',10),
                  AdjStrL(FloatToStrF(ss_err,ffGeneral,9,1),15),
                  AdjStrL(IntToStr(a*b*(n-1)),10),
                  AdjStrL(FloatToStrF(ss_err/(a*b*(n-1)),ffGeneral,9,1),15) );
    writeln(outf, AdjStrL('Total',10),
                  AdjStrL(FloatToStrF(ss_total,ffGeneral,9,1),15),
                  AdjStrL(IntToStr(a*b*n-1),10) );

    CloseFile(outf);  
    Finalize(sum);

    ExitButton.SetFocus;
end;

(*    Obhɐݒ肳Ăf[^̕ۑ    *)
procedure TCalcForm.SaveButtonClick(Sender: TObject);
var outf : TextFile;
    i, j, k : Longint;
begin
    with SaveDialog1 do        //   ۑpt@C̖O̐ݒ
      begin
          Title:='t@C';
          if not Execute then exit;
          AssignFile(outf,FileName);
      end;

    Rewrite(outf);            //  t@Copɐݒ

    j:=TabControl1.TabIndex+1;
    for i:=1 to n do
      for k:=1 to b do
        ydata[i,j,k]:=Trim(StringGrid1.Cells[k,i]);

    writeln(outf, n);
    writeln(outf, a);
    writeln(outf, b);
    for i:=1 to a do writeln(outf, LA[i]);
    for i:=1 to b do writeln(outf, LB[i]);

    for j:=1 to a do
       for k:=1 to b do
         for i:=1 to n do
           writeln(outf,ydata[i,j,k]);

    CloseFile(outf);
end;


procedure TCalcForm.PButtonClick(Sender: TObject);
var   pout : TextFile;
      i, j, k : Longint;

  function AdjStr( s : string ) : string;
    var  i, n : Longint;
    begin
        n:=Length(s);
        if n < 10 then
          for i:=1 to 10-n do s:=' '+s;
        AdjStr:=s;
    end;

begin
      j:=TabControl1.TabIndex+1;
      for i:=1 to n do
        for k:=1 to b do
          ydata[i,j,k]:=Trim(StringGrid1.Cells[k,i]);

      with printer do
        begin
          AssignPrn(pout);
          Rewrite(pout);

          with Canvas.Font do
            begin
                Name:='lr ';
                size:=16;
            end;

          writeln(pout);
          writeln(pout);

          for j:=1 to a do
            begin
              writeln(pout);
              writeln(pout,'v`',LA[j],'');
              write(pout, AdjStr(' '));
              for k:=1 to b do
                write(pout, AdjStr(LB[k]));
              writeln(pout);
              for i:=1 to n do
                begin
                  write(pout, AdjStr(IntToStr(i)));
                  for k:=1 to b do
                    write(pout, AdjStr(ydata[i,j,k]));
                  writeln(pout);
                end;
            end;

          CloseFile(pout);
        end;
end;

procedure TCalcForm.TabControl1Change(Sender: TObject);
var  i, j, k : Longint;
begin
      j:=SelCond.Cur;
      for i:=1 to n do
        for k:=1 to b do
          ydata[i,j,k]:=Trim(StringGrid1.Cells[k,i]);
      with SelCond do
        begin  Prev:=Cur; end;

      j:=TabControl1.TabIndex+1;
      SelCond.Cur:=j;
      for i:=1 to n do
        for k:=1 to b do
          StringGrid1.Cells[k,i]:=ydata[i,j,k];
end;

end.