unit UBinDistriGraph;

//  By Y. Okamoto

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    GOButton: TButton;
    ExitButton: TButton;
    NLabel: TLabel;
    NEdit: TEdit;
    PLabel: TLabel;
    PEdit: TEdit;
    Image1: TImage;
    procedure ExitButtonClick(Sender: TObject);
    procedure GOButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.ExitButtonClick(Sender: TObject);
begin
               Close;
end;

procedure TForm1.GOButtonClick(Sender: TObject);
var N, i, x0, y0, w, h : integer;
    p, MaxP, wstep, hstep, qstep, hp : extended;
    probs : array of extended;

  function Comb( N, k : integer ) : extended;
    var v : extended;
        i : integer;
    begin
        v:=1.0;
        if k > 0 then
        for i:=1 to k do
          v:=v*(N+1-i)/i;
        Comb:=v;
    end;

  //   MyPower = a**b
  function MyPower( a, b : extended ) : extended;
    begin
        if a < 0.0
          then raise Exception.Create('Invalid value for a')
        else if a > 0.0
          then MyPower:=exp(b*LN(a))
        else if b > 0.0
          then MyPower:=0.0
          else raise Exception.Create('Invalid values for a and b');
    end;

begin
    WindowState:=wsMaximized; UpDate;
    with NLabel do
      begin
          Top:=0; Left:=0;
      end;
    with NEdit do
      begin
          Top:=0; Left:=NLabel.Width;
      end;
    with PLabel do
      begin
          Top:=0;
          Left:=NEdit.Left+2*NEdit.Width;
      end;
    with PEdit do
      begin
          Top:=0;
          Left:=PLabel.Left+PLabel.Width;
      end;
    with GOButton do
      begin
          Top:=0;
          Left:=PEdit.Left+3*PEdit.Width;
      end;
    with ExitButton do
      begin
          Top:=0;
          Left:=Form1.ClientWidth-ExitButton.Width;
      end;
    with Image1 do
      begin
        Top:=GOButton.Height;
        Left:=0;
        Width:=Form1.ClientWidth;
        Height:=Form1.ClientHeight-Top;
        UpDate;
        with Canvas do
          begin
            Pen.Color:=clWhite;
            Brush.Color:=clWhite;
            Rectangle(0,0,Width,Height); UpDate;

            p:=StrToFloat(PEdit.Text);
            N:=StrToInt(NEdit.Text);
            SetLength(probs, N+1);
            for i:=0 to N do
              probs[i]:=comb(N,i)*MyPower(p,i)*MyPower(1-p,N-i);

            x0:=round(0.05*Width);
            y0:=round(0.9*Height);
            w :=round(0.9*Width);
            h :=round(0.8*Height);
            with Pen do
              begin
                Width:=3; // 2;
                Color:=clBlack;
              end;
            MoveTo(x0,y0); LineTo(x0+w,y0);

            with Font do
              begin
                  Height:=round(0.05*Image1.Height);
                  Name  :='lr SVbN';
              end;

            TextOut(x0, y0+round(0.02*Height), '0');
            TextOut(x0+w-TextWidth(IntToStr(N)),y0+round(0.02*Height),
                    IntToStr(N) );
            MaxP:=probs[0];
            for i:=1 to N do
              if MaxP < probs[i] then MaxP:=probs[i];

            with Pen do
              begin
                  Width:=2; //1;
                  Color:=clBlack;
              end;
            Brush.Color:=RGB(150,150,150); // clBlue;
            wstep:=w/(N+1);
            hstep:=wstep/2;
            qstep:=hstep*2/3;
            for i:=0 to N do
              begin
                  hp:=h*probs[i]/MaxP;
                  Rectangle(Round(x0+i*wstep+hstep-qstep), Round(y0-hp),
                            Round(x0+i*wstep+hstep+qstep), y0    );
              end;
          end;
      end;

    Finalize(probs);
end;

end.
