unit UCalcChi2C;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    ButtonClose: TButton;
    ButtonCalc: TButton;
    Label1: TLabel;
    EditP: TEdit;
    Label2: TLabel;
    EditDF: TEdit;
    LabelMsg: TLabel;
    procedure ButtonCloseClick(Sender: TObject);
    procedure ButtonCalcClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}


type   TFunc = function( x : double ) : double;


function  Gauss_Legendre( a, b : Extended;
                          f    : TFunc ) : Extended;
  const  n_points = 9;
  type   pos_arry = array[1..n_points] of Extended;
  const  x0 : pos_arry = ( -9.68160239507626090E-0001,
                           -8.36031107326635794E-0001,
                           -6.13371432700590397E-0001,
                           -3.24253423403808929E-0001,
                            0.00000000000000000E+0000,
                            3.24253423403808929E-0001,
                            6.13371432700590397E-0001,
                            8.36031107326635794E-0001,
                            9.68160239507626090E-0001  );

         w  : pos_arry = (  8.12743883615744120E-0002,
                            1.80648160694857404E-0001,
                            2.60610696402935462E-0001,
                            3.12347077040002840E-0001,
                            3.30239355001259763E-0001,
                            3.12347077040002840E-0001,
                            2.60610696402935462E-0001,
                            1.80648160694857404E-0001,
                            8.12743883615744120E-0002  );
         accuracy = 1.0E-13;
  var    v1, i_w, xi : Extended;
         i : longint;
  begin
        v1:=0.0;
        i_w:=b-a;

        for i:=1 to n_points do
          begin
                xi:=(0.5*i_w*x0[i])+(0.5*(b+a));
                v1:=v1+(w[i]*f(xi));
          end;

        v1:=0.5*i_w*v1;
        Gauss_Legendre:=v1;
  end;    {    Gauss_Legendre     }


procedure  CalcIntegral( var S0 : Extended;
                         a, b   : Extended;
                         f      : TFunc );
  var  S1, S2 : Extended;
  begin
       S1:=Gauss_Legendre( a, 0.5*(a+b), f );
       S2:=Gauss_Legendre( 0.5*(a+b), b, f );
       if ((abs(S0-S1-S2) < (1.0E-14)*abs(S1+S2))
             or
          ((abs(S0)+abs(S1+S2)) < 1.0E-13))
          and (abs(b-a) < 1.0)
         then S0:=S1+S2
         else
           begin
               CalcIntegral(S1, a, 0.5*(a+b), f);
               CalcIntegral(S2, 0.5*(a+b), b, f);
               S0:=S1+S2;
           end;
  end;   {   CalcIntegral   }


function AdaptiveGL( a, b : double;
                          f    : TFunc ) : double;
  var S0 : Extended;
  begin
        S0:=0.0;
        CalcIntegral(S0, a, b, f);
        AdaptiveGL:=S0;
  end;   {   AdaptiveGL   }



function My_Power( a, b : double ) : double;
  begin
        My_Power:=exp(b*ln(a));
  end;


var  df : integer;

function Chi_kernel( x : double ) : double;
  begin
        Chi_kernel:=My_Power(x, df/2-1) * exp(-x/2);
  end;


function gamma( r : double ) : double;
  begin
    if r > 1.25
      then gamma:=(r-1)*gamma(r-1)
      else begin
        if r > 0.75 then gamma:=1.0
                    else gamma:=sqrt(pi);
      end;
  end;



function Normal_Dist( x : double ) : double;
  begin
        Normal_Dist:=exp(-sqr(x)/2);
  end;



function Cum_Chi_distribution( chi : double ) : double;
  var  v : double;
  begin
      if chi <= 0.0
        then Cum_Chi_distribution:=0.0
      else if df <= 1
        then Cum_Chi_distribution:= AdaptiveGL(-sqrt(chi), sqrt(chi),
                                                  Normal_Dist)/sqrt(2*pi)
      else begin
             v:= AdaptiveGL(0.0, chi, Chi_kernel);
             Cum_Chi_distribution:=v/(gamma(df/2)*My_Power(2.0, df/2));
        end;
  end;


 

(*    Bisection@ɂ鍪̌vZ    *)

procedure  Bisection( f : TFunc;
                      s,         //   f֐̂Ƃ s > 0.0
                      c,         //   ɑ΂֐l
                      L_b, U_b   //   ̑݋Ԃ̉Ə
                                : double;
                      var  Root  //     f(Root) = c
                                : double;
                      acc       : double          );
  var  m, v : double;
  begin
         if (f(L_b)-c)*(f(U_b)-c) > 0.0 then
           begin
             ShowMessage('Ɖ̑gݍ킹sK؂łB');
             Application.Terminate;
           end;

         repeat
           m:=0.5*(L_b+U_b);
           v:=f(m);
           if s*(v-c) > 0.0 then U_b:=m
                            else L_b:=m;
         until  (abs(U_b-L_b) < acc*abs(U_b))
              or
                ( (abs(U_b)+abs(L_b)) < 1.0E-13 );

         Root:=0.5*(L_b+U_b);
  end;   {   Bisection   }






procedure TForm1.ButtonCalcClick(Sender: TObject);
var L_b, U_b, p, v, c : double;
begin
    LabelMsg.Caption := 'vZł';  UpDate;

    df := StrToInt(EditDF.Text);
    p  := StrToFloat(EditP.Text);

    L_b := 0.0;
    U_b := 0.0;
    repeat
      U_b := U_b + 1.0;
      v := Cum_Chi_distribution( U_b );
    until p < v;

    Bisection( Cum_Chi_distribution,   //   Function f
               1, //       s,         //   f֐̂Ƃ s > 0.0
               p, //       c,         //   ɑ΂֐l
               L_b, U_b, //       L_b, U_b   //   ̑݋Ԃ̉Ə
                         //       : double;
               c, //       var  Root  //     f(Root) = c
                  //              : double;
               1.0e-13 ); //       acc       : double          );

    LabelMsg.Caption := 'c = ' + FloatToStrF(c,ffGeneral,7,3) +
                        ', where P(ChiSqr < c) = p' ;

end;

procedure TForm1.ButtonCloseClick(Sender: TObject);
begin
                    Close;
end;

end.
