#ifndef KCNORMAL_CK
#define KCNORMAL_CK

#include "stdafx.h"

namespace kcnormal {

	using namespace System;


/**************************************************************************

      Kerridge and Cook(1976, Biometrika, 63, 401-403)'s Algorithm
                          referred to
       in  A. L. Brophy and  D. L. Wood (1989, Behav. Res. Meth. Istr.
                                         & Comp., 21, 447-454)

**************************************************************************/

	double normal_0_to_z( double z ) {
		double p;
		z = Math::Abs(z);
		if (z > 6.8) {
			double zz = z * z;
			double d = zz + 3 - 1/(0.22 * zz + 0.704);
			double m = 1 - 1/d;
			p = 0.5 - Math::Exp(-0.5 * zz) * m / (z * Math::Sqrt(2 * Math::PI));
		} else {
			p = 0.0;
			if (z > 0.0) {
				double zz4 = 0.25 * z * z;
				double n2 = 2.0;                // initial value of 2n          ; n = 1
				double theta2 = 1.0;			// initial value of theta(2n-2)
				double theta1 = zz4;			// initial value of theta(2n-1)
				p = 1.0;						// sum for n = 0
				double p_prev = 0.0;			// initial value of sub-sum
				while (true) {
					theta2 = zz4 * (theta1 - theta2) / n2;
					n2 += 1.0;
					p += theta2/n2;
					if (p == p_prev) break;
					theta1 = zz4 * (theta2 - theta1) / n2;
					n2 += 1.0;
					p_prev = p;
				}
				p = z * Math::Exp(-0.5 * zz4) * p / Math::Sqrt(2.0 * Math::PI);
			};
		}
		return p;
	}


	double Cum_NormalKC( double z ) {
		if ( z >= 0.0 ) {
			if (z > 0.0) {
				double v = 0.5 + normal_0_to_z( z );
				if (v > 1.0) {
					return 1.0;
				} else {
					return v;
				};
			} else {
				return 0.5;
			};
		} else {
			double v = 0.5 - normal_0_to_z( Math::Abs(z) );
			if (v < 0.0){
				return 0.0;
			} else {
				return v;
			};
		}
	}
}


#endif
