#ifndef CALCZ_CK
#define CALCZ_CK

#include "stdafx.h"
#include "KCNormal.h"

using namespace System;
using namespace System::Diagnostics;
using namespace kcnormal;

namespace Calcz {

	double calc_p_normal( double z );

	double calc_z_normal( double p );

	void Newton( double & x,				//  ̏lA߂l͍ f(x)=c
				 double vc,					//  ֐l
				 double (*f)( double ),		//  ֐
				 double (*df)( double ),	//  ֐
				 double acc );


	void Bisection( double (*f)(double),
			  		double s,				//   f֐̂Ƃ s > 0.0
					double c,				//   ɑ΂֐l
					double L_b, double U_b,	//   ̑݋Ԃ̉Ə
					double & Root,			//     f(Root) = c
					double acc );




//     Bisection@ɂ鍪̌vZ    

	void Bisection( double (*f)(double),
					double s,					 //   f֐̂Ƃ s > 0.0
					double c,					 //   ɑ΂֐l
					double L_b, double U_b,		 //   ̑݋Ԃ̉Ə
					double & Root,				 //     f(Root) = c
					double acc ){
		if ( (f(L_b) - c) * (f(U_b) - c) > 0.0 ){
			throw  gcnew Exception("Ɖ̑gݍ킹sK؂łB");
		}
		do {
			double m = 0.5 * (L_b + U_b);
			double v = f(m);
			if ( s * (v - c) > 0.0 ) {
				U_b = m;
			} else {
				L_b = m;
			}
		} while ( (Math::Abs(U_b - L_b) >= acc * Math::Abs(U_b))
					&&
				  ( (Math::Abs(U_b) + Math::Abs(L_b)) >= 1.0e-14)
				);
		Root = 0.5 * (L_b + U_b);
	}


//     Newton@ɂ鍪̌vZ   

	void Newton( double & x,				//  ̏lA߂l͍ f(x)=c
				 double c,					//  ֐l
				 double (*f)( double ),		//  ֐
				 double (*df)( double ),	//  ֐
				 double acc ){
		 int NStep = 0;
		 int ck = 0;
		 double x0;
		 do {
			 NStep++;
			 if (NStep > 20) {			//  20ȏJԂ̂Ƃ
				 ck = 1;
				 break;
			 };
			 x0 = x;
			 x = x0 + (c - f(x0)) / df(x0);
		 } while ( (Math::Abs(x - x0) >= (acc * (Math::Abs(x) + Math::Abs(x0))))
					 &&
					 ( (Math::Abs(x) + Math::Abs(x0)) >= 1.0e-14 ) 
			      );

		 if (ck == 0) return;

         //   Bisection@ŌvZ

		 double L_b = x;
		 do {
				L_b -= 1.0;
		 } while ( f(L_b) >= c );
		 double U_b = x;
		 do {
				U_b += 1.0;
		 } while ( f(U_b) <= c );
		 Bisection( f, 1.0, c, L_b, U_b, x, acc );
		 return;
	}
	
	double func( double x ) { return x * x; }

	double dfunc( double x ) { return 2.0 * x; }

	double dcalc_p_normal( double z ){
		double v = Math::Exp(-0.5 * z * z) / Math::Sqrt(2.0 * Math::PI);
		return v;
	}


	double calc_p_normal( double z ){
		double p = Cum_NormalKC( z );
		return p;
	}


	double calc_z_normal( double p ){
		double z = 0.0;
		Newton( z, p, calc_p_normal, dcalc_p_normal, 1.0e-12 );
		return z;
	}

}


#endif
