//    By Yasuharu Okamoto...Version 2008.11

#ifndef WHrn_CK
#define WHrn_CK


#include "mylib.h"

namespace MyLib {

using namespace System;

//    Wichmann/Hill generator...the period is of the order of 10 to the 12th power.
//    cf.  J.E.Gentle, 2003. 
//         "Random Number Generation and Monte Carlo Methods, 2nd ed."  Springer.
class WHrn {
public:
	unsigned __int32 x;
	unsigned __int32 y;
	unsigned __int32 z;
	double u;

	WHrn(): x(11111), y(22222), z(33333) {}
	virtual ~WHrn(){}

	WHrn(unsigned __int32 ix, unsigned __int32 iy, unsigned __int32 iz):
		x(ix), y(iy), z(iz) {}

	double uni();
};

class NormalRN: public WHrn {
public:
	NormalRN(){}
	virtual ~NormalRN(){}

	NormalRN(unsigned __int32 ix, unsigned __int32 iy, unsigned __int32 iz){
		x = ix;  y = iy;  z = iz;
	}		

	//        Standard Normal Distribution
	double NormalRN::normal();

    //        Normal Distribution of mean m  and standard deviation s
	double NormalRN::normalMS(double m, double s);

    //        A Pair of Independent Random Numbers of 
	//            the Standard Normal Distribution 
	void  NormalRN::normalPair( double & n1, double & n2 );

};


class RNGen: public NormalRN {
	public:
		RNGen(){}
		virtual ~RNGen(){}

		double ChiSqr( int df ){
			if ( df < 1 ) {
				throw gcnew Exception("invalid value for df...df = " + df.ToString());
			}

			double v = 0.0;
			for (int i = 0; i < df; i++)
				v += sqr( normal() );
			return v;
		}

};



//------------------  Definitions  -----------------------


double WHrn::uni(){
	do {
		x = (171 * x) % 30269;
		y = (172 * y) % 30307;
		z = (170 * z) % 30323;
		u = (x/30269.0) + (y/30307.0) + (z/30323.0);
		u = u - Math::Truncate(u);
	} while (u <= 0.0);
	return u;
}


   //        Standard Normal Distribution
	double NormalRN::normal(){
		double v1, v2, w;
		do {
    		v1 = 2.0 * uni() - 1.0;
			v2 = 2.0 * uni() - 1.0;
			w  = MyLib::sqr(v1) + MyLib::sqr(v2);
		} while (((w >= 1.0) || (w <= 0.0)));

		double c = Math::Sqrt(-2.0 * Math::Log(w)/w);

		return c * v1;
	}


    //    Normal Distribution of mean m  and standard deviation s
	double NormalRN::normalMS(double m, double s){
			double v = s * normal() + m;
			return  v;
	}


    //    A Pair of Independent Random Numbers of 
	//      the Standard Normal Distribution 
	void  NormalRN::normalPair( double & n1, double & n2 ){
			double v1, v2, w, c;
			do {
				  v1 = 2.0 * uni() - 1.0;
				  v2 = 2.0 * uni() - 1.0;
				  w  = MyLib::sqr(v1) + MyLib::sqr(v2);
			} while (((w >= 1.0) || (w <= 0.0)));

			c = Math::Sqrt(-2.0 * Math::Log(w) / w);

			n1 = c * v1;
			n2 = c * v2;
	}



}  //   End of namespace MyLib

#endif
