unit UCalcPowerF;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    ButtonClose: TButton;
    Label1: TLabel;
    EditN: TEdit;
    Label2: TLabel;
    EditA: TEdit;
    Label3: TLabel;
    EditF: TEdit;
    Label4: TLabel;
    EditFa: TEdit;
    ButtonCalc: TButton;
    Memo1: TMemo;
    LabelMsg: TLabel;
    procedure ButtonCloseClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ButtonCalcClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

uses UGenRNKISSCor200703;


const NSamples = 1000000;

var N, a, countG : integer;
    f, Lambda, mu, Fa : extended;

var RN : TNormalRN;


procedure TForm1.ButtonCalcClick(Sender: TObject);
var i, j, df1, df2 : integer;
    num, den : extended;
begin
  Memo1.Clear;
  a := StrToInt(EditA.Text);
  N := StrToInt(EditN.Text);
  f := StrToFloat(EditF.Text);
  Fa := StrToFloat(EditFa.Text);
  df1 := a-1;
  df2 := a*(N-1);
  Lambda := a*N*sqr(f);
  mu := sqrt(Lambda);
  with Memo1, Lines do
    begin
      Add('N = ' + IntToStr(N));
      Add('a = ' + IntToStr(a));
      Add('f = ' + FloatToStr(f));
      Add('Fa = ' + FloatToStr(Fa));
      Add('Lambda = ' + FloatToStrF(Lambda,ffGeneral,9,5));
      Add('vZł');
    end;

  RN := TNormalRN.Create;

  countG := 0;
  for i := 1 to NSamples do
    with RN do
      begin
        if (i mod 10000) = 0 then
          begin
         //   Form1.Caption := IntToStr(i) + '/'
         //                    + IntToStr(NSamples);
            LabelMsg.Caption := IntToStr(i) + '/'
                                + IntToStr(NSamples);
            UpDate;                  
          end;
        num := sqr(NRN(mu, 1.0));
        if df1 > 1 then num := num + Chi2(df1-1);
        den := Chi2( df2 );
        if Fa <= ((num/df1)/(den/df2))
          then countG := countG + 1;
      end;
  with Memo1, LInes do
    begin
      Add('vZI');
      Add(' ');
      Add('countG/NSamples = ' + IntToStr(countG) + '/'
                               + IntToStr(NSamples)
                               + ' = '
                               + FloatToStrF(countG/NSamples,ffGeneral,9,5));
      Add('P(F => Fa) = '+FloatToStrF(100.0*countG/NSamples,ffFixed,9,2)
                         +'%');
    end;

  RN.Free;
end;

procedure TForm1.ButtonCloseClick(Sender: TObject);
begin
                Close;
end;


procedure TForm1.FormCreate(Sender: TObject);
begin
  with Memo1 do
    begin
       Clear;
       with Lines do
         Add('lݒ肵āuvZv{^NbNĉB');
    end;
  LabelMsg.Caption := '';
end;

end.
