unit UCalcPowerT;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    ButtonClose: TButton;
    Label1: TLabel;
    EditM: TEdit;
    Label2: TLabel;
    EditN: TEdit;
    Label3: TLabel;
    EditD: TEdit;
    Label4: TLabel;
    EditTa: TEdit;
    ButtonCalc: TButton;
    Memo1: TMemo;
    LabelMsg: TLabel;
    procedure ButtonCloseClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ButtonCalcClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

uses UGenRNKISSCor200703;


const NSamples = 1000000;

var M, N, countG : integer;
    d, Delta, Ta : extended;

var RN : TNormalRN;


procedure TForm1.ButtonCalcClick(Sender: TObject);
var i, df : integer;
    num, den : extended;
begin
  Memo1.Clear;
  M := StrToInt(EditM.Text);
  N := StrToInt(EditN.Text);
  d := StrToFloat(EditD.Text);
  Ta := StrToFloat(EditTa.Text);
  df := M + N - 2;
  Delta := d/Sqrt((1/M) + (1/N));
  with Memo1, Lines do
    begin
      Add('M = ' + IntToStr(M));
      Add('N = ' + IntToStr(N));
      Add('d = ' + FloatToStr(d));
      Add('Ta = ' + FloatToStr(Ta));
      Add('df = ' + IntToStr(df));
      Add('Delta = ' + FloatToStrF(Delta,ffGeneral,9,5));
      Add('vZł');
    end;

  RN := TNormalRN.Create;

  countG := 0;
  for i := 1 to NSamples do
    with RN do
      begin
        if (i mod 10000) = 0 then
          begin
         //   Form1.Caption := IntToStr(i) + '/'
         //                    + IntToStr(NSamples);
            LabelMsg.Caption := IntToStr(i) + '/'
                                + IntToStr(NSamples);
            UpDate;                  
          end;
        num := NRN( Delta, 1.0 );
        den := sqrt(Chi2( df ) / df);
        if Ta <= (num/den)
          then countG := countG + 1;
      end;
  with Memo1, LInes do
    begin
      Add('vZI');
      Add(' ');
      Add('countG/NSamples = ' + IntToStr(countG) + '/'
                               + IntToStr(NSamples)
                               + ' = '
                               + FloatToStrF(countG/NSamples,ffGeneral,9,5));
      Add('P(t >= Ta) = '+FloatToStrF(100.0*countG/NSamples,ffFixed,9,2)
                         +'%');
    end;

  RN.Free;
end;

procedure TForm1.ButtonCloseClick(Sender: TObject);
begin
                Close;
end;


procedure TForm1.FormCreate(Sender: TObject);
begin
  with Memo1 do
    begin
       Clear;
       with Lines do
         Add('lݒ肵āuvZv{^NbNĉB');
    end;
  LabelMsg.Caption := '';
end;

end.
