unit UGenRNKISSCor200703;       //   By Yasuharu Okamoto, JWU,  2004.6


interface



(*   ̂߂̃IuWFNg  *)

//
//             The KISS Algorithm
//
//    See   C.P.Robert and G.Casella
//       "Monte Carlo Statistical Methods"
//           1999, Springer-Verlag
//                   Pp. 39-43.
//
type   TRNKiss   = class
                     protected
                       i, j, k : LongWord;

                     public  
                       //  葱
                       constructor Create; virtual;
                       procedure Init( i0, j0, k0 : Longint );

                       //  lԂ֐
                       function   Uni : Extended;
                   end;


(*   WK   *)
type   TNormalRN = class(TRNKiss)
                       //  WKԂ֐
                       function  Normal : Extended;

                       //  Q̓ƗȕWKԂ葱
                       procedure NormalP( var n1, n2 : Extended );

                       //  ֌Wr̂Q̕WK
                       procedure NormalCorP( var n1, n2 : Extended;
                                             r : Extended );

                       //   m : mean,  s : standard deviation
                       function NRN( m, s :extended ) : extended;

                       //   Chi-squared
                       function Chi2( df : integer ) : extended;
                   end;


//
//                 Indexed Search
//
//       B. D. Ripley, 1987, Stochastic Simulation
//                   Algorithm 3.11, p.72
//
type   TPoissonRN = class(TRNKiss)
                      m, Nm : integer;
                      qj : array of integer;
                      Pi : array of extended;

                      constructor Create( Lambda : extended ); virtual;
                      procedure Free;
                      function  Poisson : integer;
                    end;




implementation

uses SysUtils, Dialogs;
 

constructor TRNKiss.Create;
  begin
      inherited;

      i:=$95555555;
      j:=$56666666;
      k:=$39999999;
  end;


procedure TRNKiss.Init( i0, j0, k0 : Longint );
  begin
      i:=i0;  j:=j0;  k:=k0;
  end;


(*       0.0 <= Uni <= 1.0     *)

function  TRNKiss.Uni : Extended;
  var v : Longword;
  begin
        i:=69069*i+23606797;
        j:=j xor (j shL 17);
        j:=j xor (j shR 15);
        k:=(k xor (k shL 18)) and $7FFFFFFF;
        k:=(k xor (k shR 13));

        v:=i+j+k;
      try
        Uni:=v/$FFFFFFFF;
      except
        ShowMessage('v = '+IntToStr(v));
      end;
  end;


function TNormalRN.Normal : Extended;
  var  v1, v2, w, c : Extended;
  begin
        repeat
            v1:=2.0*Uni-1.0;
            v2:=2.0*Uni-1.0;
            w:=sqr(v1)+sqr(v2);
        until w < 1.0;

        c:=sqrt(-2.0*Ln(w)/w);

        Normal:=c*v1;
  end;


procedure TNormalRN.NormalP( var n1, n2 : Extended );
  var  v1, v2, w, c : Extended;
  begin
        repeat
            v1:=2.0*Uni-1.0;
            v2:=2.0*Uni-1.0;
            w:=sqr(v1)+sqr(v2);
        until (w < 1.0) and (w > 0.0);

        c:=sqrt(-2.0*Ln(w)/w);

        n1:=c*v1;  n2:=c*v2;
  end;


procedure TNormalRN.NormalCorP( var n1, n2 : Extended;
                                r : Extended );
var  v1, v2, w, c : Extended;
  begin
        repeat
            v1:=2.0*Uni-1.0;
            v2:=2.0*Uni-1.0;
            w:=sqr(v1)+sqr(v2);
        until w < 1.0;

        c:=sqrt(-2.0*Ln(w)/w);

        n1:=c*v1;  n2:=c*v2;
        n2 := r*n1 + sqrt(1-sqr(r))*n2;
  end;



function TNormalRN.NRN( m, s :extended ) : extended;
  begin
      NRN := s*Normal + m ;
  end;


function TNormalRN.Chi2( df : integer ) : extended;
  var v : extended;
      i : integer;
  begin
    v := sqr(Normal);
    if df > 1 then
      for i := 2 to df do
        v := v + sqr(Normal);

    Chi2 := v;    
  end;


constructor TPoissonRN.Create( Lambda :extended );
  var v, Lx, xfctr, expNLambda : extended;
      i, j : integer;
  begin
      inherited Create;

      v:=0.0; m:=0; Lx:=1.0; xfctr:=1.0;
      expNLambda:=exp(-Lambda);
      repeat
        v:=v+Lx*expNLambda/xfctr;
        m:=m+1;
        Lx:=Lx*Lambda;
        xfctr:=xfctr*m;
      until (m <= 0) or (1.0 < (v+1.0e-9));

  //    ShowMessage('m = '+IntToStr(m-1));

      if m <= 0 then raise exception.Create('TPoisson.Create failded.');

      m:=m-1;
      SetLength(Pi, m+2);
      Nm:=100;
      SetLength(qj, Nm);

      v:=0.0; i:=0; Lx:=1.0; xfctr:=1.0;
      repeat
        v:=v+Lx*expNLambda/xfctr;
        Pi[i]:=v;
        i:=i+1;
        Lx:=Lx*Lambda;
        xfctr:=xfctr*i;
      until (i > m);
      Pi[m+1]:=2.0;

      qj[0]:=0;
      j:=1;
      repeat
        i:=qj[j-1];
        while Pi[i] < (j/Nm) do i:=i+1;
        qj[j]:=i;
        j:=j+1;
      until j > (Nm-1);
  end;


procedure TPoissonRN.Free;
  begin
      Finalize(Pi);
      Finalize(qj);

      inherited;
  end;


function  TPoissonRN.Poisson : integer;
  var U : extended;
      k, i : integer;
  begin
      U:=Uni;
      k:=trunc(Nm*U);
      if k >= Nm then k:=Nm-1;
      i:=qj[k];
      while Pi[i] < U do i:=i+1;
      Poisson:=i;
  end;

end.
 