unit U1VarDescri;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, StdCtrls;

type
  TMainForm = class(TForm)
    StringGrid1: TStringGrid;
    AddButton: TButton;
    ExitButton: TButton;
    DelButton: TButton;
    CalcButton: TButton;
    SaveButton: TButton;
    LoadButton: TButton;
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    PButton: TButton;
    GrfButton: TButton;
    PrintDialog1: TPrintDialog;
    procedure ExitButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure AddButtonClick(Sender: TObject);
    procedure DelButtonClick(Sender: TObject);
    procedure CalcButtonClick(Sender: TObject);
    procedure SaveButtonClick(Sender: TObject);
    procedure LoadButtonClick(Sender: TObject);
    procedure PButtonClick(Sender: TObject);
    procedure GrfButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

uses  Printers, UBarGraph;

procedure TMainForm.ExitButtonClick(Sender: TObject);
begin
           Close;
end;


procedure TMainForm.FormCreate(Sender: TObject);
var sel : TGridRect;      //  IZ̈ʒu\킷߂̌^
begin
    with StringGrid1 do
      begin
          ColCount:=2;                  //  
          ColWidths[1]:=2*ColWidths[0]; //  ̕
          Width:=3*ColWidths[0]+10;
          RowCount:=2;                  //  s
          Font.Height:=16;
          Cells[0,1]:='1Ԗ';
          Cells[1,0]:='f[^ =';
          Options:=Options-[goRangeSelect];  //  PZ̑I
          with sel do                        //  Z̈ʒu
            begin  Left:=1; Top:=1; Right:=1; Bottom:=1;  end;
          Selection:=sel;                    //  IZ̐ݒ
          Options:=[goEditing]+Options;      //  ZҏW
          EditorMode:=true;                  //  ZҏW
      end;
end;


(*           s̒ǉ          *)
procedure TMainForm.AddButtonClick(Sender: TObject);
var   i, pos : Longint;
begin
      with StringGrid1 do
        begin
            pos:=Selection.top;
            RowCount:=RowCount+1;
            Cells[0,RowCount-1]:=IntToStr(RowCount-1)+'Ԗ';
            Cells[1,RowCount-1]:=' ';
            if (0 < pos) and (pos < RowCount-2) then
              begin
                for i:=RowCount-1 downto pos+2 do
                  Cells[1,i]:=Cells[1,i-1];
                Cells[1,pos+1]:=' ';
              end;
        end;
end;

(*          s̍폜           *)
procedure TMainForm.DelButtonClick(Sender: TObject);
var pos, i : Longint;
begin
    with StringGrid1 do
      begin
        pos:= Selection.top;     //  Is̐ݒ

        //   Z̒l̈ړ
        if (0 < pos) and (pos < RowCount-1) then
            for i:=pos to RowCount-2 do
              Cells[1,i]:=Cells[1,i+1];

           //   Ō̍s폜
        if 0 < pos then
          if RowCount > 2 then RowCount:=RowCount-1;
      end;
end;


procedure TMainForm.CalcButtonClick(Sender: TObject);
var      mean, s, v, sd, u_v, u_sd,
         s3, s4, g1, g2, z : Extended;
         x  : array[1..1000] of Extended;
         outf  : TextFile;
var      min_x, max_x, median, q1, q3 : Extended;
         n, i, j, k  : Longint;

  procedure  calc_quartile( var  q1, q3 : Extended );
    var      i, j : Longint;
             w1, w2, v1, v2 : Extended;
    begin
      i:=trunc( 0.5 + n/4 );
      w1 := 0.5 + n/4 - i;  w2 := 1.0 - w1;
      q1 := w2 * x[i] + w1 * x[i+1];

      j := trunc( 0.5 + 3*n/4 );
      v1 := 0.5 + 3*n/4 - j;  v2 := 1.0 - v1;
      q3 := v2 * x[j] + v1 * x[j+1];
    end;


begin

     with StringGrid1 do
       begin
         n:=RowCount-1;   //   f[^̐ݒ
         try
           for i:=1 to n do
             begin
               x[i]:=StrToFloat(Cells[1,i]);  //   f[^z֐ݒ
             end;
         except                             //   sȃf[^
           ShowMessage('Error ===>  Cells[1,'+IntToStr(i)+'] = '
                        +Cells[1,i]);
           Exit;   //   ̎葱̏I
         end;
       end;

     with OpenDialog1 do
       begin
         Title:='vZʂ̏o͗pt@C';
         FileName:='';
         if not Execute then exit;
         AssignFile(outf,FileName);
         Rewrite(outf);
       end;



     (*      f[^̏o       *)

     writeln(outf);
     writeln(outf, '̓f[^...');
     for i:=1 to n do
       writeln(outf, 'x[', i, '] = ', x[i]:9:2);

     (*      ϒlmeaňvZ          *)

     s := 0.0;                     //     s0ɏ
     for i := 1 to n do
                   s := s + x[i];  //     sɃf[^x[i]̘a߂
     mean := s / n ;

     (*     UEW΍̌vZ         *)

     s := 0.0;                      //  s̏
     for i := 1 to n do
       s := s + sqr( x[i] - mean ); //  sx[i]-mean̂Qa߂
     v  := s / n ;                  //  U߂
     sd := sqrt( v );               //  W΍߂
     u_v  := s / (n-1);             //  sΕU߂
     u_sd := sqrt(u_v);             //  sΕUW΍߂

     (*     cxƐx̌vZ       *)

     s3 := 0.0;
     s4 := 0.0;
     for i := 1 to n do
       begin
           z  := (x[i] - mean) / sd ;  //  zϊ
           s3 := s3 + z * sqr(z) ;     //  Ra
           s4 := s4 + sqr(sqr(z)) ;    //  Sa
       end;
     g1 := s3 / n ;       //  cx
     g2 := s4 / n ;       //  x

     writeln(outf);
     writeln(outf);
     writeln(outf, 'ϒl           = ', FloatToStrF(mean,ffGeneral,9,1));
     writeln(outf);
     writeln(outf, 'W΍         = ', FloatToStrF(sd,ffGeneral,9,1));
     writeln(outf);
     writeln(outf, 'U             = ', FloatToStrF(v,ffGeneral,9,1));
     writeln(outf);
     writeln(outf, 'sΕU̕ = ', FloatToStrF(u_sd,ffGeneral,9,1));
     writeln(outf);
     writeln(outf, 'sΕU         = ', FloatToStrF(u_v,ffGeneral,9,1));
     writeln(outf);
     writeln(outf, 'cx             = ', FloatToStrF(g1,ffGeneral,9,1));
     writeln(outf);
     writeln(outf, 'x             = ', FloatToStrF(g2,ffGeneral,9,1));


        (*      P\[g     *)

     for i := 1 to n-1 do
       begin
             k := i ;
             for j := i+1 to n do
               if x[k] > x[j]  then k := j;
             if i < k then
               begin
                     v := x[i];  x[i] := x[k];  x[k] := v;
               end;
       end;

     writeln(outf);
     writeln(outf);
     writeln(outf, 'ׂ̃f[^...');
     writeln(outf);
     for i:=1 to n do
       writeln(outf, 'x[', i, '] = ', x[i]:9:2);

     min_x := x[1];  max_x := x[n];

     if odd(n)  then median := x[ (n div 2) + 1 ]
                else median := 0.5 * (x[n div 2] + x[(n div 2) + 1]);

     calc_quartile( q1, q3 );

     writeln(outf);
     writeln(outf);
     writeln(outf, 'ŏl     = ', FloatToStrF(min_x,ffGeneral,9,1));
     writeln(outf);
     writeln(outf, 'Q1         = ', FloatToStrF(q1,ffGeneral,9,1));
     writeln(outf);
     writeln(outf, 'l     = ', FloatToStrF(median,ffGeneral,9,1));
     writeln(outf);
     writeln(outf, 'Q3         = ', FloatToStrF(q3,ffGeneral,9,1));
     writeln(outf);
     writeln(outf, 'ől     = ', FloatToStrF(max_x,ffGeneral,9,1));
     writeln(outf);
     writeln(outf);
     writeln(outf,'lʕ΍ = ',  FloatToStrF((q3-q1)/2,ffGeneral,9,1));

     CloseFile(outf);

     ExitButton.SetFocus;
end;


(*    Obhɐݒ肳Ăf[^̕ۑ    *)
procedure TMainForm.SaveButtonClick(Sender: TObject);
var outf : TextFile;
    i : Longint;
begin
    with SaveDialog1 do        //   ۑpt@C̖O̐ݒ
      begin
          Title:='t@C';
          FileName:='';
          if not Execute then exit;
          AssignFile(outf,FileName);
      end;

    Rewrite(outf);             //  t@Copɐݒ

    with StringGrid1 do
      begin
        writeln(outf,RowCount-1);          //  f[^̏o
        for i:=1 to RowCount-1 do
          writeln(outf, Trim(Cells[1,i])); //  f[^̏o
      end;

    CloseFile(outf);
end;

(*    t@CObhփf[^ǂݍ    *)
procedure TMainForm.LoadButtonClick(Sender: TObject);
var inf : TextFile;
    v, i   : Longint;
    s      : string;
begin
    with OpenDialog1 do           //  t@C̐ݒ
      begin
          Title:='t@C';
          FileName:='';
          if not Execute then exit;
          AssignFile(inf,FileName);
      end;

    Reset(inf);                  //   t@Cǂݏopɐݒ

    with StringGrid1 do
      begin
        readln(inf,v);          //   f[^̓ǂݍ
        RowCount:=v+1;
        for i:=1 to RowCount-1 do
          begin
            Cells[0,i]:=IntToStr(i)+'Ԗ';
            readln(inf,s);     //    f[^̓ǂݍ
            Cells[1,i]:=s;
          end;
      end;

    CloseFile(inf);
    CalcButton.SetFocus;
end;

procedure TMainForm.PButtonClick(Sender: TObject);
var   pout : TextFile;
      i    : Longint;
begin

      PrintDialog1.Execute;

      with printer do
        begin
          AssignPrn(pout);
          Rewrite(pout);

          with Canvas.Font do
            begin
                Name:='lr ';
                size:=16;
            end;

          writeln(pout);
          writeln(pout);
          writeln(pout,'Data =');

          with StringGrid1 do
            for i:=1 to RowCount-1 do
              writeln(pout,i:5,'   ',Cells[1,i]);

          CloseFile(pout);
        end;
end;

procedure TMainForm.GrfButtonClick(Sender: TObject);
begin
      GraphForm:=TGraphForm.Create(Self);
      with GraphForm do
        begin
          Visible:=true;
          PButton.Enabled:=false;
        end;         
end;

end.