unit UBarGraph;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TGraphForm = class(TForm)
    OKButton: TButton;
    ExitButton: TButton;
    Label3: TLabel;
    WEdit: TEdit;
    Label4: TLabel;
    BndryEdit: TEdit;
    MsgLabel: TLabel;
    PButton: TButton;
    Image1: TImage;
    OpenDialog1: TOpenDialog;
    PrintDialog1: TPrintDialog;
    procedure ExitButtonClick(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure PButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  GraphForm: TGraphForm;

implementation

{$R *.DFM}

uses  Printers, U1VarDescri;

procedure TGraphForm.ExitButtonClick(Sender: TObject);
begin
            Close;
end;

procedure TGraphForm.OKButtonClick(Sender: TObject);
var   n_cat, n, n_max, i, x0, x1, y0, y1,
      gx0, gx1, gxh, gh, txtw,
      g_max, HY, WFigure, HFigure, NFigures, HdFigure : Longint;
      c, x_min, x_max, gw_cat, Width_cat : Extended;
      s1, s2 : string;
      in_fl, out_fl : TextFile;
      x : array[1..1000] of Extended;
      cat : array[1..100] of Longint;
      iboundary : array[0..100] of Extended;

  function cat_id( a : Extended ) : Longint;  //  ãJeS[l
    var   c : Longint;
    begin
          c:=1;
          while (a >= iboundary[c]) and (c < n_cat) do c:=c+1;
          cat_id:=c;
    end;


  procedure count( var i : Longint );
    begin
            i := i + 1 ;
    end;


begin   {    OKButtonClick    }
      MsgLabel.Caption:='';
      WindowState:=wsMaximized;     //  tH[̍ő剻
      UpDate;

      with ExitButton do
        begin  Top:=0; Left:=0;  end;
      with PButton do
        begin  Top:=0; Left:=ExitButton.Width; end;
      with OKButton do
        begin  Top:=0; Left:=PButton.Left+PButton.Width; end;
      with Label3 do
        begin
          Top:=2;
          Left:=OKButton.Left+2*OKButton.Width;
        end;
      with WEdit do
        begin
          Top:=0;
          Left:=Label3.Left+Label3.Width+(ExitButton.Width div 10);
        end;
      with Label4 do
        begin
          Top:=2;
          Left:=WEdit.Left+WEdit.Width+ExitButton.Width;
        end;
      with BndryEdit do
        begin
          Top:=0;
          Left:=Label4.Left+Label3.Width+(ExitButton.Width div 10);
        end;
      with Image1 do
        begin
          Top:=ExitButton.Height;
          Left:=0;
          Width:=GraphForm.ClientWidth;
          Height:=GraphForm.ClientHeight-Top;
        end;

      UpDate;

       (*   Canvas𔒂œhԂ   *)

      with Image1.Canvas do
        begin
          Pen.Color:=clWhite;
          Brush.Color:=clWhite;
          Rectangle(0, 0, ClientWidth, ClientHeight);
        end;

      Width_cat:=StrToFloat(WEdit.Text);    //  JeS[̕

      with MainForm.StringGrid1 do
        begin
          n:=RowCount-1;   //   f[^̐ݒ
          try
            for i:=1 to n do
              begin
                x[i]:=StrToFloat(Cells[1,i]);  //   f[^z֐ݒ
              end;
          except                             //   sȃf[^
            ShowMessage('Error ===>  Cells[1,'+IntToStr(i)+'] = '
                         +Cells[1,i]);
            Exit;   //   ̎葱̏I
          end;
        end;


      x_min:=x[1]; x_max:=x[1];           //  f[^̍őlƍŏl߂
      for i:=1 to n do
        begin
            if x_min > x[i] then x_min:=x[i];
            if x_max < x[i] then x_max:=x[i];
        end;

      iboundary[0]:=StrToFloat(BndryEdit.Text);
      while x_min <= iboundary[0] do
         iboundary[0]:=iboundary[0]-Width_cat;

      n_cat:=0;
      while iboundary[n_cat] <= x_max do
        begin
            n_cat:=n_cat+1;
            iboundary[n_cat]:=iboundary[n_cat-1]+Width_cat;
        end;

      for i:=1 to n_cat do cat[i]:=0;
      for i:=1 to n do count( cat[cat_id(x[i])] ); //  JeS[ʂ̓x̌vZ
      n_max:=0;
      for i:=1 to n_cat do
        if n_max < cat[i] then n_max:=cat[i];


   (*  Ot̊Og̐ݒ (x0,y0)A(x1,y1)E   *)

      x0:=round(0.1*Image1.Width);
      x1:=round(0.9*Image1.Width);
      y0:=round(0.1*Image1.Height);
      y1:=round(0.8*Image1.Height);

      NFigures:=Trunc(ln(n_max)/ln(10.0))+1;
      HdFigure:=n_max div round(exp((NFigures-1)*ln(10.0)));

      with Image1.Canvas do
        begin
          Pen.Width:=2;
          Pen.Color:=clBlack;
          Brush.Color:=clWhite;
          Rectangle(x0, y0, x1, y1);       //  Ot̊Og̕`

          Font.Height:=round(0.05*(y1-y0));  //  TextOut̑̕傫
          TextOut(x0, round(0.5*y0),
                  'őx = '+IntToStr(n_max) );

          case HdFigure of
               1    : begin
                         g_max:=round(exp((NFigures-1)*ln(10.0)));
                         HY   :=round(0.9*(y1-y0)/2);
                         WFigure:=TextWidth('9');
                         HFigure:=TextHeight(IntToStr(g_max));
                         for i:=1 to 2 do
                           begin
                               MoveTo(x0, y1-i*HY);
                               LineTo(x0+round(0.02*(x1-x0)), y1-i*HY);
                               TextOut(x0-(NFigures+2)*WFigure,
                                       y1-i*HY-HFigure,
                                       IntToStr(i*g_max));
                           end;

                         g_max:=2*g_max;
                      end;
               2    : begin
                         g_max:=round(exp((NFigures-1)*ln(10.0)));
                         HY   :=round(0.9*(y1-y0)/3);
                         WFigure:=TextWidth('9');
                         HFigure:=TextHeight(IntToStr(g_max));
                         for i:=1 to 3 do
                           begin
                               MoveTo(x0, y1-i*HY);
                               LineTo(x0+round(0.02*(x1-x0)), y1-i*HY);
                               TextOut(x0-(NFigures+2)*WFigure,
                                       y1-i*HY-HFigure,
                                       IntToStr(i*g_max));
                           end;

                         g_max:=3*g_max;
                      end;
               3, 4 : begin
                         g_max:=round(exp((NFigures-1)*ln(10.0)));
                         HY   :=round(0.9*(y1-y0)/5);
                         WFigure:=TextWidth('9');
                         HFigure:=TextHeight(IntToStr(g_max));
                         for i:=1 to 5 do
                           begin
                               MoveTo(x0, y1-i*HY);
                               LineTo(x0+round(0.02*(x1-x0)), y1-i*HY);
                               TextOut(x0-(NFigures+2)*WFigure,
                                       y1-i*HY-HFigure,
                                       IntToStr(i*g_max));
                           end;

                         g_max:=5*g_max;
                      end;
               else   begin
                         g_max:=round(exp((NFigures-1)*ln(10.0)));
                         HY   :=round(0.9*(y1-y0)/10);
                         WFigure:=TextWidth('9');
                         HFigure:=TextHeight(IntToStr(g_max));
                         for i:=1 to 10 do
                           begin
                               MoveTo(x0, y1-i*HY);
                               LineTo(x0+round(0.02*(x1-x0)), y1-i*HY);
                               if i < 10 then
                                 TextOut(x0-(NFigures+2)*WFigure,
                                         y1-i*HY-HFigure,
                                         IntToStr(i*g_max))
                               else
                                 TextOut(x0-(NFigures+3)*WFigure,
                                         y1-i*HY-HFigure,
                                         IntToStr(i*g_max));
                           end;

                         g_max:=10*g_max;
                      end;
          end;

          Pen.Width:=1;
          gw_cat:=(x1-x0)/n_cat;            //  OtɂJeS[̕
          for i:=1 to n_cat do
            begin
                Brush.Color:=clBlue;
                gx0:=round(x0+(i-1)*gw_cat); //  _Ot̍[̈ʒu
                gx1:=round(gx0+gw_cat);             //  _Ot̉E[̈ʒu
                gh :=round(0.9*(y1-y0)*cat[i]/g_max);  //  _Ot̍
                Rectangle( gx0, y1-gh, gx1, y1 );

                s1:=FloatToStrF(iboundary[i-1],ffGeneral,7,1);
                                                    //  JeS[̉l

                s2:=FloatToStrF(iboundary[i],ffGeneral,7,1);
                                                    //  JeS[̏l
                Brush.Style:=bsClear;
                gxh:=(gx0+gx1) div 2;
                txtw:=TextWidth(s1);
                TextOut(gxh-(txtw div 2), round(y1*1.02), s1);
                txtw:=TextWidth('|');
                TextOut(gxh-(txtw div 2), round(y1*1.07), '|');
                txtw:=TextWidth(s2);
                TextOut(gxh-(txtw div 2), round(y1*1.12), s2);
            end;
        end;

      ExitButton.SetFocus;
      PButton.Enabled:=true;
end;    {    OKButtonClick    }

procedure TGraphForm.FormActivate(Sender: TObject);
begin
           WEdit.Text:='5';
           BndryEdit.Text:='0';
           MsgLabel.Caption:='Ԋu̒l'
                             +'Elݒ肵ĉ';
end;

procedure TGraphForm.PButtonClick(Sender: TObject);
var   n_cat, n, n_max, i, x0, x1, y0, y1,
      gx0, gx1, gxh, gh, txtw,
      g_max, HY, WFigure, HFigure, NFigures, HdFigure : Longint;
      c, x_min, x_max, gw_cat, Width_cat : Extended;
      s1, s2 : string;
      in_fl, out_fl : TextFile;
      x : array[1..1000] of Extended;
      cat : array[1..100] of Longint;
      iboundary   : array[0..100] of Extended;
      POrient     : TPrinterOrientation;
      dstr        : string;
      tempf, pout, inf : TextFile;

  function cat_id( a : Extended ) : Longint;  //  ãJeS[l
    var   c : Longint;
    begin
          c:=1;
          while (a >= iboundary[c]) and (c < n_cat) do c:=c+1;
          cat_id:=c;
    end;


  procedure count( var i : Longint );
    begin
            i := i + 1 ;
    end;


begin   {    PButtonClick    }

      with PButton do
        begin
          Caption:='';
          Enabled:=false;
        end;
      Update;

      PrintDialog1.Execute;

      with OpenDialog1 do
        begin
          Title:='Ɨpꎞt@C';
          FileName:='';
          if not Execute then
            begin
              PButton.Enabled:=true;
              exit;
            end;
          AssignFile(tempf,FileName);
          Rewrite(tempf);
        end;

      Width_cat:=StrToFloat(WEdit.Text);    //  JeS[̕

      with MainForm.StringGrid1 do
        begin
          n:=RowCount-1;   //   f[^̐ݒ
          try
            for i:=1 to n do
              begin
                x[i]:=StrToFloat(Cells[1,i]);  //   f[^z֐ݒ
              end;
          except                             //   sȃf[^
            ShowMessage('Error ===>  Cells[1,'+IntToStr(i)+'] = '
                         +Cells[1,i]);
            Exit;   //   ̎葱̏I
          end;
        end;


      x_min:=x[1]; x_max:=x[1];           //  f[^̍őlƍŏl߂
      for i:=1 to n do
        begin
            if x_min > x[i] then x_min:=x[i];
            if x_max < x[i] then x_max:=x[i];
        end;

      iboundary[0]:=StrToFloat(BndryEdit.Text);
      while x_min <= iboundary[0] do
         iboundary[0]:=iboundary[0]-Width_cat;

      n_cat:=0;
      while iboundary[n_cat] <= x_max do
        begin
            n_cat:=n_cat+1;
            iboundary[n_cat]:=iboundary[n_cat-1]+Width_cat;
        end;

      for i:=1 to n_cat do cat[i]:=0;
      for i:=1 to n do count( cat[cat_id(x[i])] ); //  JeS[ʂ̓x̌vZ
      n_max:=0;
      for i:=1 to n_cat do
        if n_max < cat[i] then n_max:=cat[i];

      with Printer do
        begin
          POrient:=Orientation;
          Orientation:=poLandscape;
        end;

      with Printer do
        begin
          BeginDoc;

       (*  Ot̊Og̐ݒ (x0,y0)A(x1,y1)E   *)

          x0:=round(0.1*PageWidth);
          x1:=round(0.9*PageWidth);
          y0:=round(0.1*PageHeight);
          y1:=round(0.8*PageHeight);

          writeln(tempf);
          writeln(tempf);
          writeln(tempf, 'K@@@@x');

          NFigures:=Trunc(ln(n_max)/ln(10.0))+1;
          HdFigure:=n_max div round(exp((NFigures-1)*ln(10.0)));

          with Canvas do
            begin
              Pen.Width:=2;
              Pen.Color:=clBlack;
              Brush.Color:=clWhite;
              Rectangle(x0, y0, x1, y1);       //  Ot̊Og̕`

              Font.Height:=round(0.05*(y1-y0));  //  TextOut̑̕傫
              TextOut(x0, round(0.5*y0),
                      'őx = '+IntToStr(n_max) );

              case HdFigure of
                   1    : begin
                             g_max:=round(exp((NFigures-1)*ln(10.0)));
                             HY   :=round(0.9*(y1-y0)/2);
                             WFigure:=TextWidth('9');
                             HFigure:=TextHeight(IntToStr(g_max));
                             for i:=1 to 2 do
                               begin
                                   MoveTo(x0, y1-i*HY);
                                   LineTo(x0+round(0.02*(x1-x0)), y1-i*HY);
                                   TextOut(x0-(NFigures+2)*WFigure,
                                           y1-i*HY-HFigure,
                                           IntToStr(i*g_max));
                               end;

                             g_max:=2*g_max;
                          end;
                   2    : begin
                             g_max:=round(exp((NFigures-1)*ln(10.0)));
                             HY   :=round(0.9*(y1-y0)/3);
                             WFigure:=TextWidth('9');
                             HFigure:=TextHeight(IntToStr(g_max));
                             for i:=1 to 3 do
                               begin
                                   MoveTo(x0, y1-i*HY);
                                   LineTo(x0+round(0.02*(x1-x0)), y1-i*HY);
                                   TextOut(x0-(NFigures+2)*WFigure,
                                           y1-i*HY-HFigure,
                                           IntToStr(i*g_max));
                               end;

                             g_max:=3*g_max;
                          end;
                   3, 4 : begin
                             g_max:=round(exp((NFigures-1)*ln(10.0)));
                             HY   :=round(0.9*(y1-y0)/5);
                             WFigure:=TextWidth('9');
                             HFigure:=TextHeight(IntToStr(g_max));
                             for i:=1 to 5 do
                               begin
                                   MoveTo(x0, y1-i*HY);
                                   LineTo(x0+round(0.02*(x1-x0)), y1-i*HY);
                                   TextOut(x0-(NFigures+2)*WFigure,
                                           y1-i*HY-HFigure,
                                           IntToStr(i*g_max));
                               end;

                             g_max:=5*g_max;
                          end;
                   else   begin
                             g_max:=round(exp((NFigures-1)*ln(10.0)));
                             HY   :=round(0.9*(y1-y0)/10);
                             WFigure:=TextWidth('9');
                             HFigure:=TextHeight(IntToStr(g_max));
                             for i:=1 to 10 do
                               begin
                                   MoveTo(x0, y1-i*HY);
                                   LineTo(x0+round(0.02*(x1-x0)), y1-i*HY);
                                   if i < 10 then
                                     TextOut(x0-(NFigures+2)*WFigure,
                                             y1-i*HY-HFigure,
                                             IntToStr(i*g_max))
                                   else
                                     TextOut(x0-(NFigures+3)*WFigure,
                                             y1-i*HY-HFigure,
                                             IntToStr(i*g_max));
                               end;

                             g_max:=10*g_max;
                          end;
              end;

              Pen.Width:=1;
              gw_cat:=(x1-x0)/n_cat;            //  OtɂJeS[̕
              for i:=1 to n_cat do
                begin
                    Brush.Color := clBlue;
                    gx0:=round(x0+(i-1)*gw_cat); //  _Ot̍[̈ʒu
                    gx1:=round(gx0+gw_cat);             //  _Ot̉E[̈ʒu
                    gh :=round(0.9*(y1-y0)*cat[i]/g_max);  //  _Ot̍
                    Rectangle( gx0, y1-gh, gx1, y1 );

                    s1:=FloatToStrF(iboundary[i-1],ffGeneral,7,1);
                                                    //  JeS[̉l

                    s2:=FloatToStrF(iboundary[i],ffGeneral,7,1);
                                                    //  JeS[̏l
                    Brush.Style:=bsClear;
                    gxh:=(gx0+gx1) div 2;
                    txtw:=TextWidth(s1);
                    TextOut(gxh-(txtw div 2), round(y1*1.02), s1);
                    txtw:=TextWidth('|');
                    TextOut(gxh-(txtw div 2), round(y1*1.07), '|');
                    txtw:=TextWidth(s2);
                    TextOut(gxh-(txtw div 2), round(y1*1.12), s2);

                    writeln(tempf);
                    writeln(tempf, s1+' - '+s2+'  ==>  ', cat[i]);
                end;
            end;

          CloseFile(tempf);

          EndDoc;
        end;

      with Printer do
        begin
          Orientation:=POrient;
          with Canvas.Font do
            begin
              Size:=15;
              Name:='lr SVbN';
            end;  
        end;

      AssignPrn(pout); Rewrite(pout);
      AssignFile(inf,OpenDialog1.FileName);
      Reset(inf);

      repeat
             readln(inf, dstr);
             writeln(pout, dstr);
      until eof(inf);
      CloseFile(inf);
      CloseFile(pout);
      AssignFile(inf,OpenDialog1.FileName);
      Erase(inf);

      with PButton do
        begin
          Caption:=' ';
          Enabled:=true;
        end;
end;     {   PButtonClick   }

end.