unit UCheckCor;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    GOButton: TButton;
    ExitButton: TButton;
    ClearButton: TButton;
    RdButton: TButton;
    WrButton: TButton;
    CalcButton: TButton;
    Label1: TLabel;
    OpenDialog1: TOpenDialog;
    PrintButton: TButton;
    PrintDialog1: TPrintDialog;
    procedure FormCreate(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure GOButtonClick(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure WrButtonClick(Sender: TObject);
    procedure RdButtonClick(Sender: TObject);
    procedure ClearButtonClick(Sender: TObject);
    procedure CalcButtonClick(Sender: TObject);
    procedure PrintButtonClick(Sender: TObject);
    procedure FormPaint(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses Printers;

type
  TData = array[1..1000] of Longint;

var
  x0, y0,                //  (x0,y0)Fʂ̒
  w,                     //  2*wFg̑傫
  XLeft, XRight, YTop, YBottom : Longint;
  DataX, DataY : TData;
  NData : Longint;

//   (NbN̈ʒu) [[> 0 <= ScaleX <= 100
function ScaleX( x : Longint ) : Longint;
  begin
        ScaleX:=Trunc( 100.0*(x-XLeft)/(XRight-XLeft) );
  end;

//  0 <= x <= 100  [[> XLeft <= CPosX <= XRight
function CPosX( x : Longint ) : Longint;
  begin
        CPosX := Round( XLeft + x*(XRight-XLeft)/100 );
  end;

//   (NbN̈ʒu) -->  0 <= ScaleY <= 100
function ScaleY( y : Longint ) : Longint;
  begin
        ScaleY:=Trunc( 100.0*(-(y-YBottom)/(YBottom-YTop)) );
  end;

//   0 <= y <= 100  [[>  YBottom >= CPosY >= YTop
function CPosY( y : Longint ) : Longint;
  begin
        CPosY := Round( YBottom - y*(YBottom-YTop)/100 );
  end;

procedure TForm1.ExitButtonClick(Sender: TObject);
begin
            Close;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
    ExitButton.Enabled:=false;
    ClearButton.Enabled:=false;
    RdButton.Enabled:=false;
    WrButton.Enabled:=false;
    CalcButton.Enabled:=false;
    PrintButton.Enabled:=false;
end;


procedure TForm1.GOButtonClick(Sender: TObject);
begin
    //   tH[̏
    WindowState:=wsMaximized; UpDate;
    Label1.Visible:=false;
    GOButton.Visible:=false;
    ExitButton.Enabled:=true;
    ClearButton.Enabled:=true;
    RdButton.Enabled:=true;
    WrButton.Enabled:=true;
    CalcButton.Enabled:=true;
    PrintButton.Enabled:=true;
    UpDate;

    //    `̏
    with Canvas do
      begin
        with Pen do
          begin Width:=1; Color:=clWhite; end;
        with Brush do
          begin Style:=bsSolid; Color:=clWhite; end;
        Rectangle(0,0,ClientWidth,ClientHeight);

        //  S(x0,y0)̐ݒ
        x0:=ClientWidth div 2;
        y0:=ClientHeight div 2;

        //  g̐ݒ
        if y0 < x0 then w:=round(0.8*y0)
                   else w:=round(0.8*x0);
        XLeft:=x0-w;
        YTop :=y0-w;
        XRight:=x0+w;
        YBottom:=y0+w;
        Pen.Color:=clBlack;
        Rectangle(XLeft,YTop,XRight,YBottom);
        NData:=0;
      end;
end;

//  Fclŏ~hׂ
procedure Circle( x, y : Longint;
                    cl   : TColor );
    begin
        with Form1.Canvas do
          begin
            with Pen do
              begin  Width:=1; Color:=cl;  end;
            with Brush do
              begin  Style:=bsSolid; Color:=cl;  end;

            Ellipse(x-2,y-2,x+2,y+2);
          end;
    end;

//   ~̕`Ə
procedure TForm1.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
Label QP;
var   i, ipos, PosX, PosY : Longint;
      ck : Boolean;

  //   ɐݒ肳ꂽ_ł邩H
  procedure CheckData( i : Longint );
    begin
        if (PosX = DataX[i]) and (PosY = DataY[i])
          then ck:=true;
    end;

begin
    case Button of
         mbLeft  : begin              //  _̐ݒ
                     PosX:=ScaleX(X);
                     PosY:=ScaleY(Y);
                     if (PosX < 0) or (PosX > 100) or
                        (PosY < 0) or (PosY > 100) then goto QP; 
                     if NData > 0 then
                       begin
                         ck:=false;
                         for i:=1 to NData do
                           CheckData( i );
                         if ck then goto QP;
                       end;
                     NData:=NData+1;
                     DataX[NData]:=PosX;
                     DataY[NData]:=PosY;
                     Circle( CPosX(PosX), CPosY(PosY), clBlue );
                   end;
         mbRight : begin               //  _̏
                     PosX:=ScaleX(X);
                     PosY:=ScaleY(Y);
                     if NData > 0 then
                       begin
                         ipos:=0;
                         for i:=1 to Ndata do
                           if (abs(DataX[i] - PosX) < 2)
                             and
                              (abs(DataY[i] - PosY) < 2)
                             then ipos:=i;
                         if ipos > 0 then
                           begin
                             PosX:=DataX[ipos];
                             PosY:=DataY[ipos];
                             Circle( CPosX(PosX), CPosY(PosY), clWhite );
                             if ipos < NData then
                               for i:=ipos to NData-1 do
                               begin
                                 DataX[i]:=DataX[i+1];
                                 DataY[i]:=DataY[i+1];
                               end;
                              NData:=NData-1; 
                           end;
                       end;
                   end;
         else    ;       //  
    end;

  QP : ;
end;

//   ݒ肳ꂽf[^i_̕zuj̕ۑ
procedure TForm1.WrButtonClick(Sender: TObject);
var
  outf : TextFile;
  i    : Longint;
begin
    with OpenDialog1 do
      begin
          Title:='Output File';
          Execute;
          AssignFile(outf, FileName);
      end;

    rewrite(outf);

    writeln(outf, NData);
    for i:=1 to NData do
      writeln(outf, DataX[i],'   ',DataY[i]);

    CloseFile(outf);
end;

//   t@Cf[^i_̕zujǂݍ
procedure TForm1.RdButtonClick(Sender: TObject);
var
  inf : TextFile;
  i   : Longint;
begin
    GOButtonClick(Sender);

    with OpenDialog1 do
      begin
          Title:='Input File';
          Execute;
          AssignFile(inf, FileName);
      end;

    Reset(inf);

    readln(inf, NData);
    for i:=1 to NData do
      readln(inf, DataX[i], DataY[i]);

    CloseFile(inf);

    with Canvas do
      for i:=1 to NData do
        Circle( CPosX(DataX[i]), CPosY(DataY[i]), clBlue );
end;

//   ʁif[^j̏
procedure TForm1.ClearButtonClick(Sender: TObject);
begin
           GOButtonClick(Sender);
end;

//   ֌WƉAW̌vZ
function CalcCor( x, y : TData;
                  n    : Longint;
                  var
                    a, b : Extended ) : Extended;
  var
    s_x, s_xx, s_y, s_xy,
    MeanX, MeanY, Sxy, Sx2, Sy2 : Extended;
    i : Longint;
  begin
     //    PǍXƂؕЂ̌vZ
     s_x :=0.0;
     s_xx:=0.0;
     s_y :=0.0;
     s_xy:=0.0;
     for i:=1 to n do
       begin
         s_x :=s_x  + x[i];       (*@w̘a      *)
         s_xx:=s_xx + sqr(x[i]);  (*  ŵQa  *)
         s_y :=s_y  + y[i];       (*  x̘a      *)
         s_xy:=s_xy + x[i]*y[i];  (*  XY̘a      *)
       end;

     a:=(n*s_xy-s_x*s_y)/(n*s_xx-sqr(s_x));     //  萔a̒l
     b:=(s_xx*s_y-s_x*s_xy)/(n*s_xx-sqr(s_x));  //  萔b̒l


       (*   ֌W̌vZ   *)

     MeanX:=s_x/n;   //  Pϗʂ̕ϒl
     MeanY:=s_y/n;   //  Qϗʂ̕ϒl
     Sxy:=0.0;
     Sx2:=0.0;
     Sy2:=0.0;
     for i:=1 to n do
       begin
           Sxy:=Sxy+(x[i]-MeanX)*(y[i]-MeanY);
           Sx2:=Sx2+sqr(x[i]-MeanX);
           Sy2:=Sy2+sqr(y[i]-MeanY);
       end;

     Result:=Sxy/sqrt(Sx2*Sy2);          //  ֌W
  end;   {   CalcCor   }

//   ֌WƉA̕\
procedure TForm1.CalcButtonClick(Sender: TObject);
var r, a, b, MinX, MaxX : Extended;
    i, fh, ws : Longint;
    s : string;
begin
    //    ֌WƉAWƂ
    r := CalcCor( DataX, DataY, NData, a, b );

    //   A̕`͈́AMinX <= x <= MaxX
    if abs(a) < 1.0e-15
      then
        begin  MinX:=0.0; MaxX:=100.0; end
      else
        begin
          if b >= 0.0
            then
              begin
                if b <= 100.0 then MinX:=0.0
                              else MinX:=(100.0-b)/a;
              end
            else MinX:=-b/a;
          if a*100+b <= 100
            then
              begin
                if a*100+b >= 0 then MaxX:=100.0
                                else MaxX:=-b/a;
              end
            else MaxX:=(100-b)/a;
        end;

    //    `
    with Canvas do
      begin
        //  ʂ̏
        with Pen do
          begin Width:=1; Color:=clWhite; end;
        with Brush do
          begin Style:=bsSolid; Color:=clWhite; end;
        Rectangle(0,0,ClientWidth,ClientHeight);

        //  g̕`
        Pen.Color:=clBlack;
        Rectangle(XLeft,YTop,XRight,YBottom);

        //  hbgi~j̕`
        for i:=1 to NData do
          Circle( CPosX(DataX[i]), CPosY(DataY[i]), clBlue );

        //  A̕`
        with Pen do
          begin  Width:=2; Color:=clRed;  end;

        MoveTo(CPosX(Round(MinX)),CPosY(Round(a*MinX+b)));
        LineTo(CPosX(Round(MaxX)),CPosY(Round(a*MaxX+b)));

        //  ֌WƌW̕\
        if y0 < x0 then fh:=(y0-w) div 3
                   else fh:=(x0-w) div 3;
        Font.Height:=fh;
        s:='֌W = '+FloatToStrF(r,ffGeneral,5,1)+
           '    W = '+FloatToStrF(sqr(r),ffGeneral,5,1);
        ws:=TextWidth(s);
        Font.Color:=clBlack;
        Brush.Style:=bsClear;
        TextOut( x0-(ws div 2), YBottom+(fh div 2),s );
      end;
end;

var
  ckForm : integer = 0;  //  ̃_CAO{bNX
                         //  ̍ĕ``FbNpϐ

//    v^o
procedure TForm1.PrintButtonClick(Sender: TObject);
  var
    x0, y0,                //  (x0,y0)Fʂ̒
    w,                     //  2*wFg̑傫
    XLeft, XRight, YTop, YBottom : Longint;

  //   (NbN̈ʒu) [[> 0 <= ScaleX <= 100
  function ScaleX( x : Longint ) : Longint;
    begin
          ScaleX:=Trunc( 100.0*(x-XLeft)/(XRight-XLeft) );
    end;

  //  0 <= x <= 100  [[> XLeft <= CPosX <= XRight
  function CPosX( x : Longint ) : Longint;
    begin
          CPosX := Round( XLeft + x*(XRight-XLeft)/100 );
    end;

  //   (NbN̈ʒu) -->  0 <= ScaleY <= 100
  function ScaleY( y : Longint ) : Longint;
    begin
          ScaleY:=Trunc( 100.0*(-(y-YBottom)/(YBottom-YTop)) );
    end;

  //   0 <= y <= 100  [[>  YBottom >= CPosY >= YTop
  function CPosY( y : Longint ) : Longint;
    begin
          CPosY := Round( YBottom - y*(YBottom-YTop)/100 );
    end;

  
  //  Fclŏ~hׂ
  procedure Circle( x, y : Longint;
                    cl   : TColor;
                    size : integer );
      begin
          with Printer.Canvas do
            begin
              with Pen do
                begin  Width:=1; Color:=cl;  end;
              with Brush do
                begin  Style:=bsSolid; Color:=cl;  end;

              Ellipse(x-size,y-size,x+size,y+size);
            end;
      end;

var r, a, b, MinX, MaxX : Extended;
    i, fh, ws : Longint;
    s : string;
    csize : integer;

begin
    ckForm:=1;

    PrintDialog1.Execute;

    with Printer do
      begin
        BeginDoc;

        //    `̏
        with Canvas do
          begin

            //  S(x0,y0)̐ݒ
            x0:=PageWidth div 2;
            y0:=PageHeight div 2;

            //  g̐ݒ
            if y0 < x0 then w:=round(0.8*y0)
                       else w:=round(0.8*x0);
            XLeft:=x0-w;
            YTop :=y0-w;
            XRight:=x0+w;
            YBottom:=y0+w;
            Pen.Color:=clBlack;
            Rectangle(XLeft,YTop,XRight,YBottom);
            csize:=round(0.007*w);
          end;

        //    ֌WƉAWƂ
        r := CalcCor( DataX, DataY, NData, a, b );

        //   A̕`͈́AMinX <= x <= MaxX
        if abs(a) < 1.0e-15
          then
            begin  MinX:=0.0; MaxX:=100.0; end
          else
            begin
              if b >= 0.0
                then
                  begin
                    if b <= 100.0 then MinX:=0.0
                                  else MinX:=(100.0-b)/a;
                  end
                else MinX:=-b/a;
              if a*100+b <= 100
                then
                  begin
                    if a*100+b >= 0 then MaxX:=100.0
                                    else MaxX:=-b/a;
                  end
                else MaxX:=(100-b)/a;
            end;

        //    `
        with Canvas do
          begin
            //  ʂ̏
            with Pen do
              begin Width:=1; Color:=clWhite; end;
            with Brush do
              begin Style:=bsSolid; Color:=clWhite; end;
            Rectangle(0,0,ClientWidth,ClientHeight);

            //  g̕`
            Pen.Color:=clBlack;
            Rectangle(XLeft,YTop,XRight,YBottom);

            //  hbgi~j̕`
            for i:=1 to NData do
              Circle( CPosX(DataX[i]), CPosY(DataY[i]), clBlue, csize );

            //  A̕`
            with Pen do
              begin  Width:=2; Color:=clRed;  end;

            MoveTo(CPosX(Round(MinX)),CPosY(Round(a*MinX+b)));
            LineTo(CPosX(Round(MaxX)),CPosY(Round(a*MaxX+b)));

            //  ֌WƌW̕\
            if y0 < x0 then fh:=(y0-w) div 3
                       else fh:=(x0-w) div 3;
            Font.Height:=fh;
            s:='֌W = '+FloatToStrF(r,ffGeneral,5,1)+
               '    W = '+FloatToStrF(sqr(r),ffGeneral,5,1);
            ws:=TextWidth(s);
            Font.Color:=clBlack;
            Brush.Style:=bsClear;
            TextOut( x0-(ws div 2), YBottom+(fh div 2),s );
          end;

        EndDoc;
      end;
end;

//   ̃_CAO{bNX̏
//   ĕ`
procedure TForm1.FormPaint(Sender: TObject);
begin
    if ckForm = 1 then
      begin
        CalcButtonClick(Sender);
      end;  
end;

end.
