unit UScatter;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls;

type
  TSubForm = class(TForm)
    OKButton: TButton;
    ExitButton: TButton;
    MsgLabel: TLabel;
    Image1: TImage;
    PButton: TButton;
    PrinterSetupDialog1: TPrinterSetupDialog;
    procedure OKButtonClick(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure PButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  SubForm: TSubForm;

implementation

{$R *.DFM}

uses UAnal2Vars, Printers;

{$R+}

procedure TSubForm.ExitButtonClick(Sender: TObject);
begin
           Close;
end;

procedure TSubForm.FormActivate(Sender: TObject);
begin
       Image1.Hide;
end;

const gsize = 2*25;
var  count : array[1..gsize,1..gsize] of Longint;
     Image2 : TImage;

procedure TSubForm.OKButtonClick(Sender: TObject);
var     in_f, out_f : textfile;
        XLabel, YLabel : string;
        n, i, j, x0, x1, y0, y1, size, fh, MaxCount  : Longint;
        x, y  : array of Extended;
        a, b, c, s_x, s_xx, s_y, s_xy,
        Sx2, Sy2, Sxy, MeanX, MeanY, r,
        MinX, MaxX, MinY, MaxY, MinXRng, MaxXRng : Extended;


  function XScale( x : Extended ) : Extended;
    begin
          XScale:=-1.0+2*(x-MinX)/(MaxX-MinX);
    end;


  function YScale( y : Extended ) : Extended;
    begin
          YScale:=-1.0+2*(y-MinY)/(MaxY-MinY);
    end;

  function XPos( x : Extended ) : Longint;
    begin
          XPos:=Round(x0+x*size);
    end;


  function YPos( y : Extended ) : Longint;
    begin
          YPos:=Round(y0-y*size);
    end;


  procedure AddOne( var v : Longint );
    begin
             v := v + 1;
    end;

  function  CntPosX( vx : Extended ) : Longint;
    var  v : Longint;
    begin
          v:=1+trunc(gsize*(vx-MinX)/(MaxX-MinX));
          if v > gsize then CntPosX:=gsize
                       else CntPosX:=v;
    end;

  function CntPosY( vy : Extended ) : Longint;
    var  v : Longint;
    begin
          v:=1+trunc(gsize*(vy-MinY)/(MaxY-MinY));
          if v > gsize then CntPosY:=gsize
                       else CntPosY:=v;
    end;

  procedure PlotData( i, j : Longint );
    var  v : Extended;
         s, ix, iy : Longint;
    begin
          v:=0.3+0.7*count[i,j]/MaxCount;
          s:=Round(v*size/50);
          ix:=XPos( (i-0.5-gsize/2)/(gsize/2) );
          iy:=YPos( (j-0.5-gsize/2)/(gsize/2) );
          Image1.Canvas.Ellipse(ix-s, iy-s, ix+s, iy+s);
    end;


begin
     MsgLabel.Visible:=false; UpDate;

     with MainForm.OpenDialog1 do
       begin
         FileName:='';
         Title:='o͗pt@CiApj';
         if not Execute then
           begin
             MsgLabel.Visible:=true;
             exit;
           end;
         AssignFile(out_f, FileName); //  o͗pt@C
         Rewrite(out_f);
       end;

    WindowState:=wsMaximized;
    OKButton.Visible:=false;
    with ExitButton do
      begin
        Top:=0; Left:=0;
      end;

    with PButton do
      begin
        Top:=0; Left:=ExitButton.Width;
      end;
    UpDate;  

    with MainForm.StringGrid1 do
      begin
        XLabel:=MainForm.EditXLabel.Text;
        YLabel:=MainForm.EditYLabel.Text;
        n:=RowCount-1;   //   f[^̐ݒ
        SetLength(x,n+1);
        SetLength(y,n+1);
        try
          for i:=1 to n do
            begin
              x[i]:=StrToFloat(Cells[1,i]);  //   f[^z֐ݒ
              y[i]:=StrToFloat(Cells[2,i]);
            end;
        except                             //   sȃf[^
          ShowMessage('Error ===>  Cells[1,'+IntToStr(i)+'] = '
                       +Cells[1,i]);
          Exit;   //   ̎葱̏I
        end;
      end;

      (*  ǂݍ񂾃f[^̏o   *)

     writeln(out_f);
     writeln(out_f, 'ϗʂw̃x --> ', XLabel);
     writeln(out_f, 'ϗʂx̃x --> ', YLabel);

      (*   A y=ax+b ߂邽߂̌vZ   *)

     s_x :=0.0;
     s_xx:=0.0;
     s_y :=0.0;
     s_xy:=0.0;
     for i:=1 to n do
       begin
         s_x :=s_x  + x[i];       (*@w̘a      *)
         s_xx:=s_xx + sqr(x[i]);  (*  ŵQa  *)
         s_y :=s_y  + y[i];       (*  x̘a      *)
         s_xy:=s_xy + x[i]*y[i];  (*  XY̘a      *)
       end;

     a:=(n*s_xy-s_x*s_y)/(n*s_xx-sqr(s_x));     //  萔a̒l
     b:=(s_xx*s_y-s_x*s_xy)/(n*s_xx-sqr(s_x));  //  萔b̒l

       (*   Aɂl̏o  *)

     writeln(out_f);
     writeln(out_f,
       '    X =       Y =       a*X+b =    덷');
     for i:=1 to n do writeln(out_f,
       x[i]:10:3, y[i]:10:3, (a*x[i]+b):10:3,
                             (y[i]-(a*x[i]+b)):10:3);
     writeln(out_f);
     writeln(out_f,'a = ', a:15:5);
     writeln(out_f,'b = ', b:15:5);

       (*   ֌W̌vZ   *)

     MeanX:=s_x/n;   //  Pϗʂ̕ϒl
     MeanY:=s_y/n;   //  Qϗʂ̕ϒl
     Sxy:=0.0;
     Sx2:=0.0;
     Sy2:=0.0;
     for i:=1 to n do
       begin
           Sxy:=Sxy+(x[i]-MeanX)*(y[i]-MeanY);
           Sx2:=Sx2+sqr(x[i]-MeanX);
           Sy2:=Sy2+sqr(y[i]-MeanY);
       end;

     r:=Sxy/sqrt(Sx2*Sy2);          //  ֌W
     writeln(out_f);
     writeln(out_f, 'r = ', r:15:5);
     writeln(out_f, 'W = ', sqr(r):8:5);  

     closefile(out_f);      //  o̓t@C


        (*  tH[`pɐݒ肷  *)

     OKButton.Hide;
     Image1.Show;

  (*    Image1ɎUz}ƉA`    *)

     with Image1 do
       begin
           Top:=ExitButton.Height;
           Left:=0;
           Height:=SubForm.ClientHeight-ExitButton.Height;
           Width :=SubForm.ClientWidth;
           with Canvas do
             begin
                Pen.Color:=clWhite; Brush.Color:=clWhite;
                Rectangle(0,0,ClientWidth,ClientHeight);
                UpDate;

                 (*   g̕`   *)
               
                x0:=ClientWidth div 2;
                y0:=ClientHeight div 2;
                size:=Round(0.85*x0);
                if size > Round(0.9*y0) then size:=Round(0.9*y0);
                with Pen do
                  begin  Color:=clBlack; Width:=1;  end;

                Rectangle(XPos(-1.0),YPos(1.0), XPos(1.0), YPos(-1.0));

                (*   Pϗʂ̃x̕`   *)

                fh:=Round(size*0.07);
                Font.Height:=fh;
                TextOut(XPos(-1.0), YPos(1.0)-Round(1.2*fh),
                        'w --> '+XLabel);

                Image2:=TImage.Create(Self);
                with Image2 do
                  begin
                     Visible:=false;
                     Height:=fh+1;
                     Width:=TextWidth('x --> '+YLabel)+1;
                     with Canvas do
                       begin
                          Font.Height:=fh;
                          TextOut(0, 0,'x --> '+YLabel);
                       end;
                  end;

              (*  Qϗʂ̃xcɂXOx]ăRs[   *)

                for i:=0 to TextWidth('x --> '+YLabel) do
                  for j:=0 to fh do
                    Pixels[XPos(-1.0)-Round(1.2*fh)+j,YPos(0.0)-i]
                      :=Image2.Canvas.Pixels[i, j];
                UpDate;
                Image2.Free;

      (*  XPos,YPosŗpĂXP[Op萔MinXȂǂ̐ݒ  *)

                MinX:=x[1]; MaxX:=MinX; MinY:=y[1]; MaxY:=MinY;
                for i:=2 to n do
                  begin
                      if MinX > x[i] then MinX:=x[i];
                      if MaxX < x[i] then MaxX:=x[i];
                      if MinY > y[i] then MinY:=y[i];
                      if MaxY < y[i] then MaxY:=y[i];
                  end;
                if a > 0.0
                  then
                    begin
                      if MinY > (a*MinX+b) then MinXRng:=(MinY-b)/a
                                           else MinXRng:=MinX;
                      if MaxY < (a*MaxX+b) then MaxXRng:=(MaxY-b)/a
                                           else MaxXRng:=MaxX;
                    end
                  else
                    begin
                      if MinY > (a*MaxX+b) then MaxXRng:=(MinY-b)/a
                                           else MaxXRng:=MaxX;
                      if MaxY < (A*MinX+b) then MinXRng:=(MaxY-b)/a
                                           else MinXRng:=Minx;
                    end;


               (*    f[^̃vbg   *)

                with Pen do
                  begin
                    Color:=clBlack; Width:=1;
                  end;
                with Brush do
                  begin
                    Style:=bsSolid; Color:=clBlack;
                  end;
                for i:=1 to gsize do
                  for j:=1 to gsize do count[i,j]:=0;
                for i:=1 to n do
                  AddOne(count[CntPosX(x[i]),CntPosY(y[i])]);
                MaxCount:=0;
                for i:=1 to gsize do
                  for j:=1 to gsize do
                    if MaxCount < count[i,j]
                      then MaxCount:=count[i,j];

                for i:=1 to gsize do
                  for j:=1 to gsize do
                    if count[i,j] > 0 then PlotData( i,j );

                      (*       A̕`      *)

                with Pen do
                  begin
                    Color:=clBlue; Width:=2;
                  end;
                MoveTo(XPos(XScale(MinXRng)),
                       YPos(YScale(a*MinXRng+b)));
                LineTo(XPos(XScale(MaxXRng)),
                       YPos(YScale(a*MaxXRng+b)));
             end;
       end;

     MsgLabel.Visible:=false;
     ExitButton.SetFocus;
     PButton.Enabled:=true;
     Finalize(x);
     Finalize(y);
end;

procedure TSubForm.PButtonClick(Sender: TObject);
var     XLabel, YLabel : string;
        n, i, j, x0, x1, y0, y1, size, fh, MaxCount  : Longint;
        x, y  : array of Extended;
        a, b, c, s_x, s_xx, s_y, s_xy,
        Sx2, Sy2, Sxy, MeanX, MeanY, r,
        MinX, MaxX, MinY, MaxY, MinXRng, MaxXRng : Extended;


  function XScale( x : Extended ) : Extended;
    begin
          XScale:=-1.0+2*(x-MinX)/(MaxX-MinX);
    end;


  function YScale( y : Extended ) : Extended;
    begin
          YScale:=-1.0+2*(y-MinY)/(MaxY-MinY);
    end;

  function XPos( x : Extended ) : Longint;
    begin
          XPos:=Round(x0+x*size);
    end;


  function YPos( y : Extended ) : Longint;
    begin
          YPos:=Round(y0-y*size);
    end;


  procedure AddOne( var v : Longint );
    begin
             v := v + 1;
    end;

  function  CntPosX( vx : Extended ) : Longint;
    var  v : Longint;
    begin
          v:=1+trunc(gsize*(vx-MinX)/(MaxX-MinX));
          if v > gsize then CntPosX:=gsize
                       else CntPosX:=v;
    end;

  function CntPosY( vy : Extended ) : Longint;
    var  v : Longint;
    begin
          v:=1+trunc(gsize*(vy-MinY)/(MaxY-MinY));
          if v > gsize then CntPosY:=gsize
                       else CntPosY:=v;
    end;

  procedure PlotData( i, j : Longint );
    var  v : Extended;
         s, ix, iy : Longint;
    begin
          v:=0.3+0.7*count[i,j]/MaxCount;
          s:=Round(v*size/50);
          ix:=XPos( (i-0.5-gsize/2)/(gsize/2) );
          iy:=YPos( (j-0.5-gsize/2)/(gsize/2) );
          Printer.Canvas.Ellipse(ix-s, iy-s, ix+s, iy+s);
    end;

  procedure PlotDataCk( i, j, c : Longint );
    var  v : Extended;
         s : Longint;
    begin
          v:=0.3+0.7*c/MaxCount;
          s:=Round(v*size/50);
          with Printer.Canvas do
            begin
              Ellipse(i-s, j-s, i+s, j+s);
              MoveTo(i+Round(2*size/50),j-(fh div 2) );
            end;
    end;


begin

    PButton.Enabled:=false;  UpDate;

    PrinterSetUpDialog1.Execute;

    with MainForm.StringGrid1 do
      begin
        XLabel:=MainForm.EditXLabel.Text;
        YLabel:=MainForm.EditYLabel.Text;
        n:=RowCount-1;   //   f[^̐ݒ
        SetLength(x,n+1);
        SetLength(y,n+1);
        try
          for i:=1 to n do
            begin
              x[i]:=StrToFloat(Cells[1,i]);  //   f[^z֐ݒ
              y[i]:=StrToFloat(Cells[2,i]);
            end;
        except                             //   sȃf[^
          ShowMessage('Error ===>  Cells[1,'+IntToStr(i)+'] = '
                       +Cells[1,i]);
          Exit;   //   ̎葱̏I
        end;
      end;

      (*   A y=ax+b ߂邽߂̌vZ   *)

     s_x :=0.0;
     s_xx:=0.0;
     s_y :=0.0;
     s_xy:=0.0;
     for i:=1 to n do
       begin
         s_x :=s_x  + x[i];       (*@w̘a      *)
         s_xx:=s_xx + sqr(x[i]);  (*  ŵQa  *)
         s_y :=s_y  + y[i];       (*  x̘a      *)
         s_xy:=s_xy + x[i]*y[i];  (*  XY̘a      *)
       end;

     a:=(n*s_xy-s_x*s_y)/(n*s_xx-sqr(s_x));     //  萔a̒l
     b:=(s_xx*s_y-s_x*s_xy)/(n*s_xx-sqr(s_x));  //  萔b̒l

  (*    Image1ɎUz}ƉA`    *)

     with Printer do
       begin
           BeginDoc;
           with Canvas do
             begin

                 (*   g̕`   *)

                x0:=PageWidth div 2;
                y0:=PageHeight div 2;
                size:=Round(0.85*x0);
                if size > Round(0.9*y0) then size:=Round(0.9*y0);
                with Pen do
                  begin  Color:=clBlack; Width:=2;  end;

                Rectangle(XPos(-1.0),YPos(1.0), XPos(1.0), YPos(-1.0));

                (*   Pϗʂ̃x̕`   *)

                fh:=Round(size*0.07);
                Font.Height:=fh;
                TextOut(XPos(-1.0), YPos(1.0)-Round(1.2*fh),
                        'w --> '+XLabel);

                Image2:=TImage.Create(Self);
                with Image2 do
                  begin
                     Visible:=false;
                     Height:=fh+1;
                     Width:=TextWidth('x --> '+YLabel)+1;
                     with Canvas do
                       begin
                          Font.Height:=fh;
                          TextOut(0, 0,'x --> '+YLabel);
                       end;
                  end;

              (*  Qϗʂ̃xcɂXOx]ăRs[   *)

                for i:=0 to TextWidth('x --> '+YLabel) do
                  for j:=0 to fh do
                    Pixels[XPos(-1.0)-Round(1.2*fh)+j,YPos(0.0)-i]
                      :=Image2.Canvas.Pixels[i, j];
                Image2.Free;

      (*  XPos,YPosŗpĂXP[Op萔MinXȂǂ̐ݒ  *)

                MinX:=x[1]; MaxX:=MinX; MinY:=y[1]; MaxY:=MinY;
                for i:=2 to n do
                  begin
                      if MinX > x[i] then MinX:=x[i];
                      if MaxX < x[i] then MaxX:=x[i];
                      if MinY > y[i] then MinY:=y[i];
                      if MaxY < y[i] then MaxY:=y[i];
                  end;
                if a > 0.0
                  then
                    begin
                      if MinY > (a*MinX+b) then MinXRng:=(MinY-b)/a
                                           else MinXRng:=MinX;
                      if MaxY < (a*MaxX+b) then MaxXRng:=(MaxY-b)/a
                                           else MaxXRng:=MaxX;
                    end
                  else
                    begin
                      if MinY > (a*MaxX+b) then MaxXRng:=(MinY-b)/a
                                           else MaxXRng:=MaxX;
                      if MaxY < (A*MinX+b) then MinXRng:=(MaxY-b)/a
                                           else MinXRng:=Minx;
                    end;


               (*    f[^̃vbg   *)

                with Pen do
                  begin
                    Color:=clBlack; Width:=1;
                  end;
                with Brush do
                  begin
                    Style:=bsSolid; Color:=clBlack;
                  end;
                for i:=1 to gsize do
                  for j:=1 to gsize do count[i,j]:=0;
                for i:=1 to n do
                  AddOne(count[CntPosX(x[i]),CntPosY(y[i])]);
                MaxCount:=0;
                for i:=1 to gsize do
                  for j:=1 to gsize do
                    if MaxCount < count[i,j]
                      then MaxCount:=count[i,j];

                for i:=1 to gsize do
                  for j:=1 to gsize do
                    if count[i,j] > 0 then PlotData( i,j );

                      (*       A̕`      *)

                with Pen do
                  begin
                    Color:=clBlue; Width:=2;
                  end;
                MoveTo(XPos(XScale(MinXRng)),
                       YPos(YScale(a*MinXRng+b)));
                LineTo(XPos(XScale(MaxXRng)),
                       YPos(YScale(a*MaxXRng+b)));

                Pen.Color:=clBlack;
                Brush.Style:=bsClear;
                TextOut(XPos(-1.0),YPos(-1.1),
                        'Y = a*Y + b');
                TextOut(Xpos(-1.0),YPos(-1.2),
                        'a = '+FloatToStrF(a,ffGeneral,5,1));
                TextOut(XPos(-1.0),YPos(-1.3),
                        'b = '+FloatToStrF(b,ffGeneral,5,1));

                with Brush do
                  begin
                    Style:=bsSolid; Color:=clBlack;
                  end;
                PlotDataCk( XPos(0.0), YPos(-1.1), MaxCount );
                Brush.Style:=bsClear;
                TextOut( PenPos.x, PenPos.y,
                         '==> '+IntToStr(MaxCount)+' points' );
                with Brush do
                  begin
                    Style:=bsSolid; Color:=clBlack;
                  end;
                PlotDataCk( XPos(0.0), YPos(-1.2), 1 );
                Brush.Style:=bsClear;
                TextOut( PenPos.x, PenPos.y,
                         '==> 1 point');         
             end;

           EndDoc;
       end;

     MsgLabel.Visible:=false;
     ExitButton.SetFocus;
     PButton.Enabled:=true;
     Finalize(x);
     Finalize(y);
     Close;
end;

end.