unit UGenPlot;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    ExitButton: TButton;
    Label1: TLabel;
    NEdit: TEdit;
    GOButton: TButton;
    Label2: TLabel;
    REdit: TEdit;
    procedure ExitButtonClick(Sender: TObject);
    procedure GOButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

uses URN, UTypeDefMat, UMatCalc;

var  RN : TNormalRN;

procedure TForm1.ExitButtonClick(Sender: TObject);
begin
               Close;
end;

procedure TForm1.GOButtonClick(Sender: TObject);
type TRec = record  x, y : extended; end;
var N, x0, y0, u, i, ECode : Longint;
    dots : array of TRec;
    sx, sy, sxx, syy, sxy, r, a, b, x1, x2, y1, y2 : extended;
    XX, InvXX : TMatCalc;

  function xpos( x : extended ) : Longint;
    begin
          xpos:=round(x0+u*x);
    end;

  function ypos( y : extended ) : Longint;
    begin
          ypos:=round(y0-u*y);
    end;

begin
    WindowState:=wsMaximized; UpDate;
    N:=StrToInt(NEdit.Text);
    SetLength(dots, N+1);
    r:=StrToFloat(REdit.Text);
    if abs(r) > 1.0
      then  raise Exception.Create('The value of R is not valid.');
    with Canvas do
      begin
          Pen.Color:=clWhite;
          with Brush do
            begin Style:=bsSolid; Color:=clWhite; end;
          Rectangle(0,GOButton.Height,ClientWidth,ClientHeight);
          x0:=ClientWidth div 2;
          y0:=ClientHeight div 2;
          u :=round(y0/4);
          with Pen do
            begin
              Width:=2; Color:=clBlack;
            end;  
          MoveTo(xpos(-3.5), ypos(0.0));
          LineTo(xpos(3.5), ypos(0.0));
          MoveTo(xpos(0.0), ypos(-3.5));
          LineTo(xpos(0.0), ypos(3.5));
          Pen.Width:=1;
          Brush.Style:=bsClear;
          for i:=1 to N do
            with dots[i] do
              begin
                  x:=RN.Normal;
                   if abs(r) < 1.0
                     then
                       y:=r*x+sqrt(1-sqr(r))*RN.Normal
                     else if r > 0.0 then  y:=x
                                     else  y:=-x;
                  Ellipse(xpos(x)-2, ypos(y)-2, xpos(x)+2, ypos(y)+2);
              end;


          //  Calculation of the correlation coeficient

          sx:=0.0; sy:=0.0; sxx:=0.0; syy:=0.0; sxy:=0.0;
          for i:=1 to N do
            with dots[i] do
              begin
                  sx:=sx+x;
                  sy:=sy+y;
                  sxx:=sxx+sqr(x);
                  syy:=syy+sqr(y);
                  sxy:=sxy+x*y;
              end;
          r:=(sxy-sx*sy/N)/sqrt((sxx-sqr(sx)/N)*(syy-sqr(sy)/N));
          Font.Height:=GOButton.Height-3;
          with Brush do
            begin Style:=bsSolid; Color:=clBtnFace; end;
          TextOut(xpos(0.0), 2,
                  '                                         ');
          TextOut(xpos(0.0), 2,
                  'R = '+FloatToStrF(r,ffGeneral,5,1));

          UpDate;        

          //  Calculation of the regression line.

          XX[1,1]:=sxx;  XX[1,2]:=sx;
          XX[2,1]:=sx;   XX[2,2]:=N;
          Mat_Inv_Gauss( XX, InvXX, 2, 1.0e-12, ECode );
          if ECode <> 0 then
                raise Exception.Create('Calculation of the inverse matrix'+
                                        ' failed');
          a:=InvXX[1,1]*sxy+InvXX[1,2]*sy;
          if abs(a) < 1.0e-9 then a:=0;
          b:=InvXX[2,1]*sxy+InvXX[2,2]*sy;
          if abs(b) < 1.0e-9 then b:=0;
          
          if abs(a*(-3)+b) <= 3
            then
              begin
                 x1:=-3; y1:=a*(-3)+b;
              end
            else
              if (a*(-3)+b) > 3
                then
                  begin
                    x1:=(3-b)/a; y1:=3;
                  end
                else
                  begin
                    x1:=(-3-b)/a; y1:=-3;
                  end;

          if abs(a*3+b) <= 3
            then
              begin
                  x2:=3; y2:=a*3+b;;
              end
            else
              if (a*3+b) > 3
                then
                  begin
                    x2:=(3-b)/a; y2:=3;
                  end
                else
                  begin
                    x2:=(-3-b)/a; y2:=-3;
                  end;
          with Pen do
            begin  width:=2; Color:=clRed; end;
          MoveTo(xpos(x1),ypos(y1));
          LineTo(xpos(x2),ypos(y2));   
          Brush.Style:=bsClear;
          TextOut(0, ClientHeight-Font.Height,
                  '  a = '+FloatToStrF(a,ffGeneral,9,1)+
                  '     b = '+FloatToStrF(b,ffGeneral,9,1));
      end;

    Finalize(dots);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
        RN:=TNormalRN.Create;
        RN.Init;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
            RN.Free;
end;

end.
