unit UMatCalc;

interface

uses
  SysUtils,UTypeDefMat;

type
  EMatException = class(Exception) ;

//       Z
function MatAdd( a, b : TMatCalc;
                 m, n : Longint ) : TMatCalc;

//       Z
function MatSub( a, b : TMatCalc;
                 m, n : Longint ) : TMatCalc;

//       |Z      a : L x m;   b : m x n
function MatMul( a, b : TMatCalc;
                 L, m, n : Longint ) : TMatCalc;


//     XJ[{
function MatScl( s : Extended;
                 a : TMatCalc;
                 m, n : Longint ) : TMatCalc;


//     ]us
function Transpose( a : TMatCalc;
                    m, n : Longint ) : TMatCalc;


//     KEX̏@
procedure Mat_Inv_Gauss( a     : TMatCalc;  //  a̋ts߂
                         var b : TMatCalc;  //  a̋ts񂪕Ԃ
                         n     : Longint;  //  s̃TCY
                         ZeroV : Extended; //  [̊l
                         var ECode         //  ts񂪋܂΂OԂ
                                    : Longint );

//       ts
function MatInv( a : TMatCalc;
                 n : Longint;
                 ZeroV          //  [̊l
                       : Extended ) : TMatCalc;


//     Cholesky̗p
procedure Mat_Inv_S( a     : TMatCalc;      //  a̋ts߂
                     var b : TMatCalc;      //  a̋ts񂪕Ԃ
                     n     : Longint;       //  s̃TCY
                     ZeroV : Extended;      //  [̊l
                     var ECode              //  ts񂪋܂΂OԂ
                               : Longint );

//      tsiCholeskyɂ́j
function MatInvS( a : TMatCalc;
                  n : Longint;
                  ZeroV           //  [̊l
                        : Extended ) : TMatCalc;


//     s
function  MatDet( a    : TMatCalc;
                  n    : Longint;
                  zero            //  [̊l
                       : Extended ) : Extended;

//     K
function MatRnk( a : TMatCalc;
                 m, n  : Longint;
                 ZeroV           //  [̊l
                       : Extended ) : Longint;

implementation

function MatAdd( a, b : TMatCalc;
                 m, n : Longint ) : TMatCalc;
  var
    i, j : Longint;
  begin
      for i:=1 to m do
        for j:=1 to n do
          Result[i,j]:=a[i,j]+b[i,j];
  end;


function MatSub( a, b : TMatCalc;
                 m, n : Longint ) : TMatCalc;
  var
    i, j : Longint;
  begin
      for i:=1 to m do
        for j:=1 to n do
          Result[i,j]:=a[i,j]-b[i,j];
  end;

  
function MatMul( a, b : TMatCalc;
                 L, m, n : Longint ) : TMatCalc;
  var
    i, j, k : Longint;
    v : Extended;
  begin
      for i:=1 to L do
        for j:=1 to n do
          begin
              v:=0.0;
              for k:=1 to m do
                v:=v+a[i,k]*b[k,j];
              Result[i,j]:=v;
          end;
  end;

//   {uDelphiŊwԃf[^͖@vA1998AbpoŎ
//        t^`.TusƋtsv
//         Pp.262-264,KEX̏@
procedure Mat_Inv_Gauss( a     : TMatCalc;
                         var b : TMatCalc;
                         n     : Longint;
                         ZeroV : Extended;
                         var ECode : Longint );
  label  QP;
  var    i, j, k : Longint;
         v : Extended;


  procedure swap( var x, y : Extended );
    var  v : Extended;
    begin
         v:=x;  x:=y;  y:=v;
    end;


  begin    {   Mat_Inv_Gauss   }
         ECode:=0;

         for i:=1 to n do
           for j:=1 to n do b[i,j]:=0.0;  //  b[i,i]̓XP[Oɐݒ

     (*  XP[Oies̍őlPɂj  *)

         for i:=1 to n do
           begin
               k:=1;
               for j:=1 to n do
                 if abs(a[i,k]) < abs(a[i,j]) then k:=j;
               if abs(a[i,k]) > ZeroV
                 then  v:=1/a[i,k]
                 else
                   begin
                       ECode:=1;   //  inclusion of Zero row(s)
                       goto QP;
                   end;

               for j:=1 to n do a[i,j]:=v*a[i,j];
               b[i,i]:=v;  //   b[i,i]:=v*1.0;
           end;

        (*     Oi      *)

         if n > 1 then
           for i:=1 to n-1 do
             begin
                k:=i;
                for j:=i+1 to n do
                  if abs(a[k,i]) < abs(a[j,i]) then k:=j;
                  if abs(a[k,i]) < 1.0E-10 then
                    begin
                        ECode:=2;    //  singular matrix
                        goto QP;
                    end;

                if i <> k then
                  begin
                    for j:=i to n do swap(a[i,j], a[k,j]);
                    for j:=1 to n do swap(b[i,j], b[k,j]);
                  end;

                v:=1/a[i,i];
                for j:=i+1 to n do a[i,j]:=v*a[i,j];
                for j:=1   to n do b[i,j]:=v*b[i,j];
                for j:=i+1 to n do
                  begin
                     for k:=i+1 to n do a[j,k]:=a[j,k]-a[j,i]*a[i,k];
                     for k:=1   to n do b[j,k]:=b[j,k]-a[j,i]*b[i,k];
                  end;
             end;

         if abs(a[n,n]) < 1.0E-10 then
           begin
               ECode:=3;             //  singular matrix
               goto QP;
           end;

         v:=1/a[n,n];
         for i:=1 to n do b[n,i]:=v*b[n,i];

        (*     ޑ      *)

         if n > 1 then
           begin
               for i:=n-1 downto 1 do
                 begin
                     for j:=1 to n do
                       begin
                         v:=b[i,j];
                         for k:=i+1 to n do v:=v-a[i,k]*b[k,j];
                         b[i,j]:=v;
                       end;
                 end;
           end;

         QP : ;
  end;   {   Mat_Inv_Gauss   }


function MatInv( a : TMatCalc;
                 n : Longint;
                 ZeroV : Extended ) : TMatCalc;
  var  b : TMatCalc;
       ECode : Longint;
  begin
    Mat_Inv_Gauss( a, b, n, ZeroV, ECode );
    if ECode = 0
      then Result:=b
      else raise EMatException.Create('inverse matrix for singular matrix'+
                                      '   ECode = '+IntToStr(ECode));
  end;


function MatScl( s : Extended;
                 a : TMatCalc;
                 m, n : Longint ) : TMatCalc;
  var i, j : Longint;
  begin
        for i:=1 to m do
          for j:=1 to n do
            Result[i,j]:=s*a[i,j];
  end;


function Transpose( a : TMatCalc;
                    m, n : Longint ) : TMatCalc;
  var i, j : Longint;
  begin
        for i:=1 to m do
          for j:=1 to n do
            Result[j,i]:=a[i,j];
  end;


function  MatDet( a   : TMatCalc;
                  n   : Longint;
                  zero : Extended ) : Extended;
  label  QP;
  var    i, j, k : Longint;
         TempV, v : Extended;

  procedure swap( var x, y : Extended );
    var  v : Extended;
    begin
         v:=x;  x:=y;  y:=v;
    end;

  begin    {   MatDet   }
         TempV:=1.0;

         if n > 1 then
           begin
             //   vf̐Βl̍őlɋ߂
             v:=abs(a[1,1]);
             for i:=1 to n do
               for j:=1 to n do
                 if v < abs(a[i,j])
                   then v:=abs(a[i,j]);

             if v < zero
               then      //  [sƔ
                 begin
                   TempV:=0.0;
                   goto QP;
                 end;

             //   |o@ɂđΊpsɂ
             for i:=1 to n-1 do
               begin
                  //   isȉjŐΒlő̗vf߂
                  k:=i;
                  for j:=i+1 to n do
                    if abs(a[k,i]) < abs(a[j,i]) then k:=j;

                  if abs(a[k,i]) < zero
                    then                //  sł͂Ȃ
                      begin
                          TempV:=0.0;
                          goto QP;
                      end;

                  //  ߂Βlő̗vf(i,i)vfɂȂ悤ɂ
                  if i <> k then
                    begin
                      for j:=i to n do swap(a[i,j], a[k,j]);
                      TempV:=-TempV;
                    end;

                  //  i+1sȉOɂ
                  v:=1/a[i,i];
                  TempV:=TempV*a[i,i];   //  (i,i)vfςɕۑ
                  for j:=i+1 to n do a[i,j]:=v*a[i,j];
                  for j:=i+1 to n do
                    for k:=i+1 to n do a[j,k]:=a[j,k]-a[j,i]*a[i,k];
               end;
           end
         else         //   s̓XJ[ł
           begin
             TempV:=a[1,1];
             goto QP;
           end;

         if abs(a[n,n]) < zero
           then  TempV:=0.0            //  słȂ
           else  TempV:=TempV*a[n,n];  //  a[n,n]Ƃ̐ςōs񎮂̒lZo

         QP : MatDet:=TempV;
  end;   {   MatDet   }


//   {uDelphiŊwԃf[^͖@vA1998AbpoŎ
//        t^`.TusƋtsv
//         Pp.264-267,Cholesky̗p
procedure Mat_Inv_S( a     : TMatCalc;      //  a̋ts߂
                     var b : TMatCalc;      //  a̋ts񂪕Ԃ
                     n     : Longint;       //  s̃TCY
                     ZeroV : Extended;      //  [̊l
                     var ECode              //  ts񂪋܂΂OԂ
                               : Longint );
  Label QP;
  var   i, j, k : Longint;
        s : TMatCalc;
        v : Extended;
  begin   {   Mat_Inv_S   }
      ECode:=0;

      (*  A = SS',  Cholesky  *)

      for i:=1 to n do
        for k:=i to n do
          if k = i
            then
              begin
                v:=a[i,i];
                if i > 1 then
                  for j:=1 to i-1 do v:=v-sqr(s[i,j]);
                if v > ZeroV then s[i,i]:=sqrt(v)
                             else begin  ECode:=-1; goto QP; end;
              end
            else
              begin
                v:=a[i,k];
                if i > 1 then
                  for j:=1 to i-1 do v:=v-s[i,j]*s[k,j];
                s[k,i]:=v/s[i,i];
              end;

      (*   T' = S̋ts   *)

      for i:=1 to n do
        for k:=i downto 1 do
          if k = i
            then
              s[i,i]:=1/s[i,i]
            else
              if i > 1 then
                begin
                  v:=0.0;
                  for j:=k to i-1 do v:=v-s[i,j]*s[k,j];
                  s[k,i]:=s[i,i]*v;
                end;

      (*   A̋ts = TT'  *)

      for i:=1 to n do
        for j:=i to n do
          begin
              v:=0.0;
              for k:=j to n do v:=v+s[i,k]*s[j,k];
              b[i,j]:=v;
              b[j,i]:=v;
          end;

    QP : ;
  end;   {   Mat_Inv_S   }



function MatInvS( a : TMatCalc;
                  n : Longint;
                  ZeroV : Extended ) : TMatCalc;
  var  b : TMatCalc;
       ECode : Longint;
  begin
    Mat_Inv_S( a, b, n, ZeroV, ECode );
    if ECode = 0
      then Result:=b
      else raise EMatException.Create('inverse matrix for singular matrix'+
                                      '   ECode = '+IntToStr(ECode));
  end;



function MatRnk( a : TMatCalc;
                 m, n  : Longint;
                 ZeroV : Extended ) : Longint;
  Label QP;
  const acc = 1.0e-15;
  var   rank, i, j, i1, j1, ki, kj : Longint;
        v : Extended;

  procedure Swap( var a, b : Extended );
    var t : Extended;
    begin
          t:=a;  a:=b;  b:=t;
    end;

  begin   {   MatRnk   }
      //   vf̐Βl̍őlɋ߂
      v:=0.0;
      for i:=1 to m do
        for j:=1 to n do
          if v < abs(a[i,j]) then v:=abs(a[i,j]);

      if v < ZeroV
        then       //  [sƔ
          begin
              rank:=0;
              goto QP;
          end;

      //  Krank̏l
      rank:=m;
      if rank > n then rank:=n;

      //   |o@ɂΊpɂĊK߂
      for i:=1 to m do
        if i <= n then
          begin
            //  (i,i)vf̉Eȍ~Aȉɂvf
            //  Βlő̂̂߂
            ki:=i; kj:=i;
            v:=abs(a[ki,kj]);
            for i1:=i to m do
              for j1:=i to n do
                if v < abs(a[i1,j1]) then
                  begin
                    ki:=i1; kj:=j1;
                    v:=abs(a[ki,kj]);
                  end;
            if v < ZeroV
              then          //  Βlő̂̂OȂ̂ŊKi-1
                begin
                  rank:=i-1;
                  goto QP;
                end
              else
                begin
                  //  Βlő̗vf(i,i)vfł悤ɂ
                  if ki > i then
                    begin
                      for j1:=i to n do
                        Swap( a[i,j1], a[ki,j1] );
                    end;

                  if kj > i then
                    begin
                      for j1:=i to m do
                        Swap( a[j1,i], a[j1,kj] );
                    end;

                  //  sɑ|os
                  v:=1/a[i,i];
                  for j1:=i to n do
                    a[i,j1]:=v*a[i,j1];
                  if i < m then
                    begin
                      for i1:=i+1 to m do
                        begin
                          v:=a[i1,i];
                          for j1:=i to n do
                            a[i1,j1]:=a[i1,j1]-v*a[i,j1];
                        end;
                    end;
                  //  ɑ|os  
                  if i < n then
                    begin
                      for j1:=i+1 to n do
                        begin
                          v:=a[i,j1];
                          for i1:=i to m do
                            a[i1,j1]:=a[i1,j1]-v*a[i1,i];
                        end;
                    end;
                end;
          end;

    QP : MatRnk:=rank;
  end;      {   MatRnk   }


end.
