#ifndef CALC_T_CK
#define CALC_T_CK

#include "adapIntgrtn.h"

using namespace adapInt;

namespace calc_t {

	double df;
	double t_kernel( double x ){
		double t = 1.0 / Math::Pow( 1 + x * x / df, (df + 1.0)/2.0 );
		return t;
	}

	double ga;

	double k_gamma_tr( double t ){
		double v = Math::Exp( (ga-1.0) * Math::Log(-Math::Log(t)) );
		return v;
	}

	double k_gamma( double y ){
		double t = Math::Exp( (ga-1.0) * Math::Log(y) ) * Math::Exp(-y);
		return t;
	}

	double gamma_r( double r ){
		ga = r;
		double c = Math::Exp(-1.0);
		AdaptiveGL gl;
		double v1 = gl.integral( 0.0, 1.0, k_gamma );
		double v2 = gl.integral( 0.0, c, k_gamma_tr );
		return v1 + v2;
	}

	double Cum_t_distribution( double t ) {
		if ( t == 0.0 ) {
			return 0.5;
		} else { if ( t > 0.0 ) {
				AdaptiveGL gl;
				double v = gl.integral( 0.0, t, t_kernel );
				v = 0.5 + gamma_r( (df + 1.0)/2.0) * v / (Math::Sqrt(Math::PI * df) * gamma_r(df/2.0));
				return v;
			} else {
				AdaptiveGL gl;
				double v = gl.integral( t, 0.0, t_kernel );
				v = 0.5 - gamma_r( (df + 1.0) / 2.0 ) * v / (Math::Sqrt(Math::PI * df) * gamma_r(df/2.0));
				return v;
			};
		}
	}

}

#endif
