unit UCum_t_rdf;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    MsgLabel: TLabel;
    Label2: TLabel;
    ZEdit: TEdit;
    OKButton: TButton;
    ExitButton: TButton;
    Label1: TLabel;
    DFEdit: TEdit;
    procedure FormActivate(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormActivate(Sender: TObject);
begin
           MsgLabel.Caption:='̒lƎRxdfݒ肵ĉ';
           DFEdit.Text:='';
           ZEdit.Text:='';
end;

procedure TForm1.ExitButtonClick(Sender: TObject);
begin
            Close;
end;


type   Real = Extended;

type   TFunc = function( x : real ) : real;

(******************************************************

function  Gauss_Legendre( a, b : Extended;
                          f    : TFunc ) : Extended;
  const  n_points = 9;
  type   pos_arry = array[1..n_points] of Extended;
  const  x0 : pos_arry = ( -9.68160239507626090E-0001,
                           -8.36031107326635794E-0001,
                           -6.13371432700590397E-0001,
                           -3.24253423403808929E-0001,
                            0.00000000000000000E+0000,
                            3.24253423403808929E-0001,
                            6.13371432700590397E-0001,
                            8.36031107326635794E-0001,
                            9.68160239507626090E-0001  );

         w  : pos_arry = (  8.12743883615744120E-0002,
                            1.80648160694857404E-0001,
                            2.60610696402935462E-0001,
                            3.12347077040002840E-0001,
                            3.30239355001259763E-0001,
                            3.12347077040002840E-0001,
                            2.60610696402935462E-0001,
                            1.80648160694857404E-0001,
                            8.12743883615744120E-0002  );
  //       accuracy = 1.0E-14;
  var    v1, i_w, xi : Extended;
         i : longint;
  begin
        v1:=0.0;
        i_w:=b-a;

        for i:=1 to n_points do
          begin
                xi:=(0.5*i_w*x0[i])+(0.5*(b+a));
                v1:=v1+(w[i]*f(xi));
          end;

        v1:=0.5*i_w*v1;
        Gauss_Legendre:=v1;
  end;    {    Gauss_Legendre     }


procedure  CalcIntegral( var S0 : Extended;
                         a, b   : Extended;
                         f      : TFunc );
  var  S1, S2 : Extended;
  begin
       S1:=Gauss_Legendre( a, 0.5*(a+b), f );
       S2:=Gauss_Legendre( 0.5*(a+b), b, f );
       if ((abs(S0-S1-S2) < (1.0E-14)*abs(S1+S2))
             or
          ((abs(S0)+abs(S1+S2)) < 1.0E-14))
          and
          (abs(b-a) < 1.0)
         then S0:=S1+S2
         else
           begin
               CalcIntegral(S1, a, 0.5*(a+b), f);
               CalcIntegral(S2, 0.5*(a+b), b, f);
               S0:=S1+S2;
           end;
  end;   {   CalcIntegral   }


function AdaptiveGL( a, b : real;
                     f    : TFunc ) : real;
  var S0 : Extended;
  begin
        S0:=0.0;
        CalcIntegral(S0, a, b, f);
        AdaptiveGL:=S0;
  end;   {   AdaptiveGL   }
  *****************************************)


(*   Guass-Legendre̐ϕ    *)

function  Gauss_Legendre( a, b : Extended;
                          f    : TFunc ) : Extended;
  const  n_points = 9;
  type   pos_arry = array[1..n_points] of Extended;
  const  x0 : pos_arry = ( -9.68160239507626090E-0001,
                           -8.36031107326635794E-0001,
                           -6.13371432700590397E-0001,
                           -3.24253423403808929E-0001,
                            0.00000000000000000E+0000,
                            3.24253423403808929E-0001,
                            6.13371432700590397E-0001,
                            8.36031107326635794E-0001,
                            9.68160239507626090E-0001  );

         w  : pos_arry = (  8.12743883615744120E-0002,
                            1.80648160694857404E-0001,
                            2.60610696402935462E-0001,
                            3.12347077040002840E-0001,
                            3.30239355001259763E-0001,
                            3.12347077040002840E-0001,
                            2.60610696402935462E-0001,
                            1.80648160694857404E-0001,
                            8.12743883615744120E-0002  );
         accuracy = 1.0E-14;
  var    v1, i_w, xi : Extended;
         i : longint;
  begin
        v1:=0.0;
        i_w:=b-a;

        for i:=1 to n_points do
          begin
                xi:=(0.5*i_w*x0[i])+(0.5*(b+a));
                v1:=v1+(w[i]*f(xi));
          end;

        v1:=0.5*i_w*v1;
        Gauss_Legendre:=v1;
  end;    {    Gauss_Legendre     }


(*    ϕԂ̂QɂJԂ   *)

procedure  CalcIntegral( var S0  : Extended;
                         a, b    : Extended;
                         f       : TFunc;
                         w_intvl,
                         acc     //  acc >= 1.0E-14
                                 : Extended );
  var  S1, S2 : Extended;
  begin
       S1:=Gauss_Legendre( a, 0.5*(a+b), f );
       S2:=Gauss_Legendre( 0.5*(a+b), b, f );
       if ((abs(S0-S1-S2) < acc*abs(S1+S2))
             or
          ((abs(S0)+abs(S1+S2)) < 1.0E-14))
          and
          (abs(b-a) < w_intvl)
         then S0:=S1+S2
         else
           begin
               CalcIntegral(S1, a, 0.5*(a+b), f, w_intvl, acc);
               CalcIntegral(S2, 0.5*(a+b), b, f, w_intvl, acc);
               S0:=S1+S2;
           end;
  end;   {   CalcIntegral   }


(*   ClacIntegraľĂяȍ     *)

function AdaptiveGL( a, b    : Extended;
                     f       : TFunc;
                     w_intvl : Extended;
                     acc     //   acc >= 1.0E-14
                             : Extended ) : Extended;
  var S0 : Extended;
  begin
        S0:=0.0;
        CalcIntegral(S0, a, b, f, w_intvl, acc);
        AdaptiveGL:=S0;
  end;   {   AdaptiveGL   }

  


function My_Power( a, b : real ) : real;
  begin
        My_Power:=exp(b*ln(a));
  end;


var  df : double; //integer;

function t_kernel( x : real ) : real;
  begin
        t_kernel:=1.0/My_Power(1+sqr(x)/df, (df+1)/2);
  end;

 {------------------------------
function gamma( r : real ) : real;
  begin
    if r > 1.25
      then gamma:=(r-1)*gamma(r-1)
      else begin
        if r > 0.75 then gamma:=1.0
                    else gamma:=sqrt(pi);
      end;
  end;
  -----------------------------------------}


var ga : Extended;

function k_gamma_tr( t : Extended ) : Extended;
  begin
        k_gamma_tr:=exp((ga-1)*Ln(-Ln(t)));
  end;


function k_gamma( y : Extended ) : Extended;
  begin
        k_gamma:=exp((ga-1)*Ln(y)) * exp(-y);
  end;


function gamma_r( r : Extended ) : Extended;
  var c, v1, v2 : Extended;
  begin
    ga:=r;
    c:=exp(-1.0);
    v1:=AdaptiveGL( 0.0, 1.0, k_gamma, 1.0, 1.0E-11 );
    v2:=AdaptiveGL( 0.0, c, k_gamma_tr, 1.0, 1.0E-11 );

    gamma_r:=v1+v2;
  end;




function Cum_t_distribution( t : real ) : real;
  var  v : real;
  begin
      if t = 0.0
        then Cum_t_distribution:=0.5
      else if t > 0.0
        then begin
             v:=AdaptiveGL( 0.0, t, t_kernel, 1.0, 1.0E-14 );
             Cum_t_distribution:=0.5+gamma_r((df+1)/2)*v/
                                 (sqrt(pi*df)*gamma_r(df/2));
        end
      else begin
             v:=AdaptiveGL( t, 0.0, t_kernel, 1.0, 1.0e-14 );
             Cum_t_distribution:=0.5-gamma_r((df+1)/2)*v/
                                 (sqrt(pi*df)*gamma_r(df/2));
        end;
  end;


procedure TForm1.OKButtonClick(Sender: TObject);
var   t, p : real;
      s1, s2 : string;
begin
      MsgLabel.Caption:='vZn߂܂'; UpDate;

      t:=StrToFloat(ZEdit.Text);
      df:=StrToFloat{Int}(DFEdit.Text);

      p:=Cum_t_distribution( t );

      Str( t:9:3, s1 );  Str( p:8:5, s2 );
      MsgLabel.Caption:='Prob( x <='+s1+' ) = '+s2;
      ExitButton.SetFocus;
end;

end.