unit U2SRel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, StdCtrls;

type
  TForm1 = class(TForm)
    StringGrid1: TStringGrid;
    AddButton: TButton;
    ExitButton: TButton;
    DelButton: TButton;
    MsgLabel: TLabel;
    CalcButton: TButton;
    SaveButton: TButton;
    LoadButton: TButton;
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    PButton: TButton;
    Label1: TLabel;
    EditXLabel: TEdit;
    Label2: TLabel;
    EditYLabel: TEdit;
    procedure ExitButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure AddButtonClick(Sender: TObject);
    procedure DelButtonClick(Sender: TObject);
    procedure CalcButtonClick(Sender: TObject);
    procedure SaveButtonClick(Sender: TObject);
    procedure LoadButtonClick(Sender: TObject);
    procedure PButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses  Printers;

procedure TForm1.ExitButtonClick(Sender: TObject);
begin
           Close;
end;


procedure TForm1.FormCreate(Sender: TObject);
var sel : TGridRect;      //  IZ̈ʒu\킷߂̌^
begin
    with StringGrid1 do
      begin
          ColCount:=3;                  //  
          ColWidths[1]:=2*ColWidths[0]; //  ̕
          ColWidths[2]:=ColWidths[1];
          RowCount:=2;                  //  s
          Font.Height:=16;
          Cells[0,1]:='1Ԗ';
          Cells[1,0]:='   X  =';
          Cells[2,0]:='   Y  =';
          Options:=Options-[goRangeSelect];  //  PZ̑I
          with sel do                        //  Z̈ʒu
            begin  Left:=1; Top:=1; Right:=1; Bottom:=1;  end;
          Selection:=sel;                    //  IZ̐ݒ
          Options:=[goEditing]+Options;      //  ZҏW
          EditorMode:=true;                  //  ZҏW
      end;
    EditXLabel.Text:='wϐ';
    EditYLabel.Text:='xϐ';
end;


(*           s̒ǉ          *)
procedure TForm1.AddButtonClick(Sender: TObject);
var   i, pos : Longint;
begin
      with StringGrid1 do
        begin
            pos:=Selection.top;
            RowCount:=RowCount+1;
            Cells[0,RowCount-1]:=IntToStr(RowCount-1)+'Ԗ';
            Cells[1,RowCount-1]:=' ';
            Cells[2,RowCount-1]:=' ';
            if (0 < pos) and (pos < RowCount-2) then
              begin
                for i:=RowCount-1 downto pos+2 do
                  begin
                    Cells[1,i]:=Cells[1,i-1];
                    Cells[2,i]:=Cells[2,i-1];
                  end;
                Cells[1,pos+1]:=' ';
                Cells[2,pos+1]:=' ';
              end;
        end;
end;

(*          s̍폜           *)
procedure TForm1.DelButtonClick(Sender: TObject);
var pos, i : Longint;
begin
    with StringGrid1 do
      begin
        pos:= Selection.top;     //  Is̐ݒ

        //   Z̒l̈ړ
        if (0 < pos) and (pos < RowCount-1) then
            for i:=pos to RowCount-2 do
              begin
                Cells[1,i]:=Cells[1,i+1];
                Cells[2,i]:=Cells[2,i+1];
              end;

           //   Ō̍s폜
        if 0 < pos then
          if RowCount > 2 then RowCount:=RowCount-1;
      end;
end;

const  MaxN = 1000;

var x, y : array[1..MaxN] of Extended;  //   f[^i[pz
    n   : Longint;                 //   f[^

procedure TForm1.CalcButtonClick(Sender: TObject);
var  outf : TextFile;
     i : integer;
     c, MeanX, MeanY, SDX, SDY, sx, sxx, sy, syy,
     MeanD, sumd, sdd, SD, t : real;
begin
    with StringGrid1 do
      begin
        n:=RowCount-1;   //   f[^̐ݒ
        try
          for i:=1 to n do
            begin
              x[i]:=StrToFloat(Cells[1,i]);  //   f[^z֐ݒ
              y[i]:=StrToFloat(Cells[2,i]);
            end;
        except                             //   sȃf[^
          ShowMessage('Error ===>  Cells[1,'+IntToStr(i)+'] = '
                       +Cells[1,i]);
          Exit;   //   ̎葱̏I
        end;
      end;

    with OpenDialog1 do
      begin
        Title:='vZʂ̏o͗pt@C';
        FileName:='';
        Execute;
        AssignFile(outf,FileName);
        Rewrite(outf);
      end;

    MsgLabel.Caption:='vZn߂܂';
    UpDate;


 (*   ̓f[^̏o   *)

    writeln(outf);
    writeln(outf,'Pϐ ==> ',EditXLabel.Text);
    writeln(outf,'Qϐ ==> ',EditYLabel.Text);
    writeln(outf);
    writeln(outf, 'f[^ =');
    for i:=1 to n do
      writeln(outf, '      x[', i, '] = ', x[i]:10:2,
                       '      y[', i, '] = ', y[i]:10:2 );

    sx:=0.0; sy:=0.0;
    for i:=1 to n do
      begin
         sx:=sx+x[i];        //  x[i]̘a
         sy:=sy+y[i];        //  y[i]̘a
      end;
    MeanX:=sx/n;             //  x[i]̕
    MeanY:=sy/n;             //  y[i]̕

    sxx:=0.0; syy:=0.0;
    for i:=1 to n do
      begin
          sxx:=sxx+sqr(x[i]-MeanX);   //  x[i]-MeanX̂Qa
          syy:=syy+sqr(y[i]-MeanY);   //  y[i]-MeanŶQa
      end;
    SDX:=sqrt(sxx/n);                 //  x[i]̕W΍
    SDY:=sqrt(syy/n);                 //  y[i]̕W΍

    writeln(outf);
    writeln(outf, 'X̕     = ', FloatToStrF(MeanX,ffGeneral,9,1));
    writeln(outf, 'X̕U     = ', FloatToStrF(sxx/n,ffGeneral,9,1));
    writeln(outf, 'X̕W΍ = ', FloatToStrF(SDX,  ffGeneral,9,1));
    writeln(outf, 'X̕sΕU = ', FloatToStrF(sxx/(n-1),ffGeneral,9,1));
    writeln(outf, 'X̕sΕU̕ = ',
                   FloatToStrF(sqrt(sxx/(n-1)),ffGeneral,9,1));
    writeln(outf, 'Y̕     = ', FloatToStrF(MeanY,ffGeneral,9,1));
    writeln(outf, 'Y̕U     = ', FloatToStrF(syy/n,ffGeneral,9,1));
    writeln(outf, 'Y̕W΍ = ', FloatToStrF(SDY,ffGeneral,9,1));
    writeln(outf, 'Y̕sΕU = ', FloatToStrF(syy/(n-1),ffGeneral,9,1));
    writeln(outf, 'Y̕sΕU̕ = ',
                   FloatToStrF(sqrt(syy/(n-1)),ffGeneral,9,1));

    sumd:=0.0;
    for i:=1 to n do
      sumd:=sumd+(x[i]-y[i]);        //  x[i]-y[i]̘a
    MeanD:=sumd/n;                   //  x[i]-y[i]̕
    sdd:=0.0;
    for i:=1 to n do
      sdd:=sdd+sqr(x[i]-y[i]-MeanD); //  x[i]-y[i]-MeanD̂Qa
    SD:=sqrt(sdd/n);                 //  x[i]-y[i]̕W΍
    t:=MeanD/(SD/Sqrt(n-1));         //  ťvZ

    writeln(outf);
    writeln(outf, 't = ', FormatFloat('0.000', t),
                     '    Rx = ', n-1);

    CloseFile(outf);
    MsgLabel.Caption:='vZI܂';
    ExitButton.SetFocus;
end;

(*    Obhɐݒ肳Ăf[^̕ۑ    *)
procedure TForm1.SaveButtonClick(Sender: TObject);
var outf : TextFile;
    i : Longint;
begin
    with SaveDialog1 do        //   ۑpt@C̖O̐ݒ
      begin
          Title:='t@C';
          Execute;
          AssignFile(outf,FileName);
      end;

    Rewrite(outf);            //  t@Copɐݒ

    writeln(outf,EditXLabel.Text);
    writeln(outf,EditYLabel.Text);
    with StringGrid1 do
      begin
        writeln(outf,RowCount-1);    //  f[^̏o
        for i:=1 to RowCount-1 do
          begin
            writeln(outf, Cells[1,i]); //  f[^̏o
            writeln(outf, Cells[2,i]);
          end;
      end;

    CloseFile(outf);
end;

(*    t@CObhփf[^ǂݍ    *)
procedure TForm1.LoadButtonClick(Sender: TObject);
var inf : TextFile;
    v, i   : Longint;
    s      : string;
begin
    with OpenDialog1 do           //  t@C̐ݒ
      begin
          Title:='t@C';
          Execute;
          AssignFile(inf,FileName);
      end;

    Reset(inf);                  //   t@Cǂݏopɐݒ

    readln(inf,s); EditXLabel.Text:=s;
    readln(inf,s); EditYLabel.Text:=s;
    with StringGrid1 do
      begin
        readln(inf,v);          //   f[^̓ǂݍ
        RowCount:=v+1;
        for i:=1 to RowCount-1 do
          begin
            Cells[0,i]:=IntToStr(i)+'Ԗ';
            readln(inf,s);     //    f[^̓ǂݍ
            Cells[1,i]:=s;
            readln(inf,s);
            Cells[2,i]:=s;
          end;
      end;

    CloseFile(inf);
end;

procedure TForm1.PButtonClick(Sender: TObject);
var   pout : TextFile;
      i    : Longint;
begin
      with printer do
        begin
          AssignPrn(pout);
          Rewrite(pout);

          with Canvas.Font do
            begin
                Name:='lr ';
                size:=16;
            end;

          writeln(pout);
          writeln(pout,'Pϐ = ',EditXLabel.Text);
          writeln(pout,'Qϐ = ',EditYLabel.Text);
          writeln(pout);
          writeln(pout,'Data =');

          with StringGrid1 do
            for i:=1 to RowCount-1 do
              writeln(pout,i:5,'   ',Cells[1,i],'    ',Cells[2,i]);

          CloseFile(pout);
        end;
end;

end.