unit U2SIndep;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, StdCtrls;

type
  TForm1 = class(TForm)
    StringGridX: TStringGrid;
    AddXButton: TButton;
    ExitButton: TButton;
    DelXButton: TButton;
    MsgLabel: TLabel;
    CalcButton: TButton;
    SaveButton: TButton;
    LoadButton: TButton;
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    PButton: TButton;
    Label1: TLabel;
    EditXLabel: TEdit;
    Label2: TLabel;
    EditYLabel: TEdit;
    StringGridY: TStringGrid;
    AddYButton: TButton;
    DelYButton: TButton;
    PrintDialog1: TPrintDialog;
    procedure ExitButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure AddXButtonClick(Sender: TObject);
    procedure AddYButtonClick(Sender: TObject);
    procedure DelXButtonClick(Sender: TObject);
    procedure DelYButtonClick(Sender: TObject);
    procedure CalcButtonClick(Sender: TObject);
    procedure SaveButtonClick(Sender: TObject);
    procedure LoadButtonClick(Sender: TObject);
    procedure PButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses  Printers;

procedure TForm1.ExitButtonClick(Sender: TObject);
begin
           Close;
end;


procedure TForm1.FormCreate(Sender: TObject);
var sel : TGridRect;      //  IZ̈ʒu\킷߂̌^
begin
    with StringGridX do
      begin
          ColCount:=2;                      //  
          ColWidths[1]:=Width-ColWidths[0]; //  ̕
          RowCount:=2;                      //  s
          Font.Height:=16;
          Cells[0,1]:='1Ԗ';
          Cells[1,0]:='   X  =';
          Options:=Options-[goRangeSelect];  //  PZ̑I
          with sel do                        //  Z̈ʒu
            begin  Left:=1; Top:=1; Right:=1; Bottom:=1;  end;
          Selection:=sel;                    //  IZ̐ݒ
          Options:=[goEditing]+Options;      //  ZҏW
          EditorMode:=true;                  //  ZҏW
      end;
    with StringGridY do
      begin
          ColCount:=2;                      //  
          ColWidths[1]:=Width-ColWidths[0]; //  ̕
          RowCount:=2;                      //  s
          Font.Height:=16;
          Cells[0,1]:='1Ԗ';
          Cells[1,0]:='   Y  =';
          Options:=Options-[goRangeSelect];  //  PZ̑I
          with sel do                        //  Z̈ʒu
            begin  Left:=1; Top:=1; Right:=1; Bottom:=1;  end;
          Selection:=sel;                    //  IZ̐ݒ
          Options:=[goEditing]+Options;      //  ZҏW
          EditorMode:=true;                  //  ZҏW
      end;
    EditXLabel.Text:='wϐ';
    EditYLabel.Text:='xϐ';
    MsgLabel.Caption:='';
end;


(*           s̒ǉ          *)
procedure TForm1.AddXButtonClick(Sender: TObject);
var   i, pos : Longint;
begin
      with StringGridX do
        begin
            pos:=Selection.top;
            RowCount:=RowCount+1;
            Cells[0,RowCount-1]:=IntToStr(RowCount-1)+'Ԗ';
            Cells[1,RowCount-1]:=' ';
            if (0 < pos) and (pos < RowCount-2) then
              begin
                for i:=RowCount-1 downto pos+2 do
                  Cells[1,i]:=Cells[1,i-1];

                Cells[1,pos+1]:=' ';
              end;
        end;
end;

procedure TForm1.AddYButtonClick(Sender: TObject);
var   i, pos : Longint;
begin
      with StringGridY do
        begin
            pos:=Selection.top;
            RowCount:=RowCount+1;
            Cells[0,RowCount-1]:=IntToStr(RowCount-1)+'Ԗ';
            Cells[1,RowCount-1]:=' ';
            if (0 < pos) and (pos < RowCount-2) then
              begin
                for i:=RowCount-1 downto pos+2 do
                  Cells[1,i]:=Cells[1,i-1];

                Cells[1,pos+1]:=' ';
              end;
        end;
end;

(*          s̍폜           *)
procedure TForm1.DelXButtonClick(Sender: TObject);
var pos, i : Longint;
begin
    with StringGridX do
      begin
        pos:= Selection.top;     //  Is̐ݒ

        //   Z̒l̈ړ
        if (0 < pos) and (pos < RowCount-1) then
            for i:=pos to RowCount-2 do
              Cells[1,i]:=Cells[1,i+1];

           //   Ō̍s폜
        if 0 < pos then
          if RowCount > 2 then RowCount:=RowCount-1;
      end;
end;

procedure TForm1.DelYButtonClick(Sender: TObject);
var pos, i : Longint;
begin
    with StringGridY do
      begin
        pos:= Selection.top;     //  Is̐ݒ

        //   Z̒l̈ړ
        if (0 < pos) and (pos < RowCount-1) then
            for i:=pos to RowCount-2 do
              Cells[1,i]:=Cells[1,i+1];

           //   Ō̍s폜
        if 0 < pos then
          if RowCount > 2 then RowCount:=RowCount-1;
      end;
end;

var x, y : array of Extended;  //   f[^i[pz

procedure TForm1.CalcButtonClick(Sender: TObject);
var  outf : TextFile;
     nx, ny, i : Longint;
     sx, sy, MeanX, MeanY, sxx, syy, SDX, SDY,
     SDDxy, t : Extended;
begin
     MsgLabel.Caption:='vZn߂܂';
     UpDate;

     with StringGridX do
       begin
         nx:=RowCount-1;   //   f[^̐ݒ
         SetLength(x,nx+1);
         try
           for i:=1 to nx do
             x[i]:=StrToFloat(Cells[1,i]);  //   f[^z֐ݒ
         except                             //   sȃf[^
           ShowMessage('Error ===>  Cells[1,'+IntToStr(i)+'] = '
                        +Cells[1,i]);
           Exit;   //   ̎葱̏I
         end;
       end;

     with StringGridY do
       begin
         ny:=RowCount-1;   //   f[^̐ݒ
         SetLength(y,ny+1);
         try
           for i:=1 to ny do
             y[i]:=StrToFloat(Cells[1,i]);
         except                             //   sȃf[^
           ShowMessage('Error ===>  Cells[1,'+IntToStr(i)+'] = '
                        +Cells[1,i]);
           Exit;   //   ̎葱̏I
         end;
       end;

    with OpenDialog1 do
      begin
        Title:='vZʂ̏o͗pt@C';
        FileName:='';
        if not Execute then exit;
        AssignFile(outf,FileName);
        Rewrite(outf);
      end;

    MsgLabel.Caption:='vZn߂܂';
    UpDate;

    writeln(outf);
    writeln(outf,'Pϐ ==> ',EditXLabel.Text);
    writeln(outf);

    writeln(outf, 'f[^ =');
    for i:=1 to nx do
      writeln(outf,'      x[', i, '] = ',
                    FloatToStrF(x[i],ffGeneral,9,1));

    writeln(outf);
    writeln(outf,'Qϐ ==> ',EditYLabel.Text);
    writeln(outf);
    writeln(outf, 'f[^ =');
    for i:=1 to ny do
      writeln(outf,'      y[', i, '] = ',
                    FloatToStrF(y[i],ffGeneral,9,1));

    sx:=0.0;
    for i:=1 to nx do sx:=sx+x[i];        //  x[i]̘a
    MeanX:=sx/nx;                         //  x[i]̕
    sy:=0.0;
    for i:=1 to ny do sy:=sy+y[i];        //  y[i]̘a
    MeanY:=sy/ny;                         //  y[i]̕

    sxx:=0.0;
    for i:=1 to nx do
      sxx:=sxx+sqr(x[i]-MeanX);           //  x[i]-MeanX̂Qa
    SDX:=sqrt(sxx/nx);                    //  x[i]̕W΍
    syy:=0.0;
    for i:=1 to ny do
      syy:=syy+sqr(y[i]-MeanY);           //  y[i]-MeanŶQa
    SDY:=sqrt(syy/ny);                    //  y[i]̕W΍

    writeln(outf);
    writeln(outf, 'X̕     = ', FloatToStrF(MeanX,ffGeneral,9,1));
    writeln(outf, 'X̕U     = ', FloatToStrF(sxx/nx,ffGeneral,9,1));
    writeln(outf, 'X̕W΍ = ', FloatToStrF(SDX,ffGeneral,9,1));
    writeln(outf, 'X̕sΕU = ', FloatToStrF(sxx/(nx-1),ffGeneral,9,1));
    writeln(outf, 'X̕sΕU̕ = ',
                   FloatToStrF(sqrt(sxx/(nx-1)),ffGeneral,9,1));
    writeln(outf);
    writeln(outf, 'Y̕     = ', FloatToStrF(MeanY,ffGeneral,9,1));
    writeln(outf, 'Y̕U     = ', FloatToStrF(syy/ny,ffGeneral,9,1));
    writeln(outf, 'Y̕W΍ = ', FloatToStrF(SDY,ffGeneral,9,1));
    writeln(outf, 'Y̕sΕU = ', FloatToStrF(syy/(ny-1),ffGeneral,9,1));
    writeln(outf, 'Y̕sΕU̕ = ',
                   FloatToStrF(sqrt(syy/(ny-1)),ffGeneral,9,1));

    SDDxy:=sqrt((nx*sqr(SDX)+ny*sqr(SDY))*((1/nx)+(1/ny))/(nx+ny-2));
    t:=(MeanX-MeanY)/SDDxy;                //  ťvZ

    writeln(outf);
    writeln(outf, 't = ', FormatFloat('0.000', t),
                     '    Rx = ', nx+ny-2);

    CloseFile(outf);
    Finalize(x);
    Finalize(y);
    MsgLabel.Caption:='vZI܂';
    ExitButton.SetFocus;
end;

(*    Obhɐݒ肳Ăf[^̕ۑ    *)
procedure TForm1.SaveButtonClick(Sender: TObject);
var outf : TextFile;
    i : Longint;
begin
    with SaveDialog1 do        //   ۑpt@C̖O̐ݒ
      begin
          Title:='t@C';
          FileName:='';
          if not Execute then exit;
          AssignFile(outf,FileName);
      end;

    Rewrite(outf);            //  t@Copɐݒ

    writeln(outf,EditXLabel.Text);
    with StringGridX do
      begin
        writeln(outf,RowCount-1);    //  f[^̏o
        for i:=1 to RowCount-1 do
          writeln(outf, Cells[1,i]); //  f[^̏o
      end;

    writeln(outf,EditYLabel.Text);
    with StringGridY do
      begin
        writeln(outf,RowCount-1);    //  f[^̏o
        for i:=1 to RowCount-1 do
          writeln(outf, Cells[1,i]); //  f[^̏o
      end;

    CloseFile(outf);
end;

(*    t@CObhփf[^ǂݍ    *)
procedure TForm1.LoadButtonClick(Sender: TObject);
var inf : TextFile;
    v, i   : Longint;
    s      : string;
begin
    with OpenDialog1 do           //  t@C̐ݒ
      begin
          Title:='t@C';
          if not Execute then exit;
          AssignFile(inf,FileName);
      end;

    Reset(inf);                  //   t@Cǂݏopɐݒ

    readln(inf,s); EditXLabel.Text:=s;
    with StringGridX do
      begin
        readln(inf,v);          //   f[^̓ǂݍ
        RowCount:=v+1;
        for i:=1 to RowCount-1 do
          begin
            Cells[0,i]:=IntToStr(i)+'Ԗ';
            readln(inf,s);     //    f[^̓ǂݍ
            Cells[1,i]:=s;
          end;
      end;

    readln(inf,s); EditYLabel.Text:=s;
    with StringGridY do
      begin
        readln(inf,v);          //   f[^̓ǂݍ
        RowCount:=v+1;
        for i:=1 to RowCount-1 do
          begin
            Cells[0,i]:=IntToStr(i)+'Ԗ';
            readln(inf,s);     //    f[^̓ǂݍ
            Cells[1,i]:=s;
          end;
      end;

    CloseFile(inf);
end;

procedure TForm1.PButtonClick(Sender: TObject);
var   pout : TextFile;
      i    : Longint;
begin
      PrintDialog1.execute;
      with printer do
        begin
          AssignPrn(pout);
          Rewrite(pout);

          with Canvas.Font do
            begin
                Name:='lr ';
                size:=16;
            end;

          writeln(pout);
          writeln(pout,'Pϐ = ',EditXLabel.Text);
          writeln(pout);
          writeln(pout,'Data =');
          with StringGridX do
            for i:=1 to RowCount-1 do
              writeln(pout,i:5,':   ',Cells[1,i]);

          writeln(pout);
          writeln(pout,'Qϐ = ',EditYLabel.Text);
          writeln(pout);
          writeln(pout,'Data =');
            with StringGridY do
            for i:=1 to RowCount-1 do
              writeln(pout,i:5,':   ',Cells[1,i]);

          CloseFile(pout);
        end;
end;

end.