unit UCalcFactorFromR;     //   Yasuharu Okamoto

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TFCalcFctr = class(TForm)
    MsgLabel: TLabel;
    OKButton: TButton;
    ExitButton: TButton;
    Label1: TLabel;
    NFactorEdit: TEdit;
    Label2: TLabel;
    ComboBox1: TComboBox;
    procedure ExitButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  FCalcFctr: TFCalcFctr;

implementation

{$R *.DFM}

uses  UCalcFromRawData;

{$R+}

var  CkInFile, CkOutFile : Boolean;

procedure TFCalcFctr.ExitButtonClick(Sender: TObject);
begin
            Close;
end;

procedure TFCalcFctr.FormCreate(Sender: TObject);
begin
            Position :=poScreenCenter;
            CkInFile :=False;
            CkOutFile:=False;
            NFactorEdit.Text:='1';
            with ComboBox1 do
              begin
                  items.Add('@}bNX]');
                  items.Add('v}bNX] (r=3)');
                  items.Add('v}bNX] (r=4)');
                  itemIndex:=0;
              end;
end;

procedure TFCalcFctr.FormActivate(Sender: TObject);
begin
      MsgLabel.Caption:='OKNbNĉ';

      OKButton.SetFocus;
end;

 
const  NVar  = 50;
type   TMatInv = array[1..NVar,1..NVar] of Extended;

//{$i  MatInv.inc   }


type    svd_mat = TMatInv;
        svd_vctr = array[1..NVar] of Extended;


//{$i  SVD.inc      }

//{$i  VariMax.inc  }

//{$i  Promax.inc   }

const NCase = 2000;


procedure TFCalcFctr.OKButtonClick(Sender: TObject);
Label QP, QP1, QP2, QR, QEnd;

var   infl, outfl : TextFile;
      p, NL, m, nv0, nv1, i, j, j1, j2, j3, j4,
      ECode, NEigen : Longint;
      v, SumContri, CSumContri : Extended;
      mean, SumX, commu, commu1, Lambda, Contri : svd_vctr;
      R, InvR, SigmaT, Eigen_vctr,
      FctrLdng, Phi : TMatInv;
      CkRd, CkConv : Boolean;
      SData : string;

  function LVar( i, w : Longint ) : string;
    var s : string;
        L, h : Longint;
    begin
        Str(i, s);  s:='Var'+s;
        L:=Length(s);
        for h:=1 to w-L do s:=s+' ';
        LVar:=s;
    end;

  function Min( a, b : Longint ) : Longint;
    begin
      if a <= b then Min:=a
                else Min:=b;
    end;

  procedure Sort( NEigen         : Longint;
                  var Lambda     : svd_vctr;
                  var eigen_vctr : TMatInv );
    var i, j, h : Longint;

    procedure Swap( var a, b : Extended  );
      var v : Extended;
      begin
          v:=a; a:=b; b:=v;
      end;

    begin
      if NEigen > 1 then
        for i:=1 to NEigen-1 do
          begin
            h:=i;
            for j:=i+1 to NEigen do
              if Lambda[h] < Lambda[j] then h:=j;
            if i < h then
              begin
                Swap(Lambda[h],Lambda[i]);
                for j:=1 to p do
                  Swap(eigen_vctr[j,i],eigen_vctr[j,h]);
              end;
          end;
    end;


begin
    OKButton.Enabled:=False;
    MsgLabel.Caption:='vZł';
    UpDate;

    m:=StrToInt(NFactorEdit.Text);
    p:=nvars;
    for i:=1 to p do
      for j:=1 to p do
        R[i,j]:=cor[i,j];
 {
    writeln(outf); writeln(outf);
    writeln(outf,'Correlation Data...');
    writeln(outf);
    j1:=1;
    while true do
      begin
        j2:=j1+6;
        if j2 > p then j2:=p;
        write(outf,'          ');
        for j4:=j1 to j2 do write(outf, LVar(j4, 10));
        writeln(outf);
        for j3:=1 to p do
          begin
            write(outf, LVar(j3,5));
            for j4:=j1 to j2 do write(outf, R[j3,j4]:10:5);
            writeln(outf);
          end;
        if j2 >= p then goto QP2;
        j1:=j2+1;
        writeln(outf);
        writeln(outf);
      end;
 QP2 : ;            }

 (*-----------------------------------------------------

        Initial Value for Communalities

  ------------------------------------------------------*)
//    Mat_Inv_Gauss( R, InvR, p, ECode );
    if ECode = 0
      then
        for i:=1 to p do
          commu[i]:=1-1/InvR[i,i]
      else
        begin
          writeln(outf);
          writeln(outf,'Inversion of R failed.');
          for i:=1 to p do
            begin
              v:=0.0;
              for j:=1 to p do
                if j <> i then
                  if v < abs(R[i,j])
                    then v:=abs(R[i,j]);
              commu[i]:=v;
            end;
        end;
    writeln(outf,^L);
    writeln(outf);
    writeln(outf);
    writeln(outf,'Initial Values of Communalities');
    writeln(outf);
    for i:=1 to p do
      writeln(outf, '          ',LVar(i,7), commu[i]:10:5);


    {   Calculation of Factor Loading   }

    MsgLabel.Caption:='Calculating Factor Loading';
    UpDate;
    SigmaT:=R;
    for i:=1 to p do SigmaT[i,i]:=commu[i];

//    QL_decomp_1( SigmaT, p, p, NEigen, Lambda, eigen_vctr );
    if m > NEigen then
      begin
          writeln(outf);
          writeln(outf,'Too Many Factors are Required (m = ', m, ')');
          m:=NEigen;
          writeln(outf,'New value of m is set to be ', m);
      end;
    Sort( NEigen, Lambda, eigen_vctr );

    writeln(outf);
    writeln(outf);
    writeln(outf,'Initial Values of Eigen Values');
    writeln(outf);
    for i:=1 to NEigen do
      writeln(outf,'               ', i:3, '   ',
                    Lambda[i]:9:5 );

    CkConv:=False;
    for i:=1 to p do
      begin
        v:=0.0;
        for j:=1 to m do
          v:=v+Lambda[j]*sqr(eigen_vctr[i,j]);
        commu[i]:=v;
      end;
    repeat
         SigmaT:=R;
         for i:=1 to p do SigmaT[i,i]:=commu[i];
//         QL_decomp_1( SigmaT, p, p, NEigen, Lambda, eigen_vctr );
         if m > NEigen then
           begin
               writeln(outf);
               writeln(outf,'Too Many Factors are Required (m = ', m, ')');
               m:=NEigen;
               writeln(outf,'New value of m is set to be ', m);
           end;
         Sort( NEigen, Lambda, eigen_vctr );
         commu1:=commu;
         for i:=1 to p do
           begin
             v:=0.0;
             for j:=1 to m do
               v:=v+Lambda[j]*sqr(eigen_vctr[i,j]);
             commu[i]:=v;
           end;
         v:=0.0;
         for i:=1 to p do
           v:=v+abs(commu1[i]-commu[i]);
         if v < (p*(1.0E-9)) then CkConv:=True;  
    until CkConv;

    writeln(outf,^L);
    writeln(outf);
    writeln(outf,'Factor Loadings...');
    writeln(outf);
    for i:=1 to p do
      begin
        write(outf, '     ', LVar(i, 7));
        for j:=1 to m do
          begin
            FctrLdng[i,j]:=eigen_vctr[i,j]*sqrt(Lambda[j]);
            write(outf,FctrLdng[i,j]:10:5);
          end;
        writeln(outf);
      end;
    SumContri:=0.0;
    for j:=1 to m do
      begin
        Contri[j]:=0.0;
        for i:=1 to p do
          Contri[j]:=Contri[j]+sqr(FctrLdng[i,j]);
        SumContri:=SumContri+Contri[j];
      end;
    writeln(outf);
    write(outf,'      ^  ');
    for j:=1 to m do
      write(outf,Contri[j]:10:5);
    writeln(outf);
    write(outf,'    ^   ');
    for j:=1 to m do
      write(outf,100*Contri[j]/SumContri:9:1,'%');
    writeln(outf);
    write(outf,'ݐϊ^   ');
    CSumContri:=0.0;
    for j:=1 to m do
      begin
        CSumContri:=CSumContri+Contri[j];
        write(outf,100*CSumContri/SumContri:9:1,'%');
      end;
    writeln(outf);

    writeln(outf);
    writeln(outf,'communality...');
    writeln(outf);
    for i:=1 to p do
      begin
        write(outf, '     ', LVar(i, 7), ' ==> ');
        v:=0.0;
        for j:=1 to m do
          v:=v+sqr(FctrLdng[i,j]);
        writeln(outf,v:10:5);
      end;

    writeln(outf); writeln(outf);
    MsgLabel.Caption:='Rotating Factors';
    UpDate;
    writeln(outf);
    writeln(outf);
    case ComboBox1.ItemIndex of
          0 : begin
                  writeln(outf,'@}bX]s܂');
          //        VariMax(FctrLdng, p, m, Contri );
              end;
          1 : begin
                  writeln(outf,'v}bNX] (r=3) s܂');
       //           ProMax( FctrLdng, p, m, 3 { = r }, Phi );
                  writeln(outf);
                  writeln(outf,'q֍s =');
                  writeln(outf);
                  for i:=1 to m do
                    begin
                      for j:=1 to m do
                        write(outf,Phi[i,j]:10:5);
                      writeln(outf);
                    end;
              end;
          2 : begin
                  writeln(outf,'v}bNX] (r=4) s܂');
       //           ProMax( FctrLdng, p, m, 4 { = r }, Phi );
                  writeln(outf);
                  writeln(outf,'q֍s =');
                  writeln(outf);
                  for i:=1 to m do
                    begin
                      for j:=1 to m do
                        write(outf,Phi[i,j]:10:5);
                      writeln(outf);
                    end;
              end;
         else
              begin
                  writeln(outf,'Factor rotation was not performed.');
                  for j:=1 to m do
                    begin
                      v:=0.0;
                      for i:=1 to p do
                        v:=v+sqr(FctrLdng[i,j]);
                      Contri[j]:=v;  
                    end;
              end;
    end;

    writeln(outf);
    writeln(outf);
    writeln(outf,'Factor Loadings...');
    writeln(outf);
    for i:=1 to p do
      begin
        write(outf, '     ', LVar(i, 7));
        for j:=1 to m do
          write(outf,FctrLdng[i,j]:10:5);
        writeln(outf);
      end;
    writeln(outf);

    if ComboBox1.ItemIndex = 0 then
      begin
        write(outf,'      ^  ');
        for j:=1 to m do
          write(outf,Contri[j]:10:5);
        writeln(outf);
      end;

    CloseFile(outf);

  QEnd : ;
    MsgLabel.Caption:='vZI';
end;



end.