unit UCalcFromCov;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TFRdCov = class(TForm)
    MsgLabel: TLabel;
    OKButton: TButton;
    ExitButton: TButton;
    OpenDialog1: TOpenDialog;
    procedure ExitButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  FRdCov: TFRdCov;

implementation

{$R *.DFM}

uses Printers, UCalcAlpha;

{$R+}

var InFlNm, OutFlNm : string;

procedure TFRdCov.ExitButtonClick(Sender: TObject);
begin
            Close;
end;

procedure TFRdCov.FormActivate(Sender: TObject);
begin
      MsgLabel.Caption:='OKNbNĉ';
      OKButton.SetFocus;
end;

 
const  NVar  = 50;
type   TMat = array[1..NVar,1..NVar] of Extended;


procedure TFRdCov.OKButtonClick(Sender: TObject);
Label QP, QP1, QP2, QR, QEnd;

var   infl, outfl : TextFile;
      p, NL, nv0, nv1, i, j, j1, j2, j3, j4 : Longint;
      VarT, VarX, CAlpha : extended;
      Cov : TMat;
      CkRd : Boolean;
      SData : string;

  function LVar( i, w : Longint ) : string;
    var s : string;
        L, h : Longint;
    begin
        Str(i, s);  s:='Var'+s;
        L:=Length(s);
        for h:=1 to w-L do s:=s+' ';
        LVar:=s;
    end;

  function Min( a, b : Longint ) : Longint;
    begin
      if a <= b then Min:=a
                else Min:=b;
    end;

begin
    with OpenDialog1 do
      begin
          Title:='̓f[^t@C';
          FileName:='';
          if not execute then exit;
          InFlNm:=FileName;

          Title:='o̓t@C';
          FileName:='';
          if not execute then exit;
          OutFlNm:=FileName;
      end;

    OKButton.Enabled:=False;
    MsgLabel.Caption:='vZł';
    UpDate;

    AssignFile(infl,InFlNm);
    Reset(infl);
    AssignFile(outfl,OutFlNm);
    Rewrite(outfl);
    writeln(outfl,'Input Data...',InFlNm);
    writeln(outfl);
    writeln(outfl);

    CkRd:=False;
    repeat
          readln(infl, SData);
          if length(SData) > 1 then
            if Copy(SData,1,2) = '*/' then CkRd:=True;
    until CkRd;

    readln(infl, p, NL);
    if NL > p then NL:=p;
    nv1:=0;
    while true do
      begin
        nv0:=nv1+1;
        if nv0 > p then goto QR;
        nv1:=nv0+NL-1;
        if nv1 > p then nv1:=p;

        CkRd:=False;
        repeat
              readln(infl, SData);
              if length(SData) > 1 then
                if Copy(SData,1,2) = '*/' then CkRd:=True;
        until CkRd;

        for i:=nv0 to p do
          begin
            for j:=nv0 to Min(i,nv1) do
              read(infl, Cov[i,j]);
            readln(infl);
          end;
      end;
  QR : ;
    CloseFile(infl);

    for i:=2 to p do
      for j:=1 to i-1 do Cov[j,i]:=Cov[i,j];

    writeln(outfl); writeln(outfl);
    writeln(outfl,'Us...');
    writeln(outfl);
    j1:=1;
    while true do
      begin
        j2:=j1+6;
        if j2 > p then j2:=p;
        write(outfl,'          ');
        for j4:=j1 to j2 do write(outfl, LVar(j4, 10));
        writeln(outfl);
        for j3:=1 to p do
          begin
            write(outfl, LVar(j3,5));
            for j4:=j1 to j2 do write(outfl, Cov[j3,j4]:10:5);
            writeln(outfl);
          end;
        if j2 >= p then goto QP2;
        j1:=j2+1;
        writeln(outfl);
        writeln(outfl);
      end;
 QP2 : ;


    VarT:=0.0;  VarX:=0.0;
    for i:=1 to p do
      for j:=1 to p do
        begin
          VarX:=VarX+cov[i,j];
          if i <> j then VarT:=VarT+cov[i,j];
        end;

    CAlpha:=(p/(p-1))*(VarT/VarX);
    writeln(outfl);
    writeln(outfl);
    writeln(outfl,'NobÑW =', CAlpha:9:5);    

    CloseFile(outfl);

  QEnd : ;

    Form1.Close;
end;


end.