unit UCalcFromRawData;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, StdCtrls;

type
  TFRdRawDt = class(TForm)
    StringGrid1: TStringGrid;
    AddRowButton: TButton;
    ExitButton: TButton;
    DelRowButton: TButton;
    CalcButton: TButton;
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    PButton: TButton;
    AddColButton: TButton;
    DelColButton: TButton;
    RdTxtButton: TButton;
    RdCSVButton: TButton;
    OutCSVButton: TButton;
    procedure ExitButtonClick(Sender: TObject);
    procedure DelRowButtonClick(Sender: TObject);
    procedure CalcButtonClick(Sender: TObject);
    procedure PButtonClick(Sender: TObject);
    procedure DelColButtonClick(Sender: TObject);
    procedure AddRowButtonClick(Sender: TObject);
    procedure AddColButtonMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure RdTxtButtonClick(Sender: TObject);
    procedure RdCSVButtonClick(Sender: TObject);
    procedure OutCSVButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  FRdRawDt: TFRdRawDt;

var
  outf : TextFile;
  cor  : array of array of Extended;
  LVar : array of string;
  nvars : Longint;



implementation

{$R *.DFM}

uses
  Printers, USelOutDev, UCalcAlpha;

procedure TFRdRawDt.ExitButtonClick(Sender: TObject);
begin
           Close;
end;


(*           f[^̒ǉ          *)
procedure TFRdRawDt.AddRowButtonClick(Sender: TObject);
var   i, j, pos : Longint;
begin
      //  NbNꂽZ̉Ƀf[^sǉ
    with StringGrid1 do
      begin
          pos:=Selection.top;     //  NbNꂽZ̈ʒu

          if (0 < pos) and (pos < RowCount) then
            begin
              RowCount:=RowCount+1;   //  s𑝂₷

              if pos < RowCount-2 then
                for i:=RowCount-1 downto pos+2 do
                  for j:=1 to ColCount-1 do
                    begin
                      Cells[j,i]:=Cells[j,i-1];      //  f[^Ɉړ
                    end;

              for j:=1 to ColCount-1 do
                Cells[j,pos+1]:=' ';            //  s̑}ʒu󔒂ɂ

              if pos > 1
                then
                  for i:=pos to RowCount-1 do
                    Cells[0,i]:=IntToStr(i-1)+'Ԗ'
                else
                  for i:=2 to RowCount-1 do
                    Cells[0,i]:=IntToStr(i-1)+'Ԗ';
            end;
      end;
end;

(*         ϐ̒ǉ        *)
procedure TFRdRawDt.AddColButtonMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var   i, j, pos : Longint;
begin
      with StringGrid1 do
        begin
            pos:=Selection.Left;
            ColCount:=ColCount+1;
            for j:=1 to ColCount-1 do
              Cells[j,0]:='ϐ '+IntToStr(j);
            for i:=1 to RowCount-1 do
              Cells[ColCount-1,i]:=' ';

            if ([ssShift,ssCtrl] * Shift) <> []
              then        //  ShiftL[ACtrlL[ĂƂ
                begin     //  擪ɗPϐƂđ}
                  for i:=ColCount-1 downto 2 do
                  for j:=1 to RowCount-1 do
                    Cells[i,j]:=Cells[i-1,j];

                  for j:=1 to RowCount-1 do
                    Cells[1,j]:=' ';
                end
              else       //  NbNꂽ̉Eɗ}
                if (0 < pos) and (pos < ColCount-2) then
                  begin
                    for i:=ColCount-1 downto pos+2 do
                      for j:=1 to RowCount-1 do
                        Cells[i,j]:=Cells[i-1,j];

                    for j:=1 to RowCount-1 do
                      Cells[pos+1,j]:=' ';
                  end;
        end;
end;

(*          f[^̍폜           *)
procedure TFRdRawDt.DelRowButtonClick(Sender: TObject);
var pos, i, j : Longint;
begin
    with StringGrid1 do
      if RowCount > 3 then
        begin
          pos:= Selection.top;     //  폜s̐ݒ

          if (1 < pos) and (pos < RowCount) then
            begin                        
              //   Z̒l̈ړ
              if pos < RowCount-1 then
                for i:=pos to RowCount-2 do
                  for j:=1 to ColCount-1 do
                    Cells[j,i]:=Cells[j,i+1];

              //   Ō̍s폜
              RowCount:=RowCount-1;

              for i:=2 to RowCount-1 do
                Cells[0,i]:=IntToStr(i-1)+'Ԗ';
            end;
        end;
end;

(*      ̍폜      *)
procedure TFRdRawDt.DelColButtonClick(Sender: TObject);
var pos, i, j : Longint;
begin
    with StringGrid1 do
      begin
        if ColCount > 2 then
          begin
            pos:= Selection.Left;     //  폜̐ݒ

            //   Z̒l̈ړ
            if (0 < pos) and (pos < ColCount-1) then
                for i:=pos to ColCount-2 do
                  for j:=1 to RowCount-1 do
                    Cells[i,j]:=Cells[i+1,j];

            //   Ō̗폜
            ColCount:=ColCount-1;

            for i:=1 to ColCount-1 do
              Cells[i,0]:='ϐ '+IntToStr(i);
          end;
      end;
end;

//   ֌W̌vZ
procedure TFRdRawDt.CalcButtonClick(Sender: TObject);
var      a, n, i, j, k, spos, epos  : Longint;
         v, VarT, VarX, CAlpha : Extended;
         x, cov : array of array of Extended;
         mean : array of Extended;

  function SetStr( s : string;  L : Longint ) : string;
    var i, L0 : Longint;
    begin
        L0:=Length(s);
        if L0 < L then
          for i:=1 to L-L0 do s:=' '+s;
        SetStr:=s;
    end;

  function Min( i, j : Longint ) : Longint;
    begin
        if i < j then Min:=i
                 else Min:=j;
    end;

begin
    with StringGrid1 do
      begin
        n:=RowCount-2;             //   f[^̐ݒ
        a:=Colcount-1;             //   ϐ̐
        SetLength(x,n+1,a+1);      //   f[^li[pz
        SetLength(mean, a+1);      //   ϒli[pz
        SetLength(cov,  a+1, a+1); //   Uspz
        SetLength(cor,  a+1, a+1); //   ֍spz
        SetLength(LVar, a+1);      //   ϐxpz

        for i:=1 to a do           //   ϐx̐ݒ
          LVar[i]:=Cells[i,1];
        try
          for i := 1 to n do       //  f[^̐ݒ
              for j := 1 to a do
                x[i, j]:=StrToFloat(Trim(Cells[j,i+1]));
        except                             //   sȃf[^
          ShowMessage('f[^EG[ ===> '+
                      IntToStr(i)+' Ԗ - '+
                      ' '+IntToStr(j)+' ϐ  ===> '+Cells[j,i+1]);

          Exit;      //   ̎葱̏I
        end;
      end;

    //   o̓t@C̐ݒ
    with OpenDialog1 do
      begin
        Title:='vZʂ̏o͗pt@C';
        filter:='';
        FileName:='';
        Execute;
        AssignFile(outf,FileName);
        Rewrite(outf);
      end;

    (*    f[^̏o   *)

    writeln(outf, 'ϐ =');
    for i := 1 to a do
      writeln(outf, '      ϐ ',i, ' ==> ',LVar[i]);
    nvars:=a;

    writeln(outf);
    spos:=1;
    repeat
      writeln(outf);
      epos:=spos+6;
      if epos > a then epos:=a;
      write(outf,'     ');
      for i:=spos to epos do
        write(outf, SetStr('ϐ '+IntToStr(i),10));
      writeln(outf);

      for i:=1 to n do
        begin
          write(outf,i:4, ' ');
          for j:=spos to epos do
            write(outf, SetStr(FloatToStrF(x[i,j],ffGeneral,9,1),10) );
          writeln(outf);
        end;

      spos:=epos+1;
    until spos > a;

    //  ϒľvZ
    for i:=1 to a do
      begin
        v:=0.0;
        for j:=1 to n do v:=v+x[j,i];
        mean[i]:=v/n;
      end;

    writeln(outf);
    writeln(outf);
    writeln(outf,'ϒl ');
    spos:=1;
    repeat
      epos:=spos+4;
      if epos > a then epos:=a;
      writeln(outf);
      for i:=spos to epos do
        write(outf, SetStr(LVar[i],15));
      writeln(outf);
      for i:=spos to epos do
        write(outf, SetStr(FloatToStrF(mean[i],ffGeneral,9,1),15));
      writeln(outf);
      spos:=epos+1;
    until spos > a;

    //  ǓvZ
    for i:=1 to a do
      for j:=i to a do
        begin
          v:=0.0;
          for k:=1 to n do
            v:=v+(x[k,i]-mean[i])*(x[k,j]-mean[j]);
          cov[i,j]:=v/n;
          cov[j,i]:=cov[i,j];
        end;

    //  ֌W̌vZ
    for i:=1 to a do
      for j:=i to a do
        begin
          cor[i,j]:=cov[i,j]/sqrt(cov[i,i]*cov[j,j]);
          cor[j,i]:=cor[i,j];
        end;

    writeln(outf);
    writeln(outf);
    writeln(outf,'U ');
    spos:=1;
    repeat
      writeln(outf);
      epos:=spos+4;
      if epos > a then epos:=a;
      write(outf,SetStr(' ',15));
      for i:=spos to epos do write(outf, SetStr(LVar[i],15));
      writeln(outf);
      for i:=1 to a do
        begin
          write(outf,SetStr(LVar[i],15));
          for j:=spos to epos do
            write(outf,SetStr(FloatToStrF(cov[i,j],ffGeneral,9,1),15));
          writeln(outf);
        end;
      spos:=epos+1;
    until spos > a;

    writeln(outf);
    writeln(outf);
    writeln(outf,'֌W ');
    spos:=1;
    repeat
      writeln(outf);
      epos:=spos+4;
      if epos > a then epos:=a;
      write(outf,SetStr(' ',15));
      for i:=spos to epos do write(outf, SetStr(LVar[i],15));
      writeln(outf);
      for i:=1 to a do
        begin
          write(outf,SetStr(LVar[i],15));
          for j:=spos to epos do
            write(outf,SetStr(FloatToStrF(cor[i,j],ffFixed,12,7),15));
          writeln(outf);
        end;
      spos:=epos+1;
    until spos > a;

    VarT:=0.0;  VarX:=0.0;
    for i:=1 to a do
      for j:=1 to a do
        begin
          VarX:=VarX+cov[i,j];
          if i <> j then VarT:=VarT+cov[i,j];
        end;

    CAlpha:=(a/(a-1))*(VarT/VarX);
    writeln(outf);
    writeln(outf);
    writeln(outf,'NobÑW =', CAlpha:9:5);

    CloseFile(outf);

    Finalize(x);
    Finalize(mean);
    Finalize(cov);

    Form1.Close;
end;

//   v^A܂̓eLXgEt@Cւ̏o
procedure TFRdRawDt.PButtonClick(Sender: TObject);
var   pout : TextFile;
      ck    : Longint;

  //   ɋ󔒂tāA񂓂̒Lɂ
  function SetStr( s : string;   L : Longint ) : string;
    var i, L0 : Longint;
    begin
        L0:=Length(s);
        if L0 < L then
          for i:=1 to L-L0 do s:=' '+s;
        SetStr:=s;
    end;

  //  t@Cϐpoutւ̏o
  procedure WriteFile;
    var h, i, spos, epos : Longint;
    begin
          writeln(pout);
          writeln(pout);
          writeln(pout,'Data =');

          with StringGrid1 do
            begin
              spos:=1;
              repeat
                epos:=spos+4;
                if epos > (ColCount-1) then epos:=ColCount-1;
                writeln(pout);
                for h:=1 to RowCount-1 do
                  begin
                    if h > 1 then write(pout,(h-1):5,' ')
                             else write(pout,'      ');
                    for i:=spos to epos do
                      write(pout,SetStr(Cells[i,h],15));
                    writeln(pout);
                  end;
                spos:=epos+1;
              until spos > (ColCount-1);
            end;
    end;

begin
      ck:=SelOutDev;   //  o͐̐ݒ

      if ck = 1
        then             //  t@Cւ̏o
          begin
            with SaveDialog1 do
              begin
                Title:='t@C';
                FileName:='';
                Execute;
                AssignFile(pout,FileName);
              end;
            Rewrite(pout);

            WriteFile;

            CloseFile(pout);
          end
        else             //  v^ւ̏o
          with printer do
            begin
              AssignPrn(pout);
              Rewrite(pout);

              with Canvas.Font do
                begin
                    Name:='lr ';
                    size:=11;
                end;

              WriteFile;

              CloseFile(pout);
            end;
end;


//    ʏ̃eLXgt@C̃f[^͌`
procedure TFRdRawDt.RdTxtButtonClick(Sender: TObject);
var inf : TextFile;
    v   : Extended;
    s   : string;
    ck  : Boolean;
    a, n, i, j : Longint;
begin
    //   ̓t@C̐ݒ
    with OpenDialog1 do
      begin
          Title:='̓t@C';
          Filter:='';
          Execute;
          AssignFile(inf,FileName);
      end;
    Reset(inf);

    ck:=false;
    repeat
      readln(inf,s);
      if Length(s) > 1 then
        if Copy(s,1,2) = '*/' then ck:=true;  //  f[^*/̎̍s
    until ck;

    readln(inf, a);               //  ϐ̐
    with StringGrid1 do
      begin
        ColCount:=a+1;
        for i:=1 to a do
          Cells[i,0]:='ϐ '+IntToStr(i);
        for i:=1 to a do
          begin
              readln(inf,s);       //  ϐx̓ǂݍ
              Cells[i,1]:=s;
          end;

        ck:=false;
        n:=0;
        repeat
          readln(inf, v);         //  f[^̒ʂԍA̒lŏI
          if v < 0 then ck:=true
                   else n:=n+1;   //  f[^̌v
        until ck;
        CloseFile(inf);           //  ̓t@C

        RowCount:=n+2;
        for i:=1 to n do
          Cells[0,i+1]:=' '+IntToStr(i)+'Ԗ';

        //   ̓t@Cēxǂݍݒ
        AssignFile(inf,OpenDialog1.FileName);
        Reset(inf);
        ck:=false;
        repeat
          readln(inf,s);
          if Length(s) > 1 then
            if Copy(s,1,2) = '*/' then ck:=true;
        until ck;

        for i:=0 to a do readln(inf);   //  lf[^̐擪܂œǂݔ΂

        //  lf[^̓ǂݍ
        for i:=1 to n do
          begin
            read(inf,v);               //   ʂԍǂݔ΂
            for j:=1 to a do           //   ̕ϐǂݍ
              begin
                read(inf,v);
                Cells[j,i+1]:=FloatToStrF(v,ffGeneral,9,1);
              end;
            readln(inf);              //   ̍sɐi
          end;
      end;

    CloseFile(inf);
end;

//   CSV`t@C̓ǂݍ
procedure TFRdRawDt.RdCSVButtonClick(Sender: TObject);
type
    TSType = array of string;
var inf : TextFile;
    s   : string;
    s1  : TSType;
    a, i, j, NCol, NRow, pos : Longint;

  procedure SetStrings( s : string; s1 : TSType );
    var spos, epos, i : Longint;
    begin
        spos:=1;
        for i:=1 to a do
          begin
              epos:=spos;
              if i >= a
                then
                  begin
                    if epos > Length(s) then s1[i]:=''
                                        else s1[i]:=Copy(s,epos,
                                                         Length(s)-epos+1);
                  end
                else
                  begin
                    while (s[epos] <> ',')
                         and
                          (epos < Length(s))
                           do
                              epos:=epos+1;

                    if (epos >= Length(s)) and (s[epos] <> ',')
                      then raise Exception.Create
                            ('CSV format error...Data string = '+s);

                    if (epos-spos) <= 0 then s1[i]:=''
                                        else s1[i]:=Copy(s, spos, epos-spos);
                  end;



              spos:=epos+1;
          end;
    end;  {   SetStrings   }

begin
    //   ̓t@C̐ݒ
    with OpenDialog1 do
      begin
          Title:='̓t@C';
          OpenDialog1.Filter := 'CSV files (*.csv)|*.csv';
          Execute;
          AssignFile(inf,FileName);
      end;
    Reset(inf);

    readln(inf); readln(inf,s);
    NCol:=1;
    pos:=1;
    while pos <= Length(s) do
      begin
          if s[pos] = ',' then NCol:=NCol+1;
          pos:=pos+1;
      end;
    CloseFile(inf);

    AssignFile(inf, OpenDialog1.FileName);
    Reset(inf);

    a:=NCol;                  //  ϐ̐
    SetLength(s1,a+1);
    with StringGrid1 do
      begin
        ColCount:=a+1;
        for i:=1 to a do
          Cells[i,0]:='ϐ '+IntToStr(i);
        readln(inf, s);
        SetStrings( s, s1 );

        NRow:=2;
        RowCount:=NRow;
        for i:=1 to a do Cells[i,1]:=s1[i];



        //  lf[^̓ǂݍ
        i:=1;
        repeat
            readln(inf,s);               //   ʂԍǂݔ΂
            SetStrings(s,s1);
            NRow:=NRow+1;
            RowCount:=NRow;
            Cells[0,NRow-1]:=' '+IntToStr(i)+'Ԗ';
            for j:=1 to a do           //   ̕ϐǂݍ
                Cells[j,i+1]:=s1[j];
            i:=i+1;
        until eof(inf);
      end;

    Finalize(s1);
    CloseFile(inf);
end;

procedure TFRdRawDt.OutCSVButtonClick(Sender: TObject);  
var outf : TextFile;
    h, i, NVar, NData : Longint;
begin
    with SaveDialog1 do        //   ۑpt@C̖O̐ݒ
      begin
          Title:='t@C';
          Execute;
          AssignFile(outf,FileName);
      end;

    Rewrite(outf);            //  t@Copɐݒ

    with StringGrid1 do
      begin
        NVar :=ColCount-1;
        NData:=RowCount-2;
    
        for i:=1 to NVar do
          begin
              write(outf,Cells[i,1]);
              if i < NVar then write(outf, ',')
                          else writeln(outf);
          end;
        for h:=1 to NData do
          begin
            for i:=1 to NVar do
              begin
                  write(outf,Cells[i,h+1]);
                  if i < NVar then write(outf, ',')
                              else writeln(outf);
              end;
          end;
      end;

    CloseFile(outf);
end;

procedure TFRdRawDt.FormActivate(Sender: TObject);
var sel : TGridRect;      //  IZ̈ʒu\킷߂̌^
begin
    with StringGrid1 do
      begin
          ColCount:=3;                  //  ϐ̐̏l{P
          RowCount:=3;                  //  f[^̏l{Q
          with Font do
            begin Height:=16; Name:='lrSVbN'; end;
          with FRdRawDt.Canvas.Font do
            begin Height:=16; Name:='lrSVbN'; end;
          DefaultColWidth:=FRdRawDt.Canvas.TextWidth('XϐxX');
          Cells[0,1]:=' ϐx';
          Cells[0,2]:='1Ԗ';
          Cells[1,0]:='ϐ 1';
          Cells[2,0]:='ϐ 2';
          Options:=Options-[goRangeSelect];  //  PZ̑I
          with sel do                        //  Z̈ʒu
            begin  Left:=1; Top:=1; Right:=1; Bottom:=1;  end;
          Selection:=sel;                    //  IZ̐ݒ
          Options:=[goEditing]+Options;      //  ZҏW
          EditorMode:=true;                  //  ZҏW
      end;
end;

end.