
#ifndef MyRNKISS_CK
#define MyRNKISS_CK

#include <math.h>

#include "mylib.h"

namespace MyRNKISS {

/****************************************************************

            This C++ version was translated, 2007.10, 
			             from 
                 the Delphi version, 
      which was written by Yasuharu Okamoto, JWU, 2004.6.

	  The tranlated C++ version was subsequently modified
						  and
				  added needed members.

	 The period of KISS is of order 2 to the 95th power,
		i.e.  order of 10 to the 28th power
                   


                    The KISS Algorithm

              See   C.P.Robert and G.Casella
             "Monte Carlo Statistical Methods"
                 1999, Springer-Verlag
                         Pp. 39-43.

******************************************************************/

	class myrn {
    	private:
			unsigned __int32 i, j, k;

	    public:
			myrn();
			myrn( unsigned __int32 iv, unsigned __int32 jv, unsigned __int32 kv );
		    virtual ~myrn() { }; 

		    unsigned __int32 seek_i(){ return i;};
			unsigned __int32 seek_j(){ return j;};
			unsigned __int32 seek_k(){ return k;};

			void init();
			void init( unsigned __int32 iv, unsigned __int32 jv, unsigned __int32 kv );

			double uni();                             //   0.0 < uni()  <= 1.0
			double normal();                          //   Standard Normal Distribution
			double normalMS(double m, double s);      //    m : mean,   s : standard deviation  
			void   normalPair( double & n1, double & n2 );   //    pair of independent random numbers of  
			                                                 //             the standard normal distribution 




    };

	myrn::myrn() {
		i = 0x95555555;
		j = 0x56666666;
		k = 0x39999999;
	}

	myrn::myrn( unsigned __int32 iv, unsigned __int32 jv, unsigned __int32 kv ){
		i = iv;
		j = jv;
		k = kv;
	}


	void myrn::init(){
		i = 0x95555555;
		j = 0x56666666;
		k = 0x39999999;
	}


	void myrn::init( unsigned __int32 iv, unsigned __int32 jv, unsigned __int32 kv ){
		i = iv;
		j = jv;
		k = kv;
	}


	//
	//       0.0 <  uni()  <=  1.0      
	//
	double myrn::uni() {
        const double den = ((double)0xFFFFFFFF) + 1.0;

		i = 69069 * i + 23606797;
		j = j ^ (j << 17);
		j = j ^ (j >> 15);
		k = (k ^ (k << 18)) & 0x7FFFFFFF;
		k = k ^ (k >> 13);

		unsigned __int32 v = i + j + k;

		return (((double)v) + 1.0) / den;
	}

    //        Standard Normal Distribution
	double myrn::normal(){
		double v1, v2, w;
		do {
    		v1 = 2.0 * uni() - 1.0;
			v2 = 2.0 * uni() - 1.0;
			w  = MyLib::sqr(v1) + MyLib::sqr(v2);
		} while (((w >= 1.0) || (w <= 0.0)));

		double c = Math::Sqrt(-2.0 * Math::Log(w)/w);

		return c * v1;
	}


    //    Normal Distribution of mean m  and standard deviation s
	double myrn::normalMS(double m, double s){
			double v = s * normal() + m;
			return  v;
	}


    //    A Pair of Independent Random Numbers of 
	//      the Standard Normal Distribution 
	void  myrn::normalPair( double & n1, double & n2 ){
			double v1, v2, w, c;
			do {
				  v1 = 2.0 * uni() - 1.0;
				  v2 = 2.0 * uni() - 1.0;
				  w  = MyLib::sqr(v1) + MyLib::sqr(v2);
			} while (((w >= 1.0) || (w <= 0.0)));

			c = Math::Sqrt(-2.0 * Math::Log(w) / w);

			n1 = c * v1;
			n2 = c * v2;
	}


}

#endif
