#ifndef BACKDRAW_CK
#define BACKDRAW_CK

namespace bkdraw {

	using namespace System;
	using namespace System::Drawing;

	using namespace System::Threading;


	//  f\NX
	class cmplx {
		public:
			double rl, im;   //   r1:A@im:

			cmplx(): rl(0.0), im(0.0) {}
			cmplx( double x ): rl(x), im(0.0) {}
			cmplx( double r, double i ): rl(r), im(i) {}
			virtual ~cmplx(){}

			cmplx & operator = ( const cmplx & R ){
				if (this != &R){
					rl = R.rl;
					im = R.im;
				}

				return *this;
			}

			double Abs(){
				return Math::Sqrt( rl*rl + im*im );
			}

	};

	cmplx operator + ( const cmplx & L, const cmplx & R ){
		cmplx tmp;
		tmp.rl = L.rl + R.rl;
		tmp.im = L.im + R.im;

		return tmp;
	}

	cmplx operator *( const cmplx & L, const cmplx & R ){
		cmplx tmp;
		tmp.rl = L.rl*R.rl - L.im*R.im;
		tmp.im = L.rl*R.im + L.im*R.rl;

		return tmp;
	}


	typedef Int32 * ClrAry;

	ref class simulDraw {
		public:
			ClrAry * Plt;
			int iState;
			double ax;  //@[
			double bx;  //@E[
			double ay;  //@[
			double by;  //@[

			simulDraw(): iState(0), ax(-2.0), bx(1.0), ay(-1.5), by(1.5){}

			simulDraw( double x1, double x2, double y1, double y2 ):
						iState(0), ax(x1), bx(x2), ay(y1), by(y2) {}

			virtual ~simulDraw(){}

			void set(ClrAry *  pPlt){
				Plt = pPlt;
				for (int i = 0; i < 300; i++)
					for (int j = 0; j < 300; j++)
						Plt[i][j] = Color::White.ToArgb();
			}

			Int32 myColor( int n ){
				Color clr;
				switch (n) {
					case 0 : clr = Color::Violet; break;
					case 1 : clr = Color::Aqua; break;
					case 2 : clr = Color::Yellow; break;
					case 3 : clr = Color::GreenYellow; break;
					case 4 : clr = Color::Green; break;
					case 5 : clr = Color::Blue; break;
					default : clr = Color::Pink;
				}

				return clr.ToArgb();
			}

			void doWork(){
				for (int i = 0; i < 300; i++){
					for (int j = 0; j < 300; j++){
						cmplx z(0.0, 0.0);
						cmplx c( ax + (bx - ax)*i/300.0, ay + (by - ay)*j/300.0 ); 
						int n = 0;
						do {
						z = z*z + c;
						n++;
						} while ((n < 100) && (z.Abs() < 2.0));

						n = Math::Truncate( (n*n)*6.0/10001 );
						Plt[i][j] = myColor( n );
					}
					Thread::Sleep(50);
				}

				iState = 1;
			}

	};

} //  End of bkdraw

#endif
