unit UFuncType;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TForm1 = class(TForm)
    procedure FormCreate(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

type    real = extended;
        TFunc = function( x : real ) : real;
        TMat  = array[1..5,1..5] of real;
        TMFunc = function( a, b : TMat;
                           n    : integer ) : TMat;


function  func_2( x : real ) : real;
  begin
          func_2:=sqr(x);
  end;


function  func_3( x : real ) : real;
  begin
          func_3:=x*sqr(x);
  end;


function  M_Add( a, b : TMat; n : integer ) : TMat;
  var   i, j : integer;
  begin
        for i:=1 to n do
          for j:=1 to n do
            Result[i,j]:=a[i,j]+b[i,j];
  end;


procedure TForm1.FormCreate(Sender: TObject);
var     c, L_b, U_b, R : real;
        s : string;
        a, b : TMat;


  procedure  Bisection( f : TFunc;
                        s, c, L_b, U_b : real;
                        var  Root : real );
    var  m, v : real;
    begin
           if (f(L_b)-c)*(f(U_b)-c) > 0.0 then
             begin
               ShowMessage('Ɖ̑gݍ킹sK؂łB');
               Application.Terminate;
             end;

           repeat
             m:=0.5*(L_b+U_b);
             v:=f(m);
             if s*(v-c) > 0.0 then U_b:=m
                              else L_b:=m;
           until  abs(U_b-L_b) < (1.0E-10)*abs(U_b);

           Root:=0.5*(L_b+U_b);
    end;   {   Bisection   }

begin
     Bisection( func_2, 1.0, 2.0, 1.0, 2.0, R );
     Str(R:8:5, s);
     ShowMessage('2.0̕ = '+s);

     Bisection( func_3, 1.0, 2.0, 1.0, 2.0, R );
     Str(R:8:5, s);
     ShowMessage('2.0̂R捪 = '+s);

     a[1,1]:=1.0; b[1,1]:=2;
     a:=M_Add(a, b, 1);
     Str(a[1,1]:5:1, s);
     ShowMessage('a[1,1] = '+s);
end;

end.
